/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library;

import com.google.common.base.Predicate;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryType;
import org.jetbrains.idea.maven.utils.library.RepositoryUtils;

public class RepositoryLibrarySynchronizer
implements StartupActivity,
DumbAware {
    private static boolean isLibraryNeedToBeReloaded(LibraryEx library, RepositoryLibraryProperties properties) {
        String version = properties.getVersion();
        if (version.equals("LATEST") || version.equals("RELEASE") || version.endsWith("-SNAPSHOT")) {
            return true;
        }
        for (OrderRootType orderRootType : OrderRootType.getAllTypes()) {
            if (library.getFiles(orderRootType).length == library.getUrls(orderRootType).length) continue;
            return true;
        }
        return false;
    }

    private static Collection<Library> collectLibraries(final @NotNull Project project, final @NotNull Predicate<Library> predicate) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/utils/library/RepositoryLibrarySynchronizer", "collectLibraries"));
        }
        if (predicate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predicate", "org/jetbrains/idea/maven/utils/library/RepositoryLibrarySynchronizer", "collectLibraries"));
        }
        final HashSet result = new HashSet();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                    OrderEnumerator.orderEntries((Module)module).withoutSdk().forEachLibrary((Processor)new Processor<Library>(){

                        public boolean process(Library library) {
                            if (predicate.apply((Object)library)) {
                                result.add((Object)library);
                            }
                            return true;
                        }
                    });
                }
                for (Module module : ProjectLibraryTable.getInstance((Project)project).getLibraries()) {
                    if (!predicate.apply((Object)module)) continue;
                    result.add((Object)module);
                }
            }
        });
        return result;
    }

    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/utils/library/RepositoryLibrarySynchronizer", "runActivity"));
        }
        StartupManager.getInstance((Project)project).registerPostStartupActivity((Runnable)new DumbAwareRunnable(){

            public void run() {
                ApplicationManager.getApplication().invokeLater((Runnable)new DumbAwareRunnable(){

                    public void run() {
                        final Collection libraries = RepositoryLibrarySynchronizer.collectLibraries(project, (Predicate<Library>)((Predicate)new Predicate<Library>(){

                            public boolean apply(Library library) {
                                if (!(library instanceof LibraryEx)) {
                                    return false;
                                }
                                LibraryEx libraryEx = (LibraryEx)library;
                                return libraryEx.getKind() == RepositoryLibraryType.REPOSITORY_LIBRARY_KIND && libraryEx.getProperties() instanceof RepositoryLibraryProperties;
                            }
                        }));
                        if (libraries.isEmpty()) {
                            return;
                        }
                        Task.Backgroundable task = new Task.Backgroundable(project, "Maven", false){

                            public void run(@NotNull ProgressIndicator indicator) {
                                if (indicator == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/maven/utils/library/RepositoryLibrarySynchronizer$2$1$2", "run"));
                                }
                                for (Library library : libraries) {
                                    RepositoryLibraryProperties properties;
                                    LibraryEx libraryEx = (LibraryEx)library;
                                    if (!RepositoryLibrarySynchronizer.isLibraryNeedToBeReloaded(libraryEx, properties = (RepositoryLibraryProperties)libraryEx.getProperties())) continue;
                                    RepositoryUtils.reloadDependencies(indicator, project, libraryEx);
                                }
                            }
                        };
                        ProgressManager.getInstance().run((Task)task);
                    }
                }, project.getDisposed());
            }
        });
    }
}

