/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.NewLibraryEditor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenExtraArtifactType;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.utils.library.RepositoryAttachHandler;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;

public class RepositoryUtils {
    @NotNull
    public static final String LatestVersionId = "LATEST";
    @NotNull
    public static final String LatestVersionDisplayName = "Latest";
    @NotNull
    public static final String ReleaseVersionId = "RELEASE";
    @NotNull
    public static final String ReleaseVersionDisplayName = "Release";
    @NotNull
    public static final String SnapshotVersionSuffix = "-SNAPSHOT";
    @NotNull
    public static final String DefaultVersionId = "RELEASE";

    public static void downloadAsync(final Project project, final boolean downloadSources, final boolean downloadJavaDocs, final @NotNull RepositoryLibraryProperties properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/idea/maven/utils/library/RepositoryUtils", "downloadAsync"));
        }
        String displayName = RepositoryLibraryDescription.findDescription(properties).getDisplayName();
        Task.Backgroundable task = new Task.Backgroundable(project, ProjectBundle.message("maven.loading.library.hint", displayName), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/maven/utils/library/RepositoryUtils$1", "run"));
                }
                List<OrderRoot> download = RepositoryUtils.download(project, downloadSources, downloadJavaDocs, properties);
            }
        };
        ProgressManager.getInstance().run((Task)task);
    }

    public static List<OrderRoot> download(Project project, boolean downloadSources, boolean downloadJavaDocs, @NotNull RepositoryLibraryProperties properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/idea/maven/utils/library/RepositoryUtils", "download"));
        }
        String coordinates = properties.getGroupId() + ":" + properties.getArtifactId() + ":" + RepositoryUtils.resolveEffectiveVersion(project, properties);
        return RepositoryAttachHandler.resolveAndDownloadImpl(project, coordinates, downloadJavaDocs, downloadSources, null, RepositoryLibraryDescription.findDescription(properties).getRemoteRepositories());
    }

    public static boolean libraryHasSources(@Nullable Library library) {
        return library != null && library.getUrls(OrderRootType.SOURCES).length > 0;
    }

    public static boolean libraryHasSources(@Nullable LibraryEditor libraryEditor) {
        return libraryEditor != null && libraryEditor.getUrls(OrderRootType.SOURCES).length > 0;
    }

    public static boolean libraryHasJavaDocs(@Nullable Library library) {
        return library != null && library.getUrls(JavadocOrderRootType.getInstance()).length > 0;
    }

    public static boolean libraryHasJavaDocs(@Nullable LibraryEditor libraryEditor) {
        return libraryEditor != null && libraryEditor.getUrls(JavadocOrderRootType.getInstance()).length > 0;
    }

    public static String getStorageRoot(Library library, Project project) {
        Object[] urls = library.getUrls(OrderRootType.CLASSES);
        if (urls.length == 0) {
            return null;
        }
        final String localRepositoryPath = FileUtil.toSystemIndependentName((String)MavenProjectsManager.getInstance(project).getLocalRepository().getPath());
        List roots = JBIterable.of((Object[])urls).transform((Function)new Function<String, String>(){

            public String fun(String urlWithPrefix) {
                String url = StringUtil.trimStart((String)urlWithPrefix, (String)"jar://");
                return url.startsWith(localRepositoryPath) ? null : FileUtil.toSystemDependentName((String)PathUtil.getParentPath((String)url));
            }
        }).toList();
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (String root : roots) {
            int count = counts.get(root) != null ? (Integer)counts.get(root) : 0;
            counts.put(root, count + 1);
        }
        return Collections.max(counts.entrySet(), new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        }).getKey();
    }

    private static String resolveEffectiveVersion(@NotNull Project project, @NotNull RepositoryLibraryProperties properties) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/utils/library/RepositoryUtils", "resolveEffectiveVersion"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/idea/maven/utils/library/RepositoryUtils", "resolveEffectiveVersion"));
        }
        String version = properties.getVersion();
        boolean isLatest = LatestVersionId.equals(version);
        boolean isRelease = "RELEASE".equals(version);
        if (isLatest || isRelease) {
            Iterator iterator;
            Iterable<String> versions = RepositoryAttachHandler.retrieveVersions(project, properties.getGroupId(), properties.getArtifactId(), RepositoryLibraryDescription.findDescription(properties).getRemoteRepositories());
            if (isRelease) {
                versions = Iterables.filter(versions, (Predicate)new Predicate<String>(){

                    public boolean apply(String input) {
                        return !input.endsWith(RepositoryUtils.SnapshotVersionSuffix);
                    }
                });
            }
            if ((iterator = versions.iterator()).hasNext()) {
                version = (String)iterator.next();
            }
        }
        return version;
    }

    public static void reloadDependenciesAsync(final @NotNull Project project, final @NotNull LibraryEx library) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/utils/library/RepositoryUtils", "reloadDependenciesAsync"));
        }
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/idea/maven/utils/library/RepositoryUtils", "reloadDependenciesAsync"));
        }
        Task.Backgroundable task = new Task.Backgroundable(project, "Maven", false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/maven/utils/library/RepositoryUtils$5", "run"));
                }
                RepositoryUtils.reloadDependencies(indicator, project, library);
            }
        };
        ProgressManager.getInstance().run((Task)task);
    }

    public static List<MavenExtraArtifactType> createExtraArtifactTypeList(boolean sources, boolean javaDocs) {
        ArrayList<MavenExtraArtifactType> result = new ArrayList<MavenExtraArtifactType>();
        if (sources) {
            result.add(MavenExtraArtifactType.SOURCES);
        }
        if (javaDocs) {
            result.add(MavenExtraArtifactType.DOCS);
        }
        return result;
    }

    public static synchronized void loadDependencies(@NotNull ProgressIndicator indicator, @NotNull Project project, RepositoryLibraryProperties libraryProperties, boolean downloadSources, boolean downloadJavaDocs, String displayName, Processor<List<MavenArtifact>> processor) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/maven/utils/library/RepositoryUtils", "loadDependencies"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/utils/library/RepositoryUtils", "loadDependencies"));
        }
        indicator.setText(ProjectBundle.message("maven.loading.library.hint", displayName));
        RepositoryAttachHandler.doResolveInner(project, Collections.singletonList(new MavenId(libraryProperties.getGroupId(), libraryProperties.getArtifactId(), RepositoryUtils.resolveEffectiveVersion(project, libraryProperties))), RepositoryUtils.createExtraArtifactTypeList(downloadSources, downloadJavaDocs), RepositoryLibraryDescription.findDescription(libraryProperties).getRemoteRepositories(), processor, indicator);
    }

    public static void loadDependencies(@NotNull ProgressIndicator indicator, @NotNull Project project, final @NotNull LibraryEx library, boolean downloadSources, boolean downloadJavaDocs) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/maven/utils/library/RepositoryUtils", "loadDependencies"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/utils/library/RepositoryUtils", "loadDependencies"));
        }
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/idea/maven/utils/library/RepositoryUtils", "loadDependencies"));
        }
        final String storageRoot = RepositoryUtils.getStorageRoot((Library)library, project);
        final RepositoryLibraryProperties libraryProperties = (RepositoryLibraryProperties)library.getProperties();
        RepositoryUtils.loadDependencies(indicator, project, libraryProperties, downloadSources, downloadJavaDocs, library.getName(), new Processor<List<MavenArtifact>>(){

            public boolean process(List<MavenArtifact> artifacts) {
                if (artifacts == null || artifacts.isEmpty()) {
                    return true;
                }
                final List<OrderRoot> roots = RepositoryAttachHandler.createRoots(artifacts, storageRoot);
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (library.isDisposed()) {
                            return;
                        }
                        AccessToken token = WriteAction.start();
                        try {
                            NewLibraryEditor editor = new NewLibraryEditor(null, (LibraryProperties)libraryProperties);
                            editor.removeAllRoots();
                            editor.addRoots((Collection)roots);
                            LibraryEx.ModifiableModelEx model = library.getModifiableModel();
                            editor.applyTo(model);
                            model.commit();
                        }
                        finally {
                            token.finish();
                        }
                    }
                });
                return true;
            }
        });
    }

    public static void reloadDependencies(@NotNull ProgressIndicator indicator, @NotNull Project project, @NotNull LibraryEx library) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/maven/utils/library/RepositoryUtils", "reloadDependencies"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/utils/library/RepositoryUtils", "reloadDependencies"));
        }
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/idea/maven/utils/library/RepositoryUtils", "reloadDependencies"));
        }
        RepositoryUtils.loadDependencies(indicator, project, library, RepositoryUtils.libraryHasSources((Library)library), RepositoryUtils.libraryHasJavaDocs((Library)library));
    }
}

