/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes;

import com.android.tools.idea.editors.theme.attributes.TableLabel;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;

public class AttributesGrouper {
    private static final List<Group> GROUPS = Arrays.asList(Group.of("Styles", "style", "theme"), Group.of("Colors", "color"), Group.of("Drawables", "drawable"), Group.of("Metrics", "size", "width", "height"));

    private AttributesGrouper() {
    }

    public static List<TableLabel> generateLabelsForType(List<EditedStyleItem> source, List<EditedStyleItem> sink) {
        List[] classes = new List[GROUPS.size() + 1];
        int otherGroupIndex = GROUPS.size();
        for (int i = 0; i < classes.length; ++i) {
            classes[i] = new ArrayList();
        }
        block1: for (EditedStyleItem item : source) {
            String name = item.getName();
            for (int index = 0; index < GROUPS.size(); ++index) {
                Group group = GROUPS.get(index);
                for (String marker : group.markers) {
                    if (!StringUtil.containsIgnoreCase((String)name, (String)marker)) continue;
                    classes[index].add(item);
                    continue block1;
                }
            }
            classes[otherGroupIndex].add(item);
        }
        ArrayList<TableLabel> labels = new ArrayList<TableLabel>();
        int offset = 0;
        for (int index = 0; index < GROUPS.size(); ++index) {
            Group group = GROUPS.get(index);
            int size = classes[index].size();
            if (size != 0) {
                labels.add(new TableLabel(group.name, offset));
            }
            offset += size;
        }
        int otherGroupSize = classes[otherGroupIndex].size();
        if (otherGroupSize != 0 && labels.size() > 0) {
            labels.add(new TableLabel("Everything Else", offset));
        }
        for (List list : classes) {
            for (EditedStyleItem item : list) {
                sink.add(item);
            }
        }
        return labels;
    }

    private static List<TableLabel> generateLabelsForGroup(List<EditedStyleItem> source, List<EditedStyleItem> sink) {
        TreeMap classes = new TreeMap();
        for (EditedStyleItem item : source) {
            String group = item.getAttrGroup();
            if (!classes.containsKey(group)) {
                classes.put(group, new ArrayList());
            }
            ((List)classes.get(group)).add(item);
        }
        ArrayList<TableLabel> labels = new ArrayList<TableLabel>();
        int offset = 0;
        sink.clear();
        for (String group : classes.keySet()) {
            int size = ((List)classes.get(group)).size();
            sink.addAll((Collection)classes.get(group));
            if (size != 0) {
                labels.add(new TableLabel(group, offset));
            }
            offset += size;
        }
        return labels;
    }

    public static List<TableLabel> generateLabels(GroupBy group, List<EditedStyleItem> source, List<EditedStyleItem> sink) {
        if (group == GroupBy.TYPE) {
            return AttributesGrouper.generateLabelsForType(source, sink);
        }
        if (group == GroupBy.GROUP) {
            return AttributesGrouper.generateLabelsForGroup(source, sink);
        }
        return null;
    }

    private static class Group {
        public final String name;
        public final List<String> markers;

        public Group(String name, List<String> markers) {
            this.name = name;
            this.markers = markers;
        }

        public static Group of(String name, String ... markers) {
            return new Group(name, Arrays.asList(markers));
        }
    }

    public static enum GroupBy {
        GROUP("By Group"),
        TYPE("By Type");

        private final String myText;

        private GroupBy(String text) {
            this.myText = text;
        }

        public String toString() {
            return this.myText;
        }
    }
}

