/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes.editors;

import com.android.resources.ResourceType;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.attributes.editors.AttributeEditorValue;
import com.android.tools.idea.editors.theme.attributes.editors.DrawableComponent;
import com.android.tools.idea.editors.theme.attributes.editors.DrawableRenderer;
import com.android.tools.idea.editors.theme.attributes.editors.TypedCellEditor;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.rendering.RenderTask;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTable;
import org.jetbrains.android.uipreview.ChooseResourceDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrawableEditor
extends TypedCellEditor<EditedStyleItem, AttributeEditorValue>
implements ThemeEditorContext.ChangeListener {
    private static final ResourceType[] DRAWABLE_TYPE = new ResourceType[]{ResourceType.DRAWABLE};
    private final DrawableComponent myComponent;
    private EditedStyleItem myEditedItem;
    @Nullable
    private AttributeEditorValue myResultValue;
    private RenderTask myRenderTask;
    private final ThemeEditorContext myContext;

    public DrawableEditor(@NotNull ThemeEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/editors/theme/attributes/editors/DrawableEditor", "<init>"));
        }
        this.myRenderTask = DrawableRenderer.configureRenderTask(context);
        this.myContext = context;
        context.addChangeListener(this);
        this.myComponent = new DrawableComponent();
        this.myComponent.addActionListener(new EditorClickListener());
    }

    @Override
    public Component getEditorComponent(JTable table, EditedStyleItem value, boolean isSelected, int row, int column) {
        this.myEditedItem = value;
        this.myComponent.configure(this.myEditedItem, this.myRenderTask);
        return this.myComponent;
    }

    @Override
    public AttributeEditorValue getEditorValue() {
        return this.myResultValue;
    }

    @Override
    public void onNewConfiguration(ThemeEditorContext context) {
        this.myRenderTask = DrawableRenderer.configureRenderTask(context);
    }

    private class EditorClickListener
    implements ActionListener {
        private EditorClickListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ChooseResourceDialog dialog = new ChooseResourceDialog(DrawableEditor.this.myContext.getCurrentThemeModule(), DRAWABLE_TYPE, DrawableEditor.this.myEditedItem.getValue(), null);
            dialog.show();
            if (dialog.isOK()) {
                DrawableEditor.this.myResultValue = new AttributeEditorValue(dialog.getResourceName(), false);
                DrawableEditor.this.stopCellEditing();
            } else {
                DrawableEditor.this.myResultValue = null;
                DrawableEditor.this.cancelCellEditing();
            }
        }
    }
}

