/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jgit.dirCache;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.KotlinPackage;
import kotlin.io.IoPackage;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.Repository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jgit.dirCache.AddLoadedFile;
import org.jetbrains.jgit.dirCache.DeleteDirectory;
import org.jetbrains.jgit.dirCache.DeleteFile;
import org.jetbrains.jgit.dirCache.DirCacheEditor;
import org.jetbrains.jgit.dirCache.DirCacheEditorKt;
import org.jetbrains.jgit.dirCache.DirCacheTerminator;
import org.jetbrains.jgit.dirCache.PathEdit;
import org.jetbrains.jgit.dirCache.PathEditBase;
import org.jetbrains.settingsRepository.BaseRepositoryManagerKt;
import org.jetbrains.settingsRepository.UtilKt;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"V\u0006)AQ\tR%U?\u000ek\u0005K\u0003\u0006D_6\u0004\u0018M]1u_JTAA[1wC*!Q\u000f^5m\u0015!\u0001\u0016\r\u001e5FI&$(bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\u0005U\u001eLGO\u0003\u0005eSJ\u001c\u0015m\u00195f\u0015-9W\r^#E\u0013R{6)\u0014)\u000b!\u0011K'oQ1dQ\u0016,E-\u001b;pe.#(B\u0003#fY\u0016$XMR5mK*!\u0001/\u0019;i\u0015\u0019\u0019FO]5oO*11n\u001c;mS:TA\u0001\\1oO*QQM\\2pI\u0016\u0004\u0016\r\u001e5\u000b\u0013\tKH/Z!se\u0006L(B\u0003*fa>\u001c\u0018\u000e^8ss*9Qm\u00197jaN,'b\u00017jE*qA-\u001a7fi\u0016\fE\u000e\u001c$jY\u0016\u001c(B\u00033fY\u0016$X\rZ*fi*QQ*\u001e;bE2,7+\u001a;\u000b\u001f\u0019\u0014x.\\,pe.Lgn\u001a+sK\u0016TqAQ8pY\u0016\fgN\u0003\u0003V]&$(bA*fi*QA-\u001a7fi\u0016\u0004\u0016\r\u001e5\u000b\r%\u001ch)\u001b7f\u0015\u0011)G-\u001b;\u000b\u000b\u0015$\u0017\u000e^:\u000b\t1K7\u000f\u001e\u0006\noJLG/\u001a)bi\"TQAY=uKNTAa]5{K*\u0019\u0011J\u001c;?\u0004)\u0011\u0001C\u0001\u0006\u0005\u0011\u0001\u00012A\u0003\u0004\t\u0003A\t\u0001\u0004\u0001\u0006\u0003!\u0015QA\u0001C\u0002\u0011\r)!\u0001\u0002\u0002\t\b\u0015\u0011AQ\u0001\u0005\u0005\u000b\r!1\u0001\u0003\u0002\r\u0001\u0015\u0011A\u0011\u0001E\u0001\u000b\u0005Aq!B\u0002\u0005\n!5A\u0002A\u0003\u0004\t\rAY\u0001\u0004\u0001\u0006\u0005\u0011\u0019\u00012B\u0003\u0003\t\u0001Ay!\u0002\u0002\u0005\u000e!5Qa\u0001C\u0005\u0011#a\u0001!\u0002\u0002\u0005\u0004!MQA\u0001\u0003\t\u0011\u000f)!\u0001\"\u0005\t\u0015\u0015\u0019A!\u0003\u0005\n\u0019\u0001)1\u0001\"\u0003\t\u00181\u0001Qa\u0001C\u0005\u00113a\u0001!B\u0002\u0005\n!iA\u0002A\u0003\u0003\t%A\u0011\"\u0002\u0002\u0005\u0002!mQa\u0001C\u0005\u0011Aa\u0001!\u0002\u0002\u0005\u0002!\u0001RA\u0001\u0003\u0004\u0011\t)1\u0001\"\u0003\t%1\u0001QQ\u0006\u0003b\ta\u0001\u0011\u0005C\u0003\u0002\u0011\u0005IA!C\u0002\u0006\u0003!\u001d\u0001t\u0001\r\u0002+\u000eAQa\u0001\u0003\u0001\u0013\u0005AA!D\u0002\u0005\n%\t\u0001\u0002\u0002-\u0004\u000b\u00155Ba\u0001M\u0006;\u001f!\u0001\u0001\u0003\u0004\u000e\u0007\u0015\t\u0001\"\u0002\r\u0006!\u000e\u0001\u0011eA\u0003\u0002\u0011\u0017AZ!U\u0002\u0006\t\u0017I\u0011\u0001\u0003\u0004\u000e\u0003!9\u0001lA\u0003\u00060\u0011\t\u0001\u0004CO\b\t\u0001Aa!D\u0002\u0006\u0003!)\u0001$\u0002)\u0004\u0001\u0005\u001aQ!\u0001E\b1\u001f\t6A\u0002\u0003\t\u0013\t!\u0019\u0001$\u0001\u000e\u0003!9\u0001lA\u0003\u0006[\u0011\u0019QcA\u0003\u0002\u0011'A\u001a\u0002'\u0006\u001e\u001c\u0011\t\u0001bC\u0007\n\u000b\u0005A!\"\u0003\u0003\n\u0007\u0015\t\u0001\"\u0002\r\u0006\u0019\u0003A\"\u0002UB\u0001;\u001f!\u0011\u0001\u0003\u0007\u000e\u0007\u0015\t\u0001R\u0003M\u000b!\u000e\t\u0011eA\u0003\u0002\u0011-A2\"U\u0002\n\t+I\u0011\u0001\u0002\u0001\u000e\u0003!]Q\"\u0001\u0005\r\u001b\u0005!\t\u0001W\u0002\u0006\u000bG\"1!F\u0002\u0006\u0003!M\u00014\u0003\r\u000f;\u001f!\u0001\u0001\u0003\u0004\u000e\u0007\u0015\t\u0001\"\u0002\r\u0006!\u000e\u0005Qt\u0002\u0003\u0002\u0011;i1!B\u0001\t\u0016aU\u0001kA\u0001\u001e\u0010\u0011\t\u0001\u0002D\u0007\u0004\u000b\u0005A)\u0002'\u0006Q\u0007\u0007\t3!B\u0001\t\u0017aY\u0011kA\u0006\u0005\u001d%\tA\u0001A\u0007\u0002\u0011/i\u0011\u0001C\u0004\u000e\u0003\u0011\u0005Q\"\u0001C\u00011\u000e)Q1\t\u0003\u0004+\r)\u0011\u0001c\u0005\u0019\u0014ayQ\u0014\u0004\u0003\u0001\u0011?i\u0001\"B\u0001\t\u001a%!\u0011bA\u0003\u0002\u0011\u000fA:\u0001'\u0007Q\u0007\u0003\t3!B\u0001\t\u0017aY\u0011kA\u0004\u0005\u001f%\tA\u0001A\u0007\u0002\u0011/i\u0011\u0001C\u0007Y\u0007\u0015)I\u0004B\u0002\u0016\u0007\u0015\t\u00012\u0003M\n1=iz\u0001\u0002\u0001\t\u001f5\u0019Q!\u0001E\u00041\u000f\u00016\u0011A\u0011\u0004\u000b\u0005A1\u0002G\u0006R\u0007\u001d!q\"C\u0001\u0005\u00015\t\u0001rC\u0007\u0002\u00117A6!BC3\t\r)2!B\u0001\t\u0014aM\u0001\u0014EO\b\t\u0001Aa!D\u0002\u0006\u0003!)\u0001$\u0002)\u0004\u0002u=A\u0001\u0001\u0005\u0012\u001b\r)\u0011\u0001c\u0004\u0019\u0010A\u001b\u0011!h\u0004\u0005\u0003!\rRbA\u0003\u0002\u00119Ab\u0002UB\u0002C\r)\u0011\u0001C\u0006\u0019\u0017E\u001bA\u0002\"\t\n\u0003\u0011\u0001Q\"\u0001E\f\u001b\u0005Aq!\u0004\u0002\u0005\u00041\u0005Q\"\u0001C\u00031\u000e)\u0001"})
public final class DirCacheEditorKt {
    @NotNull
    static final Comparator<PathEdit> EDIT_CMP = new Comparator<PathEdit>(){
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(EDIT_CMP.1.class);
        }

        public int compare(@NotNull PathEdit o1, @NotNull PathEdit o2) {
            Intrinsics.checkParameterIsNotNull((Object)o1, (String)"o1");
            Intrinsics.checkParameterIsNotNull((Object)o2, (String)"o2");
            byte[] a = o1.getPath();
            byte[] b = o2.getPath();
            return DirCache.cmp((byte[])a, (int)a.length, (byte[])b, (int)b.length);
        }
    };

    @NotNull
    public static final Comparator<PathEdit> getEDIT_CMP() {
        return EDIT_CMP;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final byte[] encodePath(@NotNull String path) {
        int n;
        int n2;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        ByteBuffer byteBuffer = Constants.CHARSET.encode(path);
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"Constants.CHARSET.encode(path)");
        byte[] bytes = UtilKt.byteBufferToBytes(byteBuffer);
        if (SystemInfo.isWindows && (n2 = 0) <= (n = bytes.length - 1)) {
            while (true) {
                void i;
                if ((char)bytes[i] == '\\') {
                    bytes[i] = (byte)47;
                }
                if (i == n) break;
                ++i;
            }
        }
        return bytes;
    }

    @NotNull
    public static final DeleteFile DeleteFile(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return new DeleteFile(DirCacheEditorKt.encodePath(path));
    }

    public static final void edit(Repository $receiver, @NotNull PathEdit edit2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)edit2, (String)"edit");
        DirCacheEditorKt.edit($receiver, KotlinPackage.listOf((Object)edit2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void edit(Repository $receiver, @NotNull List<? extends PathEdit> edits) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(edits, (String)"edits");
        if (edits.isEmpty()) {
            return;
        }
        DirCache dirCache = $receiver.lockDirCache();
        try {
            DirCache dirCache2 = dirCache;
            Intrinsics.checkExpressionValueIsNotNull((Object)dirCache2, (String)"dirCache");
            new DirCacheEditor(edits, $receiver, dirCache2, dirCache.getEntryCount() + 4).commit();
        }
        finally {
            dirCache.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void deleteAllFiles(Repository $receiver, @Nullable Set<String> deletedSet, boolean fromWorkingTree) {
        File[] files2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DirCache dirCache = $receiver.lockDirCache();
        try {
            int n;
            int n2;
            if (deletedSet != null && (n2 = 0) <= (n = dirCache.getEntryCount() - 1)) {
                while (true) {
                    void i;
                    DirCacheEntry entry;
                    if (Intrinsics.areEqual((Object)(entry = dirCache.getEntry((int)i)).getFileMode(), (Object)FileMode.REGULAR_FILE)) {
                        String string = entry.getPathString();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entry.getPathString()");
                        deletedSet.add(string);
                    }
                    if (i == n) break;
                    ++i;
                }
            }
            DirCache dirCache2 = dirCache;
            Intrinsics.checkExpressionValueIsNotNull((Object)dirCache2, (String)"dirCache");
            new DirCacheTerminator(dirCache2).commit();
        }
        finally {
            dirCache.unlock();
        }
        if (fromWorkingTree && (files2 = IoPackage.listFiles((File)$receiver.getWorkTree(), (Function1)deleteAllFiles.files.1.INSTANCE$)) != null) {
            for (int i = 0; i < files2.length; ++i) {
                File file = files2[i];
                FileUtil.delete((File)file);
            }
        }
    }

    public static /* synthetic */ void deleteAllFiles$default(Repository repository2, Set set, boolean bl, int n) {
        if ((n & 1) != 0) {
            set = null;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        DirCacheEditorKt.deleteAllFiles(repository2, set, bl);
    }

    public static final void writePath(Repository $receiver, @NotNull String path, @NotNull byte[] bytes, int size) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        DirCacheEditorKt.edit($receiver, new AddLoadedFile(path, bytes, size, 0L, 8, null));
        FileUtil.writeToFile((File)new File($receiver.getWorkTree(), path), (byte[])bytes, (int)0, (int)size);
    }

    public static /* synthetic */ void writePath$default(Repository repository2, String string, byte[] byArray, int n, int n2) {
        if ((n2 & 4) != 0) {
            n = byArray.length;
        }
        DirCacheEditorKt.writePath(repository2, string, byArray, n);
    }

    public static final void deletePath(Repository $receiver, @NotNull String path, boolean isFile, boolean fromWorkingTree) {
        File workTree;
        File ioFile;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        DirCacheEditorKt.edit($receiver, isFile ? (PathEditBase)DirCacheEditorKt.DeleteFile(path) : (PathEditBase)new DeleteDirectory(path));
        if (fromWorkingTree && (ioFile = new File(workTree = $receiver.getWorkTree(), path)).exists()) {
            File file = workTree;
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"workTree");
            BaseRepositoryManagerKt.removeWithParentsIfEmpty(ioFile, file, isFile);
        }
    }

    public static /* synthetic */ void deletePath$default(Repository repository2, String string, boolean bl, boolean bl2, int n) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        DirCacheEditorKt.deletePath(repository2, string, bl, bl2);
    }
}

