/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.merge.MergeProvider2;
import com.intellij.openapi.vcs.merge.MultipleFileMergeDialog;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.BaseRepositoryManagerKt;
import org.jetbrains.settingsRepository.CannotResolveConflictInTestMode;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={":\u0006)\u00012m\u001c8gY&\u001cGOU3t_24XM\u001d\u0006\n\rVt7\r^5p]JRaa[8uY&t'\u0002\u0002'jgRT1BV5siV\fGNR5mK*\u00191m\\7\u000b\u0011%tG/\u001a7mS*Tqa\u001c9f]\u0006\u0004\u0018NC\u0002wMNTa\"T3sO\u0016\u0004&o\u001c<jI\u0016\u0014(GC\u0002wGNTQ!\\3sO\u0016TA!\u00168ji*\u0019!N^7\u000b\u0013\u0019,hn\u0019;j_:\u001c(bE4fi\u000e{gN\u001a7jGR\u0014Vm]8mm\u0016\u0014(bE:fi\u000e{gN\u001a7jGR\u0014Vm]8mm\u0016\u0014(b\u0006\"bg\u0016\u0014V\r]8tSR|'/_'b]\u0006<WM]&u\u0015A\u0011Xm]8mm\u0016\u001cuN\u001c4mS\u000e$8OC\u0003gS2,7OC\u0007nKJ<W\r\u0015:pm&$WM\u001d\u0006\u0005U\u00064\u0018M\u0003\u0003vi&d'\u0002\u0002$jY\u0016T!![8\u000b1I,Wn\u001c<f/&$\b\u000eU1sK:$8/\u00134F[B$\u0018P\u0003\u0003s_>$(BB5t\r&dWMC\u0004C_>dW-\u00198\u0013\u0004)\u0011\u0001C\u0001\u0006\u0007\u0011\u0001\u0001\u0012\u0001\u0007\u0001\u000b\r!\u0001\u0001c\u0001\r\u0001\u0015\t\u0001RA\u0003\u0003\t\u0007A1!\u0002\u0002\u0005\u0005!\u001dQA\u0001C\u0003\u0011\u0011)1\u0001B\u0002\t\u00051\u0001QA\u0001C\u0003\u0011\u0015)!\u0001\u0002\u0003\t\f\u0015\u0019A\u0011\u0002E\u0005\u0019\u0001)1\u0001\u0002\u0001\t\r1\u0001QA\u0001\u0003\u0001\u0011\u001b)!\u0001\u0002\u0004\t\u000f\u0015\u0011AQ\u0002E\u0001\u000b\u0005A)\"\u0002\u0002\u0005\u0010!YQA\u0001\u0003\t\u0011\u0007)!\u0001\"\u0003\t\n\u0015\u0011Aq\u0002\u0005\r\u000b\r!\u0019\u0002c\u0006\r\u0001\u0015\u0019A\u0001\u0001\u0005\u000f\u0019\u0001)!\u0001b\u0005\t\u0018\u0015eCa1\u0007\u0019\u0001\u0005BR!\u0001E\u0001\u0013%I\u0001\"B\u0001\t\u0003%!\u0011bA\u0003\u0002\u0011\u000fA:\u0001G\u0001\n\t%\u0019Q!\u0001\u0005\u00061\u0015IA!C\u0002\u0006\u0003!-\u00014\u0002G\u00011\u0003)6AD\u0003\u0004\t\u0001I\u0011\u0001C\u0004\u000e\u0007\u0011=\u0011\"\u0001\u0005\b#\u0015!\u0001\"C\u0001\u0005\u00015\t\u0001b\u0002-\u0004\u0012\u0015YCa\u0001\r\n;3!\u0001\u0001c\u0005\u000e\u0011\u0015\t\u0001\"A\u0005\u0005\u0013\r)\u0011\u0001c\u0002\u0019\ba\t\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001BC\u0007\u0004\u000b\u0005AQ\u0001G\u0003Q\u0007\u0003\t\u0003\"B\u0001\t\u0003%!\u0011bA\u0003\u0002\u0011\u000fA:\u0001G\u0001R\u0007\u001d!\u0011\"C\u0001\t\u00125\t\u0001\u0012C\u0007\u0002\u0011%A6\u0011C\u0003(\t\r)2!B\u0001\t\u0015aQ\u0001\u0014DO\b\t\u0001AQ\"D\u0002\u0006\u0003!Q\u0001D\u0003)\u0004\u0002u=A!\u0001E\u000e\u001b\r)\u0011\u0001#\u0006\u0019\u0016A\u001b\u0011!I\u0002\u0006\u0003!-\u00014B)\u0004\u0013\u0011e\u0011\"\u0001\u0003\u0001\u001b\u0005A1\"D\u0001\t\u00175\tA\u0011\u0001-\u0004\u0012\u0001"})
public final class BaseRepositoryManagerKt {
    @Nullable
    static Function2<? super List<? extends VirtualFile>, ? super MergeProvider2, ? extends Unit> conflictResolver;

    public static final void removeWithParentsIfEmpty(File $receiver, @NotNull File root, boolean isFile) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        FileUtil.delete((File)$receiver);
        if (isFile) {
            for (File parent = $receiver.getParentFile(); parent != null && Intrinsics.areEqual((Object)parent, (Object)root) ^ true && parent.delete(); parent = parent.getParentFile()) {
            }
        }
    }

    public static /* synthetic */ void removeWithParentsIfEmpty$default(File file, File file2, boolean bl, int n) {
        if ((n & 2) != 0) {
            bl = true;
        }
        BaseRepositoryManagerKt.removeWithParentsIfEmpty(file, file2, bl);
    }

    @Nullable
    public static final Function2<List<? extends VirtualFile>, MergeProvider2, Unit> getConflictResolver() {
        return conflictResolver;
    }

    public static final void setConflictResolver(@Nullable Function2<? super List<? extends VirtualFile>, ? super MergeProvider2, ? extends Unit> function2) {
        conflictResolver = function2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<VirtualFile> resolveConflicts(@NotNull List<? extends VirtualFile> files2, @NotNull MergeProvider2 mergeProvider2) {
        void processedFiles;
        Intrinsics.checkParameterIsNotNull(files2, (String)"files");
        Intrinsics.checkParameterIsNotNull((Object)mergeProvider2, (String)"mergeProvider");
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            Intrinsics.throwNpe();
        }
        if (application.isUnitTestMode()) {
            if (conflictResolver == null) {
                throw (Throwable)new CannotResolveConflictInTestMode();
            }
            Function2<? super List<? extends VirtualFile>, ? super MergeProvider2, ? extends Unit> function2 = conflictResolver;
            if (function2 == null) {
                Intrinsics.throwNpe();
            }
            function2.invoke(files2, (Object)mergeProvider2);
            return files2;
        }
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        ActionsKt.invokeAndWaitIfNeed((Function0)((Function0)new Function0<Unit>(files2, mergeProvider2, (Ref.ObjectRef)processedFiles){
            final /* synthetic */ List $files;
            final /* synthetic */ MergeProvider2 $mergeProvider;
            final /* synthetic */ Ref.ObjectRef $processedFiles;

            public final void invoke() {
                MultipleFileMergeDialog fileMergeDialog2 = new MultipleFileMergeDialog((Project)null, this.$files, (MergeProvider)this.$mergeProvider, new MergeDialogCustomizer(){
                    public static final /* synthetic */ KClass $kotlinClass;

                    static {
                        $kotlinClass = Reflection.createKotlinClass(resolveConflicts.fileMergeDialog.1.class);
                    }

                    @NotNull
                    public String getMultipleFileDialogTitle() {
                        return "Settings Repository: Files Merged with Conflicts";
                    }
                });
                fileMergeDialog2.show();
                this.$processedFiles.element = fileMergeDialog2.getProcessedFiles();
            }
            {
                this.$files = list;
                this.$mergeProvider = mergeProvider2;
                this.$processedFiles = objectRef;
                super(0);
            }
        }));
        List list = (List)processedFiles.element;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        return list;
    }
}

