/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.ide.actions.ExportSettingsAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.Collection;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.IcsManager;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"j\u0006)y1m\u001c9z\u0019>\u001c\u0017\r\\\"p]\u001aLwM\u0003\u0003V]&$(BB6pi2LgNC\u000fD_BL\u0018\t\u001d9TKR$\u0018N\\4t)>\u0014V\r]8tSR|'/_&u\u001599W\r\u001e*pC6Lgn\u001a+za\u0016T!bY8na>tWM\u001c;t\u0015)\u0019u\u000e\u001c7fGRLwN\u001c\u0006\u0014\u000bb\u0004xN\u001d;bE2,7i\\7q_:,g\u000e\u001e\u0006\u0004G>l'\u0002C5oi\u0016dG.\u001b6\u000b\u000f=\u0004XM\\1qS*Y!k\\1nS:<G+\u001f9f\u0015\u0011Q\u0017M^1\u000b\tU$\u0018\u000e\u001c\u0006\u000eg\u00064X\rR5sK\u000e$xN]=\u000b\rA\f'/\u001a8u\u0015\u00111\u0015\u000e\\3\u000b\u0005%|'B\u00049be\u0016tGOR5mKN\u0003Xm\u0019\u0006\u0007'R\u0014\u0018N\\4\u000b\u0017I|\u0017-\\5oORK\b/\u001a\u0006\u000fgR\u0014X-Y7Qe>4\u0018\u000eZ3s\u0015EI5m]*ue\u0016\fW\u000e\u0015:pm&$WM\u001d\u0006\u000b\u0013\u000e\u001cX*\u00198bO\u0016\u0014(bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\u0013g\u0016$H/\u001b8hgJ+\u0007o\\:ji>\u0014\u0018P\u0003\u0003mC:<'\u0002H%dg6\u000bg.Y4fe\u0012J5m]*ue\u0016\fW\u000e\u0015:pm&$WM\u001dP\u0002\u0015\t\u0001\"A\u0003\u0004\t\u0001A\t\u0001\u0004\u0001\u0006\u0007\u0011\u0001\u0001b\u0001\u0007\u0001\u000b\u0005AA!\u0002\u0002\u0005\u0004!%QA\u0001\u0003\u0003\u0011\u0015)!\u0001\"\u0002\t\u0006\u0015\u0019Aa\u0001E\u0004\u0019\u0001)1\u0001B\u0002\t\f1\u0001QA\u0001\u0003\u0004\u0011\u0017)\u0011\u0001\u0003\u0004\u0006\u0005\u0011)\u0001RB\u0003\u0003\t\u0017A1!\u0002\u0002\u0005\u000b!EQa\u0001C\u0007\u0011!a\u0001!B\u0002\u0005\u0001!MA\u0002A\u0003\u0002\u00111)!\u0001\u0002\u0005\t\u001a\u0015\u0011A\u0011\u0003\u0005\u000e\u000b\r!\u0011\u0002c\u0006\r\u0001\u0015\u0019A1\u0003\u0005\f\u0019\u0001)!\u0001\"\u0004\t\u0011\u0015\u0011A!\u0002E\u000e\u000b\t!1\u0002c\u0005\u0006\u0005\u0011I\u0001BD\u0003\r\t\rA\u0002!I\u0002\u0006\u0003!\u0005\u0001\u0014A)\u0004\u0007\u0011\u0001\u0011\"\u0001\u0003\u00011\u000e\rQq\u0007\u0003\u00021\tiJ\u0002\u0002\u0001\t\u00065AQ!\u0001\u0005\u0002\u0013\u0011I1!B\u0001\t\ba\u001d\u0001$\u0001)\u0004\u0001\u0005\u001aQ!\u0001\u0005\u00051\u0011\t6!\u0002\u0003\u0003\u0013\u0005AI!D\u0001\t\ra\u001b\u0019!\u0002\u001c\u0005\u0003a9Qt\u0002\u0003\u0001\u0011\u001fi1!B\u0001\t\u000fa9\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001\"C\u0007\u0004\u000b\u0005Ay\u0001g\u0004Q\u0007\u0003iz\u0001\u0002\u0001\t\u00155\u0019Q!\u0001\u0005\u00051\u0011\u00016!AO\b\t\u0001A)\"D\u0002\u0006\u0003!Q\u0001D\u0003)\u0004\u0004\u0005\u001aQ!\u0001E\u00011\u0003\t6a\u0003\u0003\b\u0013\u0005!\u0001!D\u0001\t\u00165\t\u0001rC\u0007\u0002\u0011\u0013i\u0011\u0001\u0003\u0007Y\u0007\u0007\u0001"})
public final class CopyAppSettingsToRepositoryKt {
    public static final void copyLocalConfig() {
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            Intrinsics.throwNpe();
        }
        StateStorageManager stateStorageManager = ServiceKt.getStateStore((ComponentManager)((ComponentManager)application)).getStateStorageManager();
        if (stateStorageManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.StateStorageManagerImpl");
        }
        StateStorageManagerImpl storageManager = (StateStorageManagerImpl)stateStorageManager;
        StreamProvider streamProvider = storageManager.getStreamProvider();
        if (streamProvider == null) {
            Intrinsics.throwNpe();
        }
        if (streamProvider == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.settingsRepository.IcsManager.IcsStreamProvider");
        }
        IcsManager.IcsStreamProvider streamProvider2 = (IcsManager.IcsStreamProvider)streamProvider;
        MultiMap fileToComponents = ExportSettingsAction.getExportableComponentsMap((boolean)true, (boolean)false);
        for (File file : fileToComponents.keySet()) {
            String canonicalPath;
            String absolutePath;
            String string = absolutePath = FileUtilRt.toSystemIndependentName((String)file.getAbsolutePath());
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"absolutePath");
            String fileSpec = storageManager.collapseMacros(string);
            if (fileSpec.equals(absolutePath) && !(canonicalPath = FileUtilRt.toSystemIndependentName((String)file.getCanonicalPath())).equals(absolutePath)) {
                String string2 = canonicalPath;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"canonicalPath");
                fileSpec = storageManager.collapseMacros(string2);
            }
            Collection collection = fileToComponents.get((Object)file);
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"fileToComponents.get(file)");
            RoamingType roamingType = CopyAppSettingsToRepositoryKt.getRoamingType(collection);
            if (file.isFile()) {
                byte[] fileBytes = FileUtil.loadFileBytes((File)file);
                Intrinsics.checkExpressionValueIsNotNull((Object)fileBytes, (String)"fileBytes");
                streamProvider2.doSave(fileSpec, fileBytes, fileBytes.length, roamingType);
                continue;
            }
            File file2 = file;
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
            CopyAppSettingsToRepositoryKt.saveDirectory(file2, fileSpec, roamingType, streamProvider2);
        }
    }

    public static final void saveDirectory(@NotNull File parent, @NotNull String parentFileSpec, @NotNull RoamingType roamingType, @NotNull IcsManager.IcsStreamProvider streamProvider) {
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        Intrinsics.checkParameterIsNotNull((Object)parentFileSpec, (String)"parentFileSpec");
        Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        Intrinsics.checkParameterIsNotNull((Object)streamProvider, (String)"streamProvider");
        File[] files2 = parent.listFiles();
        if (files2 != null) {
            for (int i = 0; i < files2.length; ++i) {
                File file = files2[i];
                String childFileSpec = parentFileSpec + '/' + file.getName();
                if (file.isFile()) {
                    byte[] fileBytes = FileUtil.loadFileBytes((File)file);
                    Intrinsics.checkExpressionValueIsNotNull((Object)fileBytes, (String)"fileBytes");
                    streamProvider.doSave(childFileSpec, fileBytes, fileBytes.length, roamingType);
                    continue;
                }
                File file2 = file;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
                CopyAppSettingsToRepositoryKt.saveDirectory(file2, childFileSpec, roamingType, streamProvider);
            }
        }
    }

    @NotNull
    public static final RoamingType getRoamingType(@NotNull Collection<? extends ExportableComponent> components) {
        Intrinsics.checkParameterIsNotNull(components, (String)"components");
        for (ExportableComponent exportableComponent : components) {
            Storage[] storages;
            State stateAnnotation;
            if (exportableComponent instanceof ExportSettingsAction.ExportableComponentItem) {
                RoamingType roamingType = ((ExportSettingsAction.ExportableComponentItem)exportableComponent).getRoamingType();
                Intrinsics.checkExpressionValueIsNotNull((Object)roamingType, (String)"component.getRoamingType()");
                return roamingType;
            }
            if (!(exportableComponent instanceof PersistentStateComponent) || (stateAnnotation = ((PersistentStateComponent)exportableComponent).getClass().getAnnotation(State.class)) == null || KotlinPackage.isEmpty((Object[])(storages = stateAnnotation.storages()))) continue;
            return storages[0].roamingType();
        }
        return RoamingType.DEFAULT;
    }
}

