/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.KotlinPackage;
import kotlin.PropertyMetadata;
import kotlin.PropertyMetadataImpl;
import kotlin.Unit;
import kotlin.io.IoPackage;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KClass;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.errors.UnmergedPathsException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.ignore.IgnoreNode;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ConfigConstants;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.OperationResult;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.Transport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jgit.dirCache.AddLoadedFile;
import org.jetbrains.jgit.dirCache.DeleteDirectory;
import org.jetbrains.jgit.dirCache.DirCacheEditorKt;
import org.jetbrains.keychain.CredentialsStore;
import org.jetbrains.settingsRepository.AuthenticationException;
import org.jetbrains.settingsRepository.BaseRepositoryManager;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.RepositoryManager;
import org.jetbrains.settingsRepository.RepositoryManager$$TImpl;
import org.jetbrains.settingsRepository.SyncType;
import org.jetbrains.settingsRepository.UpdateResult;
import org.jetbrains.settingsRepository.git.CommitKt;
import org.jetbrains.settingsRepository.git.GitExKt;
import org.jetbrains.settingsRepository.git.GitRepositoryManager;
import org.jetbrains.settingsRepository.git.GitRepositoryManagerKt;
import org.jetbrains.settingsRepository.git.IdeaCommitMessageFormatter;
import org.jetbrains.settingsRepository.git.JGitCredentialsProvider;
import org.jetbrains.settingsRepository.git.JGitProgressMonitorKt;
import org.jetbrains.settingsRepository.git.Pull;
import org.jetbrains.settingsRepository.git.PullKt;
import org.jetbrains.settingsRepository.git.Reset;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"_\u0012)!r)\u001b;SKB|7/\u001b;pefl\u0015M\\1hKJT1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\ntKR$\u0018N\\4t%\u0016\u0004xn]5u_JL(bA4ji*)\")Y:f%\u0016\u0004xn]5u_JLX*\u00198bO\u0016\u0014(B\u0002\u001fj]&$hH\u0003\tde\u0016$WM\u001c;jC2\u001c8\u000b^8sK*\u0001bj\u001c;Ok2dG*\u0019>z-\u0006dW/\u001a\u0006\u0004G>l'\u0002C5oi\u0016dG.\u001b6\u000b\u000f=\u0004XM\\1qS*!Q\u000f^5m\u0015A\u0019%/\u001a3f]RL\u0017\r\\:Ti>\u0014XM\u0003\u0005lKf\u001c\u0007.Y5o\u0015\r!\u0017N\u001d\u0006\u0005\r&dWM\u0003\u0003kCZ\f'BA5p\u0015-y&/\u001a9pg&$xN]=\u000b\u0015I+\u0007o\\:ji>\u0014\u0018PC\u0004fG2L\u0007o]3\u000b\t)<\u0017\u000e\u001e\u0006\u0004Y&\u0014'BD4fi~\u0013X\r]8tSR|'/\u001f\u0006\u000fg\u0016$xL]3q_NLGo\u001c:z\u0015M\u0019'/\u001a3f]RL\u0017\r\\:Qe>4\u0018\u000eZ3s\u0015M\u0019%/\u001a3f]RL\u0017\r\\:Qe>4\u0018\u000eZ3s\u0015%!(/\u00198ta>\u0014HO\u0003\u000fde\u0016$WM\u001c;jC2\u001c\bK]8wS\u0012,'\u000f\n3fY\u0016<\u0017\r^3\u000b\r-|G\u000f\\5o\u0015)\u0001(o\u001c9feRLWm\u001d\u0006\u0011%\u0016\fGm\u00148msB\u0013x\u000e]3sifTacZ3u\u0007J,G-\u001a8uS\u0006d7\u000f\u0015:pm&$WM\u001d\u0006\fS\u001etwN]3Sk2,7O\u0003\u0006JO:|'/\u001a(pI\u0016Ta![4o_J,'B\u0003:fa>\u001c\u0018\u000e^8ss*iq-\u001a;SKB|7/\u001b;pefT!\"\u00193e)>Le\u000eZ3y\u0015\u00111\u0017\u000e\\3\u000b\tA\fG\u000f\u001b\u0006\u0007'R\u0014\u0018N\\4\u000b\u000f\r|g\u000e^3oi*I!)\u001f;f\u0003J\u0014\u0018-\u001f\u0006\u0005g&TXMC\u0002J]RTA!\u00168ji*!A.\u00198h\u0015%\u0019\u0017M\\\"p[6LGOC\u0004C_>dW-\u00198\u000b\r\r|W.\\5u\u0015%Ig\u000eZ5dCR|'OC\tQe><'/Z:t\u0013:$\u0017nY1u_JT\u0001\u0002\u001d:pOJ,7o\u001d\u0006\tgft7\rV=qK*A1+\u001f8d)f\u0004XM\u0003\fgSb\u001cF/\u0019;f\u0013\u001a\u001c\u0015M\u001c8pi\u000e{W.\\5u\u0015\u0015\u0001\u0018\r\u001e5t\u0015\u0011a\u0015n\u001d;\u000b\u0017\r|W.\\5u\u0013\u001a\u001c\u0015M\u001c\u0006\u0006gR\fG/\u001a\u0006\u0010%\u0016\u0004xn]5u_JL8\u000b^1uK*12M]3bi\u0016\u0014V\r]8tSR|'/_%g\u001d\u0016,GMC\beK2,G/\u001a$s_6Le\u000eZ3y\u0015\u0019I7OR5mK*\u0001B-\u001a7fi\u0016\u0014V\r]8tSR|'/\u001f\u0006\u0006M\u0016$8\r\u001b\u0006\b+B$\u0017\r^3s\u0015E\u0011V\r]8tSR|'/_'b]\u0006<WM\u001d\u0006\u001a%\u0016\u0004xn]5u_JLX*\u00198bO\u0016\u0014H%\u00169eCR,'O\u0003\u000bhKR\f\u0005.Z1e\u0007>lW.\u001b;t\u0007>,h\u000e\u001e\u0006\u000fO\u0016$\u0018j\u001a8pe\u0016\u0014V\u000f\\3t\u0015-9W\r^+qgR\u0014X-Y7\u000b\u0017!\f7/\u00169tiJ,\u0017-\u001c\u0006\u000eSN\u0004\u0016\r\u001e5JO:|'/\u001a3\u000b%%\u001c(+\u001a9pg&$xN]=Fq&\u001cHo\u001d\u0006\u0005aVdGN\u0003\u0007Va\u0012\fG/\u001a*fgVdGO\u0003\u0003qkND'b\u0004:f]\u0006lW\rR5sK\u000e$xN]=\u000b\u000bA\f\u0017N]:\u000b\u00075\u000b\u0007OC\u0005sKN,G\u000fV8Ns*QBn\\2bYJ+\u0007o\\:ji>\u0014\u00180\u00138ji&\fG.\u001b>fe*Ia)\u001e8di&|g\u000e\r\u0006\u0004UZl'\"\u00034v]\u000e$\u0018n\u001c8t\u00155\u0011Xm]3u)>$\u0006.Z5sg*Y1/\u001a;VaN$(/Z1n\u0015\r)(\u000f\u001c\u0006\u0007EJ\fgn\u00195\r\b)\u0011\u0001#\u0001\u0006\u0005\u0011\u0001\u0001\"A\u0003\u0003\t\u0003A\u0019!\u0002\u0002\u0005\u0003!\u0011Qa\u0001C\u0002\u0011\u0001a\u0001!B\u0002\u0005\u0003!\u0015A\u0002A\u0003\u0002\u0011\u0013)!\u0001B\u0002\t\u000b\u0015\u0011Aq\u0001E\u0006\u000b\t!A\u0001\u0003\u0004\u0006\u0007\u0011%\u0001\u0002\u0002\u0007\u0001\u000b\t!\t\u0001C\u0004\u0006\u0007\u0011-\u0001R\u0002\u0007\u0001\u000b\u0005A\t\"\u0002\u0002\u0005\u000e!IQa\u0001\u0003\b\u0011!a\u0001!\u0002\u0002\u0005\n!!QA\u0001\u0003\b\u0011!)!\u0001\u0002\u0001\t\u0016\u0015\u0011A!\u0003\u0005\f\u000b\t!\u0019\u0002c\u0006\u0006\u0007\u0011Q\u0001B\u0003\u0007\u0001\u000b\t!!\u0002\u0003\u0006\u0006\u0005\u0011M\u0001BD\u0003\u0004\t/AY\u0002\u0004\u0001\u0006\u0003!yQA\u0001C\r\u0011?)!\u0001B\u0007\t!\u0015\u0011Aq\u0003E\u000e\u000b\t!\u0019\u0002\u0003\n\u0006\u0007\u0011u\u00012\u0005\u0007\u0001\u000b\t!i\u0002c\t\u0006\u0007\u0011e\u0001\"\u0006\u0007\u0001\u000b\r!I\u0002\u0003\f\r\u0001\u0015\u0019A\u0011\u0004\u0005\u0018\u0019\u0001)1\u0001\"\u0007\t01\u0001QA\u0001C\u0007\u0011a)!\u0001\u0002\n\t+\u0015\u0019A\u0011\u0004\u0005\u001a\u0019\u0001)!\u0001\u0002\u0003\t7\u0015\u0019Aq\u0005E\u001b\u0019\u0001)1\u0001B\u0001\t91\u0001QA\u0001C\u0014\u0011k)!\u0001B\u0001\t9\u0015\u0019A\u0011\u0004E\u001e\u0019\u0001)!\u0001\"\u0004\t\r\u0015\u0011AQ\u0006E\u001e\u000b\r!!\u0002C\u0010\r\u0001\u0015\u0011AA\u0003\u0005 \u000b\r!\u0011\u0001#\u0012\r\u0001\u0015\u0019A\u0011\u0007\u0005#\u0019\u0001)!\u0001B\u0001\tG\u0015\u0019A!\u0001\u0005(\u0019\u0001)!\u0001B\u0001\tO\u0015\u0019A\u0011\u0004\u0005*\u0019\u0001)!\u0001\"\f\tS\u0015\u0019A\u0011\u0004E+\u0019\u0001)!\u0001\"\u0007\tW\u0015\u0011A\u0011\bE,\u000b\t!Q\u0004#\u0016\u0005\u00071\u0011\u0011dA\u0003\u0002\u0011\u000bA*!L\f\u0005\u00074A\u001a\"\t\u0003\u0006\u0003!UA\u0012\u0001M\u000b+\u000eqQa\u0001C\n\u0013\u0005A1\"D\u0002\u0005\u0019%\t\u0001bC\t\u0006\t3I\u0011\u0001\u0002\u0001\u000e\u0003!YQ&\u0005\u0003d\tai\u0011eA\u0003\u0002\u00111AB\u0002J\u0012V\u0007!)1\u0001\"\b\n\u0003!mQb\u0001C\u0011\u0013\u0005Aa\"L\t\u0005C\u0012A:!\t\u0005\u0006\u0003!)\u0011\u0002B\u0005\u0004\u000b\u0005Aa\u0001\u0007\u0004\u0019\u000bU\u001bA!B\u0002\u0005\b%\t\u0001\u0002C\u0017\u000e\t\u0005g\u0001$E\u0011\u0005\u000b\u0005Aq\u0002$\u0001\u0019\u001fU\u001bA!B\u0002\u0005#%\t\u0001rD\u0017\u000e\t\r$\u0001TE\u0011\u0004\u000b\u0005A)\u0002'\u0006%GU\u001bA!D\u0002\u0005'%\t\u0001bCW6\t)A:#h\u0004\u0005\u0001!!RbA\u0003\u0002\u0011\u001fAz\u0001U\u0002\u0001;\u001f!\u0001\u0001#\u000b\u000e\u0007\u0015\t\u0001\u0002\u0005\r\u0011!\u000e\u0005Qt\u0002\u0003\u0001\u0011Wi1!B\u0001\t\"a\u0005\u0002kA\u0001\u001e\u0010\u0011\u0001\u0001RF\u0007\u0004\u000b\u0005A\u0011\u0003G\tQ\u0007\u0007\t3!B\u0001\t$a\r\u0012k\u0001\u0007\u0005(%\tA\u0001A\u0007\u0002\u0011#i\u0011\u0001#\n\u000e\u0005\u0011\rA\u0012A\u0007\u0002\t\u000bi+\u0002B\u0006\u00192\u0005\u001aQ!\u0001\u0005\u00141M\t6a\u0001C\u0019\u0013\u0005!\t!\f\u0017\u0005\u0017aMR\u0014\u0003\u0003\u0001\u0011iiA!B\u0001\t)1\u0005\u0001\u0004\u0006)\u0004\u0001uEA\u0001\u0001E\u001c\u001b\u0011)\u0011\u0001#\u000b\r\u0002a%\u0002k!\u0001\u001e\u0010\u0011\u0001\u0001\u0012H\u0007\u0004\u000b\u0005A1\u0003G\nQ\u0007\u0005\t3!B\u0001\t'a\u0019\u0012kA\u0005\u00054%\tA\u0011A\u0007\u0002\u0011Ui\u0011\u0001c\u000b\u000e\u0003\u0011\u0005QF\u0007\u0003\f1giJ\u0002\u0002\u0001\t;5AQ!\u0001\u0005\u0017\u0013\u0011I1!B\u0001\t!a\u0001\u0002D\u0006)\u0004\u0001\u0005\u001aQ!\u0001E\u00121G\t6!\u0002C\u001a\u0013\u0005!\u0001!D\u0001\t/5\u0006C!\u0001\r\u001f;#!\u0001\u0001\u0003\u000e\u000e\t\u0015\t\u0001\u0002\u0006G\u00011Q\u00016\u0001AO\b\t\u0001Ai$D\u0002\u0006\u0003!=\u0002t\u0006)\u0004\u0002\u0005\u001aQ!\u0001\u0005\u00141M\t6a\u0002\u0003\u001f\u0013\u0005!\t!D\u0001\t+5\t\u0001\u0002GW\u000b\t-Az$I\u0002\u0006\u0003!\u0019\u0002dE)\u0004\u0007\u0011}\u0012\"\u0001C\u0001[\u007f!!\u0002\u0007\u0011\u001e\u0010\u0011\u0001\u0001\u0012F\u0007\u0004\u000b\u0005A\u0001\u0003\u0007\tQ\u0007\u0001iz\u0001\u0002\u0001\tB5\u0019Q!\u0001\u0005\u00141M\u00016\u0011A\u0011\u0004\u000b\u0005A\u0019\u0003g\tR\u0007\u001d!\u0001%C\u0001\u0005\u00015\t\u0001RE\u0007\u0002\t\u0003i+\u0002B\u0006\u0019C\u0005\u001aQ!\u0001E\u00121G\t6a\u0001\u0003\"\u0013\u0005!\u0001!\f\f\u0005\u0017a\rS\u0014\u0003\u0003\u0001\u0011iiA!B\u0001\t)1\u0005\u0001\u0004\u0006)\u0004\u0001\u0005\u001aQ!\u0001\u0005\u001a1e\t6!\u0002C\"\u0013\u0005A\u0019$D\u0001\t+5VAa\u0003M$C\r)\u0011\u0001C\t\u0019#E\u001b1\u0001b\u0012\n\u0003\u0011\u0015Qv\u0003\u0003\u00021\u0011\nC!B\u0001\t\u001f1\u0005\u0001dD)\u0004\u0007\u0011!\u0013\"\u0001E\u0010[/!1\u0002'\u0013\"\t\u0015\t\u0001\u0002\u0005G\u00011A\t6a\u0001C%\u0013\u0005A)#,\u0006\u0005\u0017a)\u0013eA\u0003\u0002\u0011MA2#U\u0002\u0004\t\u0015J\u0011\u0001\"\u0001.+\u0011Q\u00014JO\b\t\u0001AI#D\u0002\u0006\u0003!\u0001\u0002\u0004\u0005)\u0004\u0001\u0005\u001aQ!\u0001\u0005\u00141M\t6!\u0002C&\u0013\u0005!\t!D\u0001\t&5VAa\u0003\r'C\r)\u0011\u0001C\n\u0019'E\u001b1\u0001\u0002\u0014\n\u0003\u0011\u0005Qf\u0006\u0003\f1\u001bj\n\u0002\u0002\u0001\t55!Q!\u0001\u0005\u0015\u0019\u0003AB\u0003U\u0002\u0001C\u0011)\u0011\u0001\u0003\u000e\r\u0002aQ\u0012kA\u0003\u0005N%\t\u0001RG\u0007\u0002\u0011Uic\u0003B\u0006\u0019PuEA\u0001\u0001\u0005\u001b\u001b\u0011)\u0011\u0001\u0003\u000b\r\u0002a!\u0002k\u0001\u0001\"\u0007\u0015\t\u00012\u0005M\u0012#\u000e)AqJ\u0005\u0002\t\u0001i\u0011\u0001C\u000b.A\u0011\u0019\u0001\u0004KO\u0013\t\u0001A\t&\u0004\b\u0006\u0003!Y\u0012\u0002B\u0005\u0004\u000b\u0005A\u0001\u0003\u0007\t\n\u000b%!Q!\u0001\u0005\u0011\u0019\u0003A\u0002\u0003G\u000eQ\u0007\u0001\t3!B\u0001\t'a\u0019\u0012kA\u0003\u0005Q%\tA\u0011A\u0007\u0002\u0011oi[\u0005B\u0006\u0019Tu=A\u0001\u0001\u0005\u001b\u001b\r)\u0011\u0001\u0003\u000b\u0019)A\u001b\u0001!h\u0007\u0005\u0001!QS\"C\u0003\u0002\u0011qIA!C\u0002\u0006\u0003!\r\u00024\u0005G\u00011q\u00016\u0011A\u0011\u0004\u000b\u0005A!\u0004\u0007\u000eR\u0007\u001d!\u0019&C\u0001\t65\t\u0001\"F\u0007\u0002\u0011wiS\u0003B\u0006\u0019Yu=A\u0001\u0001\u0005\u001b\u001b\r)\u0011\u0001\u0003\u000b\u0019)A\u001b\u0001!I\u0002\u0006\u0003!Q\u0002DG)\u0004\u000b\u0011a\u0013\"\u0001E\u001b\u001b\u0005AQ#l\u0011\u0005\u0017aeS\u0014\u0003\u0003\u0001\u00115jA!B\u0001\t!1\u0005\u0001\u0004\u0005)\u0004\u0001uEA\u0001\u0001E.\u001b\u0011)\u0011\u0001\u0003\t\r\u0002a\u0001\u0002k!\u0001\"\u0007\u0015\t\u00012\u0005M\u0012#\u000e9A\u0011L\u0005\u0002\t\u0001i\u0011\u0001#\n\u000e\u0003!\u0015RGJ\u0003&\t\r\b\u0001dAO\r\t\u0001A9!\u0004\u0005\u0006\u0003!)\u0011\u0002B\u0005\u0004\u000b\u0005Aa\u0001\u0007\u0004\u0019\u000bA\u001b\u0001!h\u0004\u0005\u0001!=QbA\u0003\u0002\u0011\u001fAz\u0001UB\u0001C\r)\u0011\u0001\u0003\u0002\u0019\u0005E\u001bq\u0001B\u0002\n\u0003\u0011\u0001Q\"\u0001\u0005\t\u001b\u0005A\t\u0002"})
public final class GitRepositoryManager
extends BaseRepositoryManager {
    public static final /* synthetic */ KClass $kotlinClass;
    @Nullable
    private Repository _repository;
    @NotNull
    private final ReadOnlyProperty<? super Object, ? extends JGitCredentialsProvider> credentialsProvider$delegate;
    private IgnoreNode ignoreRules;
    private final NotNullLazyValue<CredentialsStore> credentialsStore;
    private static final /* synthetic */ PropertyMetadata[] $propertyMetadata;

    static {
        $kotlinClass = Reflection.createKotlinClass(GitRepositoryManager.class);
        $propertyMetadata = new PropertyMetadata[]{new PropertyMetadataImpl("credentialsProvider")};
    }

    @NotNull
    public final Repository getRepository() {
        Repository r = this._repository;
        if (r == null) {
            this._repository = r = ((FileRepositoryBuilder)new FileRepositoryBuilder().setWorkTree(this.getDir())).build();
            Application application = ApplicationManager.getApplication();
            if (Intrinsics.areEqual((Object)(application != null ? Boolean.valueOf(application.isUnitTestMode()) : null), (Object)true) ^ true) {
                ShutDownTracker.getInstance().registerShutdownTask(new Runnable(this){
                    final /* synthetic */ GitRepositoryManager this$0;

                    public final void run() {
                        Unit unit;
                        Repository repository2 = this.this$0.get_repository();
                        if (repository2 != null) {
                            repository2.close();
                            unit = Unit.INSTANCE$;
                        } else {
                            unit = null;
                        }
                    }
                    {
                        this.this$0 = gitRepositoryManager;
                    }
                });
            }
        }
        Repository repository2 = r;
        if (repository2 == null) {
            Intrinsics.throwNpe();
        }
        return repository2;
    }

    @Nullable
    public final Repository get_repository() {
        return this._repository;
    }

    public final void set_repository(@Nullable Repository repository2) {
        this._repository = repository2;
    }

    @NotNull
    public final CredentialsProvider getCredentialsProvider() {
        return (CredentialsProvider)this.credentialsProvider$delegate.get((Object)this, $propertyMetadata[0]);
    }

    @Override
    public boolean createRepositoryIfNeed() {
        this.ignoreRules = null;
        if (this.isRepositoryExists()) {
            return false;
        }
        this.getRepository().create();
        GitExKt.disableAutoCrLf(this.getRepository());
        return true;
    }

    @Override
    public void deleteRepository() {
        this.ignoreRules = null;
        super.deleteRepository();
        Repository r = this._repository;
        if (r != null) {
            this._repository = null;
            r.close();
        }
    }

    @Override
    @Nullable
    public String getUpstream() {
        return StringUtil.nullize((String)this.getRepository().getConfig().getString(ConfigConstants.CONFIG_REMOTE_SECTION, Constants.DEFAULT_REMOTE_NAME, ConfigConstants.CONFIG_KEY_URL));
    }

    @Override
    public void setUpstream(@Nullable String url, @Nullable String branch) {
        Repository repository2 = this.getRepository();
        String string = branch;
        if (string == null) {
            string = Constants.MASTER;
        }
        GitExKt.setUpstream(repository2, url, string);
    }

    @Override
    public boolean isRepositoryExists() {
        Repository repo = this._repository;
        if (repo == null) {
            return this.getDir().exists() && ((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setWorkTree(this.getDir())).setup()).getObjectDirectory().exists();
        }
        return repo.getObjectDatabase().exists();
    }

    @Override
    public boolean hasUpstream() {
        return this.getUpstream() != null;
    }

    @Override
    protected void addToIndex(@NotNull File file, @NotNull String path, @NotNull byte[] content, int size) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        DirCacheEditorKt.edit(this.getRepository(), new AddLoadedFile(path, content, size, file.lastModified()));
    }

    @Override
    protected void deleteFromIndex(@NotNull String path, boolean isFile) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        DirCacheEditorKt.deletePath(this.getRepository(), path, isFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public boolean commit(@Nullable ProgressIndicator indicator, @Nullable SyncType syncType, boolean fixStateIfCannotCommit) {
        int it;
        void $receiver;
        ReentrantReadWriteLock reentrantReadWriteLock = this.getLock();
        ReentrantReadWriteLock.ReadLock rl = $receiver.readLock();
        int readCount = $receiver.getWriteHoldCount() == 0 ? $receiver.getReadHoldCount() : 0;
        int n = 0;
        int n2 = readCount - 1;
        if (n <= n2) {
            void index;
            do {
                it = ++index;
                rl.unlock();
            } while (index != n2);
        }
        ReentrantReadWriteLock.WriteLock wl = $receiver.writeLock();
        wl.lock();
        try {
            try {
                RepositoryState repositoryState = !fixStateIfCannotCommit || Intrinsics.areEqual((Object)((Object)syncType), (Object)((Object)SyncType.OVERWRITE_LOCAL)) ? this.getRepository().getRepositoryState() : PullKt.fixAndGetState(this.getRepository());
                Intrinsics.checkExpressionValueIsNotNull((Object)repositoryState, (String)"if (!fixStateIfCannotCom\u2026pository.fixAndGetState()");
                boolean bl = this.commitIfCan(indicator, repositoryState);
                return bl;
            }
            catch (UnmergedPathsException e2) {
                Unit unit;
                Unit unit2;
                block19: {
                    if (!Intrinsics.areEqual((Object)((Object)syncType), (Object)((Object)SyncType.OVERWRITE_LOCAL))) break block19;
                    IcsManagerKt.getLOG().warn("Unmerged detected, ignored because sync type is OVERWRITE_LOCAL", (Throwable)e2);
                    boolean bl = false;
                    it = 0;
                    int e2 = readCount - 1;
                    if (it <= e2) {
                        do {
                            int n3 = ++it;
                            rl.lock();
                        } while (it != e2);
                    }
                    wl.unlock();
                    return bl;
                }
                ProgressIndicator progressIndicator = indicator;
                if (progressIndicator != null) {
                    progressIndicator.checkCanceled();
                    unit2 = Unit.INSTANCE$;
                } else {
                    unit2 = null;
                }
                IcsManagerKt.getLOG().warn("Unmerged detected, will be attempted to resolve", (Throwable)e2);
                PullKt.resolveUnmergedConflicts(this.getRepository());
                ProgressIndicator progressIndicator2 = indicator;
                if (progressIndicator2 != null) {
                    progressIndicator2.checkCanceled();
                    unit = Unit.INSTANCE$;
                } else {
                    unit = null;
                }
                boolean bl = this.commitIfCan(indicator, PullKt.fixAndGetState(this.getRepository()));
                it = 0;
                int n4 = readCount - 1;
                if (it <= n4) {
                    do {
                        int n5 = ++it;
                        rl.lock();
                    } while (it != n4);
                }
                wl.unlock();
                return bl;
            }
        }
        finally {
            it = 0;
            int n6 = readCount - 1;
            if (it <= n6) {
                do {
                    int n7 = ++it;
                    rl.lock();
                } while (it != n6);
            }
            wl.unlock();
        }
    }

    private final boolean commitIfCan(ProgressIndicator indicator, RepositoryState state) {
        if (state.canCommit()) {
            return CommitKt.commit$default(this.getRepository(), indicator, null, 4);
        }
        IcsManagerKt.getLOG().warn("Cannot commit, repository in state " + state.getDescription());
        return false;
    }

    @Override
    public int getAheadCommitsCount() {
        return GitExKt.getAheadCommitsCount(this.getRepository());
    }

    @Override
    public void commit(@NotNull List<? extends String> paths) {
        Intrinsics.checkParameterIsNotNull(paths, (String)"paths");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void push(@Nullable ProgressIndicator indicator) {
        Ref head;
        IcsManagerKt.getLOG().debug("Push");
        SmartList refSpecs = new SmartList((Collection)new RemoteConfig((Config)this.getRepository().getConfig(), Constants.DEFAULT_REMOTE_NAME).getPushRefSpecs());
        if (refSpecs.isEmpty() && (head = this.getRepository().getRef(Constants.HEAD)) != null && head.isSymbolic()) {
            refSpecs.add((Object)new RefSpec(head.getLeaf().getName()));
        }
        ProgressMonitor monitor = JGitProgressMonitorKt.asProgressMonitor(indicator);
        block5: for (Transport transport : Transport.openAll((Repository)this.getRepository(), (String)Constants.DEFAULT_REMOTE_NAME, (Transport.Operation)Transport.Operation.PUSH)) {
            boolean bl = false;
            boolean bl2 = true;
            if (bl > bl2) continue;
            while (true) {
                void attempt;
                transport.setCredentialsProvider(this.getCredentialsProvider());
                try {
                    PushResult result = transport.push(monitor, transport.findRemoteRefUpdatesFor((Collection)refSpecs));
                    if (!IcsManagerKt.getLOG().isDebugEnabled()) continue block5;
                    OperationResult operationResult = (OperationResult)result;
                    Intrinsics.checkExpressionValueIsNotNull((Object)operationResult, (String)"result");
                    GitRepositoryManagerKt.printMessages(operationResult);
                    for (RemoteRefUpdate refUpdate : result.getRemoteUpdates()) {
                        IcsManagerKt.getLOG().debug(refUpdate.toString());
                    }
                    continue block5;
                }
                catch (TransportException e) {
                    if (Intrinsics.areEqual((Object)e.getStatus(), (Object)TransportException.Status.NOT_PERMITTED)) {
                        if (attempt != false) throw (Throwable)new AuthenticationException(e);
                        this.getCredentialsProvider().reset(transport.getURI());
                    } else {
                        GitExKt.wrapIfNeedAndReThrow(e);
                    }
                }
                finally {
                    transport.close();
                    continue block5;
                }
                if (attempt == bl2) continue block5;
                ++attempt;
            }
        }
    }

    @Override
    @NotNull
    public RepositoryManager.Updater fetch(@Nullable ProgressIndicator indicator) {
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator == null) {
            progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
        }
        Pull pullTask = new Pull(this, progressIndicator, null, 4, null);
        Ref refToMerge = Pull.fetch$default(pullTask, null, 1);
        return new RepositoryManager.Updater(this, pullTask, refToMerge){
            public static final /* synthetic */ KClass $kotlinClass;
            private boolean definitelySkipPush;
            final /* synthetic */ GitRepositoryManager this$0;
            final /* synthetic */ Pull $pullTask;
            final /* synthetic */ Ref $refToMerge;

            static {
                $kotlinClass = Reflection.createKotlinClass(fetch.1.class);
            }

            public boolean getDefinitelySkipPush() {
                return this.definitelySkipPush;
            }

            public void setDefinitelySkipPush(boolean bl) {
                this.definitelySkipPush = bl;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @Nullable
            public UpdateResult merge() {
                int committed;
                int it;
                ReentrantReadWriteLock $receiver = GitRepositoryManager.access$getLock$1(this.this$0);
                ReentrantReadWriteLock.ReadLock rl = $receiver.readLock();
                int readCount = $receiver.getWriteHoldCount() == 0 ? $receiver.getReadHoldCount() : 0;
                int n = 0;
                int n2 = readCount - 1;
                if (n <= n2) {
                    void index;
                    do {
                        it = ++index;
                        rl.unlock();
                    } while (index != n2);
                }
                ReentrantReadWriteLock.WriteLock wl = $receiver.writeLock();
                wl.lock();
                try {
                    committed = RepositoryManager$$TImpl.commit$default(this.this$0, this.$pullTask.getIndicator(), null, false, 6);
                    if (this.$refToMerge == null && committed == 0 && this.this$0.getAheadCommitsCount() == 0) {
                        this.setDefinitelySkipPush(true);
                        UpdateResult updateResult = null;
                        return updateResult;
                    }
                    UpdateResult updateResult = Pull.pull$default(this.$pullTask, null, null, this.$refToMerge, 3);
                    return updateResult;
                }
                finally {
                    it = 0;
                    committed = readCount - 1;
                    if (it <= committed) {
                        do {
                            int n3 = ++it;
                            rl.lock();
                        } while (it != committed);
                    }
                    wl.unlock();
                }
            }
            {
                this.this$0 = $outer;
                this.$pullTask = $captured_local_variable$1;
                this.$refToMerge = $captured_local_variable$2;
            }
        };
    }

    @Override
    @Nullable
    public UpdateResult pull(@Nullable ProgressIndicator indicator) {
        return Pull.pull$default(new Pull(this, indicator, null, 4, null), null, null, null, 7);
    }

    @Override
    @NotNull
    public UpdateResult resetToTheirs(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        return Reset.reset$default(new Reset(this, indicator), true, null, 2);
    }

    @Override
    @NotNull
    public UpdateResult resetToMy(@NotNull ProgressIndicator indicator, @Nullable Function0<? extends Unit> localRepositoryInitializer) {
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        return new Reset(this, indicator).reset(false, localRepositoryInitializer);
    }

    @Override
    public boolean canCommit() {
        return this.getRepository().getRepositoryState().canCommit();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean renameDirectory(@NotNull Map<String, ? extends String> pairs) {
        void receiver;
        Object object;
        Intrinsics.checkParameterIsNotNull(pairs, (String)"pairs");
        AddCommand addCommand = null;
        SmartList toDelete = new SmartList();
        Iterator iterator = KotlinPackage.iterator(pairs);
        while (iterator.hasNext()) {
            object = (Map.Entry)iterator.next();
            String oldPath = (String)KotlinPackage.component1((Map.Entry)object);
            String newPath = (String)KotlinPackage.component2((Map.Entry)object);
            File old = new File(this.getDir(), oldPath);
            if (!old.exists()) continue;
            IcsManagerKt.getLOG().info("Rename " + oldPath + " to " + newPath);
            File[] files2 = old.listFiles();
            if (files2 != null) {
                File file = newPath == null ? this.getDir() : new File(this.getDir(), newPath);
                for (int i = 0; i < files2.length; ++i) {
                    File file2 = files2[i];
                    try {
                        if (file2.isHidden()) {
                            FileUtil.delete((File)file2);
                            continue;
                        }
                        file2.renameTo(new File(file, file2.getName()));
                        if (addCommand == null) {
                            addCommand = new AddCommand(this.getRepository());
                        }
                        addCommand.addFilepattern(newPath == null ? file2.getName() : newPath + "/" + file2.getName());
                        continue;
                    }
                    catch (Throwable e) {
                        IcsManagerKt.getLOG().error(e);
                    }
                }
                toDelete.add((Object)new DeleteDirectory(oldPath));
            }
            try {
                FileUtil.delete((File)old);
            }
            catch (Throwable e) {
                IcsManagerKt.getLOG().error(e);
            }
        }
        if (toDelete.isEmpty() && addCommand == null) {
            return false;
        }
        DirCacheEditorKt.edit(this.getRepository(), (List)toDelete);
        if (addCommand != null) {
            addCommand.call();
        }
        object = new IdeaCommitMessageFormatter();
        Repository repository2 = this.getRepository();
        IdeaCommitMessageFormatter $receiver = (IdeaCommitMessageFormatter)receiver;
        StringBuilder stringBuilder = $receiver.appendCommitOwnerInfo(new StringBuilder(), true);
        GitExKt.commit$default(repository2, stringBuilder.append("Get rid of $ROOT_CONFIG$ and $APP_CONFIG").toString(), null, null, null, 14);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final IgnoreNode getIgnoreRules() {
        File file;
        void node;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = this.ignoreRules;
        if ((IgnoreNode)node.element == null && (file = new File(this.getDir(), Constants.DOT_GIT_IGNORE)).exists()) {
            node.element = new IgnoreNode();
            Closeable $receiver = IoPackage.inputStream((File)file);
            boolean closed = false;
            try {
                InputStream it = (InputStream)$receiver;
                IgnoreNode ignoreNode = (IgnoreNode)node.element;
                if (ignoreNode == null) {
                    Intrinsics.throwNpe();
                }
                ignoreNode.parse(it);
                it = Unit.INSTANCE$;
            }
            catch (Exception e) {
                closed = true;
                try {
                    $receiver.close();
                }
                catch (Exception closeException) {
                    // empty catch block
                }
                throw (Throwable)e;
            }
            finally {
                if (!closed) {
                    $receiver.close();
                }
            }
            this.ignoreRules = (IgnoreNode)node.element;
        }
        return (IgnoreNode)node.element;
    }

    @Override
    protected boolean isPathIgnored(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        IgnoreNode ignoreNode = this.getIgnoreRules();
        return Intrinsics.areEqual(ignoreNode != null ? ignoreNode.isIgnored("/" + path, false) : null, (Object)IgnoreNode.MatchResult.IGNORED);
    }

    public GitRepositoryManager(@NotNull NotNullLazyValue<CredentialsStore> credentialsStore2, @NotNull File dir) {
        Intrinsics.checkParameterIsNotNull(credentialsStore2, (String)"credentialsStore");
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        super(dir);
        this.credentialsStore = credentialsStore2;
        this.credentialsProvider$delegate = Delegates.INSTANCE$.lazy((Function0)new Function0<JGitCredentialsProvider>(this){
            final /* synthetic */ GitRepositoryManager this$0;

            @NotNull
            public final JGitCredentialsProvider invoke() {
                return new JGitCredentialsProvider(GitRepositoryManager.access$getCredentialsStore$2(this.this$0), this.this$0.getRepository());
            }
            {
                this.this$0 = gitRepositoryManager;
                super(0);
            }
        });
    }

    @NotNull
    public static final /* synthetic */ ReentrantReadWriteLock access$getLock$1(GitRepositoryManager $this) {
        return $this.getLock();
    }

    @NotNull
    public static final /* synthetic */ NotNullLazyValue<CredentialsStore> access$getCredentialsStore$2(GitRepositoryManager $this) {
        return $this.credentialsStore;
    }
}

