/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.openapi.progress.ProgressIndicator;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.KotlinPackage;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.errors.CheckoutConflictException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.merge.MergeMessageFormatter;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.merge.Merger;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.merge.SquashMessageFormatter;
import org.eclipse.jgit.merge.ThreeWayMergeStrategy;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.RevWalkUtils;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.OperationResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.TrackingRefUpdate;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.ImmutableUpdateResult;
import org.jetbrains.settingsRepository.RepositoryManagerKt;
import org.jetbrains.settingsRepository.UpdateResult;
import org.jetbrains.settingsRepository.git.CommitMessageFormatter;
import org.jetbrains.settingsRepository.git.GitExKt;
import org.jetbrains.settingsRepository.git.GitRepositoryManager;
import org.jetbrains.settingsRepository.git.GitRepositoryManagerKt;
import org.jetbrains.settingsRepository.git.IdeaCommitMessageFormatter;
import org.jetbrains.settingsRepository.git.JGitProgressMonitorKt;
import org.jetbrains.settingsRepository.git.MergeResultEx;
import org.jetbrains.settingsRepository.git.PullKt;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"\u0002\u000e)!\u0001+\u001e7m\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NT!c]3ui&twm\u001d*fa>\u001c\u0018\u000e^8ss*\u0019q-\u001b;\u000b\u0007\u0005s\u0017P\u0003\u0004l_Rd\u0017N\u001c\u0006\u0007y%t\u0017\u000e\u001e \u000b\u000f5\fg.Y4fe*!r)\u001b;SKB|7/\u001b;pefl\u0015M\\1hKJT\u0011\"\u001b8eS\u000e\fGo\u001c:\u000b#A\u0013xn\u001a:fgNLe\u000eZ5dCR|'OC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\b_B,g.\u00199j\u0015!\u0001(o\\4sKN\u001c(BF2p[6LG/T3tg\u0006<WMR8s[\u0006$H/\u001a:\u000b-\r{W.\\5u\u001b\u0016\u001c8/Y4f\r>\u0014X.\u0019;uKJT\u0011dZ3u\u0007>lW.\u001b;NKN\u001c\u0018mZ3G_Jl\u0017\r\u001e;fe*11m\u001c8gS\u001eTAb\u0015;pe\u0016$7i\u001c8gS\u001eTq!Z2mSB\u001cXM\u0003\u0003kO&$(b\u00017jE*92n\u001c;mS:t#N^7/!2\fGOZ8s[RK\b/\u001a\u0006\nO\u0016$8i\u001c8gS\u001eTAbZ3u\u0013:$\u0017nY1u_JT!bZ3u\u001b\u0006t\u0017mZ3s\u00151\u0011X-\\8uK\u000e{gNZ5h\u00151\u0011V-\\8uK\u000e{gNZ5h\u0015%!(/\u00198ta>\u0014HOC\bhKR\u0014V-\\8uK\u000e{gNZ5h\u0015)\u0011X\r]8tSR|'/\u001f\u0006\u000b%\u0016\u0004xn]5u_JL(\"D4fiJ+\u0007o\\:ji>\u0014\u0018PC\u0003gKR\u001c\u0007NC\nqe\u00164(+\u001a4Va\u0012\fG/\u001a*fgVdGO\u0003\u0004SKN,H\u000e\u001e\u0006\n%\u00164W\u000b\u001d3bi\u0016T1AU3g\u0015A\u0011VMZ+qI\u0006$X\r\n*fgVdGOC\u0003nKJ<WMC\u0006v]B,W\r\\3e%\u00164'\"D7fe\u001e,7\u000b\u001e:bi\u0016<\u0017PC\u0007NKJ<Wm\u0015;sCR,w-\u001f\u0006\u0007G>lW.\u001b;\u000b\u000f\t{w\u000e\\3b]*ya-Y:u\r>\u0014x/\u0019:e\u001b>$WMC\bGCN$hi\u001c:xCJ$Wj\u001c3f\u00151iUM]4f\u0007>lW.\u00198e\u0015\r\t\u0007/\u001b\u0006\u0007gF,\u0018m\u001d5\u000b\u0015\u0019|'oY3NKJ<WMC\u0007d_6l\u0017\u000e^'fgN\fw-\u001a\u0006\u0007'R\u0014\u0018N\\4\u000b\u001b5+'oZ3SKN,H\u000e^#y\u0015qiUM]4f\u0007>lW.\u00198eI\u0019\u000b7\u000f\u001e$pe^\f'\u000fZ'pI\u0016TAA[1wC*!A.\u00198h\u0015\u0011\u0001X\u000f\u001c7\u000b)A\u0014XMZ3uG\",GMU3g)>lUM]4f\u00151)\u0006\u000fZ1uKJ+7/\u001e7uy\u000bQ!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0003\t\u0005A!!B\u0002\u0005\u0004!\u0001A\u0002A\u0003\u0002\u0011\r)1\u0001\"\u0002\t\u00061\u0001Qa\u0001C\u0002\u0011\u0013a\u0001!B\u0001\t\r\u0015\u0011A\u0001\u0002E\u0007\u000b\t!I\u0001C\u0004\u0006\u0005\u0011)\u0001rB\u0003\u0004\t\u0017AY\u0001\u0004\u0001\u0006\u0007\u0011\r\u0001\u0012\u0003\u0007\u0001\u000b\t!\u0019\u0001#\u0003\u0006\u0005\u0011-\u00012B\u0003\u0003\t\u0007A\t\"\u0002\u0002\u0005\u0001!UQA\u0001C\t\u0011-)!\u0001B\u0005\t\u0018\u0015\u0019A1\u0003\u0005\u000b\u0019\u0001)!\u0001b\u0005\t\u0015\u0015\u0011A!\u0003\u0005\u0010\u000b\r!1\u0002#\b\r\u0001\u0015\u0011Aa\u0003E\u000f\u000b\r!\u0019\u0002#\t\r\u0001\u0015\u0011A1\u0003E\u0011\u000b\r!\u0019\u0002C\n\r\u0001\u0015\u0019A1\u0004E\u0013\u0019\u0001)1\u0001b\u0005\t(1\u0001QA\u0001C\n\u0011O)!\u0001b\u0005\t)\u0015\u0011A!\u0003E\u0015\u000b\r!\u0001\u0003\u0003\f\r\u0001\u0015\u0019AQ\u0001\u0005\u0018\u0019\u0001)!\u0001B\u0005\t3\u0015\u0019A1\u0005E\u0019\u0019\u0001)1\u0001\u0002\n\t11\u0001Qa\u0001C\u0003\u0011ma\u0001!B\u0002\u0005\u0004!]B\u0002A\u0003\u0003\t\u0007A9$\u0002\u0002\u0005!!1RA\u0001C\u0012\u0011q)\u0011\u0001#\u000f\u0006\u0005\u0011-\u0002\"H\u0003\u0003\tYA1$B\u0002\u0005\u0003!uB\u0002A\u0003\u0003\t\u0005Ai\u0004B\u0006\r\u0005e\u0019Q!\u0001\u0005\u00041\ri\u0003\u0003B2\u00051!\t3!B\u0001\t\u000ea5Qk\u0001\u0005\u0006\u0007\u0011A\u0011\"\u0001\u0005\t\u001b\r!\u0011\"C\u0001\t\u001152Ba\u0019\u0003\u0019\u0014\u0005JQ!\u0001\u0005\u000b!1)B!B\u0001\t\u00151\u0005\u0001D\u0003\r\u000b+\u000eAQa\u0001C\n\u0013\u0005A)\"D\u0002\u0005\u001a%\t\u0001RC\u0017\u0012\t\r$\u0001$B\u0011\u0005\u000b\u0005Aa\u0001$\u0001\u0019\rU\u001b\u0001\"B\u0002\u0005\u000b%\t\u0001rB\u0007\u0004\t5I\u0011\u0001c\u0004.!\u0011\u0019G\u0001\u0007\u0003\"\u0007\u0015\t\u0001r\u0001M\u0004+\u000eAQa\u0001\u0003\u0005\u0013\u0005Aq!D\u0002\u0005\u001c%\t\u0001bB\u0017\u0011\t\r$\u0001DD\u0011\u0004\u000b\u0005A9\u0002g\u0006V\u0007!)1\u0001\u0002\b\n\u0003!aQb\u0001C\u0010\u0013\u0005AA\"\f\t\u0005G\u0012A\u0002#I\u0002\u0006\u0003!e\u0001\u0014D+\u0004\u0011\u0015\u0019A\u0001E\u0005\u0002\u00115i1\u0001B\t\n\u0003!iQf\u0006\u0003\u00041Gi\n\u0002B\u0001\t%5!Q!\u0001\u0005\u000f\u0019\u0003Ab\u0002U\u0002\u0001C\u0011)\u0011\u0001#\b\r\u0002au\u0011kA\u0003\u0005$%\t\u0001bD\u0007\u0002\u0011?iS\u001b\u0001\u0003\u00041Siz\u0001\u0002\u0001\t+5\u0019Q!\u0001E\u000f1;\u00016\u0001AO\b\t\u0005AY#D\u0002\u0006\u0003!\u0005\u0002\u0014\u0005)\u0004\u0002u=A!\u0001E\u0017\u001b\r)\u0011\u0001C\t\u0019#A\u001b\u0011!h\u0004\u0005\u0003!=RbA\u0003\u0002\u0011KA*\u0003UB\u0002;\u001f!\u0011\u0001c\r\u000e\u0007\u0015\t\u0001\"\u0005\r\u0012!\u000e\u0011Qt\u0002\u0003\u0002\u0011ii1!B\u0001\t#a\t\u0002k!\u0002\u001e\u0012\u0011\t\u0001RG\u0007\u0005\u000b\u0005A1\u0003$\u0001\u0019'A\u001b1!I\u0002\u0006\u0003!\u001d\u0002tE)\u0004#\u0011%\u0012\"\u0001\u0005\u0015\u001b\u0005Aq\"D\u0001\t*5\tA\u0011A\u0007\u0002\u0011Ui\u0011\u0001\"\u0001\u000e\u0003\u0011\u0005Q\"\u0001E\u0017[5\"1\u0001g\u000f\u001e\u0010\u0011\t\u00012F\u0007\u0004\u000b\u0005A\t\u0003'\tQ\u0007\u0001i\n\u0002B\u0001\t65!Q!\u0001\u0005\u0014\u0019\u0003A2\u0003UB\u0001;#!\u0011\u0001\u0003\u0010\u000e\t\u0015\t\u0001R\u0004G\u00011;\u00016!A\u0011\u0005\u000b\u0005Aq\u0003$\u0001\u0019/E\u001b\u0011\u0002b\u000f\n\u0003!=R\"\u0001E\u0015\u001b\u0005Ai#D\u0001\t\u001fUfSq\u000b\u0003d\u0002a\u001dQt\u0002\u0003\u0001\u0011\u0011i1!B\u0001\t\ba\u001d\u0001k\u0001\u0001\u001e\u0012\u0011\u0001\u0001\"B\u0007\u0005\u000b\u0005Aa\u0001$\u0001\u0019\rA\u001b\t!h\u0004\u0005\u0003!AQbA\u0003\u0002\u0011\u001bAj\u0001U\u0002\u0002C\r)\u0011\u0001\u0003\u0002\u0019\u0005E\u001b\u0011\u0002b\u0002\n\u0003\u0011\u0001Q\"\u0001\u0005\b\u001b\u0005Ay!D\u0001\t\u0011\u0001"})
public class Pull {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private final Repository repository;
    private final StoredConfig config;
    @NotNull
    private final RemoteConfig remoteConfig;
    @NotNull
    private final GitRepositoryManager manager;
    @Nullable
    private final ProgressIndicator indicator;
    @NotNull
    private final CommitMessageFormatter commitMessageFormatter;

    static {
        $kotlinClass = Reflection.createKotlinClass(Pull.class);
    }

    @NotNull
    public final Repository getRepository() {
        return this.repository;
    }

    public final StoredConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final RemoteConfig getRemoteConfig() {
        return this.remoteConfig;
    }

    @Nullable
    public final UpdateResult pull(@NotNull MergeStrategy mergeStrategy, @Nullable String commitMessage, @Nullable Ref prefetchedRefToMerge) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)mergeStrategy, (String)"mergeStrategy");
        ProgressIndicator progressIndicator = this.indicator;
        if (progressIndicator != null) {
            progressIndicator.checkCanceled();
            unit = Unit.INSTANCE$;
        } else {
            unit = null;
        }
        IcsManagerKt.getLOG().debug("Pull");
        RepositoryState state = PullKt.fixAndGetState(this.repository);
        if (!state.canCheckout()) {
            IcsManagerKt.getLOG().error("Cannot pull, repository in state " + state.getDescription());
            return null;
        }
        Ref ref = prefetchedRefToMerge;
        if (ref == null) {
            ref = Pull.fetch$default(this, null, 1);
        }
        if (ref == null) {
            return null;
        }
        Ref refToMerge = ref;
        MergeResultEx mergeResult = Pull.merge$default(this, refToMerge, mergeStrategy, false, null, false, false, commitMessage, 60);
        MergeResult.MergeStatus mergeStatus = mergeResult.getMergeStatus();
        if (IcsManagerKt.getLOG().isDebugEnabled()) {
            IcsManagerKt.getLOG().debug(mergeStatus.toString());
        }
        if (Intrinsics.areEqual((Object)mergeStatus, (Object)MergeResult.MergeStatus.CONFLICTING)) {
            return PullKt.resolveConflicts(mergeResult, this.repository);
        }
        if (!mergeStatus.isSuccessful()) {
            throw (Throwable)new IllegalStateException(mergeResult.toString());
        }
        return mergeResult.getResult();
    }

    @Nullable
    public static /* synthetic */ UpdateResult pull$default(Pull pull, MergeStrategy mergeStrategy, String string, Ref ref, int n) {
        if ((n & 1) != 0) {
            ThreeWayMergeStrategy threeWayMergeStrategy = MergeStrategy.RECURSIVE;
            Intrinsics.checkExpressionValueIsNotNull((Object)threeWayMergeStrategy, (String)"MergeStrategy.RECURSIVE");
            mergeStrategy = (MergeStrategy)threeWayMergeStrategy;
        }
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            ref = null;
        }
        return pull.pull(mergeStrategy, string, ref);
    }

    @Nullable
    public final Ref fetch(@Nullable RefUpdate.Result prevRefUpdateResult) {
        Unit unit;
        Unit unit2;
        ProgressIndicator progressIndicator = this.indicator;
        if (progressIndicator != null) {
            progressIndicator.checkCanceled();
            unit2 = Unit.INSTANCE$;
        } else {
            unit2 = null;
        }
        FetchResult fetchResult = GitExKt.fetch(this.repository, this.remoteConfig, this.manager.getCredentialsProvider(), JGitProgressMonitorKt.asProgressMonitor(this.indicator));
        if (fetchResult == null) {
            return null;
        }
        FetchResult fetchResult2 = fetchResult;
        if (IcsManagerKt.getLOG().isDebugEnabled()) {
            GitRepositoryManagerKt.printMessages((OperationResult)fetchResult2);
            for (TrackingRefUpdate refUpdate : fetchResult2.getTrackingRefUpdates()) {
                IcsManagerKt.getLOG().debug(refUpdate.toString());
            }
        }
        ProgressIndicator progressIndicator2 = this.indicator;
        if (progressIndicator2 != null) {
            progressIndicator2.checkCanceled();
            unit = Unit.INSTANCE$;
        } else {
            unit = null;
        }
        boolean hasChanges = false;
        for (RefSpec fetchRefSpec : this.remoteConfig.getFetchRefSpecs()) {
            TrackingRefUpdate refUpdate = fetchResult2.getTrackingRefUpdate(fetchRefSpec.getDestination());
            if (refUpdate == null) {
                IcsManagerKt.getLOG().debug("No ref update for " + fetchRefSpec);
                continue;
            }
            RefUpdate.Result refUpdateResult = refUpdate.getResult();
            if (Intrinsics.areEqual((Object)refUpdateResult, (Object)RefUpdate.Result.LOCK_FAILURE) || Intrinsics.areEqual((Object)refUpdateResult, (Object)RefUpdate.Result.IO_FAILURE)) {
                if (Intrinsics.areEqual((Object)prevRefUpdateResult, (Object)refUpdateResult)) {
                    throw (Throwable)new IOException("Ref update result " + refUpdateResult.name() + ", we have already tried to fetch again, but no luck");
                }
                IcsManagerKt.getLOG().warn("Ref update result " + refUpdateResult.name() + ", trying again after 500 ms");
                Thread.sleep(500L);
                return this.fetch(refUpdateResult);
            }
            if (!(Intrinsics.areEqual((Object)refUpdateResult, (Object)RefUpdate.Result.FAST_FORWARD) || Intrinsics.areEqual((Object)refUpdateResult, (Object)RefUpdate.Result.NEW) || Intrinsics.areEqual((Object)refUpdateResult, (Object)RefUpdate.Result.FORCED))) {
                throw (Throwable)new UnsupportedOperationException("Unsupported ref update result");
            }
            if (hasChanges) continue;
            hasChanges = Intrinsics.areEqual((Object)refUpdateResult, (Object)RefUpdate.Result.NO_CHANGE) ^ true;
        }
        if (!hasChanges) {
            IcsManagerKt.getLOG().debug("No remote changes");
            return null;
        }
        Ref ref = fetchResult2.getAdvertisedRef(GitExKt.getRemoteBranchFullName((Config)this.config));
        if (ref == null) {
            throw (Throwable)new IllegalStateException("Could not get advertised ref");
        }
        return ref;
    }

    @Nullable
    public static /* synthetic */ Ref fetch$default(Pull pull, RefUpdate.Result result, int n) {
        if ((n & 1) != 0) {
            result = null;
        }
        return pull.fetch(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final MergeResultEx merge(@NotNull Ref unpeeledRef, @NotNull MergeStrategy mergeStrategy, boolean commit, @NotNull MergeCommand.FastForwardMode fastForwardMode, boolean squash, boolean forceMerge, @Nullable String commitMessage) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)unpeeledRef, (String)"unpeeledRef");
        Intrinsics.checkParameterIsNotNull((Object)mergeStrategy, (String)"mergeStrategy");
        Intrinsics.checkParameterIsNotNull((Object)fastForwardMode, (String)"fastForwardMode");
        ProgressIndicator progressIndicator = this.indicator;
        if (progressIndicator != null) {
            progressIndicator.checkCanceled();
            unit = Unit.INSTANCE$;
        } else {
            unit = null;
        }
        Ref ref = this.repository.getRef(Constants.HEAD);
        if (ref == null) {
            throw (Throwable)new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
        }
        Ref head = ref;
        Ref ref2 = this.repository.peel(unpeeledRef);
        ObjectId objectId = ref2.getPeeledObjectId();
        if (objectId == null) {
            objectId = ref2.getObjectId();
        }
        ObjectId objectId2 = objectId;
        RevWalk revWalk = new RevWalk(this.repository);
        DirCacheCheckout dirCacheCheckout = null;
        try {
            ImmutableUpdateResult result;
            ImmutableUpdateResult immutableUpdateResult;
            boolean noProblems;
            String mergeMessage;
            RevCommit srcCommit = revWalk.lookupCommit((AnyObjectId)objectId2);
            ObjectId headId = head.getObjectId();
            if (headId == null) {
                revWalk.parseHeaders((RevObject)srcCommit);
                dirCacheCheckout = new DirCacheCheckout(this.repository, this.repository.lockDirCache(), (ObjectId)srcCommit.getTree());
                dirCacheCheckout.setFailOnConflict(true);
                dirCacheCheckout.checkout();
                RefUpdate refUpdate = this.repository.updateRef(head.getTarget().getName());
                refUpdate.setNewObjectId((AnyObjectId)objectId2);
                refUpdate.setExpectedOldObjectId((AnyObjectId)null);
                refUpdate.setRefLogMessage("initial pull", false);
                if (Intrinsics.areEqual((Object)refUpdate.update(), (Object)RefUpdate.Result.NEW) ^ true) {
                    throw (Throwable)new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
                }
                ObjectId[] objectIdArray = new ObjectId[]{null, (ObjectId)srcCommit};
                Collection collection = dirCacheCheckout.getUpdated().keySet();
                Collection collection2 = dirCacheCheckout.getRemoved();
                Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"dirCacheCheckout.getRemoved()");
                MergeResultEx mergeResultEx = new MergeResultEx(MergeResult.MergeStatus.FAST_FORWARD, objectIdArray, new ImmutableUpdateResult(collection, collection2), null, 8, null);
                return mergeResultEx;
            }
            StringBuilder refLogMessage = new StringBuilder("merge ");
            refLogMessage.append(ref2.getName());
            RevCommit headCommit = revWalk.lookupCommit((AnyObjectId)headId);
            if (!forceMerge && revWalk.isMergedInto(srcCommit, headCommit)) {
                MergeResultEx mergeResultEx = new MergeResultEx(MergeResult.MergeStatus.ALREADY_UP_TO_DATE, new ObjectId[]{(ObjectId)headCommit, (ObjectId)srcCommit}, RepositoryManagerKt.getEMPTY_UPDATE_RESULT(), null, 8, null);
                return mergeResultEx;
            }
            if (!forceMerge && Intrinsics.areEqual((Object)fastForwardMode, (Object)MergeCommand.FastForwardMode.NO_FF) ^ true && revWalk.isMergedInto(headCommit, srcCommit)) {
                Object squashedCommits;
                MergeResult.MergeStatus mergeStatus;
                refLogMessage.append(": ").append(MergeResult.MergeStatus.FAST_FORWARD);
                dirCacheCheckout = new DirCacheCheckout(this.repository, (ObjectId)headCommit.getTree(), this.repository.lockDirCache(), (ObjectId)srcCommit.getTree());
                dirCacheCheckout.setFailOnConflict(true);
                dirCacheCheckout.checkout();
                if (squash) {
                    mergeStatus = MergeResult.MergeStatus.FAST_FORWARD_SQUASHED;
                    squashedCommits = RevWalkUtils.find((RevWalk)revWalk, (RevCommit)srcCommit, (RevCommit)headCommit);
                    this.repository.writeSquashCommitMsg(new SquashMessageFormatter().format((List)squashedCommits, head));
                } else {
                    ObjectId objectId3 = (ObjectId)srcCommit;
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectId3, (String)"srcCommit");
                    PullKt.updateHead(refLogMessage, objectId3, headId, this.repository);
                    mergeStatus = MergeResult.MergeStatus.FAST_FORWARD;
                }
                ObjectId[] objectIdArray = new ObjectId[]{(ObjectId)headCommit, (ObjectId)srcCommit};
                Collection collection = dirCacheCheckout.getUpdated().keySet();
                Collection collection3 = dirCacheCheckout.getRemoved();
                Intrinsics.checkExpressionValueIsNotNull((Object)collection3, (String)"dirCacheCheckout.getRemoved()");
                squashedCommits = new MergeResultEx(mergeStatus, objectIdArray, new ImmutableUpdateResult(collection, collection3), null, 8, null);
                return squashedCommits;
            }
            if (Intrinsics.areEqual((Object)fastForwardMode, (Object)MergeCommand.FastForwardMode.FF_ONLY)) {
                MergeResultEx mergeStatus = new MergeResultEx(MergeResult.MergeStatus.ABORTED, new ObjectId[]{(ObjectId)headCommit, (ObjectId)srcCommit}, RepositoryManagerKt.getEMPTY_UPDATE_RESULT(), null, 8, null);
                return mergeStatus;
            }
            if (squash) {
                mergeMessage = "";
                this.repository.writeSquashCommitMsg(new SquashMessageFormatter().format(RevWalkUtils.find((RevWalk)revWalk, (RevCommit)srcCommit, (RevCommit)headCommit), head));
            } else {
                mergeMessage = this.commitMessageFormatter.mergeMessage(KotlinPackage.listOf((Object)ref2), head);
                this.repository.writeMergeCommitMsg(mergeMessage);
                this.repository.writeMergeHeads(KotlinPackage.listOf((Object)ref2.getObjectId()));
            }
            Merger merger = mergeStrategy.newMerger(this.repository);
            Map lowLevelResults = null;
            Map failingPaths = null;
            List unmergedPaths = null;
            if (merger instanceof ResolveMerger) {
                ((ResolveMerger)merger).setCommitNames(new String[]{"BASE", "HEAD", ref2.getName()});
                ((ResolveMerger)merger).setWorkingTreeIterator((WorkingTreeIterator)new FileTreeIterator(this.repository));
                noProblems = ((ResolveMerger)merger).merge(new AnyObjectId[]{(AnyObjectId)headCommit, (AnyObjectId)srcCommit});
                lowLevelResults = ((ResolveMerger)merger).getMergeResults();
                failingPaths = ((ResolveMerger)merger).getFailingPaths();
                unmergedPaths = ((ResolveMerger)merger).getUnmergedPaths();
            } else {
                noProblems = merger.merge(new AnyObjectId[]{(AnyObjectId)headCommit, (AnyObjectId)srcCommit});
            }
            refLogMessage.append(": Merge made by ");
            refLogMessage.append(revWalk.isMergedInto(headCommit, srcCommit) ? "recursive" : mergeStrategy.getName());
            refLogMessage.append('.');
            if (merger instanceof ResolveMerger) {
                Collection collection = ((ResolveMerger)merger).getToBeCheckedOut().keySet();
                Collection collection4 = ((ResolveMerger)merger).getToBeDeleted();
                Intrinsics.checkExpressionValueIsNotNull((Object)collection4, (String)"merger.getToBeDeleted()");
                immutableUpdateResult = new ImmutableUpdateResult(collection, collection4);
            } else {
                immutableUpdateResult = result = (ImmutableUpdateResult)null;
            }
            if (noProblems) {
                if (!(merger instanceof ResolveMerger)) {
                    dirCacheCheckout = new DirCacheCheckout(this.repository, (ObjectId)headCommit.getTree(), this.repository.lockDirCache(), merger.getResultTreeId());
                    dirCacheCheckout.setFailOnConflict(true);
                    dirCacheCheckout.checkout();
                    Collection collection = dirCacheCheckout.getUpdated().keySet();
                    Collection collection5 = dirCacheCheckout.getRemoved();
                    Intrinsics.checkExpressionValueIsNotNull((Object)collection5, (String)"dirCacheCheckout.getRemoved()");
                    result = new ImmutableUpdateResult(collection, collection5);
                }
                MergeResult.MergeStatus mergeStatus = null;
                if (!commit && squash) {
                    mergeStatus = MergeResult.MergeStatus.MERGED_SQUASHED_NOT_COMMITTED;
                }
                if (!commit && !squash) {
                    mergeStatus = MergeResult.MergeStatus.MERGED_NOT_COMMITTED;
                }
                if (commit && !squash) {
                    GitExKt.commit$default(this.repository, commitMessage, refLogMessage.toString(), null, null, 12).getId();
                    mergeStatus = MergeResult.MergeStatus.MERGED;
                }
                if (commit && squash) {
                    mergeStatus = MergeResult.MergeStatus.MERGED_SQUASHED;
                }
                MergeResult.MergeStatus mergeStatus2 = mergeStatus;
                if (mergeStatus2 == null) {
                    Intrinsics.throwNpe();
                }
                ObjectId[] objectIdArray = new ObjectId[]{headCommit.getId(), srcCommit.getId()};
                ImmutableUpdateResult immutableUpdateResult2 = result;
                if (immutableUpdateResult2 == null) {
                    Intrinsics.throwNpe();
                }
                MergeResultEx mergeResultEx = new MergeResultEx(mergeStatus2, objectIdArray, immutableUpdateResult2, null, 8, null);
                return mergeResultEx;
            }
            if (failingPaths == null) {
                this.repository.writeMergeCommitMsg(new MergeMessageFormatter().formatWithConflicts(mergeMessage, unmergedPaths));
                ObjectId[] objectIdArray = new ObjectId[]{headCommit.getId(), srcCommit.getId()};
                ImmutableUpdateResult immutableUpdateResult3 = result;
                if (immutableUpdateResult3 == null) {
                    Intrinsics.throwNpe();
                }
                MergeResultEx mergeResultEx = new MergeResultEx(MergeResult.MergeStatus.CONFLICTING, objectIdArray, immutableUpdateResult3, lowLevelResults);
                return mergeResultEx;
            }
            this.repository.writeMergeCommitMsg((String)null);
            this.repository.writeMergeHeads((List)null);
            ObjectId[] objectIdArray = new ObjectId[]{headCommit.getId(), srcCommit.getId()};
            ImmutableUpdateResult immutableUpdateResult4 = result;
            if (immutableUpdateResult4 == null) {
                Intrinsics.throwNpe();
            }
            MergeResultEx mergeResultEx = new MergeResultEx(MergeResult.MergeStatus.FAILED, objectIdArray, immutableUpdateResult4, lowLevelResults);
            return mergeResultEx;
        }
        catch (CheckoutConflictException e) {
            Object object = dirCacheCheckout;
            if (object == null || (object = object.getConflicts()) == null) {
                object = KotlinPackage.listOf();
            }
            throw (Throwable)new org.eclipse.jgit.api.errors.CheckoutConflictException((List)object, e);
        }
        finally {
            revWalk.close();
        }
    }

    @NotNull
    public static /* synthetic */ MergeResultEx merge$default(Pull pull, Ref ref, MergeStrategy mergeStrategy, boolean bl, MergeCommand.FastForwardMode fastForwardMode, boolean bl2, boolean bl3, String string, int n) {
        if ((n & 2) != 0) {
            ThreeWayMergeStrategy threeWayMergeStrategy = MergeStrategy.RECURSIVE;
            Intrinsics.checkExpressionValueIsNotNull((Object)threeWayMergeStrategy, (String)"MergeStrategy.RECURSIVE");
            mergeStrategy = (MergeStrategy)threeWayMergeStrategy;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            fastForwardMode = MergeCommand.FastForwardMode.FF;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        if ((n & 0x20) != 0) {
            bl3 = false;
        }
        if ((n & 0x40) != 0) {
            string = null;
        }
        return pull.merge(ref, mergeStrategy, bl, fastForwardMode, bl2, bl3, string);
    }

    @NotNull
    public final GitRepositoryManager getManager() {
        return this.manager;
    }

    @Nullable
    public final ProgressIndicator getIndicator() {
        return this.indicator;
    }

    @NotNull
    public final CommitMessageFormatter getCommitMessageFormatter() {
        return this.commitMessageFormatter;
    }

    public Pull(@NotNull GitRepositoryManager manager, @Nullable ProgressIndicator indicator, @NotNull CommitMessageFormatter commitMessageFormatter) {
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        Intrinsics.checkParameterIsNotNull((Object)commitMessageFormatter, (String)"commitMessageFormatter");
        this.manager = manager;
        this.indicator = indicator;
        this.commitMessageFormatter = commitMessageFormatter;
        this.repository = this.manager.getRepository();
        this.config = this.repository.getConfig();
        this.remoteConfig = new RemoteConfig((Config)this.config, Constants.DEFAULT_REMOTE_NAME);
    }

    public /* synthetic */ Pull(GitRepositoryManager gitRepositoryManager, ProgressIndicator progressIndicator, CommitMessageFormatter commitMessageFormatter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            commitMessageFormatter = new IdeaCommitMessageFormatter();
        }
        this(gitRepositoryManager, progressIndicator, commitMessageFormatter);
    }
}

