/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.eval4j.jdi;

import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ShortValue;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VoidValue;
import java.util.List;
import kotlin.IndexedValue;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.eval4j.DoubleValue;
import org.jetbrains.eval4j.FloatValue;
import org.jetbrains.eval4j.IntValue;
import org.jetbrains.eval4j.LongValue;
import org.jetbrains.eval4j.NOT_A_VALUE;
import org.jetbrains.eval4j.NewObjectValue;
import org.jetbrains.eval4j.ObjectValue;
import org.jetbrains.eval4j.VOID_VALUE;
import org.jetbrains.eval4j.Value;
import org.jetbrains.eval4j.ValuesKt;
import org.jetbrains.eval4j.jdi.JDIFailureException;
import org.jetbrains.org.objectweb.asm.Opcodes;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"U\u0006))a+\u00197vK*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB3wC2$$N\u0003\u0005kI&\u001cE.Y:t\u0015Q\u0019E.Y:t\u001f\nTWm\u0019;SK\u001a,'/\u001a8dK*\u00191m\\7\u000b\u0007M,hNC\u0002kI&T1bZ3u\u0015\u0012L7\t\\1tg*Y!\nZ5WC2,Xm]&u\u0015\u0019QG-[(cU*yqJ\u00196fGR\u0014VMZ3sK:\u001cWMC\u0005hKRTE-[(cU*\u0001R.Y6f\u0013:LG/[1m\rJ\fW.\u001a\u0006\u000b[\u0016$\bn\u001c3O_\u0012,'BC'fi\"|GMT8eK*IqN\u00196fGR<XM\u0019\u0006\u0004CNl'\u0002\u0002;sK\u0016T\u0011\"\u0019:hk6,g\u000e^:\u000b\t1K7\u000f\u001e\u0006\u0007W>$H.\u001b8\u000b\u000b\u0019\u0013\u0018-\\3\u000b\u0011\u0005t\u0017\r\\=tSNTAA[1wC*!Q\u000f^5m\u0015)\t7O\u00133j-\u0006dW/\u001a\u0006\u0003m6TaBV5siV\fG.T1dQ&tWM\u0003\u0007fqB,7\r^3e)f\u0004XM\u0003\u0003UsB,'BB1t)f\u0004XMC\u0004bgZ\u000bG.^3\u000b\u0017=\u0013'.Z2u-\u0006dW/\u001at\u0002\u0015\t\u0001\u0012A\u0003\u0003\t\u0001A\u0011!\u0002\u0002\u0005\u0002!\rQa\u0001\u0003\u0002\u0011\u0001a\u0001!B\u0001\t\u0007\u0015\u0011AA\u0001E\u0004\u000b\t!)\u0001\u0003\u0003\u0006\u0007\u0011\u0019\u0001R\u0001\u0007\u0001\u000b\t!1\u0001#\u0002\u0006\u0005\u0011\t\u0001\u0002A\u0003\u0004\t\rAa\u0001\u0004\u0001\u0006\u0005\u0011\u0019\u0001BB\u0003\u0003\t\u0003A\t!\u0002\u0002\u0005\r!EQA\u0001C\u0007\u0011%)!\u0001B\u0004\t\u0014\u0015\u0019Aq\u0002\u0005\t\u0019\u0001)\u0011\u0001C\u0006\u0006\u0007\u0011E\u0001R\u0003\u0007\u0001\u000b\t!y\u0001\u0003\u0007\u0006\u0007\u0011M\u0001r\u0003\u0007\u0001\u000b\t!\u0019\u0002c\u0006\u0006\u0005\u0011=\u0001\u0002C\u0003\u0002\u00113)!\u0001b\u0006\t\u001b\u0015\u0011A\u0001\u0004E\u000b\u000b\r!1\u0001#\b\r\u0001\u0015\u0019Aa\u0002E\u0010\u0019\u0001)1\u0001B\u0002\t\u00011\u0001QA\u0001\u0003\u0004\u0011\u0001)!\u0001B\u0002\t\u001e\u0015\u0011Aa\u0002E\u0010\u000b\r!1\u0001c\b\r\u0001\u0015\u0011Aa\u0001E\u0010\u000b\r!\u0011\u0001C\t\r\u0001\u0015\u0011A!\u0001\u0005\u0012\u000bW!1\rB\u000b\u0004\u000b\u0005A\u0019\u0001g\u0001\u0019\u0005\u0005\"Q!\u0001E\u0004\u0019\u0003A:\u0001J\u0012V\u0007\u0019iQ\u0001\"\u0003\n\u0003!!Q\"\u0001E\u00051\u000e)Q1\u0006\u0003d\tU\u0019Q!\u0001E\u00021\u0007AZ!\t\u0003\u0006\u0003!)A\u0012\u0001\r\u0006I\r*6AB\u0007\u0006\t\u001bI\u0011\u0001c\u0003\u000e\u0003!%\u0001lA\u0003\u0006W\u0011\u0019\u0001dBO\b\t\u0001Ay!D\u0002\u0006\u0003!A\u0001\u0004\u0003)\u0004\u0001ueA\u0001\u0001\u0005\u000b\u001b!)\u0011\u0001C\u0005\n\t%\u0019Q!\u0001E\u00021\u0007A\u0012\u0002UB\u0001C!)\u0011\u0001\u0003\u0006\n\t%\u0019Q!\u0001E\u00021\u0007A\"\"U\u0002\b\t\u001dI\u0011\u0001#\u0006\u000e\u0003!YQ\"\u0001E\r1\u000e)Q\u0001\u000b\u0003\u0004+\r)\u0011\u0001c\u0001\u0019\u0004amQt\u0002\u0003\u0001\u00119i1!B\u0001\t\u001bai\u0001k!\u0001\u001e\u0010\u0011\u0001\u0001bD\u0007\u0004\u000b\u0005AY\u0002g\u0007Q\u0007\u0005\tC!B\u0001\t\u001d1\u0005\u0001DD)\u0004\u0013\u0011m\u0011\"\u0001E\u000f\u001b\u0005AI!D\u0001\t\u001f5\t\u0001r\u0004-\u0004\u000b\u0015\u0011BaA\u000b\u0004\u000b\u0005A\u0001\u0003\u0007\t\u0019!\u0005\u001aQ!\u0001E\u000e17\t6!\u0002\u0003\u0011\u0013\u0005Ay\"D\u0001\t\"a\u001bQ!B\n\u0005\u0007U!Q!\u0001\u0005\u0006\u0019\u0003AR\u0001'\t\"\u0007\u0015\t\u0001\"\u0005\r\u0012#\u000e)A\u0011E\u0005\u0002\u0011Gi\u0011\u0001c\u0003Y\u0007\u0015)1\u0003B\u0002\u0016\t\u0015\t\u0001B\u0004G\u000119A\n#I\u0002\u0006\u0003!\r\u00014A)\u0004\u000b\u0011\u0005\u0012\"\u0001E\u0005\u001b\u0005Ai\u0002W\u0002\u0006"})
public final class JdiValuesKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Frame<Value> makeInitialFrame(@NotNull MethodNode methodNode, @NotNull List<? extends Value> arguments2) {
        void value2;
        Intrinsics.checkParameterIsNotNull((Object)methodNode, (String)"methodNode");
        Intrinsics.checkParameterIsNotNull(arguments2, (String)"arguments");
        boolean isStatic = (methodNode.access & Opcodes.ACC_STATIC) != 0;
        Type[] params2 = Type.getArgumentTypes((String)methodNode.desc);
        boolean bl = arguments2.size() == (isStatic ? ((Object[])params2).length : ((Object[])params2).length + 1);
        if (KotlinPackage.getASSERTIONS_ENABLED() && value2 == false) {
            String message = "Wrong number of arguments for " + methodNode + ": " + arguments2;
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        Frame frame = new Frame(methodNode.maxLocals, methodNode.maxStack);
        Type type2 = Type.getReturnType((String)methodNode.desc);
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"Type.getReturnType(methodNode.desc)");
        frame.setReturn((org.jetbrains.org.objectweb.asm.tree.analysis.Value)ValuesKt.makeNotInitializedValue(type2));
        int index2 = 0;
        for (IndexedValue indexedValue : KotlinPackage.withIndex((Iterable)arguments2)) {
            int i = indexedValue.component1();
            Value arg = (Value)indexedValue.component2();
            frame.setLocal(index2++, (org.jetbrains.org.objectweb.asm.tree.analysis.Value)arg);
            if (arg.getSize() != 2) continue;
            frame.setLocal(index2++, (org.jetbrains.org.objectweb.asm.tree.analysis.Value)NOT_A_VALUE.INSTANCE$);
        }
        while (index2 < methodNode.maxLocals) {
            frame.setLocal(index2++, (org.jetbrains.org.objectweb.asm.tree.analysis.Value)NOT_A_VALUE.INSTANCE$);
        }
        return frame;
    }

    @NotNull
    public static final ObjectValue asValue(ObjectReference $receiver) {
        ObjectReference objectReference = $receiver;
        return Intrinsics.areEqual((Object)objectReference, null) ? ValuesKt.getNULL_VALUE() : new ObjectValue($receiver, JdiValuesKt.asType($receiver.type()));
    }

    @NotNull
    public static final Value asValue(com.sun.jdi.Value $receiver) {
        Value value2;
        com.sun.jdi.Value value3 = $receiver;
        if (Intrinsics.areEqual((Object)value3, null)) {
            value2 = ValuesKt.getNULL_VALUE();
        } else if (value3 instanceof VoidValue) {
            value2 = VOID_VALUE.INSTANCE$;
        } else if (value3 instanceof BooleanValue) {
            int n = ((BooleanValue)$receiver).intValue();
            Type type2 = Type.BOOLEAN_TYPE;
            Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"Type.BOOLEAN_TYPE");
            value2 = new IntValue(n, type2);
        } else if (value3 instanceof ByteValue) {
            int n = ((ByteValue)$receiver).intValue();
            Type type3 = Type.BYTE_TYPE;
            Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"Type.BYTE_TYPE");
            value2 = new IntValue(n, type3);
        } else if (value3 instanceof ShortValue) {
            int n = ((ShortValue)$receiver).intValue();
            Type type4 = Type.SHORT_TYPE;
            Intrinsics.checkExpressionValueIsNotNull((Object)type4, (String)"Type.SHORT_TYPE");
            value2 = new IntValue(n, type4);
        } else if (value3 instanceof CharValue) {
            int n = ((CharValue)$receiver).intValue();
            Type type5 = Type.CHAR_TYPE;
            Intrinsics.checkExpressionValueIsNotNull((Object)type5, (String)"Type.CHAR_TYPE");
            value2 = new IntValue(n, type5);
        } else if (value3 instanceof IntegerValue) {
            int n = ((IntegerValue)$receiver).intValue();
            Type type6 = Type.INT_TYPE;
            Intrinsics.checkExpressionValueIsNotNull((Object)type6, (String)"Type.INT_TYPE");
            value2 = new IntValue(n, type6);
        } else if (value3 instanceof com.sun.jdi.LongValue) {
            value2 = new LongValue(((com.sun.jdi.LongValue)$receiver).longValue());
        } else if (value3 instanceof com.sun.jdi.FloatValue) {
            value2 = new FloatValue(((com.sun.jdi.FloatValue)$receiver).floatValue());
        } else if (value3 instanceof com.sun.jdi.DoubleValue) {
            value2 = new DoubleValue(((com.sun.jdi.DoubleValue)$receiver).doubleValue());
        } else if (value3 instanceof ObjectReference) {
            value2 = JdiValuesKt.asValue((ObjectReference)$receiver);
        } else {
            throw (Throwable)new JDIFailureException("Unknown value: " + $receiver, null, 2, null);
        }
        return value2;
    }

    @NotNull
    public static final Type asType(com.sun.jdi.Type $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Type type2 = Type.getType((String)$receiver.signature());
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"Type.getType(this.signature())");
        return type2;
    }

    @Nullable
    public static final ObjectReference getJdiObj(Value $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return (ObjectReference)ValuesKt.obj$default($receiver, null, 1);
    }

    @Nullable
    public static final ClassObjectReference getJdiClass(Value $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return (ClassObjectReference)JdiValuesKt.getJdiObj($receiver);
    }

    @Nullable
    public static final com.sun.jdi.Value asJdiValue(Value $receiver, @NotNull VirtualMachine vm, @NotNull Type expectedType) {
        com.sun.jdi.Value value2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        Intrinsics.checkParameterIsNotNull((Object)expectedType, (String)"expectedType");
        Value value3 = $receiver;
        if (Intrinsics.areEqual((Object)value3, (Object)ValuesKt.getNULL_VALUE())) {
            value2 = null;
        } else if (Intrinsics.areEqual((Object)value3, (Object)VOID_VALUE.INSTANCE$)) {
            value2 = vm.mirrorOfVoid();
        } else if (value3 instanceof IntValue) {
            PrimitiveValue primitiveValue;
            Type type2 = expectedType;
            if (Intrinsics.areEqual((Object)type2, (Object)Type.BOOLEAN_TYPE)) {
                primitiveValue = vm.mirrorOf(ValuesKt.getBoolean($receiver));
            } else if (Intrinsics.areEqual((Object)type2, (Object)Type.BYTE_TYPE)) {
                primitiveValue = vm.mirrorOf((byte)ValuesKt.getInt($receiver));
            } else if (Intrinsics.areEqual((Object)type2, (Object)Type.SHORT_TYPE)) {
                primitiveValue = vm.mirrorOf((short)ValuesKt.getInt($receiver));
            } else if (Intrinsics.areEqual((Object)type2, (Object)Type.CHAR_TYPE)) {
                primitiveValue = vm.mirrorOf((char)ValuesKt.getInt($receiver));
            } else if (Intrinsics.areEqual((Object)type2, (Object)Type.INT_TYPE)) {
                primitiveValue = vm.mirrorOf(ValuesKt.getInt($receiver));
            } else {
                throw (Throwable)new JDIFailureException("Unknown value type: " + $receiver, null, 2, null);
            }
            value2 = primitiveValue;
        } else if (value3 instanceof LongValue) {
            value2 = vm.mirrorOf(((Number)((LongValue)$receiver).getValue()).longValue());
        } else if (value3 instanceof FloatValue) {
            value2 = vm.mirrorOf(((Number)((FloatValue)$receiver).getValue()).floatValue());
        } else if (value3 instanceof DoubleValue) {
            value2 = vm.mirrorOf(((Number)((DoubleValue)$receiver).getValue()).doubleValue());
        } else if (value3 instanceof ObjectValue) {
            Object v = ((ObjectValue)$receiver).getValue();
            if (v == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.ObjectReference");
            }
            value2 = (ObjectReference)v;
        } else if (value3 instanceof NewObjectValue) {
            Object object = ValuesKt.obj$default($receiver, null, 1);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.ObjectReference");
            }
            value2 = (ObjectReference)object;
        } else {
            throw (Throwable)new JDIFailureException("Unknown value: " + $receiver, null, 2, null);
        }
        return value2;
    }
}

