/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.builtins;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.BuiltinsPackage;
import org.jetbrains.kotlin.builtins.BuiltinsPackageFragment;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.functions.BuiltInFictitiousFunctionClassFactory;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleParameters;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptorImpl;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationsImpl;
import org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.JetTypeImpl;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;

public class KotlinBuiltIns {
    public static final Name BUILT_INS_PACKAGE_NAME = Name.identifier("kotlin");
    public static final FqName BUILT_INS_PACKAGE_FQ_NAME = FqName.topLevel(BUILT_INS_PACKAGE_NAME);
    public static final FqName ANNOTATION_PACKAGE_FQ_NAME = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier("annotation"));
    private static volatile KotlinBuiltIns instance = null;
    private static volatile boolean initializing;
    private static Throwable initializationFailed;
    private final ModuleDescriptorImpl builtInsModule;
    private final BuiltinsPackageFragment builtinsPackageFragment;
    private final BuiltinsPackageFragment annotationPackageFragment;
    private final Map<PrimitiveType, JetType> primitiveTypeToArrayJetType;
    private final Map<JetType, JetType> primitiveJetTypeToJetArrayType;
    private final Map<JetType, JetType> jetArrayTypeToPrimitiveJetType;
    public static final FqNames FQ_NAMES;

    private static synchronized void initialize() {
        if (instance == null) {
            if (initializationFailed != null) {
                throw new IllegalStateException("Built-in library initialization failed previously: " + initializationFailed, initializationFailed);
            }
            if (initializing) {
                throw new IllegalStateException("Built-in library initialization loop");
            }
            initializing = true;
            try {
                instance = new KotlinBuiltIns();
                instance.doInitialize();
            }
            catch (Throwable e) {
                initializationFailed = e;
                throw new IllegalStateException("Built-in library initialization failed. Please ensure you have kotlin-runtime.jar in the classpath: " + e, e);
            }
            finally {
                initializing = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static KotlinBuiltIns getInstance() {
        if (initializing) {
            Class<KotlinBuiltIns> clazz = KotlinBuiltIns.class;
            synchronized (KotlinBuiltIns.class) {
                assert (instance != null) : "Built-ins are not initialized (note: We are under the same lock as initializing and instance)";
                KotlinBuiltIns kotlinBuiltIns = instance;
                // ** MonitorExit[var0] (shouldn't be in output)
                if (kotlinBuiltIns == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getInstance"));
                }
                return kotlinBuiltIns;
            }
        }
        if (instance == null) {
            KotlinBuiltIns.initialize();
        }
        KotlinBuiltIns kotlinBuiltIns = instance;
        if (kotlinBuiltIns == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getInstance"));
        }
        return kotlinBuiltIns;
    }

    private KotlinBuiltIns() {
        LockBasedStorageManager storageManager = new LockBasedStorageManager();
        this.builtInsModule = new ModuleDescriptorImpl(Name.special("<built-ins module>"), storageManager, ModuleParameters.Empty.INSTANCE$, this);
        PackageFragmentProvider packageFragmentProvider2 = BuiltinsPackage.createBuiltInPackageFragmentProvider(storageManager, this.builtInsModule, KotlinPackage.setOf((Object[])new FqName[]{BUILT_INS_PACKAGE_FQ_NAME, ANNOTATION_PACKAGE_FQ_NAME, BuiltinsPackage.getKOTLIN_REFLECT_FQ_NAME()}), new BuiltInFictitiousFunctionClassFactory(storageManager, this.builtInsModule), (Function1<? super String, ? extends InputStream>)new Function1<String, InputStream>(){

            public InputStream invoke(String path) {
                return KotlinBuiltIns.class.getClassLoader().getResourceAsStream(path);
            }
        });
        this.builtInsModule.initialize(packageFragmentProvider2);
        this.builtInsModule.setDependencies(this.builtInsModule);
        this.builtinsPackageFragment = (BuiltinsPackageFragment)KotlinPackage.single(packageFragmentProvider2.getPackageFragments(BUILT_INS_PACKAGE_FQ_NAME));
        this.annotationPackageFragment = (BuiltinsPackageFragment)KotlinPackage.single(packageFragmentProvider2.getPackageFragments(ANNOTATION_PACKAGE_FQ_NAME));
        this.primitiveTypeToArrayJetType = new EnumMap<PrimitiveType, JetType>(PrimitiveType.class);
        this.primitiveJetTypeToJetArrayType = new HashMap<JetType, JetType>();
        this.jetArrayTypeToPrimitiveJetType = new HashMap<JetType, JetType>();
    }

    private void doInitialize() {
        for (PrimitiveType primitive : PrimitiveType.values()) {
            this.makePrimitive(primitive);
        }
    }

    private void makePrimitive(@NotNull PrimitiveType primitiveType) {
        if (primitiveType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primitiveType", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "makePrimitive"));
        }
        JetType type2 = this.getBuiltInTypeByClassName(primitiveType.getTypeName().asString());
        JetType arrayType = this.getBuiltInTypeByClassName(primitiveType.getArrayTypeName().asString());
        this.primitiveTypeToArrayJetType.put(primitiveType, arrayType);
        this.primitiveJetTypeToJetArrayType.put(type2, arrayType);
        this.jetArrayTypeToPrimitiveJetType.put(arrayType, type2);
    }

    @NotNull
    public ModuleDescriptorImpl getBuiltInsModule() {
        ModuleDescriptorImpl moduleDescriptorImpl = this.builtInsModule;
        if (moduleDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getBuiltInsModule"));
        }
        return moduleDescriptorImpl;
    }

    @NotNull
    public PackageFragmentDescriptor getBuiltInsPackageFragment() {
        BuiltinsPackageFragment builtinsPackageFragment = this.builtinsPackageFragment;
        if (builtinsPackageFragment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getBuiltInsPackageFragment"));
        }
        return builtinsPackageFragment;
    }

    @NotNull
    public JetScope getBuiltInsPackageScope() {
        JetScope jetScope = this.builtinsPackageFragment.getMemberScope();
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getBuiltInsPackageScope"));
        }
        return jetScope;
    }

    @NotNull
    public JetScope getAnnotationPackageScope() {
        JetScope jetScope = this.annotationPackageFragment.getMemberScope();
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getAnnotationPackageScope"));
        }
        return jetScope;
    }

    @NotNull
    public ClassDescriptor getAnnotationClassByName(@NotNull Name simpleName) {
        if (simpleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "simpleName", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getAnnotationClassByName"));
        }
        ClassifierDescriptor classifier2 = this.annotationPackageFragment.getMemberScope().getClassifier(simpleName, NoLookupLocation.FROM_BUILTINS);
        assert (classifier2 instanceof ClassDescriptor) : "Must be a class descriptor " + simpleName + ", but was " + (classifier2 == null ? "null" : classifier2.toString());
        ClassDescriptor classDescriptor = (ClassDescriptor)classifier2;
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getAnnotationClassByName"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getBuiltInClassByName(@NotNull Name simpleName) {
        if (simpleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "simpleName", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getBuiltInClassByName"));
        }
        ClassDescriptor classDescriptor = this.getBuiltInClassByNameNullable(simpleName);
        assert (classDescriptor != null) : "Must be a class descriptor " + simpleName + ", but was null";
        ClassDescriptor classDescriptor2 = classDescriptor;
        if (classDescriptor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getBuiltInClassByName"));
        }
        return classDescriptor2;
    }

    @Nullable
    public ClassDescriptor getBuiltInClassByNameNullable(@NotNull Name simpleName) {
        if (simpleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "simpleName", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getBuiltInClassByNameNullable"));
        }
        ClassifierDescriptor classifier2 = this.getBuiltInsPackageFragment().getMemberScope().getClassifier(simpleName, NoLookupLocation.FROM_BUILTINS);
        assert (classifier2 == null || classifier2 instanceof ClassDescriptor) : "Must be a class descriptor " + simpleName + ", but was " + classifier2;
        return (ClassDescriptor)classifier2;
    }

    @NotNull
    private ClassDescriptor getBuiltInClassByName(@NotNull String simpleName) {
        if (simpleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "simpleName", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getBuiltInClassByName"));
        }
        ClassDescriptor classDescriptor = this.getBuiltInClassByName(Name.identifier(simpleName));
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getBuiltInClassByName"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getAny() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Any");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getAny"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getNothing() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Nothing");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getNothing"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getPrimitiveClassDescriptor(@NotNull PrimitiveType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getPrimitiveClassDescriptor"));
        }
        ClassDescriptor classDescriptor = this.getBuiltInClassByName(type2.getTypeName().asString());
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getPrimitiveClassDescriptor"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getByte() {
        ClassDescriptor classDescriptor = this.getPrimitiveClassDescriptor(PrimitiveType.BYTE);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getByte"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getShort() {
        ClassDescriptor classDescriptor = this.getPrimitiveClassDescriptor(PrimitiveType.SHORT);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getShort"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getInt() {
        ClassDescriptor classDescriptor = this.getPrimitiveClassDescriptor(PrimitiveType.INT);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getInt"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getLong() {
        ClassDescriptor classDescriptor = this.getPrimitiveClassDescriptor(PrimitiveType.LONG);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getLong"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getFloat() {
        ClassDescriptor classDescriptor = this.getPrimitiveClassDescriptor(PrimitiveType.FLOAT);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getFloat"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getDouble() {
        ClassDescriptor classDescriptor = this.getPrimitiveClassDescriptor(PrimitiveType.DOUBLE);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getDouble"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getChar() {
        ClassDescriptor classDescriptor = this.getPrimitiveClassDescriptor(PrimitiveType.CHAR);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getChar"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getBoolean() {
        ClassDescriptor classDescriptor = this.getPrimitiveClassDescriptor(PrimitiveType.BOOLEAN);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getBoolean"));
        }
        return classDescriptor;
    }

    @NotNull
    public Set<DeclarationDescriptor> getIntegralRanges() {
        Set set = KotlinPackage.setOf((Object[])new DeclarationDescriptor[]{this.getBuiltInClassByName("ByteRange"), this.getBuiltInClassByName("ShortRange"), this.getBuiltInClassByName("CharRange"), this.getBuiltInClassByName("IntRange")});
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getIntegralRanges"));
        }
        return set;
    }

    @NotNull
    public ClassDescriptor getArray() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Array");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getArray"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getPrimitiveArrayClassDescriptor(@NotNull PrimitiveType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getPrimitiveArrayClassDescriptor"));
        }
        ClassDescriptor classDescriptor = this.getBuiltInClassByName(type2.getArrayTypeName().asString());
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getPrimitiveArrayClassDescriptor"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getNumber() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Number");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getNumber"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getUnit() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Unit");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getUnit"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getFunction(int parameterCount) {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Function" + parameterCount);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getFunction"));
        }
        return classDescriptor;
    }

    @Deprecated
    @NotNull
    public ClassDescriptor getExtensionFunction(int parameterCount) {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Function" + (parameterCount + 1));
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getExtensionFunction"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getThrowable() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Throwable");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getThrowable"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getCloneable() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Cloneable");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getCloneable"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getDeprecatedAnnotation() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName(KotlinBuiltIns.FQ_NAMES.deprecated.shortName());
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getDeprecatedAnnotation"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getTargetAnnotation() {
        ClassDescriptor classDescriptor = this.getAnnotationClassByName(KotlinBuiltIns.FQ_NAMES.target.shortName());
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getTargetAnnotation"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getRetentionAnnotation() {
        ClassDescriptor classDescriptor = this.getAnnotationClassByName(KotlinBuiltIns.FQ_NAMES.retention.shortName());
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getRetentionAnnotation"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getRepeatableAnnotation() {
        ClassDescriptor classDescriptor = this.getAnnotationClassByName(KotlinBuiltIns.FQ_NAMES.repeatable.shortName());
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getRepeatableAnnotation"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getMustBeDocumentedAnnotation() {
        ClassDescriptor classDescriptor = this.getAnnotationClassByName(KotlinBuiltIns.FQ_NAMES.mustBeDocumented.shortName());
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getMustBeDocumentedAnnotation"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getAnnotationTargetEnum() {
        ClassDescriptor classDescriptor = this.getAnnotationClassByName(KotlinBuiltIns.FQ_NAMES.annotationTarget.shortName());
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getAnnotationTargetEnum"));
        }
        return classDescriptor;
    }

    @Nullable
    public ClassDescriptor getAnnotationTargetEnumEntry(@NotNull KotlinTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getAnnotationTargetEnumEntry"));
        }
        ClassifierDescriptor result2 = this.getAnnotationTargetEnum().getUnsubstitutedInnerClassesScope().getClassifier(Name.identifier(target.name()), NoLookupLocation.FROM_BUILTINS);
        return result2 instanceof ClassDescriptor ? (ClassDescriptor)result2 : null;
    }

    @NotNull
    public ClassDescriptor getAnnotationRetentionEnum() {
        ClassDescriptor classDescriptor = this.getAnnotationClassByName(KotlinBuiltIns.FQ_NAMES.annotationRetention.shortName());
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getAnnotationRetentionEnum"));
        }
        return classDescriptor;
    }

    @Nullable
    public ClassDescriptor getAnnotationRetentionEnumEntry(@NotNull KotlinRetention retention) {
        if (retention == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "retention", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getAnnotationRetentionEnumEntry"));
        }
        ClassifierDescriptor result2 = this.getAnnotationRetentionEnum().getUnsubstitutedInnerClassesScope().getClassifier(Name.identifier(retention.name()), NoLookupLocation.FROM_BUILTINS);
        return result2 instanceof ClassDescriptor ? (ClassDescriptor)result2 : null;
    }

    @NotNull
    public ClassDescriptor getAnnotationAnnotation() {
        ClassDescriptor classDescriptor = this.getAnnotationClassByName(KotlinBuiltIns.FQ_NAMES.annotation.shortName());
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getAnnotationAnnotation"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getString() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("String");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getString"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getCharSequence() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("CharSequence");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getCharSequence"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getComparable() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Comparable");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getComparable"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getEnum() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Enum");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getEnum"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getAnnotation() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Annotation");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getAnnotation"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getIterator() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Iterator");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getIterator"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getIterable() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Iterable");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getIterable"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getMutableIterable() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("MutableIterable");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getMutableIterable"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getMutableIterator() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("MutableIterator");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getMutableIterator"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getCollection() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Collection");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getCollection"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getMutableCollection() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("MutableCollection");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getMutableCollection"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getList() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("List");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getList"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getMutableList() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("MutableList");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getMutableList"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getSet() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Set");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getSet"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getMutableSet() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("MutableSet");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getMutableSet"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getMap() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Map");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getMap"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getMutableMap() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("MutableMap");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getMutableMap"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getMapEntry() {
        ClassDescriptor classDescriptor = DescriptorUtils.getInnerClassByName(this.getMap(), "Entry", NoLookupLocation.FROM_BUILTINS);
        assert (classDescriptor != null) : "Can't find Map.Entry";
        ClassDescriptor classDescriptor2 = classDescriptor;
        if (classDescriptor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getMapEntry"));
        }
        return classDescriptor2;
    }

    @NotNull
    public ClassDescriptor getMutableMapEntry() {
        ClassDescriptor classDescriptor = DescriptorUtils.getInnerClassByName(this.getMutableMap(), "MutableEntry", NoLookupLocation.FROM_BUILTINS);
        assert (classDescriptor != null) : "Can't find MutableMap.MutableEntry";
        ClassDescriptor classDescriptor2 = classDescriptor;
        if (classDescriptor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getMutableMapEntry"));
        }
        return classDescriptor2;
    }

    @NotNull
    public ClassDescriptor getListIterator() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("ListIterator");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getListIterator"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getMutableListIterator() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("MutableListIterator");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getMutableListIterator"));
        }
        return classDescriptor;
    }

    @NotNull
    private JetType getBuiltInTypeByClassName(@NotNull String classSimpleName) {
        if (classSimpleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classSimpleName", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getBuiltInTypeByClassName"));
        }
        JetType jetType = this.getBuiltInClassByName(classSimpleName).getDefaultType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getBuiltInTypeByClassName"));
        }
        return jetType;
    }

    @NotNull
    public JetType getNothingType() {
        JetType jetType = this.getNothing().getDefaultType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getNothingType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getNullableNothingType() {
        JetType jetType = TypeUtils.makeNullable(this.getNothingType());
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getNullableNothingType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getAnyType() {
        JetType jetType = this.getAny().getDefaultType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getAnyType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getNullableAnyType() {
        JetType jetType = TypeUtils.makeNullable(this.getAnyType());
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getNullableAnyType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getPrimitiveJetType(@NotNull PrimitiveType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getPrimitiveJetType"));
        }
        JetType jetType = this.getPrimitiveClassDescriptor(type2).getDefaultType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getPrimitiveJetType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getByteType() {
        JetType jetType = this.getPrimitiveJetType(PrimitiveType.BYTE);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getByteType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getShortType() {
        JetType jetType = this.getPrimitiveJetType(PrimitiveType.SHORT);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getShortType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getIntType() {
        JetType jetType = this.getPrimitiveJetType(PrimitiveType.INT);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getIntType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getLongType() {
        JetType jetType = this.getPrimitiveJetType(PrimitiveType.LONG);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getLongType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getFloatType() {
        JetType jetType = this.getPrimitiveJetType(PrimitiveType.FLOAT);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getFloatType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getDoubleType() {
        JetType jetType = this.getPrimitiveJetType(PrimitiveType.DOUBLE);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getDoubleType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getCharType() {
        JetType jetType = this.getPrimitiveJetType(PrimitiveType.CHAR);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getCharType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getBooleanType() {
        JetType jetType = this.getPrimitiveJetType(PrimitiveType.BOOLEAN);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getBooleanType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getUnitType() {
        JetType jetType = this.getUnit().getDefaultType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getUnitType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getStringType() {
        JetType jetType = this.getString().getDefaultType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getStringType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getArrayElementType(@NotNull JetType arrayType) {
        if (arrayType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayType", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getArrayElementType"));
        }
        if (KotlinBuiltIns.isArray(arrayType)) {
            if (arrayType.getArguments().size() != 1) {
                throw new IllegalStateException();
            }
            JetType jetType = arrayType.getArguments().get(0).getType();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getArrayElementType"));
            }
            return jetType;
        }
        JetType primitiveType = this.jetArrayTypeToPrimitiveJetType.get(TypeUtils.makeNotNullable(arrayType));
        if (primitiveType == null) {
            throw new IllegalStateException("not array: " + arrayType);
        }
        JetType jetType = primitiveType;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getArrayElementType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getPrimitiveArrayJetType(@NotNull PrimitiveType primitiveType) {
        if (primitiveType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primitiveType", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getPrimitiveArrayJetType"));
        }
        JetType jetType = this.primitiveTypeToArrayJetType.get((Object)primitiveType);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getPrimitiveArrayJetType"));
        }
        return jetType;
    }

    @Nullable
    public JetType getPrimitiveArrayJetTypeByPrimitiveJetType(@NotNull JetType jetType) {
        if (jetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetType", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getPrimitiveArrayJetTypeByPrimitiveJetType"));
        }
        return this.primitiveJetTypeToJetArrayType.get(jetType);
    }

    @Nullable
    public static PrimitiveType getPrimitiveTypeByFqName(@NotNull FqNameUnsafe primitiveClassFqName) {
        if (primitiveClassFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primitiveClassFqName", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getPrimitiveTypeByFqName"));
        }
        return KotlinBuiltIns.FQ_NAMES.fqNameToPrimitiveType.get(primitiveClassFqName);
    }

    @Nullable
    public static PrimitiveType getPrimitiveTypeByArrayClassFqName(@NotNull FqNameUnsafe primitiveArrayClassFqName) {
        if (primitiveArrayClassFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primitiveArrayClassFqName", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getPrimitiveTypeByArrayClassFqName"));
        }
        return KotlinBuiltIns.FQ_NAMES.arrayClassFqNameToPrimitiveType.get(primitiveArrayClassFqName);
    }

    @NotNull
    public JetType getArrayType(@NotNull Variance projectionType, @NotNull JetType argument) {
        if (projectionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectionType", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getArrayType"));
        }
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getArrayType"));
        }
        List<TypeProjectionImpl> types2 = Collections.singletonList(new TypeProjectionImpl(projectionType, argument));
        JetTypeImpl jetTypeImpl = JetTypeImpl.create(Annotations.EMPTY, this.getArray(), false, types2);
        if (jetTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getArrayType"));
        }
        return jetTypeImpl;
    }

    @NotNull
    public JetType getEnumType(@NotNull JetType argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getEnumType"));
        }
        Variance projectionType = Variance.INVARIANT;
        List<TypeProjectionImpl> types2 = Collections.singletonList(new TypeProjectionImpl(projectionType, argument));
        JetTypeImpl jetTypeImpl = JetTypeImpl.create(Annotations.EMPTY, this.getEnum(), false, types2);
        if (jetTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getEnumType"));
        }
        return jetTypeImpl;
    }

    @NotNull
    public JetType getAnnotationType() {
        JetType jetType = this.getAnnotation().getDefaultType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getAnnotationType"));
        }
        return jetType;
    }

    @NotNull
    public ClassDescriptor getPropertyMetadata() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("PropertyMetadata");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getPropertyMetadata"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getPropertyMetadataImpl() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("PropertyMetadataImpl");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getPropertyMetadataImpl"));
        }
        return classDescriptor;
    }

    @NotNull
    public AnnotationDescriptor createExtensionAnnotation() {
        AnnotationDescriptorImpl annotationDescriptorImpl = new AnnotationDescriptorImpl(this.getBuiltInClassByName(KotlinBuiltIns.FQ_NAMES.extension.shortName()).getDefaultType(), Collections.<ValueParameterDescriptor, ConstantValue<?>>emptyMap(), SourceElement.NO_SOURCE);
        if (annotationDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "createExtensionAnnotation"));
        }
        return annotationDescriptorImpl;
    }

    private static boolean isTypeAnnotatedWithExtension(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isTypeAnnotatedWithExtension"));
        }
        return type2.getAnnotations().findAnnotation(KotlinBuiltIns.FQ_NAMES.extension) != null;
    }

    @NotNull
    public JetType getFunctionType(@NotNull Annotations annotations2, @Nullable JetType receiverType, @NotNull List<JetType> parameterTypes, @NotNull JetType returnType2) {
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getFunctionType"));
        }
        if (parameterTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterTypes", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getFunctionType"));
        }
        if (returnType2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getFunctionType"));
        }
        List<TypeProjection> arguments2 = KotlinBuiltIns.getFunctionTypeArgumentProjections(receiverType, parameterTypes, returnType2);
        int size = parameterTypes.size();
        ClassDescriptor classDescriptor = receiverType == null ? this.getFunction(size) : this.getExtensionFunction(size);
        Annotations typeAnnotations2 = receiverType == null ? annotations2 : this.addExtensionAnnotation(annotations2);
        JetTypeImpl jetTypeImpl = JetTypeImpl.create(typeAnnotations2, classDescriptor, false, arguments2);
        if (jetTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getFunctionType"));
        }
        return jetTypeImpl;
    }

    @NotNull
    private Annotations addExtensionAnnotation(@NotNull Annotations annotations2) {
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "addExtensionAnnotation"));
        }
        if (annotations2.findAnnotation(KotlinBuiltIns.FQ_NAMES.extension) != null) {
            Annotations annotations3 = annotations2;
            if (annotations3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "addExtensionAnnotation"));
            }
            return annotations3;
        }
        AnnotationsImpl annotationsImpl = new AnnotationsImpl(KotlinPackage.plus((Iterable)annotations2, (Iterable)KotlinPackage.listOf((Object)this.createExtensionAnnotation())));
        if (annotationsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "addExtensionAnnotation"));
        }
        return annotationsImpl;
    }

    @NotNull
    public static List<TypeProjection> getFunctionTypeArgumentProjections(@Nullable JetType receiverType, @NotNull List<JetType> parameterTypes, @NotNull JetType returnType2) {
        if (parameterTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterTypes", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getFunctionTypeArgumentProjections"));
        }
        if (returnType2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getFunctionTypeArgumentProjections"));
        }
        ArrayList<TypeProjection> arguments2 = new ArrayList<TypeProjection>(parameterTypes.size() + (receiverType != null ? 1 : 0) + 1);
        if (receiverType != null) {
            arguments2.add(KotlinBuiltIns.defaultProjection(receiverType));
        }
        for (JetType parameterType : parameterTypes) {
            arguments2.add(KotlinBuiltIns.defaultProjection(parameterType));
        }
        arguments2.add(KotlinBuiltIns.defaultProjection(returnType2));
        ArrayList<TypeProjection> arrayList = arguments2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getFunctionTypeArgumentProjections"));
        }
        return arrayList;
    }

    private static TypeProjection defaultProjection(JetType returnType2) {
        return new TypeProjectionImpl(Variance.INVARIANT, returnType2);
    }

    public static boolean isArray(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isArray"));
        }
        return KotlinBuiltIns.isConstructedFromGivenClass(type2, KotlinBuiltIns.FQ_NAMES.array);
    }

    public static boolean isPrimitiveArray(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isPrimitiveArray"));
        }
        ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
        return descriptor2 != null && KotlinBuiltIns.getPrimitiveTypeByArrayClassFqName(DescriptorUtils.getFqName(descriptor2)) != null;
    }

    public static boolean isPrimitiveType(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isPrimitiveType"));
        }
        ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
        return !type2.isMarkedNullable() && descriptor2 instanceof ClassDescriptor && KotlinBuiltIns.isPrimitiveClass((ClassDescriptor)descriptor2);
    }

    public static boolean isPrimitiveClass(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isPrimitiveClass"));
        }
        return KotlinBuiltIns.getPrimitiveTypeByFqName(DescriptorUtils.getFqName(descriptor2)) != null;
    }

    public static boolean isFunctionOrExtensionFunctionType(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isFunctionOrExtensionFunctionType"));
        }
        return KotlinBuiltIns.isFunctionType(type2) || KotlinBuiltIns.isExtensionFunctionType(type2);
    }

    public static boolean isFunctionType(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isFunctionType"));
        }
        if (KotlinBuiltIns.isExactFunctionType(type2)) {
            return true;
        }
        for (JetType superType : type2.getConstructor().getSupertypes()) {
            if (!KotlinBuiltIns.isFunctionType(superType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isExtensionFunctionType(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isExtensionFunctionType"));
        }
        if (KotlinBuiltIns.isExactExtensionFunctionType(type2)) {
            return true;
        }
        for (JetType superType : type2.getConstructor().getSupertypes()) {
            if (!KotlinBuiltIns.isExtensionFunctionType(superType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isExactFunctionOrExtensionFunctionType(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isExactFunctionOrExtensionFunctionType"));
        }
        ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
        return descriptor2 != null && KotlinBuiltIns.isNumberedFunctionClassFqName(DescriptorUtils.getFqName(descriptor2));
    }

    public static boolean isExactFunctionType(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isExactFunctionType"));
        }
        return KotlinBuiltIns.isExactFunctionOrExtensionFunctionType(type2) && !KotlinBuiltIns.isTypeAnnotatedWithExtension(type2);
    }

    public static boolean isExactExtensionFunctionType(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isExactExtensionFunctionType"));
        }
        return KotlinBuiltIns.isExactFunctionOrExtensionFunctionType(type2) && KotlinBuiltIns.isTypeAnnotatedWithExtension(type2);
    }

    public static boolean isNumberedFunctionClassFqName(@NotNull FqNameUnsafe fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isNumberedFunctionClassFqName"));
        }
        List<Name> segments = fqName2.pathSegments();
        if (segments.size() != 2) {
            return false;
        }
        if (!BUILT_INS_PACKAGE_NAME.equals(KotlinPackage.first(segments))) {
            return false;
        }
        String shortName = ((Name)KotlinPackage.last(segments)).asString();
        return BuiltInFictitiousFunctionClassFactory.parseClassName(shortName, BUILT_INS_PACKAGE_FQ_NAME) != null;
    }

    @Nullable
    public static JetType getReceiverType(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getReceiverType"));
        }
        assert (KotlinBuiltIns.isFunctionOrExtensionFunctionType(type2)) : type2;
        if (KotlinBuiltIns.isExtensionFunctionType(type2)) {
            return type2.getArguments().get(0).getType();
        }
        return null;
    }

    @NotNull
    public static List<ValueParameterDescriptor> getValueParameters(@NotNull FunctionDescriptor functionDescriptor, @NotNull JetType type2) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getValueParameters"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getValueParameters"));
        }
        assert (KotlinBuiltIns.isFunctionOrExtensionFunctionType(type2));
        List<TypeProjection> parameterTypes = KotlinBuiltIns.getParameterTypeProjectionsFromFunctionType(type2);
        ArrayList<ValueParameterDescriptor> valueParameters = new ArrayList<ValueParameterDescriptor>(parameterTypes.size());
        for (int i = 0; i < parameterTypes.size(); ++i) {
            TypeProjection parameterType = parameterTypes.get(i);
            ValueParameterDescriptorImpl valueParameterDescriptor = new ValueParameterDescriptorImpl(functionDescriptor, null, i, Annotations.EMPTY, Name.identifier("p" + (i + 1)), parameterType.getType(), false, null, SourceElement.NO_SOURCE);
            valueParameters.add(valueParameterDescriptor);
        }
        ArrayList<ValueParameterDescriptor> arrayList = valueParameters;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getValueParameters"));
        }
        return arrayList;
    }

    @NotNull
    public static JetType getReturnTypeFromFunctionType(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getReturnTypeFromFunctionType"));
        }
        assert (KotlinBuiltIns.isFunctionOrExtensionFunctionType(type2));
        List<TypeProjection> arguments2 = type2.getArguments();
        JetType jetType = arguments2.get(arguments2.size() - 1).getType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getReturnTypeFromFunctionType"));
        }
        return jetType;
    }

    @NotNull
    public static List<TypeProjection> getParameterTypeProjectionsFromFunctionType(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getParameterTypeProjectionsFromFunctionType"));
        }
        assert (KotlinBuiltIns.isFunctionOrExtensionFunctionType(type2));
        List<TypeProjection> arguments2 = type2.getArguments();
        int first = KotlinBuiltIns.isExtensionFunctionType(type2) ? 1 : 0;
        int last = arguments2.size() - 2;
        ArrayList<TypeProjection> parameterTypes = new ArrayList<TypeProjection>(last - first + 1);
        for (int i = first; i <= last; ++i) {
            parameterTypes.add(arguments2.get(i));
        }
        ArrayList<TypeProjection> arrayList = parameterTypes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getParameterTypeProjectionsFromFunctionType"));
        }
        return arrayList;
    }

    private static boolean isConstructedFromGivenClass(@NotNull JetType type2, @NotNull FqNameUnsafe fqName2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isConstructedFromGivenClass"));
        }
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isConstructedFromGivenClass"));
        }
        ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
        return descriptor2 != null && descriptor2.getName().equals(fqName2.shortName()) && fqName2.equals(DescriptorUtils.getFqName(descriptor2));
    }

    private static boolean isNotNullConstructedFromGivenClass(@NotNull JetType type2, @NotNull FqNameUnsafe fqName2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isNotNullConstructedFromGivenClass"));
        }
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isNotNullConstructedFromGivenClass"));
        }
        return !type2.isMarkedNullable() && KotlinBuiltIns.isConstructedFromGivenClass(type2, fqName2);
    }

    public static boolean isSpecialClassWithNoSupertypes(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isSpecialClassWithNoSupertypes"));
        }
        FqNameUnsafe fqName2 = DescriptorUtils.getFqName(descriptor2);
        return KotlinBuiltIns.FQ_NAMES.any.equals(fqName2) || KotlinBuiltIns.FQ_NAMES.nothing.equals(fqName2);
    }

    public static boolean isAny(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isAny"));
        }
        return KotlinBuiltIns.isAny(DescriptorUtils.getFqName(descriptor2));
    }

    public static boolean isBoolean(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isBoolean"));
        }
        return KotlinBuiltIns.isConstructedFromGivenClassAndNotNullable(type2, KotlinBuiltIns.FQ_NAMES._boolean);
    }

    public static boolean isBooleanOrNullableBoolean(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isBooleanOrNullableBoolean"));
        }
        return KotlinBuiltIns.isConstructedFromGivenClass(type2, KotlinBuiltIns.FQ_NAMES._boolean);
    }

    public static boolean isBoolean(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isBoolean"));
        }
        return KotlinBuiltIns.FQ_NAMES._boolean.equals(DescriptorUtils.getFqName(classDescriptor));
    }

    public static boolean isChar(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isChar"));
        }
        return KotlinBuiltIns.isConstructedFromGivenClassAndNotNullable(type2, KotlinBuiltIns.FQ_NAMES._char);
    }

    public static boolean isInt(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isInt"));
        }
        return KotlinBuiltIns.isConstructedFromGivenClassAndNotNullable(type2, KotlinBuiltIns.FQ_NAMES._int);
    }

    public static boolean isByte(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isByte"));
        }
        return KotlinBuiltIns.isConstructedFromGivenClassAndNotNullable(type2, KotlinBuiltIns.FQ_NAMES._byte);
    }

    public static boolean isLong(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isLong"));
        }
        return KotlinBuiltIns.isConstructedFromGivenClassAndNotNullable(type2, KotlinBuiltIns.FQ_NAMES._long);
    }

    public static boolean isShort(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isShort"));
        }
        return KotlinBuiltIns.isConstructedFromGivenClassAndNotNullable(type2, KotlinBuiltIns.FQ_NAMES._short);
    }

    public static boolean isFloat(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isFloat"));
        }
        return KotlinBuiltIns.isConstructedFromGivenClassAndNotNullable(type2, KotlinBuiltIns.FQ_NAMES._float);
    }

    public static boolean isDouble(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isDouble"));
        }
        return KotlinBuiltIns.isConstructedFromGivenClassAndNotNullable(type2, KotlinBuiltIns.FQ_NAMES._double);
    }

    private static boolean isConstructedFromGivenClassAndNotNullable(@NotNull JetType type2, @NotNull FqNameUnsafe fqName2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isConstructedFromGivenClassAndNotNullable"));
        }
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isConstructedFromGivenClassAndNotNullable"));
        }
        return KotlinBuiltIns.isConstructedFromGivenClass(type2, fqName2) && !type2.isMarkedNullable();
    }

    public static boolean isAny(@NotNull FqNameUnsafe fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isAny"));
        }
        return KotlinBuiltIns.FQ_NAMES.any.equals(fqName2);
    }

    public static boolean isNothing(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isNothing"));
        }
        return KotlinBuiltIns.isNothingOrNullableNothing(type2) && !type2.isMarkedNullable();
    }

    public static boolean isNullableNothing(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isNullableNothing"));
        }
        return KotlinBuiltIns.isNothingOrNullableNothing(type2) && type2.isMarkedNullable();
    }

    public static boolean isNothingOrNullableNothing(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isNothingOrNullableNothing"));
        }
        return KotlinBuiltIns.isConstructedFromGivenClass(type2, KotlinBuiltIns.FQ_NAMES.nothing);
    }

    public static boolean isAnyOrNullableAny(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isAnyOrNullableAny"));
        }
        return KotlinBuiltIns.isConstructedFromGivenClass(type2, KotlinBuiltIns.FQ_NAMES.any);
    }

    public static boolean isNullableAny(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isNullableAny"));
        }
        return KotlinBuiltIns.isAnyOrNullableAny(type2) && type2.isMarkedNullable();
    }

    public static boolean isDefaultBound(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isDefaultBound"));
        }
        return KotlinBuiltIns.isNullableAny(type2);
    }

    public static boolean isUnit(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isUnit"));
        }
        return KotlinBuiltIns.isNotNullConstructedFromGivenClass(type2, KotlinBuiltIns.FQ_NAMES.unit);
    }

    public boolean isBooleanOrSubtype(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isBooleanOrSubtype"));
        }
        return JetTypeChecker.DEFAULT.isSubtypeOf(type2, this.getBooleanType());
    }

    public static boolean isString(@Nullable JetType type2) {
        return type2 != null && KotlinBuiltIns.isNotNullConstructedFromGivenClass(type2, KotlinBuiltIns.FQ_NAMES.string);
    }

    public static boolean isCollectionOrNullableCollection(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isCollectionOrNullableCollection"));
        }
        return KotlinBuiltIns.isConstructedFromGivenClass(type2, KotlinBuiltIns.FQ_NAMES._collection);
    }

    public static boolean isListOrNullableList(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isListOrNullableList"));
        }
        return KotlinBuiltIns.isConstructedFromGivenClass(type2, KotlinBuiltIns.FQ_NAMES._list);
    }

    public static boolean isSetOrNullableSet(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isSetOrNullableSet"));
        }
        return KotlinBuiltIns.isConstructedFromGivenClass(type2, KotlinBuiltIns.FQ_NAMES._set);
    }

    public static boolean isIterableOrNullableIterable(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isIterableOrNullableIterable"));
        }
        return KotlinBuiltIns.isConstructedFromGivenClass(type2, KotlinBuiltIns.FQ_NAMES._iterable);
    }

    public static boolean isKClass(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isKClass"));
        }
        return KotlinBuiltIns.FQ_NAMES.kClass.equals(DescriptorUtils.getFqName(descriptor2));
    }

    public static boolean isNonPrimitiveArray(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isNonPrimitiveArray"));
        }
        return KotlinBuiltIns.FQ_NAMES.array.equals(DescriptorUtils.getFqName(descriptor2));
    }

    public static boolean isAnnotation(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isAnnotation"));
        }
        return DescriptorUtils.getFqName(descriptor2) == KotlinBuiltIns.FQ_NAMES.annotation.toUnsafe() || KotlinBuiltIns.containsAnnotation(descriptor2, KotlinBuiltIns.FQ_NAMES.annotation);
    }

    public static boolean isCloneable(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isCloneable"));
        }
        return KotlinBuiltIns.FQ_NAMES.cloneable.equals(DescriptorUtils.getFqName(descriptor2));
    }

    public static boolean isData(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isData"));
        }
        return KotlinBuiltIns.containsAnnotation(classDescriptor, KotlinBuiltIns.FQ_NAMES.data);
    }

    public static boolean isDeprecated(@NotNull DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isDeprecated"));
        }
        return KotlinBuiltIns.containsAnnotation(declarationDescriptor, KotlinBuiltIns.FQ_NAMES.deprecated);
    }

    public static boolean isTailRecursive(@NotNull DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isTailRecursive"));
        }
        return KotlinBuiltIns.containsAnnotation(declarationDescriptor, KotlinBuiltIns.FQ_NAMES.tailRecursive) || KotlinBuiltIns.containsAnnotation(declarationDescriptor, KotlinBuiltIns.FQ_NAMES.tailRecursiveDeprecated);
    }

    public static boolean isNoinline(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isNoinline"));
        }
        return KotlinBuiltIns.containsAnnotation(descriptor2, KotlinBuiltIns.FQ_NAMES.noinline);
    }

    public static boolean isSuppressAnnotation(@NotNull AnnotationDescriptor annotationDescriptor) {
        if (annotationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationDescriptor", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "isSuppressAnnotation"));
        }
        return KotlinBuiltIns.isConstructedFromGivenClass(annotationDescriptor.getType(), KotlinBuiltIns.FQ_NAMES.suppress);
    }

    private static boolean containsAnnotation(DeclarationDescriptor descriptor2, FqName annotationClassFqName) {
        DeclarationDescriptor original = descriptor2.getOriginal();
        Annotations annotations2 = original.getAnnotations();
        if (annotations2.findAnnotation(annotationClassFqName) != null) {
            return true;
        }
        AnnotationUseSiteTarget associatedUseSiteTarget = AnnotationUseSiteTarget.Companion.getAssociatedUseSiteTarget(descriptor2);
        return associatedUseSiteTarget != null && Annotations.Companion.findUseSiteTargetedAnnotation(annotations2, associatedUseSiteTarget, annotationClassFqName) != null;
    }

    @NotNull
    public JetType getDefaultBound() {
        JetType jetType = this.getNullableAnyType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getDefaultBound"));
        }
        return jetType;
    }

    @NotNull
    public FunctionDescriptor getIdentityEquals() {
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)KotlinPackage.first(this.getBuiltInsPackageFragment().getMemberScope().getFunctions(Name.identifier("identityEquals"), NoLookupLocation.FROM_BUILTINS));
        if (functionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns", "getIdentityEquals"));
        }
        return functionDescriptor;
    }

    static {
        FQ_NAMES = new FqNames();
    }

    public static class FqNames {
        public final FqNameUnsafe any = FqNames.fqNameUnsafe("Any");
        public final FqNameUnsafe nothing = FqNames.fqNameUnsafe("Nothing");
        public final FqNameUnsafe cloneable = FqNames.fqNameUnsafe("Cloneable");
        public final FqNameUnsafe suppress = FqNames.fqNameUnsafe("Suppress");
        public final FqNameUnsafe unit = FqNames.fqNameUnsafe("Unit");
        public final FqNameUnsafe string = FqNames.fqNameUnsafe("String");
        public final FqNameUnsafe array = FqNames.fqNameUnsafe("Array");
        public final FqNameUnsafe _boolean = FqNames.fqNameUnsafe("Boolean");
        public final FqNameUnsafe _char = FqNames.fqNameUnsafe("Char");
        public final FqNameUnsafe _byte = FqNames.fqNameUnsafe("Byte");
        public final FqNameUnsafe _short = FqNames.fqNameUnsafe("Short");
        public final FqNameUnsafe _int = FqNames.fqNameUnsafe("Int");
        public final FqNameUnsafe _long = FqNames.fqNameUnsafe("Long");
        public final FqNameUnsafe _float = FqNames.fqNameUnsafe("Float");
        public final FqNameUnsafe _double = FqNames.fqNameUnsafe("Double");
        public final FqNameUnsafe _collection = FqNames.fqNameUnsafe("Collection");
        public final FqNameUnsafe _list = FqNames.fqNameUnsafe("List");
        public final FqNameUnsafe _set = FqNames.fqNameUnsafe("Set");
        public final FqNameUnsafe _iterable = FqNames.fqNameUnsafe("Iterable");
        public final FqName data = FqNames.fqName("data");
        public final FqName deprecated = FqNames.fqName("Deprecated");
        public final FqName tailRecursive = FqNames.fqName("tailrec");
        public final FqName tailRecursiveDeprecated = FqNames.fqName("tailRecursive");
        public final FqName inline = FqNames.fqName("inline");
        public final FqName noinline = FqNames.fqName("noinline");
        public final FqName crossinline = FqNames.fqName("crossinline");
        public final FqName inlineOptions = FqNames.fqName("inlineOptions");
        public final FqName extension = FqNames.fqName("Extension");
        public final FqName target = FqNames.annotationName("Target");
        public final FqName annotation = FqNames.annotationName("annotation");
        public final FqName annotationTarget = FqNames.annotationName("AnnotationTarget");
        public final FqName annotationRetention = FqNames.annotationName("AnnotationRetention");
        public final FqName retention = FqNames.annotationName("Retention");
        public final FqName repeatable = FqNames.annotationName("Repeatable");
        public final FqName mustBeDocumented = FqNames.annotationName("MustBeDocumented");
        public final FqName mutableList = FqNames.fqName("MutableList");
        public final FqName mutableSet = FqNames.fqName("MutableSet");
        public final FqName mutableMap = FqNames.fqName("MutableMap");
        public final FqNameUnsafe kClass = new FqName("kotlin.reflect.KClass").toUnsafe();
        public final Map<FqNameUnsafe, PrimitiveType> fqNameToPrimitiveType = new HashMap<FqNameUnsafe, PrimitiveType>(0);
        public final Map<FqNameUnsafe, PrimitiveType> arrayClassFqNameToPrimitiveType = new HashMap<FqNameUnsafe, PrimitiveType>(0);

        public FqNames() {
            for (PrimitiveType primitiveType : PrimitiveType.values()) {
                this.fqNameToPrimitiveType.put(FqNames.fqNameUnsafe(primitiveType.getTypeName().asString()), primitiveType);
                this.arrayClassFqNameToPrimitiveType.put(FqNames.fqNameUnsafe(primitiveType.getArrayTypeName().asString()), primitiveType);
            }
        }

        @NotNull
        private static FqNameUnsafe fqNameUnsafe(@NotNull String simpleName) {
            if (simpleName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "simpleName", "org/jetbrains/kotlin/builtins/KotlinBuiltIns$FqNames", "fqNameUnsafe"));
            }
            FqNameUnsafe fqNameUnsafe = FqNames.fqName(simpleName).toUnsafe();
            if (fqNameUnsafe == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns$FqNames", "fqNameUnsafe"));
            }
            return fqNameUnsafe;
        }

        @NotNull
        private static FqName fqName(@NotNull String simpleName) {
            if (simpleName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "simpleName", "org/jetbrains/kotlin/builtins/KotlinBuiltIns$FqNames", "fqName"));
            }
            FqName fqName2 = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier(simpleName));
            if (fqName2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns$FqNames", "fqName"));
            }
            return fqName2;
        }

        @NotNull
        private static FqName annotationName(@NotNull String simpleName) {
            if (simpleName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "simpleName", "org/jetbrains/kotlin/builtins/KotlinBuiltIns$FqNames", "annotationName"));
            }
            FqName fqName2 = ANNOTATION_PACKAGE_FQ_NAME.child(Name.identifier(simpleName));
            if (fqName2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/KotlinBuiltIns$FqNames", "annotationName"));
            }
            return fqName2;
        }
    }
}

