/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.inline.CapturedParamInfo;
import org.jetbrains.kotlin.codegen.inline.FieldRemapper;
import org.jetbrains.kotlin.codegen.inline.LambdaInfo;
import org.jetbrains.kotlin.codegen.inline.Parameters;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.FieldInsnNode;

public class RegeneratedLambdaFieldRemapper
extends FieldRemapper {
    private final String oldOwnerType;
    private final String newOwnerType;
    private final Parameters parameters;
    private final Map<String, LambdaInfo> recapturedLambdas;
    private final boolean isConstructor;

    public RegeneratedLambdaFieldRemapper(String oldOwnerType, String newOwnerType, Parameters parameters2, Map<String, LambdaInfo> recapturedLambdas, FieldRemapper remapper, boolean isConstructor) {
        super(oldOwnerType, remapper, parameters2);
        this.oldOwnerType = oldOwnerType;
        this.newOwnerType = newOwnerType;
        this.parameters = parameters2;
        this.recapturedLambdas = recapturedLambdas;
        this.isConstructor = isConstructor;
    }

    @Override
    public boolean canProcess(@NotNull String fieldOwner, String fieldName, boolean isFolding) {
        if (fieldOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldOwner", "org/jetbrains/kotlin/codegen/inline/RegeneratedLambdaFieldRemapper", "canProcess"));
        }
        return super.canProcess(fieldOwner, fieldName, isFolding) || this.isRecapturedLambdaType(fieldOwner);
    }

    private boolean isRecapturedLambdaType(String owner) {
        return this.recapturedLambdas.containsKey(owner);
    }

    @Override
    @Nullable
    public CapturedParamInfo findField(@NotNull FieldInsnNode fieldInsnNode, @NotNull Collection<CapturedParamInfo> captured) {
        boolean searchInParent;
        if (fieldInsnNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldInsnNode", "org/jetbrains/kotlin/codegen/inline/RegeneratedLambdaFieldRemapper", "findField"));
        }
        if (captured == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "captured", "org/jetbrains/kotlin/codegen/inline/RegeneratedLambdaFieldRemapper", "findField"));
        }
        boolean bl = searchInParent = !this.canProcess(fieldInsnNode.owner, fieldInsnNode.name, false);
        if (searchInParent) {
            return this.parent.findField(fieldInsnNode);
        }
        return this.findFieldInMyCaptured(fieldInsnNode);
    }

    @Override
    public boolean processNonAload0FieldAccessChains(boolean isInlinedLambda) {
        return isInlinedLambda && this.isConstructor;
    }

    @Nullable
    public CapturedParamInfo findFieldInMyCaptured(@NotNull FieldInsnNode fieldInsnNode) {
        if (fieldInsnNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldInsnNode", "org/jetbrains/kotlin/codegen/inline/RegeneratedLambdaFieldRemapper", "findFieldInMyCaptured"));
        }
        return super.findField(fieldInsnNode, this.parameters.getCaptured());
    }

    @Override
    @Nullable
    public StackValue getFieldForInline(@NotNull FieldInsnNode node, @Nullable StackValue prefix) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/inline/RegeneratedLambdaFieldRemapper", "getFieldForInline"));
        }
        assert (node.name.startsWith("$$$")) : "Captured field template should start with $$$ prefix";
        FieldInsnNode fin = new FieldInsnNode(node.getOpcode(), node.owner, node.name.substring(3), node.desc);
        CapturedParamInfo field2 = this.findFieldInMyCaptured(fin);
        boolean searchInParent = false;
        if (field2 == null) {
            field2 = this.findFieldInMyCaptured(new FieldInsnNode(178, this.oldOwnerType, "this$0", Type.getObjectType((String)this.parent.getLambdaInternalName()).getDescriptor()));
            searchInParent = true;
            if (field2 == null) {
                throw new IllegalStateException("Couldn't find captured this " + this.getLambdaInternalName() + " for " + node.name);
            }
        }
        StackValue.Field result2 = StackValue.field(field2.getType(), Type.getObjectType((String)this.newOwnerType), field2.getNewFieldName(), false, prefix == null ? StackValue.LOCAL_0 : prefix);
        return searchInParent ? this.parent.getFieldForInline(node, result2) : result2;
    }
}

