/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.when;

import java.util.ArrayList;
import java.util.List;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.when.EnumSwitchCodegen;
import org.jetbrains.kotlin.codegen.when.IntegralConstantsSwitchCodegen;
import org.jetbrains.kotlin.codegen.when.StringSwitchCodegen;
import org.jetbrains.kotlin.codegen.when.SwitchCodegen;
import org.jetbrains.kotlin.codegen.when.WhenByEnumsMapping;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetWhenCondition;
import org.jetbrains.kotlin.psi.JetWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.JetWhenEntry;
import org.jetbrains.kotlin.psi.JetWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.IntegerValueConstant;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.org.objectweb.asm.Type;

public class SwitchCodegenUtil {
    public static boolean checkAllItemsAreConstantsSatisfying(@NotNull JetWhenExpression expression2, @NotNull BindingContext bindingContext2, Function1<ConstantValue<?>, Boolean> predicate) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "checkAllItemsAreConstantsSatisfying"));
        }
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "checkAllItemsAreConstantsSatisfying"));
        }
        for (JetWhenEntry entry : expression2.getEntries()) {
            for (JetWhenCondition condition2 : entry.getConditions()) {
                if (!(condition2 instanceof JetWhenConditionWithExpression)) {
                    return false;
                }
                JetExpression patternExpression = ((JetWhenConditionWithExpression)condition2).getExpression();
                if (patternExpression == null) {
                    return false;
                }
                ConstantValue<?> constant = ExpressionCodegen.getCompileTimeConstant(patternExpression, bindingContext2);
                if (constant != null && ((Boolean)predicate.invoke(constant)).booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public static Iterable<ConstantValue<?>> getAllConstants(@NotNull JetWhenExpression expression2, @NotNull BindingContext bindingContext2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "getAllConstants"));
        }
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "getAllConstants"));
        }
        ArrayList result2 = new ArrayList();
        for (JetWhenEntry entry : expression2.getEntries()) {
            SwitchCodegenUtil.addConstantsFromEntry(result2, entry, bindingContext2);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "getAllConstants"));
        }
        return arrayList;
    }

    private static void addConstantsFromEntry(@NotNull List<ConstantValue<?>> result2, @NotNull JetWhenEntry entry, @NotNull BindingContext bindingContext2) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "addConstantsFromEntry"));
        }
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "addConstantsFromEntry"));
        }
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "addConstantsFromEntry"));
        }
        for (JetWhenCondition condition2 : entry.getConditions()) {
            if (!(condition2 instanceof JetWhenConditionWithExpression)) continue;
            JetExpression patternExpression = ((JetWhenConditionWithExpression)condition2).getExpression();
            assert (patternExpression != null) : "expression in when should not be null";
            result2.add(ExpressionCodegen.getCompileTimeConstant(patternExpression, bindingContext2));
        }
    }

    @NotNull
    public static Iterable<ConstantValue<?>> getConstantsFromEntry(@NotNull JetWhenEntry entry, @NotNull BindingContext bindingContext2) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "getConstantsFromEntry"));
        }
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "getConstantsFromEntry"));
        }
        ArrayList result2 = new ArrayList();
        SwitchCodegenUtil.addConstantsFromEntry(result2, entry, bindingContext2);
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "getConstantsFromEntry"));
        }
        return arrayList;
    }

    @Nullable
    public static SwitchCodegen buildAppropriateSwitchCodegenIfPossible(@NotNull JetWhenExpression expression2, boolean isStatement, @NotNull ExpressionCodegen codegen) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "buildAppropriateSwitchCodegenIfPossible"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "buildAppropriateSwitchCodegenIfPossible"));
        }
        BindingContext bindingContext2 = codegen.getBindingContext();
        if (!SwitchCodegenUtil.isThereConstantEntriesButNulls(expression2, bindingContext2)) {
            return null;
        }
        Type subjectType = codegen.expressionType(expression2.getSubjectExpression());
        WhenByEnumsMapping mapping = codegen.getBindingContext().get(CodegenBinding.MAPPING_FOR_WHEN_BY_ENUM, expression2);
        if (mapping != null) {
            return new EnumSwitchCodegen(expression2, isStatement, codegen, mapping);
        }
        if (SwitchCodegenUtil.isIntegralConstantsSwitch(expression2, subjectType, bindingContext2)) {
            return new IntegralConstantsSwitchCodegen(expression2, isStatement, codegen);
        }
        if (SwitchCodegenUtil.isStringConstantsSwitch(expression2, subjectType, bindingContext2)) {
            return new StringSwitchCodegen(expression2, isStatement, codegen);
        }
        return null;
    }

    private static boolean isThereConstantEntriesButNulls(@NotNull JetWhenExpression expression2, @NotNull BindingContext bindingContext2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "isThereConstantEntriesButNulls"));
        }
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "isThereConstantEntriesButNulls"));
        }
        for (ConstantValue<?> constant : SwitchCodegenUtil.getAllConstants(expression2, bindingContext2)) {
            if (constant == null || constant instanceof NullValue) continue;
            return true;
        }
        return false;
    }

    private static boolean isIntegralConstantsSwitch(@NotNull JetWhenExpression expression2, @NotNull Type subjectType, @NotNull BindingContext bindingContext2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "isIntegralConstantsSwitch"));
        }
        if (subjectType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subjectType", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "isIntegralConstantsSwitch"));
        }
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "isIntegralConstantsSwitch"));
        }
        int typeSort = subjectType.getSort();
        if (typeSort != 5 && typeSort != 2 && typeSort != 4 && typeSort != 3) {
            return false;
        }
        return SwitchCodegenUtil.checkAllItemsAreConstantsSatisfying(expression2, bindingContext2, new Function1<ConstantValue<?>, Boolean>(){

            public Boolean invoke(@NotNull ConstantValue<?> constant) {
                if (constant == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constant", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil$1", "invoke"));
                }
                return constant instanceof IntegerValueConstant;
            }
        });
    }

    private static boolean isStringConstantsSwitch(@NotNull JetWhenExpression expression2, @NotNull Type subjectType, @NotNull BindingContext bindingContext2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "isStringConstantsSwitch"));
        }
        if (subjectType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subjectType", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "isStringConstantsSwitch"));
        }
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil", "isStringConstantsSwitch"));
        }
        if (!subjectType.getClassName().equals(String.class.getName())) {
            return false;
        }
        return SwitchCodegenUtil.checkAllItemsAreConstantsSatisfying(expression2, bindingContext2, new Function1<ConstantValue<?>, Boolean>(){

            public Boolean invoke(@NotNull ConstantValue<?> constant) {
                if (constant == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constant", "org/jetbrains/kotlin/codegen/when/SwitchCodegenUtil$2", "invoke"));
                }
                return constant instanceof StringValue || constant instanceof NullValue;
            }
        });
    }
}

