/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.impl;

import java.util.Collections;
import java.util.Set;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.ReadOnly;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.DeclarationDescriptorNonRootImpl;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilPackage;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.resolve.scopes.LazyScopeAdapter;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.JetTypeImpl;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;

public abstract class AbstractTypeParameterDescriptor
extends DeclarationDescriptorNonRootImpl
implements TypeParameterDescriptor {
    private final Variance variance;
    private final boolean reified;
    private final int index;
    private final NotNullLazyValue<TypeConstructor> typeConstructor;
    private final NotNullLazyValue<JetType> defaultType;
    private final NotNullLazyValue<Set<JetType>> upperBounds;
    private final NotNullLazyValue<JetType> upperBoundsAsType;

    protected AbstractTypeParameterDescriptor(final @NotNull StorageManager storageManager, @NotNull DeclarationDescriptor containingDeclaration, @NotNull Annotations annotations2, @NotNull Name name2, @NotNull Variance variance, boolean isReified, int index2, @NotNull SourceElement source) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/kotlin/descriptors/impl/AbstractTypeParameterDescriptor", "<init>"));
        }
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/kotlin/descriptors/impl/AbstractTypeParameterDescriptor", "<init>"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/descriptors/impl/AbstractTypeParameterDescriptor", "<init>"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/descriptors/impl/AbstractTypeParameterDescriptor", "<init>"));
        }
        if (variance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variance", "org/jetbrains/kotlin/descriptors/impl/AbstractTypeParameterDescriptor", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/kotlin/descriptors/impl/AbstractTypeParameterDescriptor", "<init>"));
        }
        super(containingDeclaration, annotations2, name2, source);
        this.variance = variance;
        this.reified = isReified;
        this.index = index2;
        this.typeConstructor = storageManager.createLazyValue(new Function0<TypeConstructor>(){

            public TypeConstructor invoke() {
                return AbstractTypeParameterDescriptor.this.createTypeConstructor();
            }
        });
        this.defaultType = storageManager.createLazyValue(new Function0<JetType>(){

            public JetType invoke() {
                return JetTypeImpl.create(Annotations.EMPTY, AbstractTypeParameterDescriptor.this.getTypeConstructor(), false, Collections.emptyList(), new LazyScopeAdapter(storageManager.createLazyValue(new Function0<JetScope>(){

                    public JetScope invoke() {
                        return AbstractTypeParameterDescriptor.this.getUpperBoundsAsType().getMemberScope();
                    }
                })));
            }
        });
        this.upperBounds = storageManager.createRecursionTolerantLazyValue(new Function0<Set<JetType>>(){

            public Set<JetType> invoke() {
                return AbstractTypeParameterDescriptor.this.resolveUpperBounds();
            }
        }, Collections.singleton(ErrorUtils.createErrorType("Recursion while calculating upper bounds")));
        this.upperBoundsAsType = storageManager.createLazyValue(new Function0<JetType>(){

            public JetType invoke() {
                return AbstractTypeParameterDescriptor.this.computeUpperBoundsAsType();
            }
        });
    }

    @NotNull
    @ReadOnly
    protected abstract Set<JetType> resolveUpperBounds();

    @NotNull
    protected abstract TypeConstructor createTypeConstructor();

    @Override
    @NotNull
    public Variance getVariance() {
        Variance variance = this.variance;
        if (variance == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/AbstractTypeParameterDescriptor", "getVariance"));
        }
        return variance;
    }

    @Override
    public boolean isReified() {
        return this.reified;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    @NotNull
    public Set<JetType> getUpperBounds() {
        Set set = (Set)this.upperBounds.invoke();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/AbstractTypeParameterDescriptor", "getUpperBounds"));
        }
        return set;
    }

    @Override
    @NotNull
    public JetType getUpperBoundsAsType() {
        JetType jetType = (JetType)this.upperBoundsAsType.invoke();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/AbstractTypeParameterDescriptor", "getUpperBoundsAsType"));
        }
        return jetType;
    }

    @NotNull
    private JetType computeUpperBoundsAsType() {
        Set<JetType> upperBounds = this.getUpperBounds();
        assert (!upperBounds.isEmpty()) : "Upper bound list is empty in " + this.getName();
        KotlinBuiltIns builtIns = DescriptorUtilPackage.getBuiltIns(this);
        JetType upperBoundsAsType = TypeIntersector.intersectTypes(builtIns, JetTypeChecker.DEFAULT, upperBounds);
        JetType jetType = upperBoundsAsType != null ? upperBoundsAsType : builtIns.getNothingType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/AbstractTypeParameterDescriptor", "computeUpperBoundsAsType"));
        }
        return jetType;
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        TypeConstructor typeConstructor2 = (TypeConstructor)this.typeConstructor.invoke();
        if (typeConstructor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/AbstractTypeParameterDescriptor", "getTypeConstructor"));
        }
        return typeConstructor2;
    }

    @Override
    @NotNull
    public JetType getDefaultType() {
        JetType jetType = (JetType)this.defaultType.invoke();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/AbstractTypeParameterDescriptor", "getDefaultType"));
        }
        return jetType;
    }

    @Override
    @NotNull
    public Set<JetType> getLowerBounds() {
        Set<JetType> set = Collections.singleton(DescriptorUtilPackage.getBuiltIns(this).getNothingType());
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/AbstractTypeParameterDescriptor", "getLowerBounds"));
        }
        return set;
    }

    @Override
    @Deprecated
    @NotNull
    public TypeParameterDescriptor substitute(@NotNull TypeSubstitutor substitutor3) {
        if (substitutor3 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/descriptors/impl/AbstractTypeParameterDescriptor", "substitute"));
        }
        throw new UnsupportedOperationException("Don't call substitute() on type parameters");
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor2, D data2) {
        return visitor2.visitTypeParameterDescriptor(this, data2);
    }
}

