/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.intellij.ide.IconProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.RowIcon;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.KotlinLightClassForExplicitDeclaration;
import org.jetbrains.kotlin.asJava.KotlinLightClassForFacade;
import org.jetbrains.kotlin.idea.JetIcons;
import org.jetbrains.kotlin.idea.caches.resolve.KotlinLightClassForDecompiledDeclaration;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetEnumEntry;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetModifierList;
import org.jetbrains.kotlin.psi.JetModifierListOwner;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetPackageDirective;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPsiUtil;

public class JetIconProvider
extends IconProvider
implements DumbAware {
    public static JetIconProvider INSTANCE = new JetIconProvider();

    @Nullable
    public static JetClassOrObject getMainClass(@NotNull JetFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/JetIconProvider", "getMainClass"));
        }
        List classes2 = ContainerUtil.filter(file.getDeclarations(), (Condition)new Condition<JetDeclaration>(){

            public boolean value(JetDeclaration jetDeclaration) {
                return jetDeclaration instanceof JetClassOrObject;
            }
        });
        if (classes2.size() == 1 && StringUtil.getPackageName((String)file.getName()).equals(((JetDeclaration)classes2.get(0)).getName())) {
            return (JetClassOrObject)classes2.get(0);
        }
        return null;
    }

    public Icon getIcon(@NotNull PsiElement psiElement2, int flags) {
        if (psiElement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/kotlin/idea/JetIconProvider", "getIcon"));
        }
        if (psiElement2 instanceof JetFile) {
            JetFile file = (JetFile)psiElement2;
            JetClassOrObject mainClass = JetIconProvider.getMainClass(file);
            return mainClass != null && file.getDeclarations().size() == 1 ? this.getIcon(mainClass, flags) : JetIcons.FILE;
        }
        Icon result2 = JetIconProvider.getBaseIcon(psiElement2);
        if ((flags & 1) > 0 && psiElement2 instanceof JetModifierListOwner) {
            JetModifierList list = ((JetModifierListOwner)psiElement2).getModifierList();
            result2 = JetIconProvider.createRowIcon(result2, JetIconProvider.getVisibilityIcon(list));
        }
        return result2;
    }

    private static RowIcon createRowIcon(Icon baseIcon, Icon visibilityIcon) {
        RowIcon rowIcon = new RowIcon(2);
        rowIcon.setIcon(baseIcon, 0);
        rowIcon.setIcon(visibilityIcon, 1);
        return rowIcon;
    }

    public static Icon getVisibilityIcon(@Nullable JetModifierList list) {
        if (list != null) {
            if (list.hasModifier(JetTokens.PRIVATE_KEYWORD)) {
                return PlatformIcons.PRIVATE_ICON;
            }
            if (list.hasModifier(JetTokens.PROTECTED_KEYWORD)) {
                return PlatformIcons.PROTECTED_ICON;
            }
            if (list.hasModifier(JetTokens.PUBLIC_KEYWORD)) {
                return PlatformIcons.PUBLIC_ICON;
            }
        }
        return PlatformIcons.PACKAGE_LOCAL_ICON;
    }

    public static Icon getBaseIcon(PsiElement psiElement2) {
        if (psiElement2 instanceof JetPackageDirective) {
            return PlatformIcons.PACKAGE_ICON;
        }
        if (psiElement2 instanceof KotlinLightClassForFacade) {
            return JetIcons.FILE;
        }
        if (psiElement2 instanceof KotlinLightClassForDecompiledDeclaration) {
            JetClassOrObject origin = ((KotlinLightClassForDecompiledDeclaration)psiElement2).getOrigin();
            if (origin != null) {
                psiElement2 = origin;
            } else {
                return JetIcons.CLASS;
            }
        }
        if (psiElement2 instanceof KotlinLightClassForExplicitDeclaration) {
            psiElement2 = psiElement2.getNavigationElement();
        }
        if (psiElement2 instanceof JetNamedFunction) {
            if (((JetFunction)psiElement2).getReceiverTypeReference() != null) {
                return JetIcons.EXTENSION_FUNCTION;
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)psiElement2, JetNamedDeclaration.class) instanceof JetClass) {
                if (JetPsiUtil.isAbstract((JetFunction)psiElement2)) {
                    return PlatformIcons.ABSTRACT_METHOD_ICON;
                }
                return PlatformIcons.METHOD_ICON;
            }
            return JetIcons.FUNCTION;
        }
        if (psiElement2 instanceof JetFunctionLiteral) {
            return JetIcons.LAMBDA;
        }
        if (psiElement2 instanceof JetClass) {
            JetEnumEntry enumEntry;
            Icon icon;
            JetClass jetClass = (JetClass)psiElement2;
            if (jetClass.isInterface()) {
                return JetIcons.TRAIT;
            }
            Icon icon2 = icon = jetClass.isEnum() ? JetIcons.ENUM : JetIcons.CLASS;
            if (jetClass instanceof JetEnumEntry && (enumEntry = (JetEnumEntry)jetClass).getPrimaryConstructorParameterList() == null) {
                icon = JetIcons.ENUM;
            }
            return icon;
        }
        if (psiElement2 instanceof JetObjectDeclaration) {
            return JetIcons.OBJECT;
        }
        if (psiElement2 instanceof JetParameter) {
            JetParameter parameter = (JetParameter)psiElement2;
            if (JetPsiUtil.getClassIfParameterIsProperty(parameter) != null) {
                return parameter.isMutable() ? JetIcons.FIELD_VAR : JetIcons.FIELD_VAL;
            }
            return JetIcons.PARAMETER;
        }
        if (psiElement2 instanceof JetProperty) {
            JetProperty property = (JetProperty)psiElement2;
            return property.isVar() ? JetIcons.FIELD_VAR : JetIcons.FIELD_VAL;
        }
        return null;
    }
}

