/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import com.intellij.util.cls.ClsFormatException;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"X\u0006)i2\t\\:KCZ\f7\u000b^;c\u0005f4\u0016N\u001d;vC24\u0015\u000e\\3DC\u000eDWMC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\u0011IG-Z1\u000b\r\r\f7\r[3t\u0015\u001d\u0011Xm]8mm\u0016T1!\u00118z\u0015\u0019a\u0014N\\5u}))1-Y2iK*i1i\u001c8dkJ\u0014XM\u001c;NCBTAA[1wC*!Q\u000f^5m\u0015)\u0019wN\\2veJ,g\u000e\u001e\u0006\f-&\u0014H/^1m\r&dWMC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\b_B,g.\u00199j\u0015\r1hm\u001d\u0006\u0018W>$H.\u001b8/UZlg\u0006\u00157bi\u001a|'/\u001c+za\u0016TabQ1dQ\u0016$'*\u0019<b'R,(MC\u0004O_RtU\u000f\u001c7\u000b\u0017\u0005tgn\u001c;bi&|gn\u001d\u0006\u000bGJ,\u0017\r^3TiV\u0014'\u0002\u00024jY\u0016Tq\u0002U:j\u0015\u00064\u0018MR5mKN#XO\u0019\u0006\u0004aNL'\u0002B5na2TQa\u001d;vENT1aZ3u\u0015%\u0019G.Y:t\r&dWMC\nQg&T\u0015M^1GS2,7\u000b^;c\u00136\u0004HNC\u0005D_6\u0004\u0018M\\5p]\"\u000f!B\u0001\t\u0002\u0015\u0011A\u0001\u0001\u0005\u0002\u000b\t!\t\u0001c\u0001\u0006\u0005\u0011\t\u0001BA\u0003\u0003\t\u0007A)!\u0002\u0002\u0005\u0005!\u0019Qa\u0001C\u0003\u0011\u0001a\u0001!B\u0001\t\u0004\u0015\u0019Aq\u0001E\u0004\u0019\u0001)\u0011\u0001c\u0003\u0006\u0005\u0011%\u0001BB\u0003\u0003\t\u0015Ai!B\u0002\u0005\f!)A\u0002A\u0003\u0002\u0011\u001f)!\u0001\"\u0004\t\u0011\u0015\u0011Aa\u0002E\t\u000b\t!y\u0001C\u0005\u0006\u0007\u0011A\u0001b\u0002\u0007\u0001\u000b\r!1\u0001\u0003\u0006\r\u0001\u0015\u0011A\u0011\u0001\u0005\f\u000b\r!\u0019\u0002#\u0006\r\u0001\u0015\u0011A1\u0002\u0005\u0006\u000b\t!q\u0001C\u0007\u0006\u0005\u0011Y\u00012D\u0003\u0003\t/AY!\u0002\u0002\u0005\u0019!qQa\u0001C\r\u00113a\u0001!\u0002\u0002\u0005\u001a!eQA\u0001\u0003\t\u0011\u001d)!\u0001\"\u0007\t\u001c\u0015\u0019AQ\u0004E\u0010\u0019\u0001)!\u0001\"\b\t \u0011\u0019Ab\u0001\t\u00113\r)\u0011\u0001\u0003\u0003\u0019\tu\t!\u0002EW%\t\u0005$\u0001\u0014BQ\u001c\u000b\u0005Aa!\u0003\u0006\n\u0013\u0015\t\u0001\u0012\u0003I\n+\u0011)\u0011\u0001#\u0005\r\u0002aE\u0001\u0014C\u0005\u000b\u0013%)\u0011\u0001C\u0005\u0011\u0014U!Q!\u0001\u0005\n\u0019\u0003A\u0012\u0002G\u0005\u0019\rE\u001b\u0011\u0001\u0002\u0006V\u0007\u0011)1\u0001\"\u0003\n\u0003!UQF\u0006\u0003\u00021/iz\u0001\u0002\u0001\t\u00195\u0019Q!\u0001E\t1#\u00016\u0001A\u0011\u0005\u000b\u0005AQ\u0002$\u0001\u0019\u001bE\u001bQ\u0001b\u0006\n\u0003!mQ\"\u0001\u0005\u000f[Y!1\u0001'\b\u001e\u0010\u0011\u0001\u0001bD\u0007\u0004\u000b\u0005A\t\u0002'\u0005Q\u0007\u0001\tC!B\u0001\t\u001f1\u0005\u0001dD)\u0004\u000b\u0011u\u0011\"\u0001E\u0010\u001b\u0005Aa\"\u000e\u0007\u0006\u0017\u0011\u0019\u000f\u0001\u0007\u0003\"\u0007\u0015\t\u0001b\u0001\r\u0004#\u000e\u0019A\u0001B\u0005\u0002\t\u0001\u0001"})
public final class ClsJavaStubByVirtualFileCache {
    public static final /* synthetic */ KClass $kotlinClass;
    private static final Logger LOG;
    private final ConcurrentMap<VirtualFile, CachedJavaStub> cache = ContainerUtil.createConcurrentWeakKeySoftValueMap();
    public static final Companion Companion;

    static {
        $kotlinClass = Reflection.createKotlinClass(ClsJavaStubByVirtualFileCache.class);
        Companion companion = Companion = new Companion(null);
        LOG = Logger.getInstance(ClsJavaStubByVirtualFileCache.class);
    }

    @Nullable
    public final PsiJavaFileStubImpl get(@NotNull VirtualFile classFile) {
        Intrinsics.checkParameterIsNotNull((Object)classFile, (String)"classFile");
        CachedJavaStub cached = (CachedJavaStub)this.cache.get(classFile);
        long fileModificationStamp = classFile.getModificationStamp();
        if (cached != null && cached.getModificationStamp() == fileModificationStamp) {
            return cached.getJavaFileStub();
        }
        PsiJavaFileStubImpl psiJavaFileStubImpl = (PsiJavaFileStubImpl)this.createStub(classFile);
        if (psiJavaFileStubImpl == null) {
            return null;
        }
        PsiJavaFileStubImpl stub = psiJavaFileStubImpl;
        this.cache.put(classFile, new CachedJavaStub(fileModificationStamp, stub));
        return stub;
    }

    private final PsiJavaFileStub createStub(VirtualFile file) {
        if (file.getFileType() != JavaClassFileType.INSTANCE) {
            return null;
        }
        try {
            return ClsFileImpl.buildFileStub((VirtualFile)file, (byte[])file.contentsToByteArray());
        }
        catch (ClsFormatException e) {
            ClsJavaStubByVirtualFileCache.Companion.getLOG().debug((Throwable)e);
        }
        catch (IOException e) {
            ClsJavaStubByVirtualFileCache.Companion.getLOG().debug((Throwable)e);
        }
        Logger logger = ClsJavaStubByVirtualFileCache.Companion.getLOG();
        StringBuilder stringBuilder = new StringBuilder().append("Failed to build java cls class for ");
        String string = file.getCanonicalPath();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        logger.error(stringBuilder.append(string).toString());
        return null;
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"v\u0004)q1)Y2iK\u0012T\u0015M^1TiV\u0014'\"H\"mg*\u000bg/Y*uk\n\u0014\u0015PV5siV\fGNR5mK\u000e\u000b7\r[3\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:TA!\u001b3fC*11-Y2iKNTqA]3t_24XMC\u0002B]fTa\u0001P5oSRt$\"E7pI&4\u0017nY1uS>t7\u000b^1na*!Aj\u001c8h\u00151Q\u0017M^1GS2,7\u000b^;c\u0015M\u00016/\u001b&bm\u00064\u0015\u000e\\3TiV\u0014\u0017*\u001c9m\u0015\r\u0019w.\u001c\u0006\tS:$X\r\u001c7jU*\u0019\u0001o]5\u000b\t%l\u0007\u000f\u001c\u0006\u0005U\u00064\u0018MC\u0003tiV\u00147OC\bhKRT\u0015M^1GS2,7\u000b^;c\u0015Q9W\r^'pI&4\u0017nY1uS>t7\u000b^1narT!\u0001\u0005\u0002\u000b\t!\u0001\u0001c\u0001\u0006\u0005\u0011\u0005\u0001BA\u0003\u0003\t\u0005A)!\u0002\u0002\u0005\u0004!\u0019QA\u0001\u0003\u0003\u0011\u000f)1\u0001\"\u0002\t\u00021\u0001Qa\u0001\u0003\u0004\u0011\u0001a\u0001!B\u0001\t\u0005\u0015\u0019A\u0001\u0002\u0005\u0005\u0019\u0001)1\u0001\u0002\u0003\t\f1\u0001Q!\u0001\u0005\b\u000b\t!Y\u0001c\u0004\u0006\u0005\u00111\u0001\u0002C\u0003\u0003\t\u001bA\t\"\u0002\u0002\u0005\u000f!IQA\u0001C\b\u0011')!\u0001\u0002\u0005\t\u0012\u0015\u0019A\u0011\u0003E\u0007\u0019\u0001)!\u0001\"\u0005\t\u000e\u0011\tArA\r\u0004\u000b\u0005AI\u0001'\u0003.!\u0011\u0019G\u0001\u0007\u0004\"\u0007\u0015\t\u0001\"\u0003\r\n+\u000eAQa\u0001\u0003\u0007\u0013\u0005A\u0019\"D\u0002\u0005\u0015%\t\u00012C\u0017\u0011\t\r$\u0001$B\u0011\u0004\u000b\u0005AQ\u0001G\u0003V\u0007!)1\u0001B\u0003\n\u0003\u0011\u001dQb\u0001C\u000b\u0013\u0005!9!N\u0011\u0006A\u0011\u0019\u000f\u0001'\u0003\u001e\u0010\u0011\u0001\u0001\"B\u0007\u0004\u000b\u0005AQ\u0001G\u0003Q\u0007\u0001iz\u0001\u0002\u0001\t\r5\u0019Q!\u0001\u0005\n1%\u00016\u0011A\u0011\u0004\u000b\u0005A9\u0001g\u0002R\u0007\u001d!I!C\u0001\u0005\u00015\tAqA\u0007\u0002\u0011'\u0001"})
    private static final class CachedJavaStub {
        public static final /* synthetic */ KClass $kotlinClass;
        private final long modificationStamp;
        @NotNull
        private final PsiJavaFileStubImpl javaFileStub;

        static {
            $kotlinClass = Reflection.createKotlinClass(CachedJavaStub.class);
        }

        public final long getModificationStamp() {
            return this.modificationStamp;
        }

        @NotNull
        public final PsiJavaFileStubImpl getJavaFileStub() {
            return this.javaFileStub;
        }

        public CachedJavaStub(long modificationStamp, @NotNull PsiJavaFileStubImpl javaFileStub) {
            Intrinsics.checkParameterIsNotNull((Object)javaFileStub, (String)"javaFileStub");
            this.modificationStamp = modificationStamp;
            this.javaFileStub = javaFileStub;
        }
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"M\u0004)I1i\\7qC:LwN\u001c\u0006\u001e\u00072\u001c(*\u0019<b'R,(MQ=WSJ$X/\u00197GS2,7)Y2iK*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgN\u0003\u0003jI\u0016\f'BB2bG\",7OC\u0004sKN|GN^3\u000b\u0007\u0005s\u0017PC\u0002M\u001f\u001eSa\u0001T8hO\u0016\u0014(bA2p[*A\u0011N\u001c;fY2L'NC\u0004pa\u0016t\u0017\r]5\u000b\u0015\u0011L\u0017m\u001a8pgRL7MC\u0004O_RtU\u000f\u001c7\u000b\u0017\u0005tgn\u001c;bi&|gn\u001d\u0006\u0007O\u0016$HjT$\u000b\u0017\u001d,G/\u00138ti\u0006t7-\u001a\u0006\baJ|'.Z2u\u0015\u001d\u0001&o\u001c6fGRT\u0019A\u0003\u0002\u0011\u0005)!\u0001\u0002\u0001\t\u0004\u0015\u0011A\u0011\u0001\u0005\u0003\u000b\t!\u0011\u0001#\u0002\u0006\u0005\u0011\r\u0001bA\u0003\u0003\t\tA9!B\u0002\u0005\u0006!\u0005A\u0002A\u0003\u0004\t\rA\u0001\u0001\u0004\u0001\u0006\u0003!\u0011Qa\u0001\u0003\u0005\u0011\u0011a\u0001!B\u0001\t\f\u0015\u0011A!\u0002\u0005\u0007\u000b\t!Y\u0001#\u0004\u0006\u0005\u00111\u0001bB\u0003\u0004\t\u001bAQ\u0001\u0004\u0001\u0006\u0005\u0011\u0005\u0001\u0002C\u0003\u0004\t\u001fAy\u0001\u0004\u0001\u0006\u0005\u00115\u0001\"B\u0003\u0003\t\u0019A\u0019\"B\u0002\u0005\u0013!QA\u0002A\u0003\u0003\t\u000bA\t!\u0002\u0002\u0005\u0013!QAaq\u0001\r\be\u0019Q!\u0001E\u00051\u0013i;\u0003B1\u00051\u0013\t[!B\u0001\t\u000fa9\u0011kA\u0001\u0005\u0011U\u001b\u0011\"\u0002\u0003\u0005\n%\t\u0001\u0012\u0003G\u0001\u001b\r!\t\"C\u0001\t\u00125*Ba\u0001\r\n;\u001f!\u0001\u0001c\u0005\u000e\u0007\u0015\t\u00012\u0003M\n!\u000e\u0001\u0011eA\u0003\u0002\u0011\rA2!U\u0002\u0006\t%I\u0011\u0001\u0003\u0006\u000e\u0003!UQ\u0007\u0001"})
    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        private final Logger getLOG() {
            return LOG;
        }

        @NotNull
        public final ClsJavaStubByVirtualFileCache getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            ClsJavaStubByVirtualFileCache clsJavaStubByVirtualFileCache = (ClsJavaStubByVirtualFileCache)ServiceManager.getService((Project)project, ClsJavaStubByVirtualFileCache.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)clsJavaStubByVirtualFileCache, (String)"ServiceManager.getServic\u2026ualFileCache::class.java)");
            return clsJavaStubByVirtualFileCache;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

