/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetLabelReferenceExpression;
import org.jetbrains.kotlin.psi.JetOperationReferenceExpression;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.scopes.receivers.Qualifier;
import org.jetbrains.kotlin.types.JetType;

public class CodeInsightUtils {
    @Nullable
    public static JetExpression findExpression(@NotNull PsiFile file, int startOffset, int endOffset) {
        ClassifierDescriptor classifier2;
        JetExpression statement;
        List<JetExpression> statements;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findExpression"));
        }
        PsiElement element2 = CodeInsightUtils.findElementOfClassAtRange(file, startOffset, endOffset, JetExpression.class);
        if (element2 == null) {
            return null;
        }
        if (element2 instanceof JetOperationReferenceExpression && ((JetOperationReferenceExpression)element2).getReferencedNameElementType() != JetTokens.IDENTIFIER && element2.getParent() instanceof JetBinaryExpression) {
            return null;
        }
        if (JetPsiUtil.isLabelIdentifierExpression(element2)) {
            element2 = PsiTreeUtil.getParentOfType((PsiElement)element2, JetExpression.class);
        }
        if (element2 instanceof JetBlockExpression && (statements = ((JetBlockExpression)element2).getStatements()).size() == 1 && (statement = statements.get(0)).getText().equals(element2.getText())) {
            return statement;
        }
        JetExpression expression2 = (JetExpression)element2;
        BindingContext context = ResolutionUtils.analyze(expression2);
        Qualifier qualifier = context.get(BindingContext.QUALIFIER, expression2);
        if (!(qualifier == null || (classifier2 = qualifier.getClassifier()) instanceof ClassDescriptor && ((ClassDescriptor)classifier2).getKind() == ClassKind.OBJECT)) {
            return null;
        }
        return expression2;
    }

    @NotNull
    public static PsiElement[] findStatements(@NotNull PsiFile file, int startOffset, int endOffset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findStatements"));
        }
        PsiElement element1 = CodeInsightUtils.getElementAtOffsetIgnoreWhitespaceBefore(file, startOffset);
        PsiElement element2 = CodeInsightUtils.getElementAtOffsetIgnoreWhitespaceAfter(file, endOffset);
        if (element1 == null || element2 == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findStatements"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        startOffset = element1.getTextRange().getStartOffset();
        if (startOffset >= (endOffset = element2.getTextRange().getEndOffset())) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findStatements"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        if (parent == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findStatements"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        while (!(parent instanceof JetBlockExpression)) {
            if (parent == null || parent instanceof JetFile) {
                if (PsiElement.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findStatements"));
                }
                return PsiElement.EMPTY_ARRAY;
            }
            parent = parent.getParent();
        }
        if (startOffset != (element1 = CodeInsightUtils.getTopmostParentInside(element1, parent)).getTextRange().getStartOffset()) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findStatements"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (endOffset != (element2 = CodeInsightUtils.getTopmostParentInside(element2, parent)).getTextRange().getEndOffset()) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findStatements"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        PsiElement stopElement = element2.getNextSibling();
        for (PsiElement currentElement = element1; currentElement != stopElement; currentElement = currentElement.getNextSibling()) {
            if (currentElement instanceof PsiWhiteSpace) continue;
            array.add(currentElement);
        }
        for (PsiElement element3 : array) {
            if (element3 instanceof JetExpression || element3.getNode().getElementType() == JetTokens.SEMICOLON || element3 instanceof PsiWhiteSpace || element3 instanceof PsiComment) continue;
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findStatements"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(array);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findStatements"));
        }
        return psiElementArray;
    }

    @Nullable
    public static PsiElement findElementOfClassAtRange(@NotNull PsiFile file, int startOffset, int endOffset, Class<JetExpression> aClass) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findElementOfClassAtRange"));
        }
        PsiElement element1 = CodeInsightUtils.getParentLabelOrElement(CodeInsightUtils.getElementAtOffsetIgnoreWhitespaceBefore(file, startOffset));
        PsiElement element2 = CodeInsightUtils.getParentLabelOrElement(CodeInsightUtils.getElementAtOffsetIgnoreWhitespaceAfter(file, endOffset));
        if (element1 == null || element2 == null) {
            return null;
        }
        startOffset = element1.getTextRange().getStartOffset();
        JetExpression jetExpression = (JetExpression)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file, (int)startOffset, (int)(endOffset = element2.getTextRange().getEndOffset()), aClass);
        if (jetExpression == null || jetExpression.getTextRange().getStartOffset() != startOffset || jetExpression.getTextRange().getEndOffset() != endOffset) {
            return null;
        }
        return jetExpression;
    }

    private static PsiElement getParentLabelOrElement(@Nullable PsiElement element2) {
        if (element2 != null && element2.getParent() instanceof JetLabelReferenceExpression) {
            return element2.getParent();
        }
        return element2;
    }

    @NotNull
    public static List<PsiElement> findElementsOfClassInRange(@NotNull PsiFile file, int startOffset, int endOffset, Class<? extends PsiElement> ... classes2) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findElementsOfClassInRange"));
        }
        PsiElement element1 = CodeInsightUtils.getElementAtOffsetIgnoreWhitespaceBefore(file, startOffset);
        PsiElement element2 = CodeInsightUtils.getElementAtOffsetIgnoreWhitespaceAfter(file, endOffset);
        if (element1 == null || element2 == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findElementsOfClassInRange"));
            }
            return list;
        }
        startOffset = element1.getTextRange().getStartOffset();
        endOffset = element2.getTextRange().getEndOffset();
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        if (parent == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findElementsOfClassInRange"));
            }
            return list;
        }
        if (startOffset != (element1 = CodeInsightUtils.getTopmostParentInside(element1, parent)).getTextRange().getStartOffset()) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findElementsOfClassInRange"));
            }
            return list;
        }
        if (endOffset != (element2 = CodeInsightUtils.getTopmostParentInside(element2, parent)).getTextRange().getEndOffset()) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findElementsOfClassInRange"));
            }
            return list;
        }
        PsiElement stopElement = element2.getNextSibling();
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        for (PsiElement currentElement = element1; currentElement != stopElement && currentElement != null; currentElement = currentElement.getNextSibling()) {
            for (Class<? extends PsiElement> aClass : classes2) {
                if (aClass.isInstance(currentElement)) {
                    result2.add(currentElement);
                }
                result2.addAll(PsiTreeUtil.findChildrenOfType((PsiElement)currentElement, aClass));
            }
        }
        ArrayList<PsiElement> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findElementsOfClassInRange"));
        }
        return arrayList;
    }

    @NotNull
    private static PsiElement getTopmostParentInside(@NotNull PsiElement element2, @NotNull PsiElement parent) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "getTopmostParentInside"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "getTopmostParentInside"));
        }
        if (!parent.equals(element2)) {
            while (!parent.equals(element2.getParent())) {
                element2 = element2.getParent();
            }
        }
        PsiElement psiElement2 = element2;
        if (psiElement2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "getTopmostParentInside"));
        }
        return psiElement2;
    }

    @Nullable
    public static PsiElement getElementAtOffsetIgnoreWhitespaceBefore(@NotNull PsiFile file, int offset2) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "getElementAtOffsetIgnoreWhitespaceBefore"));
        }
        PsiElement element2 = file.findElementAt(offset2);
        if (element2 instanceof PsiWhiteSpace) {
            return file.findElementAt(element2.getTextRange().getEndOffset());
        }
        return element2;
    }

    @Nullable
    public static PsiElement getElementAtOffsetIgnoreWhitespaceAfter(@NotNull PsiFile file, int offset2) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "getElementAtOffsetIgnoreWhitespaceAfter"));
        }
        PsiElement element2 = file.findElementAt(offset2 - 1);
        if (element2 instanceof PsiWhiteSpace) {
            return file.findElementAt(element2.getTextRange().getStartOffset() - 1);
        }
        return element2;
    }

    @Nullable
    public static String defaultInitializer(JetType type2) {
        if (type2.isMarkedNullable()) {
            return "null";
        }
        if (KotlinBuiltIns.isInt(type2) || KotlinBuiltIns.isLong(type2) || KotlinBuiltIns.isShort(type2) || KotlinBuiltIns.isByte(type2)) {
            return "0";
        }
        if (KotlinBuiltIns.isFloat(type2)) {
            return "0.0f";
        }
        if (KotlinBuiltIns.isDouble(type2)) {
            return "0.0";
        }
        if (KotlinBuiltIns.isChar(type2)) {
            return "'\\u0000'";
        }
        if (KotlinBuiltIns.isBoolean(type2)) {
            return "false";
        }
        if (KotlinBuiltIns.isUnit(type2)) {
            return "Unit";
        }
        if (KotlinBuiltIns.isString(type2)) {
            return "\"\"";
        }
        return null;
    }

    public static void showErrorHint(@NotNull Project project, @NotNull Editor editor, @NotNull String message, @NotNull String title, @Nullable String helpId) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "showErrorHint"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "showErrorHint"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "showErrorHint"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "showErrorHint"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException(message);
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)title, (String)helpId);
    }

    private CodeInsightUtils() {
    }

    @Nullable
    public static Integer getStartLineOffset(@NotNull PsiFile file, int line) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "getStartLineOffset"));
        }
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document == null) {
            return null;
        }
        if (line >= document.getLineCount()) {
            return null;
        }
        int lineStartOffset = document.getLineStartOffset(line);
        return CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)lineStartOffset, (String)" \t");
    }

    @Nullable
    public static Integer getEndLineOffset(@NotNull PsiFile file, int line) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "getEndLineOffset"));
        }
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document == null) {
            return null;
        }
        if (line >= document.getLineCount()) {
            return null;
        }
        int lineStartOffset = document.getLineEndOffset(line);
        return CharArrayUtil.shiftBackward((CharSequence)document.getCharsSequence(), (int)lineStartOffset, (String)" \t");
    }

    @Nullable
    public static PsiElement getTopmostElementAtOffset(@NotNull PsiElement element2, int offset2) {
        PsiElement parent;
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "getTopmostElementAtOffset"));
        }
        while ((parent = element2.getParent()) != null && parent.getTextOffset() >= offset2 && !(parent instanceof JetBlockExpression)) {
            element2 = parent;
        }
        return element2;
    }

    @Nullable
    public static <T> T getTopmostElementAtOffset(@NotNull PsiElement element2, int offset2, @NotNull Class<T> klass) {
        PsiElement parent;
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "getTopmostElementAtOffset"));
        }
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "getTopmostElementAtOffset"));
        }
        PsiElement lastElementOfType = null;
        if (klass.isInstance(element2)) {
            lastElementOfType = element2;
        }
        while ((parent = element2.getParent()) != null && parent.getTextOffset() >= offset2 && !(parent instanceof JetBlockExpression)) {
            if (klass.isInstance(parent)) {
                lastElementOfType = parent;
            }
            element2 = parent;
        }
        return (T)lastElementOfType;
    }
}

