/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.upDownMover;

import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInsight.upDownMover.AbstractJetUpDownMover;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetClassBody;
import org.jetbrains.kotlin.psi.JetClassInitializer;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetEnumEntry;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetModifierList;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPropertyAccessor;
import org.jetbrains.kotlin.psi.JetTypeParameter;
import org.jetbrains.kotlin.psi.JetTypeParameterList;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetVisitorVoid;

public class JetDeclarationMover
extends AbstractJetUpDownMover {
    private boolean moveEnumConstant = false;
    private static final Class[] DECLARATION_CONTAINER_CLASSES = new Class[]{JetClassBody.class, JetClassInitializer.class, JetFunction.class, JetPropertyAccessor.class, JetFile.class};
    private static final Class[] CLASSBODYLIKE_DECLARATION_CONTAINER_CLASSES = new Class[]{JetClassBody.class, JetFile.class};

    private static int findNearestNonWhitespace(@NotNull CharSequence sequence2, int index2) {
        if (sequence2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetDeclarationMover", "findNearestNonWhitespace"));
        }
        char ch = sequence2.charAt(--index2);
        while (Character.isWhitespace(ch)) {
            ch = sequence2.charAt(--index2);
        }
        return index2;
    }

    public void afterMove(@NotNull Editor editor, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetDeclarationMover", "afterMove"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetDeclarationMover", "afterMove"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetDeclarationMover", "afterMove"));
        }
        super.afterMove(editor, file, info, down);
        if (this.moveEnumConstant) {
            int end2;
            char c2;
            int end1;
            Document document = editor.getDocument();
            CharSequence cs = document.getCharsSequence();
            char c1 = cs.charAt(end1 = JetDeclarationMover.findNearestNonWhitespace(cs, info.range1.getEndOffset()));
            if (c1 == (c2 = cs.charAt(end2 = JetDeclarationMover.findNearestNonWhitespace(cs, info.range2.getEndOffset()))) || c1 != ',' && c2 != ',') {
                return;
            }
            if (c1 == ';' || c2 == ';') {
                document.replaceString(end1, end1 + 1, (CharSequence)String.valueOf(c2));
                document.replaceString(end2, end2 + 1, (CharSequence)String.valueOf(c1));
            } else if (c1 == ',') {
                document.deleteString(end1, end1 + 1);
                document.insertString(end2 + 1, (CharSequence)",");
            } else {
                document.deleteString(end2, end2 + 1);
                document.insertString(end1 + 1, (CharSequence)",");
            }
        }
    }

    @NotNull
    private static List<PsiElement> getDeclarationAnchors(@NotNull JetDeclaration declaration) {
        PsiElement nameIdentifier;
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetDeclarationMover", "getDeclarationAnchors"));
        }
        final ArrayList<PsiElement> memberSuspects = new ArrayList<PsiElement>();
        JetModifierList modifierList = declaration.getModifierList();
        if (modifierList != null) {
            memberSuspects.add((PsiElement)modifierList);
        }
        if (declaration instanceof JetNamedDeclaration && (nameIdentifier = ((JetNamedDeclaration)declaration).getNameIdentifier()) != null) {
            memberSuspects.add(nameIdentifier);
        }
        declaration.accept(new JetVisitorVoid(){

            @Override
            public void visitAnonymousInitializer(@NotNull JetClassInitializer initializer) {
                if (initializer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetDeclarationMover$1", "visitAnonymousInitializer"));
                }
                PsiElement brace = initializer.getOpenBraceNode();
                if (brace != null) {
                    memberSuspects.add(brace);
                }
            }

            @Override
            public void visitNamedFunction(@NotNull JetNamedFunction function2) {
                JetTypeReference returnTypeRef;
                JetTypeReference receiverTypeRef;
                JetTypeParameterList typeParameterList;
                if (function2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetDeclarationMover$1", "visitNamedFunction"));
                }
                PsiElement equalsToken = function2.getEqualsToken();
                if (equalsToken != null) {
                    memberSuspects.add(equalsToken);
                }
                if ((typeParameterList = function2.getTypeParameterList()) != null) {
                    memberSuspects.add(typeParameterList);
                }
                if ((receiverTypeRef = function2.getReceiverTypeReference()) != null) {
                    memberSuspects.add(receiverTypeRef);
                }
                if ((returnTypeRef = function2.getTypeReference()) != null) {
                    memberSuspects.add(returnTypeRef);
                }
            }

            @Override
            public void visitProperty(@NotNull JetProperty property) {
                JetTypeReference returnTypeRef;
                JetTypeReference receiverTypeRef;
                JetTypeParameterList typeParameterList;
                if (property == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetDeclarationMover$1", "visitProperty"));
                }
                PsiElement valOrVarKeyword = property.getValOrVarKeyword();
                if (valOrVarKeyword != null) {
                    memberSuspects.add(valOrVarKeyword);
                }
                if ((typeParameterList = property.getTypeParameterList()) != null) {
                    memberSuspects.add(typeParameterList);
                }
                if ((receiverTypeRef = property.getReceiverTypeReference()) != null) {
                    memberSuspects.add(receiverTypeRef);
                }
                if ((returnTypeRef = property.getTypeReference()) != null) {
                    memberSuspects.add(returnTypeRef);
                }
            }
        });
        ArrayList<PsiElement> arrayList = memberSuspects;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetDeclarationMover", "getDeclarationAnchors"));
        }
        return arrayList;
    }

    @Nullable
    private static JetDeclaration getMovableDeclaration(@Nullable PsiElement element2) {
        if (element2 == null) {
            return null;
        }
        JetDeclaration declaration = (JetDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element2, JetDeclaration.class, (boolean)false);
        if (declaration instanceof JetParameter) {
            return null;
        }
        if (declaration instanceof JetTypeParameter) {
            return JetDeclarationMover.getMovableDeclaration(declaration.getParent());
        }
        return PsiTreeUtil.instanceOf((Object)PsiTreeUtil.getParentOfType((PsiElement)declaration, (Class[])DECLARATION_CONTAINER_CLASSES), (Class[])CLASSBODYLIKE_DECLARATION_CONTAINER_CLASSES) ? declaration : null;
    }

    @Override
    protected boolean checkSourceElement(@NotNull PsiElement element2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetDeclarationMover", "checkSourceElement"));
        }
        return element2 instanceof JetDeclaration;
    }

    @Override
    protected LineRange getElementSourceLineRange(@NotNull PsiElement element2, @NotNull Editor editor, @NotNull LineRange oldRange) {
        PsiElement last;
        PsiElement first;
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetDeclarationMover", "getElementSourceLineRange"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetDeclarationMover", "getElementSourceLineRange"));
        }
        if (oldRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldRange", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetDeclarationMover", "getElementSourceLineRange"));
        }
        if (element2 instanceof JetDeclaration) {
            first = element2.getFirstChild();
            last = element2.getLastChild();
            if (first == null || last == null) {
                return null;
            }
        } else {
            first = last = element2;
        }
        TextRange textRange1 = first.getTextRange();
        TextRange textRange2 = last.getTextRange();
        Document doc = editor.getDocument();
        if (doc.getTextLength() < textRange2.getEndOffset()) {
            return null;
        }
        int startLine = editor.offsetToLogicalPosition((int)textRange1.getStartOffset()).line;
        int endLine = editor.offsetToLogicalPosition((int)textRange2.getEndOffset()).line + 1;
        if (element2 instanceof PsiComment || startLine == oldRange.startLine || startLine == oldRange.endLine || endLine == oldRange.startLine || endLine == oldRange.endLine) {
            return new LineRange(startLine, endLine);
        }
        TextRange lineTextRange = new TextRange(doc.getLineStartOffset(oldRange.startLine), doc.getLineEndOffset(oldRange.endLine));
        if (element2 instanceof JetDeclaration) {
            for (PsiElement anchor2 : JetDeclarationMover.getDeclarationAnchors((JetDeclaration)element2)) {
                TextRange suspectTextRange = anchor2.getTextRange();
                if (suspectTextRange == null || !lineTextRange.intersects(suspectTextRange)) continue;
                return new LineRange(startLine, endLine);
            }
        }
        return null;
    }

    @Nullable
    private static LineRange getTargetRange(@NotNull Editor editor, @NotNull PsiElement sibling, boolean down, @NotNull PsiElement target) {
        JetClassOrObject jetClassOrObject;
        JetClassBody classBody;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetDeclarationMover", "getTargetRange"));
        }
        if (sibling == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sibling", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetDeclarationMover", "getTargetRange"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetDeclarationMover", "getTargetRange"));
        }
        PsiElement start = sibling;
        PsiElement end = sibling;
        JetClassBody nextParent = null;
        if (sibling.getNode().getElementType() == (down ? JetTokens.RBRACE : JetTokens.LBRACE)) {
            PsiElement parent = sibling.getParent();
            if (!(parent instanceof JetClassBody)) {
                return null;
            }
            if (target instanceof JetEnumEntry) {
                return null;
            }
            JetClassOrObject jetClassOrObject2 = (JetClassOrObject)parent.getParent();
            assert (jetClassOrObject2 != null);
            nextParent = jetClassOrObject2.getParent();
            if (!down) {
                start = jetClassOrObject2;
            }
        } else if (sibling instanceof JetClassOrObject && (classBody = (jetClassOrObject = (JetClassOrObject)sibling).getBody()) != null) {
            nextParent = classBody;
            if (!down) {
                start = classBody.getRBrace();
            }
            PsiElement psiElement2 = end = down ? classBody.getLBrace() : classBody.getRBrace();
        }
        if (nextParent != null) {
            if (target instanceof JetClassInitializer && !(nextParent instanceof JetClassBody)) {
                return null;
            }
            if (target instanceof JetEnumEntry) {
                if (!(nextParent instanceof JetClassBody)) {
                    return null;
                }
                JetClassOrObject nextClassOrObject = (JetClassOrObject)nextParent.getParent();
                assert (nextClassOrObject != null);
                if (!nextClassOrObject.hasModifier(JetTokens.ENUM_KEYWORD)) {
                    return null;
                }
            }
        }
        if (target instanceof JetPropertyAccessor && !(sibling instanceof JetPropertyAccessor)) {
            return null;
        }
        return start != null && end != null ? new LineRange(start, end, editor.getDocument()) : null;
    }

    @Override
    public boolean checkAvailable(@NotNull Editor editor, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetDeclarationMover", "checkAvailable"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetDeclarationMover", "checkAvailable"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetDeclarationMover", "checkAvailable"));
        }
        if (!super.checkAvailable(editor, file, info, down)) {
            return false;
        }
        LineRange oldRange = info.toMove;
        Pair psiRange = JetDeclarationMover.getElementRange((Editor)editor, (PsiFile)file, (LineRange)oldRange);
        if (psiRange == null) {
            return false;
        }
        JetDeclaration firstDecl = JetDeclarationMover.getMovableDeclaration((PsiElement)psiRange.getFirst());
        if (firstDecl == null) {
            return false;
        }
        this.moveEnumConstant = firstDecl instanceof JetEnumEntry;
        JetDeclaration lastDecl = JetDeclarationMover.getMovableDeclaration((PsiElement)psiRange.getSecond());
        if (lastDecl == null) {
            return false;
        }
        LineRange sourceRange = this.getSourceRange(firstDecl, lastDecl, editor, oldRange);
        if (sourceRange == null) {
            return false;
        }
        PsiElement sibling = JetDeclarationMover.getLastNonWhiteSiblingInLine(JetDeclarationMover.firstNonWhiteSibling(sourceRange, down), editor, down);
        if (sibling == null) {
            info.toMove2 = null;
            return true;
        }
        info.toMove = sourceRange;
        info.toMove2 = JetDeclarationMover.getTargetRange(editor, sibling, down, sourceRange.firstElement);
        return true;
    }
}

