/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.upDownMover;

import com.google.common.base.Predicate;
import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInsight.upDownMover.AbstractJetUpDownMover;
import org.jetbrains.kotlin.idea.core.refactoring.RefactoringPackage;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetClassBody;
import org.jetbrains.kotlin.psi.JetClassInitializer;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetDoWhileExpression;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetFunctionLiteralArgument;
import org.jetbrains.kotlin.psi.JetIfExpression;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPropertyAccessor;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetValueArgument;
import org.jetbrains.kotlin.psi.JetWhenEntry;
import org.jetbrains.kotlin.psi.JetWhenExpression;
import org.jetbrains.kotlin.psi.PsiPackage;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilPackage;

public class JetExpressionMover
extends AbstractJetUpDownMover {
    private static final Predicate<JetElement> IS_CALL_EXPRESSION = new Predicate<JetElement>(){

        public boolean apply(@Nullable JetElement input) {
            return input instanceof JetCallExpression;
        }
    };
    private static final Class[] MOVABLE_ELEMENT_CLASSES = new Class[]{JetExpression.class, JetWhenEntry.class, JetValueArgument.class, PsiComment.class};
    private static final Function1<PsiElement, Boolean> MOVABLE_ELEMENT_CONSTRAINT = new Function1<PsiElement, Boolean>(){

        @NotNull
        public Boolean invoke(PsiElement element2) {
            Boolean bl = !(element2 instanceof JetExpression) || element2 instanceof JetDeclaration || element2 instanceof JetBlockExpression || element2.getParent() instanceof JetBlockExpression;
            if (bl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetExpressionMover$2", "invoke"));
            }
            return bl;
        }
    };
    private static final Class[] BLOCKLIKE_ELEMENT_CLASSES = new Class[]{JetBlockExpression.class, JetWhenExpression.class, JetClassBody.class, JetFile.class};
    private static final Class[] FUNCTIONLIKE_ELEMENT_CLASSES = new Class[]{JetFunction.class, JetPropertyAccessor.class, JetClassInitializer.class};
    private static final Predicate<JetElement> CHECK_BLOCK_LIKE_ELEMENT = new Predicate<JetElement>(){

        public boolean apply(@Nullable JetElement input) {
            return (input instanceof JetBlockExpression || input instanceof JetClassBody) && !PsiTreeUtil.instanceOf((Object)input.getParent(), (Class[])FUNCTIONLIKE_ELEMENT_CLASSES);
        }
    };
    private static final Predicate<JetElement> CHECK_BLOCK = new Predicate<JetElement>(){

        public boolean apply(@Nullable JetElement input) {
            return input instanceof JetBlockExpression && !PsiTreeUtil.instanceOf((Object)input.getParent(), (Class[])FUNCTIONLIKE_ELEMENT_CLASSES);
        }
    };
    @Nullable
    private Pair<PsiElement, PsiElement> parametersOrArgsToMove;

    @Nullable
    private static PsiElement getStandaloneClosingBrace(@NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetExpressionMover", "getStandaloneClosingBrace"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetExpressionMover", "getStandaloneClosingBrace"));
        }
        LineRange range = JetExpressionMover.getLineRangeFromSelection((Editor)editor);
        if (range.endLine - range.startLine != 1) {
            return null;
        }
        int offset2 = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        int line = document.getLineNumber(offset2);
        int lineStartOffset = document.getLineStartOffset(line);
        String lineText = document.getText().substring(lineStartOffset, document.getLineEndOffset(line));
        if (!lineText.trim().equals("}")) {
            return null;
        }
        return file.findElementAt(lineStartOffset + lineText.indexOf(125));
    }

    private static BraceStatus checkForMovableDownClosingBrace(@NotNull PsiElement closingBrace, @NotNull PsiElement block, @NotNull Editor editor, @NotNull StatementUpDownMover.MoveInfo info) {
        if (closingBrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closingBrace", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetExpressionMover", "checkForMovableDownClosingBrace"));
        }
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetExpressionMover", "checkForMovableDownClosingBrace"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetExpressionMover", "checkForMovableDownClosingBrace"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetExpressionMover", "checkForMovableDownClosingBrace"));
        }
        PsiElement current = block;
        PsiElement nextElement = null;
        PsiElement nextExpression = null;
        do {
            PsiElement sibling;
            if ((sibling = JetExpressionMover.firstNonWhiteElement((PsiElement)current.getNextSibling(), (boolean)true)) != null && nextElement == null) {
                nextElement = sibling;
            }
            if (!(sibling instanceof JetExpression)) continue;
            nextExpression = sibling;
            break;
        } while ((current = current.getParent()) != null && !PsiTreeUtil.instanceOf((Object)current, (Class[])BLOCKLIKE_ELEMENT_CLASSES));
        if (nextExpression == null) {
            return BraceStatus.NOT_MOVABLE;
        }
        Document doc = editor.getDocument();
        info.toMove = new LineRange(closingBrace, closingBrace, doc);
        info.toMove2 = new LineRange(nextElement, nextExpression);
        info.indentSource = true;
        return BraceStatus.MOVABLE;
    }

    private static BraceStatus checkForMovableUpClosingBrace(@NotNull PsiElement closingBrace, PsiElement block, @NotNull Editor editor, @NotNull StatementUpDownMover.MoveInfo info) {
        if (closingBrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closingBrace", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetExpressionMover", "checkForMovableUpClosingBrace"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetExpressionMover", "checkForMovableUpClosingBrace"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetExpressionMover", "checkForMovableUpClosingBrace"));
        }
        Object prev2 = JetPsiUtil.getLastChildByType(block, JetExpression.class);
        if (prev2 == null) {
            return BraceStatus.NOT_MOVABLE;
        }
        Document doc = editor.getDocument();
        info.toMove = new LineRange(closingBrace, closingBrace, doc);
        info.toMove2 = new LineRange(prev2, prev2, doc);
        info.indentSource = true;
        return BraceStatus.MOVABLE;
    }

    private static BraceStatus checkForMovableClosingBrace(@NotNull Editor editor, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        JetIfExpression ifExpression2;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetExpressionMover", "checkForMovableClosingBrace"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetExpressionMover", "checkForMovableClosingBrace"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetExpressionMover", "checkForMovableClosingBrace"));
        }
        PsiElement closingBrace = JetExpressionMover.getStandaloneClosingBrace(file, editor);
        if (closingBrace == null) {
            return BraceStatus.NOT_FOUND;
        }
        PsiElement blockLikeElement = closingBrace.getParent();
        if (!(blockLikeElement instanceof JetBlockExpression)) {
            return BraceStatus.NOT_MOVABLE;
        }
        PsiElement blockParent = blockLikeElement.getParent();
        if (blockParent instanceof JetWhenEntry) {
            return BraceStatus.NOT_FOUND;
        }
        if (PsiTreeUtil.instanceOf((Object)blockParent, (Class[])FUNCTIONLIKE_ELEMENT_CLASSES)) {
            return BraceStatus.NOT_FOUND;
        }
        PsiElement enclosingExpression = PsiTreeUtil.getParentOfType((PsiElement)blockLikeElement, JetExpression.class);
        if (enclosingExpression instanceof JetDoWhileExpression) {
            return BraceStatus.NOT_MOVABLE;
        }
        if (enclosingExpression instanceof JetIfExpression && blockLikeElement == (ifExpression2 = (JetIfExpression)enclosingExpression).getThen() && ifExpression2.getElse() != null) {
            return BraceStatus.NOT_MOVABLE;
        }
        return down ? JetExpressionMover.checkForMovableDownClosingBrace(closingBrace, blockLikeElement, editor, info) : JetExpressionMover.checkForMovableUpClosingBrace(closingBrace, blockLikeElement, editor, info);
    }

    @Nullable
    private static JetBlockExpression findClosestBlock(@NotNull PsiElement anchor2, boolean down, boolean strict) {
        if (anchor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetExpressionMover", "findClosestBlock"));
        }
        PsiElement current = PsiTreeUtil.getParentOfType((PsiElement)anchor2, JetBlockExpression.class, (boolean)strict);
        while (current != null) {
            PsiElement sibling;
            PsiElement parent = current.getParent();
            if (parent instanceof JetClassBody || parent instanceof JetClassInitializer || parent instanceof JetNamedFunction || parent instanceof JetProperty && !((JetProperty)parent).isLocal()) {
                return null;
            }
            if (parent instanceof JetBlockExpression) {
                return (JetBlockExpression)parent;
            }
            PsiElement psiElement2 = sibling = down ? current.getNextSibling() : current.getPrevSibling();
            if (sibling != null) {
                JetBlockExpression block = (JetBlockExpression)JetPsiUtil.getOutermostDescendantElement(sibling, down, CHECK_BLOCK);
                if (block != null) {
                    return block;
                }
                current = sibling;
                continue;
            }
            current = parent;
        }
        return null;
    }

    @Nullable
    private static JetBlockExpression getDSLLambdaBlock(@NotNull PsiElement element2, boolean down) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetExpressionMover", "getDSLLambdaBlock"));
        }
        JetCallExpression callExpression = (JetCallExpression)JetPsiUtil.getOutermostDescendantElement(element2, down, IS_CALL_EXPRESSION);
        if (callExpression == null) {
            return null;
        }
        List<JetFunctionLiteralArgument> functionLiterals = callExpression.getFunctionLiteralArguments();
        if (functionLiterals.isEmpty()) {
            return null;
        }
        return functionLiterals.get(0).getFunctionLiteral().getBodyExpression();
    }

    @Nullable
    private static LineRange getExpressionTargetRange(@NotNull Editor editor, @NotNull PsiElement sibling, boolean down) {
        JetExpression elseBranch;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetExpressionMover", "getExpressionTargetRange"));
        }
        if (sibling == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sibling", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetExpressionMover", "getExpressionTargetRange"));
        }
        if (sibling instanceof JetIfExpression && !down && (elseBranch = ((JetIfExpression)sibling).getElse()) instanceof JetBlockExpression) {
            sibling = elseBranch;
        }
        PsiElement start = sibling;
        PsiElement end = sibling;
        if (sibling.getNode().getElementType() == (down ? JetTokens.RBRACE : JetTokens.LBRACE)) {
            JetBlockExpression newBlock;
            PsiElement parent = sibling.getParent();
            if (!(parent instanceof JetBlockExpression) && !(parent instanceof JetFunctionLiteral)) {
                return null;
            }
            if (parent instanceof JetFunctionLiteral) {
                PsiElement arrow;
                newBlock = JetExpressionMover.findClosestBlock((PsiElement)((JetFunctionLiteral)parent).getBodyExpression(), down, false);
                if (!down && (arrow = ((JetFunctionLiteral)parent).getArrow()) != null) {
                    end = arrow;
                }
            } else {
                newBlock = JetExpressionMover.findClosestBlock(sibling, down, true);
            }
            if (newBlock == null) {
                return null;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)newBlock, (PsiElement)parent, (boolean)true)) {
                PsiElement outermostParent = JetPsiUtil.getOutermostParent(parent, (PsiElement)newBlock, true);
                if (down) {
                    end = outermostParent;
                } else {
                    start = outermostParent;
                }
            } else if (down) {
                end = newBlock.getLBrace();
            } else {
                start = newBlock.getRBrace();
            }
        } else {
            JetBlockExpression dslBlock = JetExpressionMover.getDSLLambdaBlock(sibling, down);
            Object blockLikeElement = dslBlock != null ? dslBlock.getParent() : JetPsiUtil.getOutermostDescendantElement(sibling, down, CHECK_BLOCK_LIKE_ELEMENT);
            if (blockLikeElement != null) {
                if (down) {
                    PsiElement arrow;
                    end = JetPsiUtil.findChildByType(blockLikeElement, JetTokens.LBRACE);
                    if (blockLikeElement instanceof JetFunctionLiteral && (arrow = ((JetFunctionLiteral)blockLikeElement).getArrow()) != null) {
                        end = arrow;
                    }
                } else {
                    start = JetPsiUtil.findChildByType(blockLikeElement, JetTokens.RBRACE);
                }
            }
        }
        return start != null && end != null ? new LineRange(start, end, editor.getDocument()) : null;
    }

    @Nullable
    private static LineRange getWhenEntryTargetRange(@NotNull Editor editor, @NotNull PsiElement sibling, boolean down) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetExpressionMover", "getWhenEntryTargetRange"));
        }
        if (sibling == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sibling", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetExpressionMover", "getWhenEntryTargetRange"));
        }
        if (sibling.getNode().getElementType() == (down ? JetTokens.RBRACE : JetTokens.LBRACE) && PsiTreeUtil.getParentOfType((PsiElement)sibling, JetWhenEntry.class) == null) {
            return null;
        }
        return new LineRange(sibling, sibling, editor.getDocument());
    }

    @Nullable
    private LineRange getValueParamOrArgTargetRange(@NotNull Editor editor, @NotNull PsiElement elementToCheck, @NotNull PsiElement sibling, boolean down) {
        LineRange range;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetExpressionMover", "getValueParamOrArgTargetRange"));
        }
        if (elementToCheck == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToCheck", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetExpressionMover", "getValueParamOrArgTargetRange"));
        }
        if (sibling == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sibling", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetExpressionMover", "getValueParamOrArgTargetRange"));
        }
        PsiElement next2 = sibling;
        if (next2.getNode().getElementType() == JetTokens.COMMA) {
            next2 = JetExpressionMover.firstNonWhiteSibling(next2, down);
        }
        Object object = range = next2 instanceof JetParameter || next2 instanceof JetValueArgument ? new LineRange(next2, next2, editor.getDocument()) : null;
        if (range != null) {
            this.parametersOrArgsToMove = new Pair((Object)elementToCheck, (Object)next2);
        }
        return range;
    }

    @Nullable
    private LineRange getTargetRange(@NotNull Editor editor, @Nullable PsiElement elementToCheck, @NotNull PsiElement sibling, boolean down) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetExpressionMover", "getTargetRange"));
        }
        if (sibling == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sibling", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetExpressionMover", "getTargetRange"));
        }
        if (elementToCheck instanceof JetParameter || elementToCheck instanceof JetValueArgument) {
            return this.getValueParamOrArgTargetRange(editor, elementToCheck, sibling, down);
        }
        if (elementToCheck instanceof JetExpression || elementToCheck instanceof PsiComment) {
            return JetExpressionMover.getExpressionTargetRange(editor, sibling, down);
        }
        if (elementToCheck instanceof JetWhenEntry) {
            return JetExpressionMover.getWhenEntryTargetRange(editor, sibling, down);
        }
        return null;
    }

    @Override
    protected boolean checkSourceElement(@NotNull PsiElement element2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetExpressionMover", "checkSourceElement"));
        }
        return PsiTreeUtil.instanceOf((Object)element2, (Class[])MOVABLE_ELEMENT_CLASSES);
    }

    @Override
    protected LineRange getElementSourceLineRange(@NotNull PsiElement element2, @NotNull Editor editor, @NotNull LineRange oldRange) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetExpressionMover", "getElementSourceLineRange"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetExpressionMover", "getElementSourceLineRange"));
        }
        if (oldRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldRange", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetExpressionMover", "getElementSourceLineRange"));
        }
        TextRange textRange = element2.getTextRange();
        if (editor.getDocument().getTextLength() < textRange.getEndOffset()) {
            return null;
        }
        int startLine = editor.offsetToLogicalPosition((int)textRange.getStartOffset()).line;
        int endLine = editor.offsetToLogicalPosition((int)textRange.getEndOffset()).line + 1;
        return new LineRange(startLine, endLine);
    }

    @Nullable
    private static PsiElement getMovableElement(@NotNull PsiElement element2, boolean lookRight) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetExpressionMover", "getMovableElement"));
        }
        PsiElement movableElement = PsiUtilPackage.getParentOfTypesAndPredicate(element2, false, MOVABLE_ELEMENT_CLASSES, MOVABLE_ELEMENT_CONSTRAINT);
        if (movableElement == null) {
            return null;
        }
        if (JetExpressionMover.isBracelessBlock(movableElement)) {
            movableElement = JetExpressionMover.firstNonWhiteElement((PsiElement)(lookRight ? movableElement.getLastChild() : movableElement.getFirstChild()), (!lookRight ? 1 : 0) != 0);
        }
        return movableElement;
    }

    private static boolean isLastOfItsKind(@NotNull PsiElement element2, boolean down) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetExpressionMover", "isLastOfItsKind"));
        }
        return JetExpressionMover.getSiblingOfType(element2, down, element2.getClass()) == null;
    }

    private static boolean isForbiddenMove(@NotNull PsiElement element2, boolean down) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetExpressionMover", "isForbiddenMove"));
        }
        if (element2 instanceof JetParameter || element2 instanceof JetValueArgument) {
            return JetExpressionMover.isLastOfItsKind(element2, down);
        }
        return false;
    }

    private static boolean isBracelessBlock(@NotNull PsiElement element2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetExpressionMover", "isBracelessBlock"));
        }
        if (!(element2 instanceof JetBlockExpression)) {
            return false;
        }
        JetBlockExpression block = (JetBlockExpression)element2;
        return block.getLBrace() == null && block.getRBrace() == null;
    }

    protected static PsiElement adjustSibling(@NotNull LineRange sourceRange, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        PsiElement parent;
        PsiElement sibling;
        if (sourceRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRange", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetExpressionMover", "adjustSibling"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetExpressionMover", "adjustSibling"));
        }
        PsiElement element2 = down ? sourceRange.lastElement : sourceRange.firstElement;
        PsiElement whiteSpaceTestSubject = sibling = down ? element2.getNextSibling() : element2.getPrevSibling();
        if (sibling == null && (parent = element2.getParent()) != null && JetExpressionMover.isBracelessBlock(parent)) {
            PsiElement psiElement2 = whiteSpaceTestSubject = down ? parent.getNextSibling() : parent.getPrevSibling();
        }
        if (whiteSpaceTestSubject instanceof PsiWhiteSpace) {
            if (RefactoringPackage.isMultiLine(whiteSpaceTestSubject)) {
                int nearLine = down ? sourceRange.endLine : sourceRange.startLine - 1;
                info.toMove = sourceRange;
                info.toMove2 = new LineRange(nearLine, nearLine + 1);
                info.indentTarget = false;
                return null;
            }
            if (sibling != null) {
                sibling = JetExpressionMover.firstNonWhiteElement((PsiElement)sibling, (boolean)down);
            }
        }
        if (sibling == null) {
            JetBlockExpression dslBlock;
            JetCallExpression callExpression = (JetCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element2, JetCallExpression.class);
            if (callExpression != null && PsiTreeUtil.isAncestor((PsiElement)(dslBlock = JetExpressionMover.getDSLLambdaBlock((PsiElement)callExpression, down)), (PsiElement)element2, (boolean)false)) {
                PsiElement blockParent = dslBlock.getParent();
                return down ? JetPsiUtil.findChildByType(blockParent, JetTokens.RBRACE) : JetPsiUtil.findChildByType(blockParent, JetTokens.LBRACE);
            }
            info.toMove2 = null;
            return null;
        }
        return sibling;
    }

    @Override
    public boolean checkAvailable(@NotNull Editor editor, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        LineRange sourceRange;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetExpressionMover", "checkAvailable"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetExpressionMover", "checkAvailable"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetExpressionMover", "checkAvailable"));
        }
        this.parametersOrArgsToMove = null;
        if (!super.checkAvailable(editor, file, info, down)) {
            return false;
        }
        switch (JetExpressionMover.checkForMovableClosingBrace(editor, file, info, down)) {
            case NOT_MOVABLE: {
                info.toMove2 = null;
                return true;
            }
            case MOVABLE: {
                return true;
            }
        }
        LineRange oldRange = info.toMove;
        Pair psiRange = JetExpressionMover.getElementRange((Editor)editor, (PsiFile)file, (LineRange)oldRange);
        if (psiRange == null) {
            return false;
        }
        PsiElement firstElement = JetExpressionMover.getMovableElement((PsiElement)psiRange.getFirst(), false);
        PsiElement lastElement = JetExpressionMover.getMovableElement((PsiElement)psiRange.getSecond(), true);
        if (firstElement == null || lastElement == null) {
            return false;
        }
        if (JetExpressionMover.isForbiddenMove(firstElement, down) || JetExpressionMover.isForbiddenMove(lastElement, down)) {
            info.toMove2 = null;
            return true;
        }
        if ((firstElement instanceof JetParameter || firstElement instanceof JetValueArgument) && PsiTreeUtil.isAncestor((PsiElement)lastElement, (PsiElement)firstElement, (boolean)false)) {
            lastElement = firstElement;
        }
        if ((sourceRange = this.getSourceRange(firstElement, lastElement, editor, oldRange)) == null) {
            return false;
        }
        PsiElement sibling = JetExpressionMover.getLastNonWhiteSiblingInLine(JetExpressionMover.adjustSibling(sourceRange, info, down), editor, down);
        if (sibling == null) {
            return true;
        }
        info.toMove = sourceRange;
        info.toMove2 = this.getTargetRange(editor, sourceRange.firstElement, sibling, down);
        return true;
    }

    private static PsiElement getComma(@NotNull PsiElement element2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetExpressionMover", "getComma"));
        }
        PsiElement sibling = JetExpressionMover.firstNonWhiteSibling(element2, true);
        return sibling != null && sibling.getNode().getElementType() == JetTokens.COMMA ? sibling : null;
    }

    private static void fixCommaIfNeeded(@NotNull PsiElement element2, boolean willBeLast) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetExpressionMover", "fixCommaIfNeeded"));
        }
        PsiElement comma = JetExpressionMover.getComma(element2);
        if (willBeLast && comma != null) {
            comma.delete();
        } else if (!willBeLast && comma == null) {
            PsiElement parent = element2.getParent();
            assert (parent != null);
            parent.addAfter(PsiPackage.JetPsiFactory(parent.getProject()).createComma(), element2);
        }
    }

    public void beforeMove(@NotNull Editor editor, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetExpressionMover", "beforeMove"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/JetExpressionMover", "beforeMove"));
        }
        if (this.parametersOrArgsToMove != null) {
            PsiElement element1 = (PsiElement)this.parametersOrArgsToMove.first;
            PsiElement element2 = (PsiElement)this.parametersOrArgsToMove.second;
            JetExpressionMover.fixCommaIfNeeded(element1, down && JetExpressionMover.isLastOfItsKind(element2, true));
            JetExpressionMover.fixCommaIfNeeded(element2, !down && JetExpressionMover.isLastOfItsKind(element1, true));
            PsiDocumentManager.getInstance((Project)editor.getProject()).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        }
    }

    private static enum BraceStatus {
        NOT_FOUND,
        MOVABLE,
        NOT_MOVABLE;

    }
}

