/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.handlers;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.completion.CompletionUtilsKt;
import org.jetbrains.kotlin.idea.completion.handlers.BaseDeclarationInsertHandler;
import org.jetbrains.kotlin.idea.core.completion.DeclarationLookupObject;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.ShortenReferences;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetNameReferenceExpression;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"\u0005\u0006)i2j\u001c;mS:\u001cE.Y:tS\u001aLWM]%og\u0016\u0014H\u000fS1oI2,'OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\u0011IG-Z1\u000b\u0015\r|W\u000e\u001d7fi&|gN\u0003\u0005iC:$G.\u001a:t\u0015q\u0011\u0015m]3EK\u000ed\u0017M]1uS>t\u0017J\\:feRD\u0015M\u001c3mKJTA\u0002[1oI2,\u0017J\\:feRTqaY8oi\u0016DHO\u0003\tJ]N,'\u000f^5p]\u000e{g\u000e^3yi*\u00191m\\7\u000b\u0011%tG/\u001a7mS*T1bY8eK&s7/[4ii*!\u0011\u000e^3n\u00155aun\\6va\u0016cW-\\3oi*1An\\8lkBTA!\u00168ji*)\u0012/^1mS\u001aLW\r\u001a(b[\u0016$v.\u00138tKJ$(BB*ue&twM\u0003\u0003kCZ\f'\u0002\u00027b]\u001et\u0019A\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\t!\u0011\u0001\u0003\u0002\u0006\u0005\u0011\r\u0001RA\u0003\u0003\t\tA1!B\u0002\u0005\u0006!\u0001A\u0002A\u0003\u0004\t\u000bA9\u0001\u0004\u0001\u0006\u0003!-QA\u0001\u0003\u0005\u0011\u0019)!\u0001\"\u0003\t\u000e\u0015\u0011A!\u0002E\u0003\u000b\r!Y\u0001C\u0003\r\u0001\u0015\u0011A!\u0002\u0005\t\u000b\r!i\u0001c\u0004\r\u0001\u0015\t\u00012A\u0003\u0004\t\u001fA\t\u0002\u0004\u0001\u0006\u0005\u0011-\u0001\"B\u0003\u0003\t\u001bAy!B\u0002\u0005\u0010!MA\u0002A\u0003\u0002\u0011))!\u0001\u0002\u0006\t\u0016\u0015\u0011AQ\u0003E\n\t\r\fAbA\r\u0004\u000b\u0005A9\u0001g\u0002.@\u0011Y\u0001\u0004BO\b\t\u0001AI!D\u0002\u0006\u0003!1\u0001D\u0002)\u0004\u0001u=A\u0001\u0001\u0005\b\u001b\r)\u0011\u0001C\u0004\u0019\u000fA\u001b\t!I\u0002\u0006\u0003!A\u0001\u0004C)\u0004\u000f\u0011!\u0011\"\u0001\u0003\u0001\u001b\u0005A\t\"D\u0001\t\u00135*B!\u0001\r\n;\u001f!\u0001\u0001C\u0004\u000e\u0007\u0015\t\u0001b\u0002\r\b!\u000e\u0001\u0011eA\u0003\u0002\u0011'A\u001a\"U\u0002\u0006\t%I\u0011\u0001C\u0006\u000e\u0003!IQ\u0007\u0001"})
public final class KotlinClassifierInsertHandler
extends BaseDeclarationInsertHandler {
    public static final /* synthetic */ KClass $kotlinClass;
    public static final KotlinClassifierInsertHandler INSTANCE$;

    static {
        $kotlinClass = Reflection.createKotlinClass(KotlinClassifierInsertHandler.class);
        new KotlinClassifierInsertHandler();
    }

    @Override
    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        super.handleInsert(context, item);
        PsiFile file = context.getFile();
        if (file instanceof JetFile && !CompletionUtilsKt.isAfterDot(context)) {
            JetNameReferenceExpression nameRef;
            PsiElement psiElement2;
            PsiElement token;
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)context.getProject());
            psiDocumentManager.commitAllDocuments();
            int startOffset = context.getStartOffset();
            Document document = context.getDocument();
            String qualifiedName = this.qualifiedNameToInsert(item);
            PsiElement psiElement3 = token = ((JetFile)file).findElementAt(startOffset);
            if (psiElement3 == null) {
                Intrinsics.throwNpe();
            }
            if (!((psiElement2 = psiElement3.getParent()) instanceof JetNameReferenceExpression)) {
                psiElement2 = null;
            }
            if ((nameRef = (JetNameReferenceExpression)psiElement2) != null) {
                ClassDescriptor target;
                BindingContext bindingContext2 = ResolutionUtils.getResolutionFacade(nameRef).analyze(nameRef, BodyResolveMode.PARTIAL);
                ClassDescriptor classDescriptor = (ClassDescriptor)bindingContext2.get(BindingContext.SHORT_REFERENCE_TO_COMPANION_OBJECT, nameRef);
                if (classDescriptor == null) {
                    Object v = bindingContext2.get(BindingContext.REFERENCE_TARGET, nameRef);
                    if (!(v instanceof ClassDescriptor)) {
                        v = null;
                    }
                    classDescriptor = target = (ClassDescriptor)v;
                }
                if (target != null && Intrinsics.areEqual((Object)IdeDescriptorRenderers.INSTANCE$.getSOURCE_CODE().renderClassifierName(target), (Object)qualifiedName)) {
                    return;
                }
            }
            String tempPrefix = nameRef != null ? " " : "$;val v:";
            String tempSuffix = ".xxx";
            document.replaceString(startOffset, context.getTailOffset(), (CharSequence)(tempPrefix + qualifiedName + tempSuffix));
            psiDocumentManager.commitAllDocuments();
            int classNameStart = startOffset + tempPrefix.length();
            int classNameEnd = classNameStart + qualifiedName.length();
            RangeMarker rangeMarker = document.createRangeMarker(classNameStart, classNameEnd);
            RangeMarker wholeRangeMarker = document.createRangeMarker(startOffset, classNameEnd + tempSuffix.length());
            ShortenReferences shortenReferences = ShortenReferences.Companion.getDEFAULT();
            JetFile jetFile = (JetFile)file;
            Intrinsics.checkExpressionValueIsNotNull((Object)jetFile, (String)"file");
            shortenReferences.process(jetFile, classNameStart, classNameEnd);
            psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
            if (rangeMarker.isValid() && wholeRangeMarker.isValid()) {
                document.deleteString(wholeRangeMarker.getStartOffset(), rangeMarker.getStartOffset());
                document.deleteString(rangeMarker.getEndOffset(), wholeRangeMarker.getEndOffset());
            }
        }
    }

    private final String qualifiedNameToInsert(LookupElement item) {
        String string;
        String qualifiedName;
        Object object = item.getObject();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.idea.core.completion.DeclarationLookupObject");
        }
        DeclarationLookupObject lookupObject2 = (DeclarationLookupObject)object;
        if (lookupObject2.getDescriptor() != null) {
            DeclarationDescriptor declarationDescriptor = lookupObject2.getDescriptor();
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassifierDescriptor");
            }
            return IdeDescriptorRenderers.INSTANCE$.getSOURCE_CODE().renderClassifierName((ClassifierDescriptor)declarationDescriptor);
        }
        PsiElement psiElement2 = lookupObject2.getPsiElement();
        if (psiElement2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiClass");
        }
        String string2 = ((PsiClass)psiElement2).getQualifiedName();
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        if (FqNameUnsafe.isValid(qualifiedName = string2)) {
            string = RenderingUtilsKt.render(new FqNameUnsafe(qualifiedName));
        } else {
            String string3 = qualifiedName;
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"qualifiedName");
        }
        return string;
    }

    KotlinClassifierInsertHandler() {
        INSTANCE$ = this;
    }
}

