/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.quickfix;

import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.references.BuiltInsReferenceResolver;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetIfExpression;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetParenthesizedExpression;
import org.jetbrains.kotlin.psi.JetReturnExpression;
import org.jetbrains.kotlin.psi.JetWithExpressionInitializer;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.DeferredType;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;

public class QuickFixUtil {
    private QuickFixUtil() {
    }

    public static boolean removePossiblyWhiteSpace(ASTDelegatePsiElement element2, PsiElement possiblyWhiteSpace) {
        if (possiblyWhiteSpace instanceof PsiWhiteSpace) {
            element2.deleteChildInternal(possiblyWhiteSpace.getNode());
            return true;
        }
        return false;
    }

    @Nullable
    public static <T extends PsiElement> T getParentElementOfType(Diagnostic diagnostic, Class<T> aClass) {
        return (T)PsiTreeUtil.getParentOfType((PsiElement)diagnostic.getPsiElement(), aClass, (boolean)false);
    }

    @Nullable
    public static JetType getDeclarationReturnType(JetNamedDeclaration declaration) {
        PsiFile file = declaration.getContainingFile();
        if (!(file instanceof JetFile)) {
            return null;
        }
        DeclarationDescriptor descriptor2 = ResolutionUtils.resolveToDescriptor(declaration);
        if (!(descriptor2 instanceof CallableDescriptor)) {
            return null;
        }
        JetType type2 = ((CallableDescriptor)descriptor2).getReturnType();
        if (type2 instanceof DeferredType) {
            type2 = ((DeferredType)type2).getDelegate();
        }
        return type2;
    }

    @Nullable
    public static JetType findLowerBoundOfOverriddenCallablesReturnTypes(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/idea/core/quickfix/QuickFixUtil", "findLowerBoundOfOverriddenCallablesReturnTypes"));
        }
        JetType matchingReturnType = null;
        for (CallableDescriptor callableDescriptor : descriptor2.getOverriddenDescriptors()) {
            JetType overriddenReturnType = callableDescriptor.getReturnType();
            if (overriddenReturnType == null) {
                return null;
            }
            if (matchingReturnType == null || JetTypeChecker.DEFAULT.isSubtypeOf(overriddenReturnType, matchingReturnType)) {
                matchingReturnType = overriddenReturnType;
                continue;
            }
            if (JetTypeChecker.DEFAULT.isSubtypeOf(matchingReturnType, overriddenReturnType)) continue;
            return null;
        }
        return matchingReturnType;
    }

    public static boolean canModifyElement(@NotNull PsiElement element2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/core/quickfix/QuickFixUtil", "canModifyElement"));
        }
        return element2.isWritable() && !BuiltInsReferenceResolver.Companion.isFromBuiltIns(element2);
    }

    @Nullable
    public static PsiElement safeGetDeclaration(@Nullable CallableDescriptor descriptor2) {
        if (descriptor2 == null || descriptor2.getOverriddenDescriptors().size() > 1) {
            return null;
        }
        return DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
    }

    @Nullable
    public static JetParameter getParameterDeclarationForValueArgument(@NotNull ResolvedCall<?> resolvedCall, @Nullable ValueArgument valueArgument) {
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/idea/core/quickfix/QuickFixUtil", "getParameterDeclarationForValueArgument"));
        }
        PsiElement declaration = QuickFixUtil.safeGetDeclaration(CallUtilKt.getParameterForArgument(resolvedCall, valueArgument));
        return declaration instanceof JetParameter ? (JetParameter)declaration : null;
    }

    private static boolean equalOrLastInThenOrElse(JetExpression thenOrElse, JetExpression expression2) {
        if (thenOrElse == expression2) {
            return true;
        }
        return thenOrElse instanceof JetBlockExpression && expression2.getParent() == thenOrElse && PsiTreeUtil.getNextSiblingOfType((PsiElement)expression2, JetExpression.class) == null;
    }

    @Nullable
    public static JetIfExpression getParentIfForBranch(@Nullable JetExpression expression2) {
        JetIfExpression ifExpression2 = (JetIfExpression)PsiTreeUtil.getParentOfType((PsiElement)expression2, JetIfExpression.class, (boolean)true);
        if (ifExpression2 == null) {
            return null;
        }
        if (QuickFixUtil.equalOrLastInThenOrElse(ifExpression2.getThen(), expression2) || QuickFixUtil.equalOrLastInThenOrElse(ifExpression2.getElse(), expression2)) {
            return ifExpression2;
        }
        return null;
    }

    public static boolean canEvaluateTo(JetExpression parent, JetExpression child) {
        if (parent == null || child == null) {
            return false;
        }
        while (parent != child) {
            if (child.getParent() instanceof JetParenthesizedExpression) {
                child = (JetExpression)child.getParent();
                continue;
            }
            if ((child = QuickFixUtil.getParentIfForBranch(child)) != null) continue;
            return false;
        }
        return true;
    }

    public static boolean canFunctionOrGetterReturnExpression(@NotNull JetDeclaration functionOrGetter, @NotNull JetExpression expression2) {
        if (functionOrGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionOrGetter", "org/jetbrains/kotlin/idea/core/quickfix/QuickFixUtil", "canFunctionOrGetterReturnExpression"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/core/quickfix/QuickFixUtil", "canFunctionOrGetterReturnExpression"));
        }
        if (functionOrGetter instanceof JetFunctionLiteral) {
            JetBlockExpression functionLiteralBody = ((JetFunctionLiteral)functionOrGetter).getBodyExpression();
            PsiElement returnedElement = functionLiteralBody == null ? null : functionLiteralBody.getLastChild();
            return returnedElement instanceof JetExpression && QuickFixUtil.canEvaluateTo((JetExpression)returnedElement, expression2);
        }
        if (functionOrGetter instanceof JetWithExpressionInitializer && QuickFixUtil.canEvaluateTo(((JetWithExpressionInitializer)((Object)functionOrGetter)).getInitializer(), expression2)) {
            return true;
        }
        JetReturnExpression returnExpression = (JetReturnExpression)PsiTreeUtil.getParentOfType((PsiElement)expression2, JetReturnExpression.class);
        return returnExpression != null && QuickFixUtil.canEvaluateTo(returnExpression.getReturnedExpression(), expression2);
    }

    public static String renderTypeWithFqNameOnClash(JetType type2, String nameToCheckAgainst) {
        FqName typeFqName = DescriptorUtils.getFqNameSafe(DescriptorUtils.getClassDescriptorForType(type2));
        FqName fqNameToCheckAgainst = new FqName(nameToCheckAgainst);
        DescriptorRenderer renderer2 = typeFqName.shortName().equals(fqNameToCheckAgainst.shortName()) ? IdeDescriptorRenderers.SOURCE_CODE : IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES;
        return renderer2.renderType(type2);
    }
}

