/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SourcePositionProvider;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextUtil;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.ui.tree.FieldDescriptor;
import com.intellij.debugger.ui.tree.LocalVariableDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinCodeFragmentFactory;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetExpressionCodeFragment;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"\u001e\b)a2j\u001c;mS:\u001cv.\u001e:dKB{7/\u001b;j_:\u0004&o\u001c<jI\u0016\u0014(bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\u0007W>$H.\u001b8\u000b\t%$W-\u0019\u0006\tI\u0016\u0014WoZ4fe*12k\\;sG\u0016\u0004vn]5uS>t\u0007K]8wS\u0012,'OC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\u0007K:<\u0017N\\3\u000b\rqJg.\u001b;?\u0015U\u0019w.\u001c9vi\u0016\u001cv.\u001e:dKB{7/\u001b;j_:T!\u0002Z3tGJL\u0007\u000f^8s\u0015=1\u0015.\u001a7e\t\u0016\u001c8M]5qi>\u0014(BA;j\u0015\u0011!(/Z3\u000b\u000fA\u0014xN[3di*9\u0001K]8kK\u000e$(bB8qK:\f\u0007/\u001b\u0006\bG>tG/\u001a=u\u0015M!UMY;hO\u0016\u00148i\u001c8uKb$\u0018*\u001c9m\u0015\u0011IW\u000e\u001d7\u000b\u000f9,\u0017M]3ti*9!i\\8mK\u0006t'BD*pkJ\u001cW\rU8tSRLwN\u001c\u0006\u0018\u0019>\u001c\u0017\r\u001c,be&\f'\r\\3EKN\u001c'/\u001b9u_JTaBT8eK\u0012+7o\u0019:jaR|'OC\bgS:$7\t\\1tg\nKH+\u001f9f\u0015\u0011!\u0018\u0010]3\u000b\u001bI+g-\u001a:f]\u000e,G+\u001f9f\u0015\r\u0019XO\u001c\u0006\u0004U\u0012L'B\u0003)tS\u0016cW-\\3oi*\u0019\u0001o]5\u000b+\u001d,G\u000fT1tiN{WO]2f!>\u001c\u0018\u000e^5p]:\u0010!B\u0001\t\u0002\u0015\u0011A\u0001\u0001\u0005\u0002\u000b\t!\t\u0001c\u0001\u0006\u0005\u0011\t\u0001BA\u0003\u0003\t\u0007A)!B\u0002\u0005\u0005!\u0001A\u0002A\u0003\u0002\u0011\u000f)!\u0001B\u0002\t\t\u0015\u0011Aq\u0001E\u0003\u000b\t!A\u0001#\u0003\u0006\u0007\u0011%\u0001b\u0001\u0007\u0001\u000b\t!A\u0001C\u0004\u0006\u0005\u0011-\u0001rB\u0003\u0004\t\u0019Ai\u0001\u0004\u0001\u0006\u0005\u0011\u001d\u0001\"C\u0003\u0003\t\u001dA\u0001\"B\u0002\u0005\u0010!EA\u0002A\u0003\u0003\t\u0011A)\"B\u0002\u0005\u0012!QA\u0002A\u0003\u0002\u0011\u0007)1\u0001b\u0005\t\u00181\u0001Qa\u0001\u0003\u0005\u00111a\u0001!\u0002\u0002\u0005\t!aQA\u0001\u0003\u0007\u0011\u001b)!\u0001b\u0004\t\u0012\u0015\u0011A\u0011\u0003\u0005\u000b\u000b\r!a\u0001#\u0007\r\u0001\u0015\u0011AA\u0002E\r\u000b\r!a\u0001C\u0007\r\u0001\u0015\u0011AA\u0002\u0005\u000e\u000b\t!1\u0001C\b\u0006\u0005\u0011y\u0001rD\u0003\u0004\t?Ai\u0002\u0004\u0001\u0006\u0005\u0011\u001d\u0001\u0012E\u0003\u0004\tCA\u0001\u0003\u0004\u0001\u0006\u0005\u0011\u0005\u0002\u0002E\u0003\u0003\t?Ai\u0002B\u0002\r\u0006e\u0019Q!\u0001\u0005\u00061\u0015i[\u0007B\u0001\u0019\fu=A\u0001\u0001\u0005\u0007\u001b\r)\u0011\u0001#\u0004\u0019\u000eA\u001b\u0001!h\u0004\u0005\u0001!AQbA\u0003\u0002\u0011!A\u0002\u0002UB\u0001;\u001f!\u0001\u0001c\u0005\u000e\u0007\u0015\t\u0001\"\u0003\r\n!\u000e\tQt\u0002\u0003\u0001\u0011-i1!B\u0001\t\u0015aQ\u0001ka\u0001\"\t\u0015\t\u0001R\u0003G\u00011+\t6a\u0003C\u0006\u0013\u0005A1\"D\u0001\t\u00185\t\u0001\u0002D\u0007\u0002\u00113i\u0011\u0001\"\u0001.l\u0011\t\u00014BO\b\t\u0001Aa!D\u0002\u0006\u0003!i\u0001$\u0004)\u0004\u0001u=A\u0001\u0001\u0005\t\u001b\r)\u0011\u0001\u0003\u0005\u0019\u0011A\u001b\t!h\u0004\u0005\u0001!MQbA\u0003\u0002\u0011%A\u0012\u0002U\u0002\u0002;\u001f!\u0001\u0001C\u0006\u000e\u0007\u0015\t\u0001B\u0003\r\u000b!\u000e\r\u0011\u0005B\u0003\u0002\u0011+a\t\u0001'\u0006R\u0007-!Y!C\u0001\t\u00175\t\u00012D\u0007\u0002\u00111i\u0011\u0001#\u0007\u000e\u0003\u0011\u0005Q6\u000e\u0003\u000b1\u0017iz\u0001\u0002\u0001\t\r5\u0019Q!\u0001\u0005\u000f19\u00016\u0001AO\b\t\u0001A\u0001\"D\u0002\u0006\u0003!A\u0001\u0004\u0003)\u0004\u0002u=A\u0001\u0001E\n\u001b\r)\u0011\u0001C\u0005\u0019\u0013A\u001b\u0011!h\u0004\u0005\u0001!YQbA\u0003\u0002\u0011)A\"\u0002UB\u0002C\u0011)\u0011\u0001#\u0006\r\u0002aU\u0011kA\u0006\u0005\f%\t\u0001bC\u0007\u0002\u0011;i\u0011\u0001\u0003\u0007\u000e\u0003!eQ\"\u0001C\u0001[-\"\u0011\u0001g\u0007\u001e\u0010\u0011\u0001\u0001\u0002C\u0007\u0004\u000b\u0005A\u0001\u0002\u0007\u0005Q\u0007\u0001iz\u0001\u0002\u0001\t\u001d5\u0019Q!\u0001\u0005\u00111A\u00016\u0011AO\b\t\u0001A\u0019\"D\u0002\u0006\u0003!I\u0001$\u0003)\u0004\u0003\u0005\"Q!\u0001\u0005\u0012\u0019\u0003A\u0012#U\u0002\n\t7I\u0011\u0001c\t\u000e\u0003!aQ\"\u0001\u0005\u0013\u001b\u0005AI\",\u0011\u0005\u0003a\tRt\u0002\u0003\u0001\u00119i1!B\u0001\t!a\u0001\u0002k\u0001\u0001\u001e\u0010\u0011\u0001\u00012C\u0007\u0004\u000b\u0005A\u0011\u0002G\u0005Q\u0007\u0003\tC!B\u0001\t\u00161\u0005\u0001TC)\u0004\u000f\u0011\t\u0012\"\u0001\u0005\f\u001b\u0005A!#D\u0001\t\u001aUbQa\u0003\u0003d\u0002a)\u0011eA\u0003\u0002\u0011\u000bA*!U\u0002\u0004\t\u0015I\u0011\u0001\u0002\u0001"})
public final class KotlinSourcePositionProvider
extends SourcePositionProvider {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(KotlinSourcePositionProvider.class);
    }

    @Nullable
    protected SourcePosition computeSourcePosition(@NotNull NodeDescriptor descriptor2, @NotNull Project project, @NotNull DebuggerContextImpl context, boolean nearest) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (context.getFrameProxy() == null) {
            return null;
        }
        if (descriptor2 instanceof FieldDescriptor) {
            return this.computeSourcePosition((FieldDescriptor)descriptor2, project, context, nearest);
        }
        if (descriptor2 instanceof LocalVariableDescriptor) {
            return this.computeSourcePosition((LocalVariableDescriptor)descriptor2, project, context, nearest);
        }
        return null;
    }

    private final SourcePosition computeSourcePosition(LocalVariableDescriptor descriptor2, Project project, DebuggerContextImpl context, boolean nearest) {
        PsiElement psiElement2 = PositionUtil.getContextElement((StackFrameContext)((StackFrameContext)context));
        if (psiElement2 == null) {
            return null;
        }
        PsiElement place = psiElement2;
        if (!(place.getContainingFile() instanceof JetFile)) {
            return null;
        }
        JetElement jetElement = KotlinCodeFragmentFactory.Companion.getContextElement(place);
        if (jetElement == null) {
            return null;
        }
        JetElement contextElement = jetElement;
        JetPsiFactory jetPsiFactory = new JetPsiFactory(project);
        String string = descriptor2.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"descriptor.getName()");
        JetExpressionCodeFragment codeFragment = jetPsiFactory.createExpressionCodeFragment(string, (PsiElement)contextElement);
        JetExpression expression2 = codeFragment.getContentElement();
        if (expression2 instanceof JetSimpleNameExpression) {
            SourceElement sourceElement;
            VariableDescriptor declarationDescriptor;
            BindingContext bindingContext2 = ResolutionUtils.analyze(expression2, BodyResolveMode.PARTIAL);
            VariableDescriptor variableDescriptor = declarationDescriptor = BindingContextUtils.extractVariableDescriptorIfAny(bindingContext2, expression2, false);
            SourceElement sourceElement2 = sourceElement = variableDescriptor != null ? variableDescriptor.getSource() : null;
            if (sourceElement instanceof KotlinSourceElement) {
                PsiElement psiElement3 = KotlinSourceElementKt.getPsi(sourceElement);
                if (psiElement3 == null) {
                    return null;
                }
                PsiElement element2 = psiElement3;
                if (nearest) {
                    return DebuggerContextUtil.findNearest((DebuggerContextImpl)context, (PsiElement)element2, (PsiFile)element2.getContainingFile());
                }
                return SourcePosition.createFromOffset((PsiFile)element2.getContainingFile(), (int)element2.getTextOffset());
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final SourcePosition computeSourcePosition(FieldDescriptor descriptor2, Project project, DebuggerContextImpl context, boolean nearest) {
        Object v4;
        JetClassOrObject myClass;
        block6: {
            void $receiver;
            ReferenceType type2;
            String fieldName = descriptor2.getField().name();
            if (Intrinsics.areEqual((Object)fieldName, (Object)AsmUtil.CAPTURED_THIS_FIELD) || Intrinsics.areEqual((Object)fieldName, (Object)AsmUtil.CAPTURED_RECEIVER_FIELD)) {
                return null;
            }
            ReferenceType referenceType = type2 = descriptor2.getField().declaringType();
            Intrinsics.checkExpressionValueIsNotNull((Object)referenceType, (String)"type");
            PsiElement psiElement2 = this.findClassByType(project, referenceType, context);
            Object object = psiElement2 != null ? psiElement2.getNavigationElement() : null;
            if (!(object instanceof JetClassOrObject)) {
                object = null;
            }
            JetClassOrObject jetClassOrObject = (JetClassOrObject)object;
            if (jetClassOrObject == null) {
                return null;
            }
            myClass = jetClassOrObject;
            Iterable iterable = myClass.getDeclarations();
            for (Object element2 : $receiver) {
                JetDeclaration it = (JetDeclaration)element2;
                if (!Intrinsics.areEqual((Object)fieldName, (Object)it.getName())) continue;
                v4 = element2;
                break block6;
            }
            v4 = null;
        }
        JetDeclaration jetDeclaration = v4;
        if (jetDeclaration == null) {
            return null;
        }
        JetDeclaration field2 = jetDeclaration;
        if (nearest) {
            return DebuggerContextUtil.findNearest((DebuggerContextImpl)context, (PsiElement)field2, (PsiFile)myClass.getContainingFile());
        }
        return SourcePosition.createFromOffset((PsiFile)field2.getContainingFile(), (int)field2.getTextOffset());
    }

    /*
     * WARNING - void declaration
     */
    private final PsiElement findClassByType(Project project, ReferenceType type2, DebuggerContextImpl context) {
        PsiElement element2;
        DebuggerSession session = context.getDebuggerSession();
        GlobalSearchScope scope2 = session != null ? session.getSearchScope() : GlobalSearchScope.allScope((Project)project);
        String className = JvmClassName.byInternalName(type2.name()).getFqNameForClassNameWithoutDollars().asString();
        PsiClass myClass = JavaPsiFacade.getInstance((Project)project).findClass(className, scope2);
        if (myClass != null) {
            return (PsiElement)myClass;
        }
        SourcePosition position = this.getLastSourcePosition(type2, context);
        if (position != null && (element2 = position.getElementAt()) != null) {
            void $receiver;
            PsiElement psiElement2 = element2;
            return PsiTreeUtil.getParentOfType((PsiElement)$receiver, JetClassOrObject.class, (boolean)true);
        }
        return null;
    }

    private final SourcePosition getLastSourcePosition(ReferenceType type2, DebuggerContextImpl context) {
        DebugProcessImpl debugProcess = context.getDebugProcess();
        if (debugProcess != null) {
            try {
                List<Location> locations = type2.allLineLocations();
                if (!locations.isEmpty()) {
                    Location lastLocation = locations.get(locations.size() - 1);
                    return debugProcess.getPositionManager().getSourcePosition(lastLocation);
                }
            }
            catch (AbsentInformationException ignored) {
            }
            catch (ClassNotPreparedException ignored) {
                // empty catch block
            }
        }
        return null;
    }
}

