/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.breakpoints;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.breakpoints.BreakpointsPackage;
import org.jetbrains.kotlin.psi.JetFunction;

public class KotlinLineBreakpointType
extends JavaLineBreakpointType {
    public KotlinLineBreakpointType() {
        super("kotlin-line", "Kotlin Line Breakpoints");
    }

    public boolean matchesPosition(@NotNull LineBreakpoint<?> breakpoint, @NotNull SourcePosition position) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType", "matchesPosition"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType", "matchesPosition"));
        }
        if (super.matchesPosition(breakpoint, position)) {
            return true;
        }
        PsiElement containingMethod = this.getContainingMethod(breakpoint);
        if (containingMethod == null) {
            return false;
        }
        return KotlinLineBreakpointType.inTheMethod(position, containingMethod);
    }

    @Nullable
    public PsiElement getContainingMethod(@NotNull LineBreakpoint<?> breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType", "getContainingMethod"));
        }
        SourcePosition position = breakpoint.getSourcePosition();
        if (position == null) {
            return null;
        }
        return KotlinLineBreakpointType.getContainingMethod(position.getElementAt());
    }

    @Nullable
    public static PsiElement getContainingMethod(@Nullable PsiElement elem) {
        return PsiTreeUtil.getParentOfType((PsiElement)elem, JetFunction.class);
    }

    public static boolean inTheMethod(@NotNull SourcePosition pos, @NotNull PsiElement method) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType", "inTheMethod"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType", "inTheMethod"));
        }
        PsiElement elem = pos.getElementAt();
        if (elem == null) {
            return false;
        }
        return Comparing.equal((Object)KotlinLineBreakpointType.getContainingMethod(elem), (Object)method);
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType", "canPutAt"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType", "canPutAt"));
        }
        return BreakpointsPackage.canPutAt(file, line, project, ((Object)((Object)this)).getClass());
    }
}

