/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilder;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluatorImpl;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluationBuilderKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator;
import org.jetbrains.kotlin.idea.util.attachment.AttachmentUtilsKt;
import org.jetbrains.kotlin.psi.JetCodeFragment;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetFile;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"b\u0004)92j\u001c;mS:,e/\u00197vCRLwN\u001c\"vS2$WM\u001d\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*!\u0011\u000eZ3b\u0015!!WMY;hO\u0016\u0014(\u0002C3wC2,\u0018\r^3\u000b!\u00153\u0018\r\\;bi>\u0014()^5mI\u0016\u0014(bA2p[*A\u0011N\u001c;fY2L'N\u0003\u0004f]\u001eLg.\u001a\u0006\u000bKZ\fG.^1uS>t'BC3yaJ,7o]5p]*)!-^5mI*a1m\u001c3f\rJ\fw-\\3oi*Q\u0001k]5FY\u0016lWM\u001c;\u000b\u0007A\u001c\u0018N\u0003\u0005q_NLG/[8o\u00159\u0019v.\u001e:dKB{7/\u001b;j_:T1#\u0012=qe\u0016\u001c8/[8o\u000bZ\fG.^1u_J$\u0019A\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\t!\u0011\u0001\u0003\u0002\u0006\u0005\u0011\r\u0001RA\u0003\u0003\t\tA1!B\u0002\u0005\u0006!\u0001A\u0002A\u0003\u0002\u0011\u0011)!\u0001b\u0002\t\n\u0015\u0011A\u0001\u0002E\u0003\u000b\t!I\u0001C\u0003\u0006\u0005\u0011)\u00012B\u0003\u0003\t\u0017Aa!B\u0002\u0005\r!\u001dA\u0002A\u0003\u0003\t\u0011A\u0001\"B\u0002\u0005\u000f!=A\u0002A\u0003\u0004\t\u0013A\u0011\u0002\u0004\u0001\u0006\u0007\u00111\u00012\u0003\u0007\u0001\u000b\t!a\u0001c\u0005\u0006\u0005\u00119\u0001rB\u0003\u0003\t\u0013A\u0011\u0002B2\u0002\u0019\rI2!B\u0001\t\u000ea5Q\u0016\t\u0003\f1\u001biz\u0001\u0002\u0001\t\u000f5\u0019Q!\u0001E\b1\u001f\u00016\u0001AO\t\t\u0001A\t\"\u0004\u0003\u0006\u0003!AA\u0012\u0001\r\t!\u000e\u0005\u0011eA\u0003\u0002\u0011#A\n\"U\u0002\b\t\u001bI\u0011\u0001C\u0005\u000e\u0003!MQ\"\u0001\u0005\u000bk\u0001\u0001"})
public final class KotlinEvaluationBuilder
implements EvaluatorBuilder {
    public static final /* synthetic */ KClass $kotlinClass;
    public static final KotlinEvaluationBuilder INSTANCE$;

    static {
        $kotlinClass = Reflection.createKotlinClass(KotlinEvaluationBuilder.class);
        new KotlinEvaluationBuilder();
    }

    @NotNull
    public ExpressionEvaluator build(@NotNull PsiElement codeFragment, @Nullable SourcePosition position) {
        Intrinsics.checkParameterIsNotNull((Object)codeFragment, (String)"codeFragment");
        if (!(codeFragment instanceof JetCodeFragment) || position == null) {
            EvaluatorBuilder evaluatorBuilder = EvaluatorBuilderImpl.getInstance();
            if (evaluatorBuilder == null) {
                Intrinsics.throwNpe();
            }
            ExpressionEvaluator expressionEvaluator = evaluatorBuilder.build(codeFragment, position);
            Intrinsics.checkExpressionValueIsNotNull((Object)expressionEvaluator, (String)"EvaluatorBuilderImpl.get\u2026d(codeFragment, position)");
            return expressionEvaluator;
        }
        PsiFile file = position.getFile();
        if (!(file instanceof JetFile)) {
            Throwable throwable = EvaluateExceptionUtil.createEvaluateException((String)"Couldn't evaluate kotlin expression in non-kotlin context");
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"EvaluateExceptionUtil.cr\u2026n in non-kotlin context\")");
            throw throwable;
        }
        if (position.getLine() < 0) {
            Throwable throwable = EvaluateExceptionUtil.createEvaluateException((String)("Couldn't evaluate kotlin expression at " + position));
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"EvaluateExceptionUtil.cr\u2026expression at $position\")");
            throw throwable;
        }
        Document document = PsiDocumentManager.getInstance((Project)((JetFile)file).getProject()).getDocument(file);
        if (document == null || document.getLineCount() < position.getLine()) {
            Throwable throwable = EvaluateExceptionUtil.createEvaluateException((String)("Couldn't evaluate kotlin expression: breakpoint is placed outside the file. " + "It may happen when you've changed source file after starting a debug process."));
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"EvaluateExceptionUtil.cr\u2026arting a debug process.\")");
            throw throwable;
        }
        if (!(((JetCodeFragment)codeFragment).getContext() instanceof JetElement)) {
            Attachment[] attachments = new Attachment[]{AttachmentUtilsKt.attachmentByPsiFile(position.getFile()), AttachmentUtilsKt.attachmentByPsiFile((PsiFile)codeFragment), new Attachment("breakpoint.info", "line: " + position.getLine())};
            PsiElement psiElement2 = ((JetCodeFragment)codeFragment).getContext();
            KotlinEvaluationBuilderKt.getLogger().error("Trying to evaluate " + ((JetCodeFragment)codeFragment).getClass() + " with context " + (psiElement2 != null ? psiElement2.getClass() : null), new Attachment[]{AttachmentUtilsKt.mergeAttachments(attachments)});
            Throwable throwable = EvaluateExceptionUtil.createEvaluateException((String)"Couldn't evaluate kotlin expression in this context");
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"EvaluateExceptionUtil.cr\u2026ression in this context\")");
            throw throwable;
        }
        return (ExpressionEvaluator)new ExpressionEvaluatorImpl((Evaluator)new KotlinEvaluator((JetCodeFragment)codeFragment, position));
    }

    KotlinEvaluationBuilder() {
        INSTANCE$ = this;
    }
}

