/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.diagnostic.LogMessageEx;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ExceptionUtil;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.InvocationException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.EventRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.data;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.eval4j.AbnormalTermination;
import org.jetbrains.eval4j.ExceptionThrown;
import org.jetbrains.eval4j.InterpreterLoopKt;
import org.jetbrains.eval4j.InterpreterResult;
import org.jetbrains.eval4j.Value;
import org.jetbrains.eval4j.ValueReturned;
import org.jetbrains.eval4j.jdi.JDIEval;
import org.jetbrains.eval4j.jdi.JdiValuesKt;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ClassBuilderFactories;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.ClassFileUtilsKt;
import org.jetbrains.kotlin.codegen.CompilationErrorHandler;
import org.jetbrains.kotlin.codegen.KotlinCodegenFacade;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.idea.caches.resolve.KotlinCacheService;
import org.jetbrains.kotlin.idea.core.refactoring.JetRefactoringUtilKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.ExtractFunctionForDebuggerUtilKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.FrameVisitor;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinCodeFragmentFactory;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluateExpressionCache;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluationBuilderKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator$Companion$extractAndCompile$;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilingEvaluator.CompilingEvaluatorKt;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractionResult;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.Parameter;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.DebuggerUtils;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.util.attachment.AttachmentUtilsKt;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetCodeFragment;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetScript;
import org.jetbrains.kotlin.psi.JetTreeVisitorVoid;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.codeFragmentUtil.CodeFragmentUtilKt;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Opcodes;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"I\u0006)y1j\u001c;mS:,e/\u00197vCR|'OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\u0011IG-Z1\u000b\u0011\u0011,'-^4hKJT\u0001\"\u001a<bYV\fG/\u001a\u0006\n\u000bZ\fG.^1u_JT1aY8n\u0015!Ig\u000e^3mY&T'BB3oO&tWM\u0003\u0006fm\u0006dW/\u0019;j_:T!\"\u001a=qe\u0016\u001c8/[8o\u0015\u0019a\u0014N\\5u})a1m\u001c3f\rJ\fw-\\3oi*y!*\u001a;D_\u0012,gI]1h[\u0016tGOC\u0002qg&Tab]8ve\u000e,\u0007k\\:ji&|gN\u0003\bT_V\u00148-\u001a)pg&$\u0018n\u001c8\u000b\u001f\u001d,GoQ8eK\u001a\u0013\u0018mZ7f]RT\u0011cZ3u'>,(oY3Q_NLG/[8o\u0015\u001d\u0019wN\u001c;fqRTQ#\u0012<bYV\fG/[8o\u0007>tG/\u001a=u\u00136\u0004HNC\u0002B]fTAA[1wC*!A.\u00198h\u0015\u0019y%M[3di*Yq-\u001a;N_\u0012Lg-[3s\u0015!iu\u000eZ5gS\u0016\u0014(\"C\"p[B\fg.[8o]\u0007Q!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0003\t\u0005A!!\u0002\u0002\u0005\u0004!\u0015QA\u0001\u0003\u0003\u0011\r)1\u0001\"\u0002\t\u00011\u0001Q!\u0001\u0005\u0005\u000b\t!9\u0001#\u0003\u0006\u0005\u0011!\u0001RA\u0003\u0003\t\u0013AQ!\u0002\u0002\u0005\u000b!-QA\u0001C\u0006\u0011\u0019)1\u0001\u0002\u0004\t\b1\u0001QA\u0001\u0003\u0002\u0011!)1\u0001B\u0004\t\u00101\u0001Qa\u0001C\u0005\u0011%a\u0001!\u0002\u0002\u0005\u000f!=QA\u0001C\u0005\u0011%)1\u0001b\u0003\t\u00171\u0001Q!\u0001E\u0002\u000b\r!!\u0002c\u0006\r\u0001\u0015\t\u0001\u0002D\u0003\u0003\t-AI\"\u0002\u0002\u0005\u0018!iQA\u0001C\u0006\u0011-)1\u0001\u0002\u0004\t\u001d1\u0001QA\u0001\u0003\u0007\u00119!1\u0001D\u0002\u0011\u001ee\u0019Q!\u0001E\u00071\u001bi\nQD\u0017\u0011\t\r$\u0001dB\u0011\u0004\u000b\u0005Ay\u0001g\u0004V\u0007!)1\u0001B\u0004\n\u0003!EQb\u0001C\n\u0013\u0005A\t\"\f\t\u0005G\u0012A\n\"I\u0002\u0006\u0003!A\u0001\u0004C+\u0004\u0011\u0015\u0019A\u0011C\u0005\u0002\u0011%i1\u0001\u0002\u0006\n\u0003!IQF\u0006\u0003\f1\riz\u0001\u0002\u0001\t\u00165\u0019Q!\u0001E\n1'\u00016\u0001A\u0011\u0005\u000b\u0005A)\u0002$\u0001\u0019\u0016E\u001bQ\u0001B\u0002\n\u0003!aQ\"\u0001E\r[/!1\u0002g\u0007\"\t\u0015\t\u0001\"\u0004G\u000115\t6a\u0001C\u000e\u0013\u0005AY\"N\u0011\u0006A\u0011\u0019\u000f\u0001'\u0004\u001e\u0010\u0011\u0001\u0001bB\u0007\u0004\u000b\u0005Ay\u0001g\u0004Q\u0007\u0001iz\u0001\u0002\u0001\t\u00125\u0019Q!\u0001\u0005\t1!\u00016\u0011A\u0011\u0004\u000b\u0005A1\u0001G\u0002R\u0007\u001d!i!C\u0001\u0005\u00015\t\u0001\u0012C\u0007\u0002\u0011%\u0001"})
public final class KotlinEvaluator
implements Evaluator {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private final JetCodeFragment codeFragment;
    @NotNull
    private final SourcePosition sourcePosition;
    public static final Companion Companion;

    static {
        $kotlinClass = Reflection.createKotlinClass(KotlinEvaluator.class);
        Companion companion = Companion = new Companion(null);
    }

    @Nullable
    public Object evaluate(@NotNull EvaluationContextImpl context) {
        Object isCompiledDataFromCache;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (KotlinPackage.isEmpty((String)this.codeFragment.getText())) {
            return context.getDebugProcess().getVirtualMachineProxy().mirrorOf();
        }
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = true;
        try {
            KotlinEvaluateExpressionCache.CompiledDataDescriptor compiledData2 = KotlinEvaluateExpressionCache.Companion.getOrCreateCompiledData(this.codeFragment, this.sourcePosition, context, (Function2<? super JetCodeFragment, ? super SourcePosition, ? extends KotlinEvaluateExpressionCache.CompiledDataDescriptor>)((Function2)new Function2<JetCodeFragment, SourcePosition, KotlinEvaluateExpressionCache.CompiledDataDescriptor>((Ref.BooleanRef)isCompiledDataFromCache, context){
                final /* synthetic */ Ref.BooleanRef $isCompiledDataFromCache;
                final /* synthetic */ EvaluationContextImpl $context;

                @NotNull
                public final KotlinEvaluateExpressionCache.CompiledDataDescriptor invoke(@NotNull JetCodeFragment fragment, @NotNull SourcePosition position) {
                    Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
                    Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
                    this.$isCompiledDataFromCache.element = false;
                    return org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator$Companion.access$extractAndCompile$1(KotlinEvaluator.Companion, fragment, position, this.$context);
                }
                {
                    this.$isCompiledDataFromCache = booleanRef;
                    this.$context = evaluationContextImpl;
                    super(2);
                }
            }));
            InterpreterResult result2 = KotlinEvaluator.Companion.runEval4j(context, compiledData2);
            VirtualMachine virtualMachine = context.getDebugProcess().getVirtualMachineProxy().getVirtualMachine();
            if (isCompiledDataFromCache.element && result2 instanceof ExceptionThrown && Intrinsics.areEqual((Object)((Object)((ExceptionThrown)result2).getKind()), (Object)((Object)ExceptionThrown.ExceptionKind.BROKEN_CODE))) {
                InterpreterResult interpreterResult = KotlinEvaluator.Companion.runEval4j(context, KotlinEvaluator.Companion.extractAndCompile(this.codeFragment, this.sourcePosition, context));
                VirtualMachine virtualMachine2 = virtualMachine;
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualMachine2, (String)"virtualMachine");
                return KotlinEvaluator.Companion.toJdiValue(interpreterResult, virtualMachine2);
            }
            VirtualMachine virtualMachine3 = virtualMachine;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualMachine3, (String)"virtualMachine");
            return KotlinEvaluator.Companion.toJdiValue(result2, virtualMachine3);
        }
        catch (EvaluateException e) {
            throw (Throwable)e;
        }
        catch (ProcessCanceledException e) {
            KotlinEvaluator.Companion.exception(e);
        }
        catch (VMDisconnectedException e) {
            String string = DebuggerBundle.message((String)"error.vm.disconnected", (Object[])new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DebuggerBundle.message(\"error.vm.disconnected\")");
            KotlinEvaluator.Companion.exception(string);
        }
        catch (Exception e) {
            Attachment[] attachments = new Attachment[]{AttachmentUtilsKt.attachmentByPsiFile(this.sourcePosition.getFile()), AttachmentUtilsKt.attachmentByPsiFile((PsiFile)this.codeFragment), new Attachment("breakpoint.info", "line: " + this.sourcePosition.getLine())};
            KotlinEvaluationBuilderKt.getLogger().error((Object)LogMessageEx.createEvent((String)"Couldn't evaluate expression", (String)ExceptionUtil.getThrowableText((Throwable)e), (Attachment[])new Attachment[]{AttachmentUtilsKt.mergeAttachments(attachments)}));
            String cause = e.getMessage() != null ? ": " + e.getMessage() : "";
            KotlinEvaluator.Companion.exception("An exception occurs during Evaluate Expression Action " + cause);
        }
        isCompiledDataFromCache = null;
        return Unit.INSTANCE$;
    }

    @Nullable
    public Modifier getModifier() {
        return null;
    }

    @NotNull
    public final JetCodeFragment getCodeFragment() {
        return this.codeFragment;
    }

    @NotNull
    public final SourcePosition getSourcePosition() {
        return this.sourcePosition;
    }

    public KotlinEvaluator(@NotNull JetCodeFragment codeFragment, @NotNull SourcePosition sourcePosition2) {
        Intrinsics.checkParameterIsNotNull((Object)codeFragment, (String)"codeFragment");
        Intrinsics.checkParameterIsNotNull((Object)sourcePosition2, (String)"sourcePosition");
        this.codeFragment = codeFragment;
        this.sourcePosition = sourcePosition2;
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"A\u0014)I1i\\7qC:LwN\u001c\u0006\u0010\u0017>$H.\u001b8Fm\u0006dW/\u0019;pe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgN\u0003\u0003jI\u0016\f'\u0002\u00033fEV<w-\u001a:\u000b\u0011\u00154\u0018\r\\;bi\u0016T1!\u00118z\u0015i\u0011w\u000e_(s+:\u0014w\u000e_!sOVlWM\u001c;JM:+W\rZ3e\u0015\u0011)g/\u00197\u000b\u000f)#\u0015*\u0012<bY*1QM^1mi)T1A\u001b3j\u00155\t'oZ;nK:$h+\u00197vK*)a+\u00197vK*i\u0001/\u0019:b[\u0016$XM\u001d+za\u0016TA\u0001V=qK*IqN\u00196fGR<XM\u0019\u0006\u0004CNl'BF2sK\u0006$Xm\u00117bgN4\u0015\u000e\\3GC\u000e$xN]=\u000b\u0019\r|G-\u001a$sC\u001elWM\u001c;\u000b\u001f)+GoQ8eK\u001a\u0013\u0018mZ7f]RT1\u0001]:j\u0015E)\u0007\u0010\u001e:bGR,GMR;oGRLwN\u001c\u0006\u0011\u0015\u0016$h*Y7fI\u001a+hn\u0019;j_:TqaY8oi\u0016DHOC\u000bFm\u0006dW/\u0019;j_:\u001cuN\u001c;fqRLU\u000e\u001d7\u000b\u0007\r|WN\u0003\u0005j]R,G\u000e\\5k\u0015\u0019)gnZ5oK*QQM^1mk\u0006$\u0018n\u001c8\u000b\u0015A\f'/Y7fi\u0016\u00148O\u0003\u000bQCJ\fW.\u001a;feN$Um]2sSB$xN\u001d\u0006\u001e\u0017>$H.\u001b8Fm\u0006dW/\u0019;f\u000bb\u0004(/Z:tS>t7)Y2iK*\u00012\t\\1tg\u001aKG.\u001a$bGR|'/\u001f\u0006\bG>$WmZ3o\u0015IZu\u000e\u001e7j]\u00163\u0018\r\\;bi\u0016,\u0005\u0010\u001d:fgNLwN\\\"bG\",G\u0005U1sC6,G/\u001a:t\t\u0016\u001c8M]5qi>\u0014(\"C3yG\u0016\u0004H/[8o\u0015\ri7o\u001a\u0006\u0007'R\u0014\u0018N\\4\u000b\u000f9{G\u000f[5oO*!!.\u0019<b\u0015\u0011a\u0017M\\4\u000b\tY{\u0017\u000e\u001a\u0006\u0002K*IA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0012Kb$(/Y2u\u0003:$7i\\7qS2,'BD:pkJ\u001cW\rU8tSRLwN\u001c\u0006\u000f'>,(oY3Q_NLG/[8o\u0015Y\u0019u.\u001c9jY\u0016$G)\u0019;b\t\u0016\u001c8M]5qi>\u0014(\u0002N&pi2Lg.\u0012<bYV\fG/Z#yaJ,7o]5p]\u000e\u000b7\r[3%\u0007>l\u0007/\u001b7fI\u0012\u000bG/\u0019#fg\u000e\u0014\u0018\u000e\u001d;pe*aq-\u001a;DY\u0006\u001c8OT1nK*Aa-\u001b7f\u001d\u0006lWMC\u0005sk:,e/\u001975U*a1m\\7qS2,G\rR1uC*\t\u0012J\u001c;feB\u0014X\r^3s%\u0016\u001cX\u000f\u001c;\u000b\u000f)+GOR5mK*q1\r[3dW\u001a{'/\u0012:s_J\u001c(BF1oC2L(0Z%oY&tWMR;oGRLwN\\:\u000b\u000f\t{w\u000e\\3b]*1R\t\u001f;f]\u0012,G-\u00118bYf\u001c\u0018n\u001d*fgVdGO\u0003\u0019L_Rd\u0017N\\#wC2,\u0018\r^8sI\r{W\u000e]1oS>tG%\u0012=uK:$W\rZ!oC2L8/[:SKN,H\u000e\u001e\u0006\u0016O\u0016$\u0018I]4v[\u0016tGo\u001d$pe\u00163\u0018\r\u001c\u001bk\u00159\u0001\u0018M]1nKR,'\u000fV=qKNTQ!\u0011:sCfTA\u0001T5ti*!Q\u000f^5m\u0015A)\u0005\u0010\u001e:bGRLwN\u001c*fgVdGOC\u0006sK\u001a\f7\r^8sS:<'\"C5oiJ|G-^2f\u0015A)\u0007\u0010\u001e:bGRLwN\\#oO&tWM\u0003\rhKR\u0004\u0016M]1nKR,'o\u001d$pe\u0012+'-^4hKJT\u0001B\u001a:bO6,g\u000e\u001e\u0006\r\u0005&tG-\u001b8h)J\f7-\u001a\u0006\be\u0016\u001cx\u000e\u001c<f\u0015M\u0011XmY8sI\u0006swN\\=n_V\u001cH+\u001f9f\u00155!\u0018\u0010]3SK\u001a,'/\u001a8dK*\u0001\"*\u001a;UsB,'+\u001a4fe\u0016t7-\u001a\u0006\u0012Y>\u001c\u0017\r\u001c,be&\f'\r\\3OC6,'b\u0002<jg&$xN\u001d\u0006\r\rJ\fW.\u001a,jg&$xN\u001d\u0006\u0005+:LGO\u0003\u0006u_*#\u0017NV1mk\u0016T!A^7\u000b\u001dYK'\u000f^;bY6\u000b7\r[5oK*\u00191/\u001e8\u001b\n)\u0011\u0001C\u0001\u0006\u0005\u0011\u0001\u00012A\u0003\u0003\t\u0003A!!\u0002\u0002\u0005\u0003!\u0015QA\u0001C\u0002\u0011\r)!\u0001\u0002\u0002\t\b\u0015\u0019AQ\u0001E\u0001\u0019\u0001)1\u0001B\u0002\t\u00011\u0001Q!\u0001\u0005\u0003\u000b\r!A\u0001\u0003\u0003\r\u0001\u0015\u0011A\u0011\u0001\u0005\u0007\u000b\t!Q\u0001#\u0004\u0006\u0007\u0011-\u00012\u0002\u0007\u0001\u000b\r!Q\u0001c\u0004\r\u0001\u0015\u0011A\u0011\u0001\u0005\u0002\u000b\t!q\u0001C\u0005\u0006\u0005\u0011=\u00012C\u0003\u0004\t!A\t\u0002\u0004\u0001\u0006\u0005\u0011)\u0001rB\u0003\u0003\t\u0017AY!\u0002\u0002\u0005\u0011!EQA\u0001\u0003\u0002\u0011/)1\u0001\"\u0006\t\u00171\u0001Qa\u0001C\u000b\u00113a\u0001!B\u0001\t\u001d\u0015\u0011A\u0001\u0004E\u000f\u000b\t!I\u0002C\u0002\u0006\u0005\u0011i\u0001bD\u0003\u0003\t7Ay\"B\u0002\u0005\u001d!mA\u0002A\u0003\u0004\t\u000bA\u0011\u0003\u0004\u0001\u0006\u0007\u0011y\u0001\u0012\u0005\u0007\u0001\u000b\t!\u0011\u0001\u0003\n\u0006\u0007\u0011\u0001\u00022\u0005\u0007\u0001\u000b\t!\u0001\u0003c\t\u0006\u0005\u0011U\u0001bC\u0003\u0003\t+AI\"\u0002\u0002\u0005\u001d!mQA\u0001C\u0003\u0011K)1\u0001\u0002\u0003\t)1\u0001Qa\u0001\u0003\u0005\u0011Sa\u0001!B\u0001\t+\u0015\u0011A\u0011\u0006E\u0016\u000b\t!Q\u0003\u0003\f\u0006\u0005\u0011)\u0002\u0002F\u0003\u0004\t\u0011Aq\u0003\u0004\u0001\u0006\u0005\u0011)\u0002bF\u0003\u0004\t5A\t\u0004\u0004\u0001\u0006\u0007\u0011y\u0001\"\u0007\u0007\u0001\u000b\t!)\u0001c\r\u0006\u0005\u0011i\u0001\u0012G\u0003\u0004\t\u0015AA\u0004\u0004\u0001\u0006\u0005\u0011)\u0001\u0002H\u0003\u0004\t+AI\u0004\u0004\u0001\u0006\u0007\u0011!\u0001B\b\u0007\u0001\u000b\r!9\u0001#\u0010\r\u0001\u0015\u0011AQ\u0001\u0005 \u000b\t!)\u0002#\u000f\u0006\u0007\u0011!\u0001\u0012\t\u0007\u0001\u000b\r!A\u0001C\u0011\r\u0001\u0015\u0011A\u0011\u0006E\"\u000b\t!a\u0004C\u0011\u0006\u0005\u0011\r\u0001RI\u0003\u0003\t}A1%\u0002\u0002\u0005@!\u001dSa\u0001\u0003!\u0011\tb\u0001!\u0002\u0002\u0005A!\u0011SA\u0001\u0003\u0002\u0011\u0017*1\u0001b\u0011\tK1\u0001Qa\u0001C\u000b\u0011\u001db\u0001!B\u0002\u0005\u0006!EC\u0002A\u0003\u0004\t\u0011A\u0011\u0006\u0004\u0001\u0006\u0005\u0011\r\u0003\"J\u0003\u0003\t+Aq%\u0002\u0002\u0005\u0006!ESA\u0001\u0003\r\u0011-*!\u0001b\u0013\t\u000e\u0015\u0019AA\nE+\u0019\u0001)1\u0001\u0002\u0014\t\u00101\u0001QA\u0001\u0003'\u0011\u001f)!\u0001\u0002\u0014\tV\u0011\u0019\u001d\u0001d\u0002\u001a\u0007\u0015\t\u0001\u0012\u0002M\u0005;\u0003uRF\u000b\u0003\u00021\u0013iz\u0001\u0002\u0001\t\u000b5\u0019Q!\u0001\u0005\u00071\u0019\u00016\u0001AO\b\t\u0001Aq!D\u0002\u0006\u0003!5\u0001T\u0002)\u0004\u0002u=A\u0001\u0001\u0005\t\u001b\r)\u0011\u0001#\u0005\u0019\u0012A\u001b\u0011!I\u0002\u0006\u0003!5\u0001TB)\u0004\u0013\u0011%\u0011\"\u0001\u0005\n\u001b\u0005A\u0019\"D\u0001\t\u00135\t\u0001BCW5\t\u0005A\"\"h\u0004\u0005\u0001!UQbA\u0003\u0002\u0011-A2\u0002U\u0002\u0001;\u001f!\u0001\u0001\u0003\u0007\u000e\u0007\u0015\t\u0001r\u0003M\f!\u000e\u0005Qt\u0002\u0003\u0001\u00115i1!B\u0001\t\u001eau\u0001kA\u0001\u001e\u0010\u0011\u0001\u0001\u0002E\u0007\u0004\u000b\u0005Ay\u0002g\bQ\u0007\u0007\t3!B\u0001\t\"a\u0005\u0012kA\u0006\u0005\u0015%\t\u0001\"E\u0007\u0002\u0011Gi\u0011\u0001\u0003\n\u000e\u0003!\u0015R\"\u0001\u0005\u0014[U!\u0011\u0001G\n\u001e\u0010\u0011\u0001\u0001rE\u0007\u0004\u000b\u0005A9\u0003g\nQ\u0007\u0001\t3!B\u0001\t)a!\u0012kA\u0003\u0005'%\t\u00012F\u0007\u0002\u0011YiS\u0003B\u0001\u0019'u=A\u0001\u0001E\u0017\u001b\r)\u0011\u0001#\f\u0019.A\u001b\u0001!I\u0002\u0006\u0003!!\u0002\u0004F)\u0004\u000b\u0011\u0019\u0012\"\u0001E\u0016\u001b\u0005Aq#\f\u0016\u0005\u0003a=Rt\u0002\u0003\u0001\u0011+i1!B\u0001\t\u0017aY\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001\u0002G\u0007\u0004\u000b\u0005Ay\u0003g\fQ\u0007\u0003iz\u0001\u0002\u0001\t\u001b5\u0019Q!\u0001E\u000f1;\u00016!A\u0011\u0004\u000b\u0005A\u0001\u0004\u0007\rR\u0007%!y#C\u0001\t25\t\u00012E\u0007\u0002\u0011ei\u0011\u0001#\n.+\u0011\t\u0001DGO\b\t\u0001A)$D\u0002\u0006\u0003!\u001d\u0002t\u0005)\u0004\u0001\u0005\u001aQ!\u0001E\u00141O\t6!\u0002\u0003\u001b\u0013\u0005Aa#D\u0001\t-5~B!\u0001\r\u001c;\u001f!\u0001\u0001C\u0007\u000e\u0007\u0015\t\u0001R\u0004M\u000f!\u000e\u0001Qt\u0002\u0003\u0001\u0011oi1!B\u0001\t1aA\u0002k!\u0001\"\u0007\u0015\t\u00012\u0007M\u001a#\u000e9AaG\u0005\u0002\u0011ii\u0011\u0001#\n\u000e\u0003!ERf\u0007\u0003\u0002+\r)\u0011\u0001#\u000e\u00196aiRt\u0002\u0003\u0001\u0011wi1!B\u0001\t7aY\u0002k!\u0001\"\u0007\u0015\t\u0001r\u0007M\u001c#\u000e9A!H\u0005\u0002\u0011qi\u0011\u0001#\u000f\u000e\u0003\u0011\u0005Q\u0016\r\u0003\u0002+\r)\u0011\u0001#\b\u0019\u001ea}Rt\u0002\u0003\u0001\u0011Ai1!B\u0001\t a}\u0001k!\u0001\u001e\u001a\u0011\u0001\u0001\u0002I\u0007\t\u000b\u0005AQ$\u0003\u0003\n\u0007\u0015\t\u0001\u0012\u0003M\t1u\u00016!A\u0011\t\u000b\u0005AY$\u0003\u0003\n\u0007\u0015\t\u0001R\u0002M\u00071w\t6A\u0003C \u0013\u0005Ai$D\u0001\t&5\t\u0001bE\u0007\u0003\u0011)a\t!L\u000e\u0005\u0003U\u0019Q!\u0001E!1\u0003BB%h\u0004\u0005\u0001!%SbA\u0003\u0002\u0011-A2\u0002UB\u0001C\r)\u0011\u0001c\b\u0019 E\u001bq\u0001\u0002\u0013\n\u0003!\u0019R\"\u0001\u0005\"\u001b\u0005A\u0019#\f\u0019\u0005\u0003U\u0019Q!\u0001\u0005#1\tBb%h\u0004\u0005\u0001!5SbA\u0003\u0002\u0011\u000bB*\u0005UB\u0001;\u001f!\u0001\u0001c\u0014\u000e\u0007\u0015\t\u0001r\u0005M\u0014!\u000e\tQt\u0002\u0003\u0001\u0011!j1!B\u0001\tGa\u0019\u0003ka\u0001\"\u0007\u0015\t\u0001r\tM$#\u000eYAAJ\u0005\u0002\t\u0001i\u0011\u0001\u0003\u0013\u000e\u0003!%S\"\u0001\u0005\u0017\u001b\u0005AQ%\f\u000f\u0005\u0003U\u0019Q!\u0001E\u001a1gA\u001a&h\u0004\u0005\u0001!QSbA\u0003\u0002\u0011\u001bBj\u0005UB\u0001C\u0011)\u0011\u0001C\u0014\r\u0002a9\u0013kA\u0004\u0005T%\t\u0001rJ\u0007\u0002\u0011ii\u0011\u0001\u0003\u00156\u0001\u0001"})
    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        /*
         * WARNING - void declaration
         */
        private final KotlinEvaluateExpressionCache.CompiledDataDescriptor extractAndCompile(JetCodeFragment codeFragment, SourcePosition sourcePosition2, EvaluationContextImpl context) {
            List list;
            void destination;
            void $receiver;
            Iterable $receiver2;
            this.checkForErrors(codeFragment, false);
            PsiFile psiFile = sourcePosition2.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"sourcePosition.file");
            ExtractionResult extractionResult = ExtractFunctionForDebuggerUtilKt.getFunctionForExtractedFragment(codeFragment, psiFile, sourcePosition2.getLine());
            if (extractionResult == null) {
                throw (Throwable)new IllegalStateException("Code fragment cannot be extracted to function");
            }
            KotlinEvaluateExpressionCache.ParametersDescriptor parametersDescriptor = this.getParametersForDebugger(extractionResult, codeFragment);
            JetNamedDeclaration jetNamedDeclaration = extractionResult.getDeclaration();
            if (jetNamedDeclaration == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.JetNamedFunction");
            }
            JetNamedFunction extractedFunction = (JetNamedFunction)jetNamedDeclaration;
            ClassFileFactory classFileFactory = this.createClassFileFactory(codeFragment, extractedFunction, context, parametersDescriptor);
            Iterable<OutputFile> iterable = ClassFileUtilsKt.filterClassFiles(classFileFactory.asList());
            void var10_9 = $receiver2;
            Collection collection = new ArrayList();
            for (Object element2 : $receiver) {
                OutputFile it = (OutputFile)element2;
                if (!(Intrinsics.areEqual((Object)it.getRelativePath(), (Object)(KotlinEvaluationBuilderKt.getPackageInternalName() + ".class")) ^ true)) continue;
                destination.add(element2);
            }
            $receiver2 = (List)destination;
            ArrayList sortedList = KotlinPackage.toArrayList((Iterable)$receiver2);
            Object sortBy2 = new Comparator<T>(){
                public static final /* synthetic */ KClass $kotlinClass;

                static {
                    $kotlinClass = Reflection.createKotlinClass(Companion$extractAndCompile$$inlined$sortBy$1.class);
                }

                public int compare(T a, T b) {
                    OutputFile it = (OutputFile)a;
                    Comparable comparable = Integer.valueOf(it.getRelativePath().length());
                    it = (OutputFile)b;
                    Comparable comparable2 = comparable;
                    Integer n = it.getRelativePath().length();
                    return KotlinPackage.compareValues((Comparable)comparable2, (Comparable)n);
                }
            };
            Collections.sort(sortedList, sortBy2);
            List outputFiles = sortedList;
            String funName = extractedFunction.getName();
            if (funName == null) {
                throw (Throwable)new IllegalStateException("Extracted function should have a name: " + extractedFunction.getText());
            }
            if (outputFiles.size() < 2) {
                list = KotlinPackage.emptyList();
            } else {
                void destination2;
                void $receiver3;
                void $receiver4;
                Object element2;
                sortBy2 = outputFiles.subList(1, outputFiles.size());
                Iterator iterator2 = $receiver4;
                element2 = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver4, (int)10));
                for (Object item : $receiver3) {
                    void it;
                    OutputFile outputFile = (OutputFile)item;
                    void var17_17 = destination2;
                    Pair pair2 = KotlinPackage.to((Object)Companion.getClassName(it.getRelativePath()), (Object)it.asByteArray());
                    var17_17.add(pair2);
                }
                list = (List)destination2;
            }
            List additionalFiles = list;
            return new KotlinEvaluateExpressionCache.CompiledDataDescriptor(((OutputFile)KotlinPackage.first((List)outputFiles)).asByteArray(), additionalFiles, sourcePosition2, funName, parametersDescriptor);
        }

        private final String getClassName(String fileName) {
            return KotlinPackage.replace$default((String)KotlinPackage.substringBeforeLast$default((String)fileName, (String)".class", null, (int)2), (String)"/", (String)".", (boolean)false, (int)4);
        }

        /*
         * WARNING - void declaration
         */
        private final InterpreterResult runEval4j(EvaluationContextImpl context, KotlinEvaluateExpressionCache.CompiledDataDescriptor compiledData2) {
            void resultValue;
            VirtualMachine virtualMachine = context.getDebugProcess().getVirtualMachineProxy().getVirtualMachine();
            if (KotlinPackage.isNotEmpty((Collection)compiledData2.getAdditionalClasses())) {
                CompilingEvaluatorKt.loadClasses(context, (Collection<? extends Pair<? extends String, ? extends byte[]>>)compiledData2.getAdditionalClasses());
            }
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            new ClassReader(compiledData2.getBytecodes()).accept(new ClassVisitor(compiledData2, context, virtualMachine, (Ref.ObjectRef)resultValue, Opcodes.ASM5){
                public static final /* synthetic */ KClass $kotlinClass;
                final /* synthetic */ KotlinEvaluateExpressionCache.CompiledDataDescriptor $compiledData;
                final /* synthetic */ EvaluationContextImpl $context;
                final /* synthetic */ VirtualMachine $virtualMachine;
                final /* synthetic */ Ref.ObjectRef $resultValue;

                static {
                    $kotlinClass = Reflection.createKotlinClass(runEval4j.1.class);
                }

                @Nullable
                public MethodVisitor visitMethod(int access, @NotNull String name2, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions) {
                    Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
                    Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
                    if (Intrinsics.areEqual((Object)name2, (Object)this.$compiledData.getFunName())) {
                        Type[] argumentTypes = Type.getArgumentTypes((String)desc);
                        KotlinEvaluateExpressionCache.ParametersDescriptor parametersDescriptor = this.$compiledData.getParameters();
                        Intrinsics.checkExpressionValueIsNotNull((Object)argumentTypes, (String)"argumentTypes");
                        List<Value> args = org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator$Companion.access$getArgumentsForEval4j$2(KotlinEvaluator.Companion, this.$context, parametersDescriptor, argumentTypes);
                        return (MethodVisitor)new MethodNode(this, args, argumentTypes, Opcodes.ASM5, access, name2, desc, signature, exceptions){
                            public static final /* synthetic */ KClass $kotlinClass;
                            final /* synthetic */ runEval4j.1 this$0;
                            final /* synthetic */ List $args;
                            final /* synthetic */ Type[] $argumentTypes;

                            static {
                                $kotlinClass = Reflection.createKotlinClass(runEval4j.visitMethod.1.class);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public void visitEnd() {
                                List list;
                                void destination;
                                void $receiver;
                                Iterable $receiver2;
                                Object it;
                                T element22;
                                Collection collection = this.this$0.$virtualMachine.eventRequestManager().breakpointRequests();
                                Iterable iterable = this.this$0.$virtualMachine.eventRequestManager().classPrepareRequests();
                                Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"virtualMachine.eventRequ\u2026().classPrepareRequests()");
                                List allRequests = KotlinPackage.plus((Collection)collection, (Iterable)iterable);
                                Iterable $receiver3 = allRequests;
                                for (T element22 : $receiver3) {
                                    it = (EventRequest)element22;
                                    it.disable();
                                }
                                VirtualMachine virtualMachine = this.this$0.$virtualMachine;
                                Intrinsics.checkExpressionValueIsNotNull((Object)virtualMachine, (String)"virtualMachine");
                                ClassLoaderReference classLoaderReference = this.this$0.$context.getClassLoader();
                                ThreadReferenceProxyImpl threadReferenceProxyImpl = this.this$0.$context.getSuspendContext().getThread();
                                ThreadReference threadReference = threadReferenceProxyImpl != null ? threadReferenceProxyImpl.getThreadReference() : null;
                                if (threadReference == null) {
                                    Intrinsics.throwNpe();
                                }
                                JDIEval eval = new JDIEval(virtualMachine, classLoaderReference, threadReference, KotlinEvaluationBuilderKt.getInvokePolicy((SuspendContext)this.this$0.$context.getSuspendContext()));
                                Ref.ObjectRef objectRef = this.this$0.$resultValue;
                                MethodNode methodNode = this;
                                MethodNode methodNode2 = this;
                                Iterable iterable2 = this.$args;
                                Object[] objectArray = this.$argumentTypes;
                                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"argumentTypes");
                                Iterable iterable3 = KotlinPackage.zip((Iterable)iterable2, (Object[])objectArray);
                                MethodNode methodNode3 = methodNode2;
                                MethodNode methodNode4 = methodNode;
                                Ref.ObjectRef objectRef2 = objectRef;
                                element22 = $receiver2;
                                it = new ArrayList<E>(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
                                for (T item : $receiver) {
                                    void it2;
                                    Pair pair2 = (Pair)item;
                                    list = destination;
                                    Value value2 = (Value)it2.getFirst();
                                    Type type2 = (Type)it2.getSecond();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"it.second");
                                    Value value3 = org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator$Companion.access$boxOrUnboxArgumentIfNeeded$3(KotlinEvaluator.Companion, eval, value2, type2);
                                    list.add(value3);
                                }
                                list = (List)destination;
                                objectRef2.element = InterpreterLoopKt.interpreterLoop$default(methodNode4, JdiValuesKt.makeInitialFrame(methodNode3, list), eval, null, 8);
                                $receiver2 = allRequests;
                                for (T element3 : $receiver2) {
                                    EventRequest it3 = (EventRequest)element3;
                                    it3.enable();
                                }
                            }
                            {
                                this.this$0 = $outer;
                                this.$args = $captured_local_variable$1;
                                this.$argumentTypes = $captured_local_variable$2;
                                super($super_call_param$3, $super_call_param$4, $super_call_param$5, $super_call_param$6, $super_call_param$7, $super_call_param$8);
                            }
                        };
                    }
                    return super.visitMethod(access, name2, desc, signature, exceptions);
                }
                {
                    this.$compiledData = $captured_local_variable$0;
                    this.$context = $captured_local_variable$1;
                    this.$virtualMachine = $captured_local_variable$2;
                    this.$resultValue = $captured_local_variable$3;
                    super($super_call_param$4);
                }
            }, 0);
            InterpreterResult interpreterResult = (InterpreterResult)resultValue.element;
            if (interpreterResult == null) {
                throw (Throwable)new IllegalStateException("resultValue is null: cannot find method " + compiledData2.getFunName());
            }
            return interpreterResult;
        }

        private final Value boxOrUnboxArgumentIfNeeded(JDIEval eval, Value argumentValue, Type parameterType) {
            Type argumentType = argumentValue.getAsmType();
            if (AsmUtil.isPrimitive(parameterType) && !AsmUtil.isPrimitive(argumentType)) {
                try {
                    Type unboxedType = AsmUtil.unboxType(argumentType);
                    if (Intrinsics.areEqual((Object)parameterType, (Object)unboxedType)) {
                        return eval.unboxType(argumentValue, parameterType);
                    }
                }
                catch (UnsupportedOperationException ignored) {
                    // empty catch block
                }
            }
            if (!AsmUtil.isPrimitive(parameterType) && AsmUtil.isPrimitive(argumentType) && Intrinsics.areEqual((Object)parameterType, (Object)AsmUtil.boxType(argumentType))) {
                return eval.boxType(argumentValue);
            }
            return argumentValue;
        }

        private final com.sun.jdi.Value toJdiValue(InterpreterResult $receiver, VirtualMachine vm) {
            Value value2;
            InterpreterResult interpreterResult = $receiver;
            if (interpreterResult instanceof ValueReturned) {
                value2 = ((ValueReturned)$receiver).getResult();
            } else if (interpreterResult instanceof ExceptionThrown) {
                Void void_;
                if (Intrinsics.areEqual((Object)((Object)((ExceptionThrown)$receiver).getKind()), (Object)((Object)ExceptionThrown.ExceptionKind.FROM_EVALUATED_CODE))) {
                    Object v = ((ExceptionThrown)$receiver).getException().getValue();
                    if (v == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.ObjectReference");
                    }
                    void_ = this.exception(new InvocationException((ObjectReference)v));
                } else {
                    void_ = this.exception(((ExceptionThrown)$receiver).getException().toString());
                }
                value2 = (Value)((Object)void_);
            } else if (interpreterResult instanceof AbnormalTermination) {
                value2 = (Value)((Object)this.exception(((AbnormalTermination)$receiver).getMessage()));
            } else {
                throw (Throwable)new IllegalStateException("Unknown result value produced by eval4j");
            }
            Value jdiValue = value2;
            return JdiValuesKt.asJdiValue(jdiValue, vm, jdiValue.getAsmType());
        }

        private final KotlinEvaluateExpressionCache.ParametersDescriptor getParametersForDebugger(ExtractionResult $receiver, JetCodeFragment fragment) {
            return (KotlinEvaluateExpressionCache.ParametersDescriptor)ApplicationUtilsKt.runReadAction((Function0)new Function0<KotlinEvaluateExpressionCache.ParametersDescriptor>($receiver, fragment){
                final /* synthetic */ ExtractionResult receiver$0;
                final /* synthetic */ JetCodeFragment $fragment;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final KotlinEvaluateExpressionCache.ParametersDescriptor invoke() {
                    void var3_3;
                    PsiFile contextElementFile;
                    HashMap<K, V> valuesForLabels = new HashMap<K, V>();
                    PsiElement psiElement2 = this.$fragment.getContext();
                    Object object = contextElementFile = psiElement2 != null ? psiElement2.getContainingFile() : null;
                    if (contextElementFile instanceof JetCodeFragment) {
                        ((JetCodeFragment)contextElementFile).accept(new JetTreeVisitorVoid(valuesForLabels){
                            public static final /* synthetic */ KClass $kotlinClass;
                            final /* synthetic */ HashMap $valuesForLabels;

                            static {
                                $kotlinClass = Reflection.createKotlinClass(getParametersForDebugger.1.class);
                            }

                            public void visitProperty(@NotNull JetProperty property) {
                                Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
                                com.sun.jdi.Value value2 = (com.sun.jdi.Value)property.getUserData(KotlinCodeFragmentFactory.Companion.getLABEL_VARIABLE_VALUE_KEY());
                                if (value2 != null) {
                                    String string = property.getName();
                                    String string2 = string != null ? JetRefactoringUtilKt.quoteIfNeeded(string) : null;
                                    if (string2 == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    this.$valuesForLabels.put(string2, JdiValuesKt.asValue(value2));
                                }
                            }
                            {
                                this.$valuesForLabels = $captured_local_variable$0;
                            }
                        });
                    }
                    KotlinEvaluateExpressionCache.ParametersDescriptor parameters2 = new KotlinEvaluateExpressionCache.ParametersDescriptor();
                    Parameter receiver = this.receiver$0.getConfig().getDescriptor().getReceiverParameter();
                    if (receiver != null) {
                        KotlinEvaluateExpressionCache.ParametersDescriptor.add$default(parameters2, KotlinEvaluationBuilderKt.getTHIS_NAME(), receiver.getParameterType(true), null, 4);
                    }
                    for (Parameter param : this.receiver$0.getConfig().getDescriptor().getParameters()) {
                        String paramName = KotlinPackage.contains$default((String)param.getArgumentText(), (CharSequence)"@", (boolean)false, (int)2) ? KotlinPackage.substringBefore$default((String)param.getArgumentText(), (String)"@", null, (int)2) : (KotlinPackage.startsWith$default((String)param.getArgumentText(), (String)"::", (boolean)false, (int)2) ? KotlinPackage.substring((String)param.getArgumentText(), (int)2) : param.getArgumentText());
                        parameters2.add(paramName, param.getParameterType(true), (Value)valuesForLabels.get(paramName));
                    }
                    return var3_3;
                }
                {
                    this.receiver$0 = extractionResult;
                    this.$fragment = jetCodeFragment;
                    super(0);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final List<Value> getArgumentsForEval4j(EvaluationContextImpl $receiver, KotlinEvaluateExpressionCache.ParametersDescriptor parameters2, Type[] parameterTypes) {
            void destination;
            void $receiver2;
            void $receiver3;
            FrameVisitor frameVisitor = new FrameVisitor($receiver);
            Iterable iterable = KotlinPackage.zip((Iterable)parameters2, (Object[])parameterTypes);
            void var6_6 = $receiver3;
            Collection collection = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver3, (int)10));
            for (Object item : $receiver2) {
                Value value2;
                void it;
                Pair pair2 = (Pair)item;
                void var11_11 = destination;
                if (((KotlinEvaluateExpressionCache.Parameter)it.getFirst()).getValue() != null) {
                    value2 = ((KotlinEvaluateExpressionCache.Parameter)it.getFirst()).getValue();
                    if (value2 == null) {
                        Intrinsics.throwNpe();
                    }
                } else {
                    value2 = frameVisitor.findValue(((KotlinEvaluateExpressionCache.Parameter)it.getFirst()).getCallText(), (Type)it.getSecond(), false, true);
                    if (value2 == null) {
                        Intrinsics.throwNpe();
                    }
                }
                Value value3 = value2;
                var11_11.add(value3);
            }
            return (List)destination;
        }

        private final ClassFileFactory createClassFileFactory(JetCodeFragment codeFragment, JetNamedFunction extractedFunction, EvaluationContextImpl context, KotlinEvaluateExpressionCache.ParametersDescriptor parameters2) {
            return (ClassFileFactory)ApplicationUtilsKt.runReadAction((Function0)new Function0<ClassFileFactory>(codeFragment, extractedFunction, context, parameters2){
                final /* synthetic */ JetCodeFragment $codeFragment;
                final /* synthetic */ JetNamedFunction $extractedFunction;
                final /* synthetic */ EvaluationContextImpl $context;
                final /* synthetic */ KotlinEvaluateExpressionCache.ParametersDescriptor $parameters;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final ClassFileFactory invoke() {
                    Unit unit;
                    void files;
                    void bindingContext2;
                    void moduleDescriptor;
                    JetFile jetFile = KotlinEvaluationBuilderKt.createFileForDebugger(this.$codeFragment, this.$extractedFunction);
                    ExtendedAnalysisResult extendedAnalysisResult = org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator$Companion.access$checkForErrors$6(KotlinEvaluator.Companion, jetFile, true);
                    BindingContext bindingContext3 = extendedAnalysisResult.component1();
                    ModuleDescriptor moduleDescriptor2 = extendedAnalysisResult.component2();
                    List<JetFile> list = extendedAnalysisResult.component3();
                    extendedAnalysisResult = null;
                    GenerationState.GenerateClassFilter generateClassFilter2 = new GenerationState.GenerateClassFilter(jetFile){
                        public static final /* synthetic */ KClass $kotlinClass;
                        final /* synthetic */ JetFile $jetFile;

                        static {
                            $kotlinClass = Reflection.createKotlinClass(createClassFileFactory.generateClassFilter.1.class);
                        }

                        public boolean shouldGeneratePackagePart(@NotNull JetFile file) {
                            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                            return Intrinsics.areEqual((Object)file, (Object)this.$jetFile);
                        }

                        public boolean shouldAnnotateClass(@NotNull JetClassOrObject classOrObject) {
                            Intrinsics.checkParameterIsNotNull((Object)classOrObject, (String)"classOrObject");
                            return true;
                        }

                        public boolean shouldGenerateClass(@NotNull JetClassOrObject classOrObject) {
                            Intrinsics.checkParameterIsNotNull((Object)classOrObject, (String)"classOrObject");
                            return Intrinsics.areEqual((Object)classOrObject.getContainingJetFile(), (Object)this.$jetFile);
                        }

                        public boolean shouldGenerateScript(@NotNull JetScript script) {
                            Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
                            return false;
                        }
                        {
                            this.$jetFile = $captured_local_variable$0;
                        }
                    };
                    Project project = jetFile.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"jetFile.project");
                    ClassBuilderFactory classBuilderFactory = ClassBuilderFactories.BINARIES;
                    Intrinsics.checkExpressionValueIsNotNull((Object)classBuilderFactory, (String)"ClassBuilderFactories.BINARIES");
                    GenerationState state = new GenerationState(project, classBuilderFactory, (ModuleDescriptor)moduleDescriptor, (BindingContext)bindingContext2, (List)files, false, false, generateClassFilter2, false, false, false, null, null, null, null, null, null, null, 261984, null);
                    FrameVisitor frameVisitor = new FrameVisitor(this.$context);
                    JetTypeReference jetTypeReference = this.$extractedFunction.getReceiverTypeReference();
                    if (jetTypeReference != null) {
                        void $receiver;
                        JetTypeReference jetTypeReference2 = jetTypeReference;
                        JetTypeReference it = (JetTypeReference)$receiver;
                        BindingTrace bindingTrace = state.getBindingTrace();
                        JetTypeReference jetTypeReference3 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)jetTypeReference3, (String)"it");
                        org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator$Companion.access$recordAnonymousType$7(KotlinEvaluator.Companion, bindingTrace, jetTypeReference3, KotlinEvaluationBuilderKt.getTHIS_NAME(), frameVisitor);
                        unit = Unit.INSTANCE$;
                    } else {
                        unit = null;
                    }
                    List<JetParameter> valueParameters = this.$extractedFunction.getValueParameters();
                    int paramIndex = 0;
                    for (KotlinEvaluateExpressionCache.Parameter param : this.$parameters) {
                        JetParameter valueParameter;
                        JetTypeReference paramRef;
                        if (KotlinPackage.contains$default((String)param.getCallText(), (CharSequence)KotlinEvaluationBuilderKt.getTHIS_NAME(), (boolean)false, (int)2)) continue;
                        if ((paramRef = (valueParameter = valueParameters.get(paramIndex++)).getTypeReference()) == null) {
                            KotlinEvaluationBuilderKt.getLogger().error("Each parameter for extracted function should have a type reference", new Attachment[]{new Attachment("codeFragment.txt", this.$codeFragment.getText()), new Attachment("extractedFunction.txt", this.$extractedFunction.getText())});
                            org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator$Companion.access$exception$8(KotlinEvaluator.Companion, "An exception occurs during Evaluate Expression Action");
                        }
                        org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator$Companion.access$recordAnonymousType$7(KotlinEvaluator.Companion, state.getBindingTrace(), paramRef, param.getCallText(), frameVisitor);
                    }
                    KotlinCodegenFacade.compileCorrectFiles(state, CompilationErrorHandler.THROW_EXCEPTION);
                    return state.getFactory();
                }
                {
                    this.$codeFragment = jetCodeFragment;
                    this.$extractedFunction = jetNamedFunction;
                    this.$context = evaluationContextImpl;
                    this.$parameters = parametersDescriptor;
                    super(0);
                }
            });
        }

        private final void recordAnonymousType(BindingTrace $receiver, JetTypeReference typeReference, String localVariableName, FrameVisitor visitor2) {
            ClassifierDescriptor declarationDescriptor;
            JetType paramAnonymousType = CodeFragmentUtilKt.getDebugTypeInfo(typeReference);
            if (paramAnonymousType != null && (declarationDescriptor = paramAnonymousType.getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor) {
                Value localVariable = visitor2.findValue(localVariableName, null, false, false);
                if (localVariable == null) {
                    this.exception("Couldn't find local variable this in current frame to get classType for anonymous type " + paramAnonymousType + "}");
                }
                $receiver.record(CodegenBinding.ASM_TYPE, declarationDescriptor, localVariable.getAsmType());
            }
        }

        private final Void exception(String msg) {
            Throwable throwable = EvaluateExceptionUtil.createEvaluateException((String)msg);
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"EvaluateExceptionUtil.createEvaluateException(msg)");
            throw throwable;
        }

        private final Void exception(Throwable e) {
            String message = e.getMessage();
            if (message != null) {
                Throwable throwable = EvaluateExceptionUtil.createEvaluateException((String)message, (Throwable)e);
                Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"EvaluateExceptionUtil.cr\u2026uateException(message, e)");
                throw throwable;
            }
            Throwable throwable = EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"EvaluateExceptionUtil.createEvaluateException(e)");
            throw throwable;
        }

        private final ExtendedAnalysisResult checkForErrors(JetFile $receiver, boolean analyzeInlineFunctions) {
            return (ExtendedAnalysisResult)ApplicationUtilsKt.runReadAction((Function0)new Function0<ExtendedAnalysisResult>($receiver, analyzeInlineFunctions){
                final /* synthetic */ JetFile receiver$0;
                final /* synthetic */ boolean $analyzeInlineFunctions;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final ExtendedAnalysisResult invoke() {
                    ExtendedAnalysisResult extendedAnalysisResult;
                    Object it;
                    Object v4;
                    Object $receiver;
                    BindingContext bindingContext2;
                    AnalysisResult analysisResult;
                    ResolutionFacade resolutionFacade;
                    block7: {
                        try {
                            AnalyzingUtils.checkForSyntacticErrors((PsiElement)this.receiver$0);
                        }
                        catch (IllegalArgumentException e) {
                            Throwable throwable = EvaluateExceptionUtil.createEvaluateException((String)e.getMessage());
                            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"EvaluateExceptionUtil.cr\u2026Exception(e.getMessage())");
                            throw throwable;
                        }
                        Project project = this.receiver$0.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                        resolutionFacade = KotlinCacheService.Companion.getInstance(project).getResolutionFacade(KotlinPackage.listOf((Object[])new JetFile[]{this.receiver$0, KotlinEvaluationBuilderKt.createFlexibleTypesFile((PsiElement)this.receiver$0)}));
                        Collection collection = Collections.singletonList(this.receiver$0);
                        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"Collections.singletonList(this)");
                        analysisResult = resolutionFacade.analyzeFullyAndGetResult(collection);
                        if (analysisResult.isError()) {
                            Throwable throwable = EvaluateExceptionUtil.createEvaluateException((Throwable)analysisResult.getError());
                            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"EvaluateExceptionUtil.cr\u2026ion(analysisResult.error)");
                            throw throwable;
                        }
                        bindingContext2 = analysisResult.getBindingContext();
                        Iterable iterable = bindingContext2.getDiagnostics();
                        Iterator<T> iterator2 = $receiver.iterator();
                        while (iterator2.hasNext()) {
                            T element2 = iterator2.next();
                            Diagnostic it2 = (Diagnostic)element2;
                            if (!Intrinsics.areEqual((Object)((Object)it2.getSeverity()), (Object)((Object)Severity.ERROR))) continue;
                            v4 = element2;
                            break block7;
                        }
                        v4 = null;
                    }
                    Diagnostic diagnostic = v4;
                    if (diagnostic != null) {
                        $receiver = diagnostic;
                        it = $receiver;
                        Throwable throwable = EvaluateExceptionUtil.createEvaluateException((String)DefaultErrorMessages.render((Diagnostic)it));
                        Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"EvaluateExceptionUtil.cr\u2026ErrorMessages.render(it))");
                        throw throwable;
                    }
                    if (this.$analyzeInlineFunctions) {
                        void files;
                        void newBindingContext;
                        Pair<BindingContext, List<JetFile>> pair2 = DebuggerUtils.analyzeInlinedFunctions(resolutionFacade, bindingContext2, this.receiver$0, false);
                        $receiver = (BindingContext)pair2.component1();
                        it = (List)pair2.component2();
                        pair2 = null;
                        void v7 = newBindingContext;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"newBindingContext");
                        ModuleDescriptor moduleDescriptor = analysisResult.getModuleDescriptor();
                        void v9 = files;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"files");
                        extendedAnalysisResult = new ExtendedAnalysisResult((BindingContext)v7, moduleDescriptor, (List<? extends JetFile>)v9);
                    } else {
                        ModuleDescriptor moduleDescriptor = analysisResult.getModuleDescriptor();
                        List<JetFile> list = Collections.singletonList(this.receiver$0);
                        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Collections.singletonList(this)");
                        extendedAnalysisResult = new ExtendedAnalysisResult(bindingContext2, moduleDescriptor, list);
                    }
                    return extendedAnalysisResult;
                }
                {
                    this.receiver$0 = jetFile;
                    this.$analyzeInlineFunctions = bl;
                    super(0);
                }
            });
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ List<Value> access$getArgumentsForEval4j$2(Companion $this, EvaluationContextImpl $receiver, @NotNull KotlinEvaluateExpressionCache.ParametersDescriptor parameters2, @NotNull Type[] parameterTypes) {
            return $this.getArgumentsForEval4j($receiver, parameters2, parameterTypes);
        }

        @NotNull
        public static final /* synthetic */ Value access$boxOrUnboxArgumentIfNeeded$3(Companion $this, @NotNull JDIEval eval, @NotNull Value argumentValue, @NotNull Type parameterType) {
            return $this.boxOrUnboxArgumentIfNeeded(eval, argumentValue, parameterType);
        }

        @NotNull
        public static final /* synthetic */ ExtendedAnalysisResult access$checkForErrors$6(Companion $this, JetFile $receiver, boolean analyzeInlineFunctions) {
            return $this.checkForErrors($receiver, analyzeInlineFunctions);
        }

        public static final /* synthetic */ void access$recordAnonymousType$7(Companion $this, BindingTrace $receiver, @NotNull JetTypeReference typeReference, @NotNull String localVariableName, @NotNull FrameVisitor visitor2) {
            $this.recordAnonymousType($receiver, typeReference, localVariableName, visitor2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @data
        @KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"\u0003\b)1R\t\u001f;f]\u0012,G-\u00118bYf\u001c\u0018n\u001d*fgVdGOC\u0005D_6\u0004\u0018M\\5p]*y1j\u001c;mS:,e/\u00197vCR|'OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\u0011IG-Z1\u000b\u0011\u0011,'-^4hKJT\u0001\"\u001a<bYV\fG/\u001a\u0006\u0004\u0003:L(B\u0002\u001fj]&$hH\u0003\bcS:$\u0017N\\4D_:$X\r\u001f;\u000b\u001d\tKg\u000eZ5oO\u000e{g\u000e^3yi*9!/Z:pYZ,'\u0002E7pIVdW\rR3tGJL\u0007\u000f^8s\u0015Aiu\u000eZ;mK\u0012+7o\u0019:jaR|'OC\u0006eKN\u001c'/\u001b9u_J\u001c(\"\u00024jY\u0016\u001c(\u0002\u0002'jgRTqAS3u\r&dWMC\u0002qg&TAA[1wC*!Q\u000f^5m\u0015E9W\r\u001e\"j]\u0012LgnZ\"p]R,\u0007\u0010\u001e\u0006\tO\u0016$h)\u001b7fg*\u0019r-\u001a;N_\u0012,H.\u001a#fg\u000e\u0014\u0018\u000e\u001d;pe*Q1m\\7q_:,g\u000e^\u0019\u000b\u0015\r|W\u000e]8oK:$(G\u0003\u0006d_6\u0004xN\\3oiNRAaY8qs*\u00014j\u001c;mS:,e/\u00197vCR|'\u000fJ\"p[B\fg.[8oI\u0015CH/\u001a8eK\u0012\fe.\u00197zg&\u001c(+Z:vYRT\u001aA\u0003\u0002\u0011\u0007)!\u0001\u0002\u0001\t\u0005\u0015\u0011A\u0011\u0001E\u0003\u000b\t!\u0011\u0001C\u0002\u0006\u0005\u0011\r\u0001rA\u0003\u0003\t\tAA!B\u0002\u0005\u0006!\tA\u0002A\u0003\u0004\t\rA\t\u0001\u0004\u0001\u0006\u0007\u0011\u001d\u0001\u0002\u0001\u0007\u0001\u000b\u0005A)!B\u0002\u0005\n!%A\u0002A\u0003\u0003\t\u0005Ai!B\u0002\u0005\f!1A\u0002A\u0003\u0003\t\u0005A\u0001\"B\u0002\u0005\u000e!=A\u0002A\u0003\u0004\t\u0013A\u0011\u0002\u0004\u0001\u0006\u0005\u0011\t\u0001BC\u0003\u0004\t!A\u0019\u0002\u0004\u0001\u0006\u0005\u0011-\u0001BB\u0003\u0003\t\u001bAy!B\u0001\t\u0016\u0015\u0011AA\u0003\u0005\f\u000b\t!)\u0002C\u0005\u0006\u0005\u0011\u0015\u0001b\u0004C\u0002\u0019\u0011I2!B\u0001\t\u000ba)Q\u0006\u0005\u0003d\ta-\u0011eA\u0003\u0002\u0011\u0019Ab!V\u0002\t\u000b\r!Y!C\u0001\t\u00135\u0019AqC\u0005\u0002\u0011%iS\u0003B2\u00051#\t\u0003\"B\u0001\t\u0010%!\u0011bA\u0003\u0002\u0011#A\n\u0002g\u0004V\u0007!)1\u0001\"\u0005\n\u0003!YQb\u0001\u0003\r\u0013\u0005A1\"\f\t\u0005G\u0012Ar!I\u0002\u0006\u0003!9\u0001dB+\u0004\u0011\u0015\u0019AaB\u0005\u0002\u0011'i1\u0001\"\u0007\n\u0003!MQf\u0003\u0003D\u0007ai\u0011eA\u0003\u0002\u0011\u0019Ab!U\u0002\u0004\t5I\u0011\u0001C\u0005.\u0017\u0011\u00195\u0001g\u0007\"\u0007\u0015\t\u0001b\u0002\r\b#\u000e\u0019A1D\u0005\u0002\u0011'i\u0003\u0003B\"\u000419\t\u0003\"B\u0001\t\u0010%!\u0011bA\u0003\u0002\u0011#A\n\u0002g\u0004R\u0007\r!a\"C\u0001\t\u00175~CaQ\u0002\u0019\u001eu=A!\u0001E\u0006\u001b\r)\u0011\u0001\u0003\u0004\u0019\rA\u001b\u0001!h\u0004\u0005\u0003!9QbA\u0003\u0002\u0011\u001dAr\u0001UB\u0001;3!\u0011\u0001#\u0005\u000e\u0011\u0015\t\u0001rB\u0005\u0005\u0013\r)\u0011\u0001#\u0005\u0019\u0012a=\u0001kA\u0001\"\u0007\u0015\t\u0001\u0002\u0002\r\u0005#\u000eIAQD\u0005\u0002\u0011/i\u0011\u0001C\u0005\u000e\u0003!MQ\"\u0001\u0005\fkC*y\u0006Br\u00011\u0015iz\u0001\u0002\u0001\t\f5\u0019Q!\u0001\u0005\u00071\u0019\u00016\u0001AO\b\t\u0001Aq!D\u0002\u0006\u0003!9\u0001d\u0002)\u0004\u0002ueA\u0001\u0001E\t\u001b!)\u0011\u0001c\u0004\n\t%\u0019Q!\u0001E\t1#Az\u0001U\u0002\u0002C\r)\u0011\u0001\u0003\u0003\u0019\tE\u001b\u0011\u0002B\u0003\n\u0003\u0011\u0001Q\"\u0001\u0005\n\u001b\u0005A\u0019\"D\u0001\t\u0017\u0001"})
        private static final class ExtendedAnalysisResult {
            public static final /* synthetic */ KClass $kotlinClass;
            @NotNull
            private final BindingContext bindingContext;
            @NotNull
            private final ModuleDescriptor moduleDescriptor;
            @NotNull
            private final List<? extends JetFile> files;

            static {
                $kotlinClass = Reflection.createKotlinClass(ExtendedAnalysisResult.class);
            }

            @NotNull
            public final BindingContext getBindingContext() {
                return this.bindingContext;
            }

            @NotNull
            public final ModuleDescriptor getModuleDescriptor() {
                return this.moduleDescriptor;
            }

            @NotNull
            public final List<JetFile> getFiles() {
                return this.files;
            }

            public ExtendedAnalysisResult(@NotNull BindingContext bindingContext2, @NotNull ModuleDescriptor moduleDescriptor, @NotNull List<? extends JetFile> files) {
                Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
                Intrinsics.checkParameterIsNotNull((Object)moduleDescriptor, (String)"moduleDescriptor");
                Intrinsics.checkParameterIsNotNull(files, (String)"files");
                this.bindingContext = bindingContext2;
                this.moduleDescriptor = moduleDescriptor;
                this.files = files;
            }

            @NotNull
            public final BindingContext component1() {
                return this.bindingContext;
            }

            @NotNull
            public final ModuleDescriptor component2() {
                return this.moduleDescriptor;
            }

            @NotNull
            public final List<JetFile> component3() {
                return this.files;
            }

            @NotNull
            public final ExtendedAnalysisResult copy(@NotNull BindingContext bindingContext2, @NotNull ModuleDescriptor moduleDescriptor, @NotNull List<? extends JetFile> files) {
                Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
                Intrinsics.checkParameterIsNotNull((Object)moduleDescriptor, (String)"moduleDescriptor");
                Intrinsics.checkParameterIsNotNull(files, (String)"files");
                return new ExtendedAnalysisResult(bindingContext2, moduleDescriptor, files);
            }

            @NotNull
            public static /* synthetic */ ExtendedAnalysisResult copy$default(ExtendedAnalysisResult extendedAnalysisResult, BindingContext bindingContext2, ModuleDescriptor moduleDescriptor, List list, int n) {
                if ((n & 1) != 0) {
                    bindingContext2 = extendedAnalysisResult.bindingContext;
                }
                if ((n & 2) != 0) {
                    moduleDescriptor = extendedAnalysisResult.moduleDescriptor;
                }
                if ((n & 4) != 0) {
                    list = extendedAnalysisResult.files;
                }
                return extendedAnalysisResult.copy(bindingContext2, moduleDescriptor, list);
            }

            public String toString() {
                return "ExtendedAnalysisResult(bindingContext=" + this.bindingContext + ", moduleDescriptor=" + this.moduleDescriptor + ", files=" + this.files + ")";
            }

            public int hashCode() {
                BindingContext bindingContext2 = this.bindingContext;
                ModuleDescriptor moduleDescriptor = this.moduleDescriptor;
                List<? extends JetFile> list = this.files;
                return ((bindingContext2 != null ? bindingContext2.hashCode() : 0) * 31 + (moduleDescriptor != null ? moduleDescriptor.hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0);
            }

            public boolean equals(Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof ExtendedAnalysisResult)) break block3;
                        ExtendedAnalysisResult extendedAnalysisResult = (ExtendedAnalysisResult)object;
                        if (!Intrinsics.areEqual((Object)this.bindingContext, (Object)extendedAnalysisResult.bindingContext) || !Intrinsics.areEqual((Object)this.moduleDescriptor, (Object)extendedAnalysisResult.moduleDescriptor) || !Intrinsics.areEqual(this.files, extendedAnalysisResult.files)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

