/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.compilingEvaluator;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkVersionUtil;
import com.intellij.openapi.util.SystemInfo;
import com.sun.jdi.ClassLoaderReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.evaluate.CompilingEvaluatorUtils;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilingEvaluator.ClassBytes;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"%\b)\u0019B*Q'C\t\u0006{6+\u0016)F%\u000ec\u0015iU*F'*!A*[:u\u0015\u0019Yw\u000e\u001e7j]*Q1\t\\1tg\nKH/Z:\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*!\u0011\u000eZ3b\u0015!!WMY;hO\u0016\u0014(\u0002C3wC2,\u0018\r^3\u000b%\r|W\u000e]5mS:<WI^1mk\u0006$xN\u001d\u0006\u0005U\u00064\u0018M\u0003\u0003vi&d'BF4fi2\u000bUJ\u0011#B?N+\u0006+\u0012*D\u0019\u0006\u001b6+R*\u000b)\r{W\u000e]5mS:<WI^1mk\u0006$xN]&u\u00155!WMZ5oK\u000ec\u0017m]:fg*91\r\\1tg\u0016\u001c(BC\"pY2,7\r^5p]*!\u0001+Y5s\u0015\u0019\u0019FO]5oO*I!)\u001f;f\u0003J\u0014\u0018-\u001f\u0006\bG>tG/\u001a=u\u0015E)e/\u00197vCRLwN\\\"p]R,\u0007\u0010\u001e\u0006\u0004G>l'\u0002C5oi\u0016dG.\u001b6\u000b\r\u0015tw-\u001b8f\u0015))g/\u00197vCRLwN\u001c\u0006\baJ|7-Z:t\u00151!UMY;h!J|7-Z:t\u0015-\u0019G.Y:t\u0019>\fG-\u001a:\u000b)\rc\u0017m]:M_\u0006$WM\u001d*fM\u0016\u0014XM\\2f\u0015\r\u0019XO\u001c\u0006\u0004U\u0012L'\u0002B+oSRT1\u0002\\8bI\u000ec\u0017m]:fg*\tRM^1mk\u0006$\u0018n\u001c8D_:$X\r\u001f;\u000b+\u00153\u0018\r\\;bi&|gnQ8oi\u0016DH/S7qYj\u000f!B\u0001\t\u0003\u0015\u0019A\u0001\u0001E\u0001\u0019\u0001)\u0011\u0001\u0003\u0002\u0006\u0005\u0011\t\u0001RA\u0003\u0003\t\u0007A\u0011!\u0002\u0002\u0005\u0005!\u0019QA\u0001C\u0003\u0011\u000f)!\u0001B\u0002\t\t\u0015\u0011Aq\u0001E\u0005\u000b\r!A\u0001c\u0001\r\u0001\u0015\t\u0001\"B\u0003\u0003\t\u0015AY!\u0002\u0002\u0005\f!\u0005Qa\u0001\u0003\u0001\u0011!a\u0001!B\u0002\u0005\u0001!EA\u0002A\u0003\u0004\t\u0001A\u0011\u0002\u0004\u0001\u0006\u0007\u0011\u0001\u00012\u0003\u0007\u0001\u000b\u0005A1\"\u0002\u0002\u0005\u0012!]QA\u0001\u0003\n\u0011\u000f)!\u0001b\u0005\t\u0019\u0015\u0011AA\u0003E\r\u000b\r!)\u0002#\u0006\r\u0001\u0015\u0019AA\u0003E\u000e\u0019\u0001)!\u0001\"\u0005\t\u001f\u0015\u0011A\u0001\u0004E\u0010\u000b\r!I\u0002#\b\r\u0001\u0015\u0019A\u0001\u0001\u0005\u0011\u0019\u0001)!\u0001b\u0003\t\u0011\u0015\u0011AQ\u0003E\u000b\u000b\t!!\u0002c\u0007\u0006\u0005\u0011e\u0001RD\u0003\u0004\t+A\u0019\u0003\u0004\u0001\u0006\u0005\u0011U\u00012EC\u0017\t\u0005$\u0001\u0004A\u0011\t\u000b\u0005A\t!\u0003\u0003\n\u0007\u0015\t\u0001\u0012\u0002M\u00051\u0003)6\u0001C\u0003\u0004\t\u0001I\u0011\u0001\u0003\u0004\u000e\u0007\u00111\u0011\"\u0001\u0005\u00071\u000e5Q!2\u0001\u0005\u0003a9QT\u0006\u0003\u0001\u0011\u001fi!#B\u0001\t\u000e%q\u0011\"D\u0003\u0002\u0011\u001dIA!C\u0002\u0006\u0003!=\u0001tB\u0005\u0005\u0013\r)\u0011\u0001\u0003\u0005\u0019\u0011a9\u0001T\u0002)\u0004\u0001u=A\u0001\u0001\u0005\u000b\u001b\r)\u0011\u0001C\u0006\u0019\u0017A\u001b\t!h\u0004\u0005\u0001!iQbA\u0003\u0002\u0011/A:\u0002U\u0002\u0002;\u001f!\u0001\u0001\u0003\b\u000e\u0007\u0015\t\u0001\"\u0004\r\u000e!\u000e\r\u0011eA\u0003\u0002\u00117AZ\"U\u0002\f\t\u001dI\u0011\u0001\u0002\u0001\u000e\u0003!qQ\"\u0001E\u000f\u001b\u0005Aq\"D\u0001\t a\u001bi!\u0002\u0019\u0005\u0007a\u0005Rt\u0002\u0003\u0001\u0011Ei1!B\u0001\t!a\u0001\u0002k\u0001\u0001\u001e.\u0011\u0001\u0001rB\u0007\u0013\u000b\u0005Ai!\u0003\b\n\u001b\u0015\t\u0001bB\u0005\u0005\u0013\r)\u0011\u0001c\u0004\u0019\u0010%!\u0011bA\u0003\u0002\u0011!A\u0002\u0002G\u0004\u0019\u000eA\u001b\t!I\u0002\u0006\u0003!m\u00014D)\u0004\u000f\u0011\u0005\u0012\"\u0001\u0003\u0001\u001b\u0005A\t#D\u0001\t\u001da\u001bi\u0001"})
public final class CompilingEvaluatorKt {
    @NotNull
    static final List<? extends ClassBytes> LAMBDA_SUPERCLASSES = KotlinPackage.listOf((Object[])new ClassBytes[]{new ClassBytes("kotlin.jvm.internal.FunctionImpl"), new ClassBytes("kotlin.jvm.internal.Lambda")});

    public static final void loadClasses(@NotNull EvaluationContextImpl evaluationContext, @NotNull Collection<? extends Pair<? extends String, ? extends byte[]>> classes2) {
        ClassLoaderReference classLoader;
        Intrinsics.checkParameterIsNotNull((Object)evaluationContext, (String)"evaluationContext");
        Intrinsics.checkParameterIsNotNull(classes2, (String)"classes");
        DebugProcessImpl process2 = evaluationContext.getDebugProcess();
        try {
            ClassLoaderReference classLoaderReference = CompilingEvaluatorUtils.getClassLoader((EvaluationContext)evaluationContext, (DebugProcess)process2);
            Intrinsics.checkExpressionValueIsNotNull((Object)classLoaderReference, (String)"CompilingEvaluatorUtils.\u2026aluationContext, process)");
            classLoader = classLoaderReference;
        }
        catch (Exception e) {
            throw (Throwable)new EvaluateException("Error creating evaluation class loader: " + e, (Throwable)e);
        }
        String version = process2.getVirtualMachineProxy().version();
        JavaSdkVersion sdkVersion = JdkVersionUtil.getVersion((String)version);
        if (!SystemInfo.isJavaVersionAtLeast((String)sdkVersion.getDescription())) {
            throw (Throwable)new EvaluateException("Unable to compile for target level " + sdkVersion.getDescription() + ". Need to run IDEA on java version at least " + sdkVersion.getDescription() + ", currently running on " + SystemInfo.JAVA_RUNTIME_VERSION);
        }
        try {
            EvaluationContext evaluationContext2 = (EvaluationContext)evaluationContext;
            DebugProcess debugProcess = (DebugProcess)process2;
            Intrinsics.checkExpressionValueIsNotNull((Object)debugProcess, (String)"process");
            CompilingEvaluatorKt.defineClasses(classes2, evaluationContext2, debugProcess, classLoader);
        }
        catch (Exception e) {
            throw (Throwable)new EvaluateException("Error during classes definition " + e, (Throwable)e);
        }
        evaluationContext.setClassLoader(classLoader);
    }

    /*
     * WARNING - void declaration
     */
    public static final void defineClasses(@NotNull Collection<? extends Pair<? extends String, ? extends byte[]>> classes2, @NotNull EvaluationContext context, @NotNull DebugProcess process2, @NotNull ClassLoaderReference classLoader) {
        void destination;
        void $receiver;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull(classes2, (String)"classes");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)process2, (String)"process");
        Intrinsics.checkParameterIsNotNull((Object)classLoader, (String)"classLoader");
        Iterable iterable2 = LAMBDA_SUPERCLASSES;
        Iterator iterator2 = $receiver2;
        Collection collection = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
        for (Object item : $receiver) {
            void it;
            ClassBytes classBytes = (ClassBytes)item;
            void var11_10 = destination;
            Pair pair2 = KotlinPackage.to((Object)it.getName(), (Object)it.getBytes());
            var11_10.add(pair2);
        }
        List lambdaSuperclasses = (List)destination;
        for (Iterable iterable2 : KotlinPackage.plus((Collection)lambdaSuperclasses, (Iterable)classes2)) {
            String className = (String)iterable2.component1();
            byte[] bytes2 = (byte[])iterable2.component2();
            CompilingEvaluatorUtils.defineClass(className, bytes2, context, process2, classLoader);
        }
    }

    @NotNull
    public static final List<ClassBytes> getLAMBDA_SUPERCLASSES() {
        return LAMBDA_SUPERCLASSES;
    }
}

