/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ClassFileViewProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.decompiler.HasCompiledKotlinInJar;
import org.jetbrains.kotlin.idea.decompiler.KotlinJavaScriptMetaFileType;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.DirectoryBasedClassFinder;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.kotlin.KotlinBinaryClassCache;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.deserialization.BinaryVersion;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"\u000b\b)9b-\u001b8e\u001bVdG/\u001b4jY\u0016\u001cE.Y:t!\u0006\u0014Ho\u001d\u0006\u0005M&dWMC\u0006WSJ$X/\u00197GS2,'bA2p[*A\u0011N\u001c;fY2L'NC\u0004pa\u0016t\u0017\r]5\u000b\u0007Y47O\u0003\bnk2$\u0018NZ5mK\u000ec\u0017m]:\u000b)-{G\u000f\\5o\u0015Zl')\u001b8bef\u001cE.Y:t\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'\u0002\u00027pC\u0012TA\u0001T5ti*!!.\u0019<b\u0015\u0011)H/\u001b7\u000b#\u0011+7m\\7qS2,G-\u0016;jYN\\EO\u0003\u000fjg.{G\u000f\\5o\u0013:$XM\u001d8bY\u000e{W\u000e]5mK\u00124\u0015\u000e\\3\u000b\u000f\t{w\u000e\\3b]*1\u0013n]&pi2LgNS1wCN\u001b'/\u001b9u\u0013:$XM\u001d8bY\u000e{W\u000e]5mK\u00124\u0015\u000e\\3\u000b%%\u001c8j\u001c;mS:T5/T3uC\u001aKG.\u001a\u0006\u0018SN\\u\u000e\u001e7j]*3XnQ8na&dW\r\u001a$jY\u0016T\u0001%[:L_Rd\u0017N\\,ji\"\u001cu.\u001c9bi&\u0014G.Z!cSZ+'o]5p]*i\"/Z1e\u001bVdG/\u001b4jY\u0016\u001cE.Y:t!\u0006\u0014H\u000fS3bI\u0016\u00148OC\tL_Rd\u0017N\\\"mCN\u001c\b*Z1eKJTa\u0001[3bI\u0016\u0014\b1\u0001\u0006\u0003!\rQA\u0001\u0003\u0001\u0011\t)!\u0001\"\u0001\t\u0006\u0015\u0011A!\u0001\u0005\u0004\u000b\r!\u0019\u0001C\u0001\r\u0001\u0015\t\u0001\u0012B\u0003\u0003\t\u000bAQ!\u0002\u0002\u0005\u0007!-QA\u0001C\u0004\u0011\u0019)!\u0001\u0002\u0003\t\f\u0015\u0019A\u0011\u0002\u0005\u0005\u0019\u0001)\u0011\u0001c\u0003\u0006\u0007\u0011-\u0001R\u0002\u0007\u0001\u000b\u0005Aq!\u0002\u0002\u0005\u000e!=QA\u0001\u0003\b\u0011\u001b)!\u0001b\u0001\t\u0003\u0015\u0011A\u0011\u0002\u0005\u0005\u000b\r!Y\u0001C\u0005\r\u0001\u0015\u0011A\u0011\u0002E\r\u000b\r!\u0019\u0002\u0003\u0007\r\u0001\u00151Ca\u0001\r\u0001;\u001f!\u0001\u0001#\u0001\u000e\u0007\u0015\t\u0001B\u0001\r\u0003!\u000e\u0001Qt\u0002\u0003\u0001\u0011\u000fi1!B\u0001\t\u000ba)\u0001k!\u0001\"\u0011\u0015\t\u0001BB\u0005\u0005\u0013\r)\u0011\u0001C\u0003\u0019\u000ba1\u0011kA\u0004\u0005\u0001%\t\u0001rB\u0007\u0002\u0011!i\u0011\u0001#\u0005Y\u0007!)i\u0003B\u0002\u0019\u0012u=A\u0001\u0001E\u0001\u001b\r)\u0011\u0001\u0003\u0002\u0019\u0005A\u001b\u0001!I\u0002\u0006\u0003!I\u0001$C)\u0004\u000b\u0011E\u0011\"\u0001C\u0001\u001b\u0005A\u0001\u0002W\u0002\t\u000b[!1\u0001g\u0005\u001e\u0010\u0011\u0001\u0001\u0012A\u0007\u0004\u000b\u0005A!\u0001\u0007\u0002Q\u0007\u0001\t3!B\u0001\t\u0013aI\u0011kA\u0003\u0005\u0014%\tA\u0011A\u0007\u0002\u0011!A6\u0001CC\u0017\t\rA\"\"h\u0004\u0005\u0001!\u0005QbA\u0003\u0002\u0011\tA\"\u0001U\u0002\u0001C\r)\u0011\u0001C\u0005\u0019\u0013E\u001bQ\u0001\u0002\u0006\n\u0003\u0011\u0005Q\"\u0001\u0005\t1\u000eAQQ\u0006\u0003\u00041+iz\u0001\u0002\u0001\t\u00025\u0019Q!\u0001\u0005\u00031\t\u00016\u0001A\u0011\u0004\u000b\u0005A\u0011\u0002G\u0005R\u0007\u0015!)\"C\u0001\u0005\u00025\t\u0001\u0002\u0003-\u0004\u0011\u00155Ba\u0001\r\f;\u001f!\u0001\u0001#\u0001\u000e\u0007\u0015\t\u0001B\u0001\r\u0003!\u000e\u0001\u0011eA\u0003\u0002\u0011%A\u0012\"U\u0002\u0006\t-I\u0011\u0001\"\u0001\u000e\u0003!A\u0001l\u0001\u0005\u0006M\u0011\u0019\u0001tCO\b\t\u0001A\t!D\u0002\u0006\u0003!\u0011\u0001D\u0001)\u0004\u0001u=A\u0001\u0001E\u0004\u001b\r)\u0011\u0001C\u0003\u0019\u000bA\u001b\t!\t\u0005\u0006\u0003!1\u0011\u0002B\u0005\u0004\u000b\u0005A!\u0002\u0007\u0006\u0019\rE\u001bq\u0001b\u0006\n\u0003!=Q\"\u0001\u0005\t\u001b\u0005A\t\u0002W\u0002\t"})
public final class DecompiledUtilsKt {
    public static final boolean isKotlinJvmCompiledFile(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        String string = file.getExtension();
        JavaClassFileType javaClassFileType = JavaClassFileType.INSTANCE;
        if (javaClassFileType == null) {
            Intrinsics.throwNpe();
        }
        if (Intrinsics.areEqual((Object)string, (Object)javaClassFileType.getDefaultExtension()) ^ true) {
            return false;
        }
        if (HasCompiledKotlinInJar.INSTANCE$.isInNoKotlinJar(file)) {
            return false;
        }
        KotlinJvmBinaryClass kotlinJvmBinaryClass = KotlinBinaryClassCache.getKotlinBinaryClass(file);
        KotlinClassHeader header = kotlinJvmBinaryClass != null ? kotlinJvmBinaryClass.getClassHeader() : null;
        return header != null && Intrinsics.areEqual((Object)((Object)header.getSyntheticClassKind()), (Object)((Object)JvmAnnotationNames.KotlinSyntheticClass.Kind.TRAIT_IMPL)) ^ true && Intrinsics.areEqual((Object)((Object)header.getSyntheticClassKind()), (Object)((Object)JvmAnnotationNames.KotlinSyntheticClass.Kind.LOCAL_TRAIT_IMPL)) ^ true;
    }

    public static final boolean isKotlinJsMetaFile(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)file.getFileType(), (Object)KotlinJavaScriptMetaFileType.INSTANCE$);
    }

    public static final boolean isKotlinWithCompatibleAbiVersion(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (!DecompiledUtilsKt.isKotlinJvmCompiledFile(file)) {
            return false;
        }
        KotlinJvmBinaryClass kotlinJvmBinaryClass = KotlinBinaryClassCache.getKotlinBinaryClass(file);
        KotlinClassHeader header = kotlinJvmBinaryClass != null ? kotlinJvmBinaryClass.getClassHeader() : null;
        return header != null && header.getIsCompatibleAbiVersion();
    }

    public static final boolean isKotlinInternalCompiledFile(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (!DecompiledUtilsKt.isKotlinJvmCompiledFile(file)) {
            return false;
        }
        if (ClassFileViewProvider.isInnerClass((VirtualFile)file)) {
            return true;
        }
        Object object = KotlinBinaryClassCache.getKotlinBinaryClass(file);
        if (object == null || (object = object.getClassHeader()) == null) {
            return false;
        }
        Object header = object;
        if (Intrinsics.areEqual((Object)((Object)((KotlinClassHeader)header).getSyntheticClassKind()), (Object)((Object)JvmAnnotationNames.KotlinSyntheticClass.Kind.PACKAGE_PART))) {
            BinaryVersion version = ((KotlinClassHeader)header).getVersion();
            return version.getMajor() < 0 || version.getMajor() == 0 && version.getMinor() < 24;
        }
        return Intrinsics.areEqual((Object)((Object)((KotlinClassHeader)header).getKind()), (Object)((Object)KotlinClassHeader.Kind.SYNTHETIC_CLASS)) || Intrinsics.areEqual((Object)((Object)((KotlinClassHeader)header).getKind()), (Object)((Object)KotlinClassHeader.Kind.CLASS)) && ((KotlinClassHeader)header).getClassKind() != null && Intrinsics.areEqual((Object)((Object)((KotlinClassHeader)header).getClassKind()), (Object)((Object)JvmAnnotationNames.KotlinClass.Kind.CLASS)) ^ true || Intrinsics.areEqual((Object)((Object)((KotlinClassHeader)header).getKind()), (Object)((Object)KotlinClassHeader.Kind.MULTIFILE_CLASS_PART));
    }

    public static final boolean isKotlinJavaScriptInternalCompiledFile(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return DecompiledUtilsKt.isKotlinJsMetaFile(file) && KotlinPackage.contains$default((String)file.getNameWithoutExtension(), (char)'.', (boolean)false, (int)2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KotlinJvmBinaryClass> findMultifileClassParts(@NotNull VirtualFile file, @NotNull KotlinJvmBinaryClass multifileClass) {
        void destination;
        void $receiver;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)multifileClass, (String)"multifileClass");
        FqName packageFqName = multifileClass.getClassId().getPackageFqName();
        VirtualFile virtualFile = file.getParent();
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        FqName fqName2 = packageFqName;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"packageFqName");
        DirectoryBasedClassFinder partsFinder = new DirectoryBasedClassFinder(virtualFile, fqName2);
        String[] stringArray = multifileClass.getClassHeader().getFilePartClassNames();
        if (stringArray == null) {
            return KotlinPackage.emptyList();
        }
        String[] partNames = stringArray;
        Object[] objectArray = partNames;
        void var6_6 = $receiver2;
        Collection collection = new ArrayList(((void)$receiver2).length);
        for (int i = 0; i < ((void)$receiver).length; ++i) {
            void it;
            void item = $receiver[i];
            String string = (String)item;
            void var11_11 = destination;
            KotlinJvmBinaryClass kotlinJvmBinaryClass = partsFinder.findKotlinClass(new ClassId(packageFqName, Name.identifier((String)it)));
            var11_11.add(kotlinJvmBinaryClass);
        }
        return KotlinPackage.filterNotNull((Iterable)((List)destination));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KotlinClassHeader> readMultifileClassPartHeaders(@NotNull VirtualFile file, @NotNull KotlinJvmBinaryClass multifileClass) {
        void destination;
        void $receiver;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)multifileClass, (String)"multifileClass");
        Iterable $receiver2 = DecompiledUtilsKt.findMultifileClassParts(file, multifileClass);
        Iterable iterable = $receiver2;
        Collection collection = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
        for (Object item : $receiver) {
            void it;
            KotlinJvmBinaryClass kotlinJvmBinaryClass = (KotlinJvmBinaryClass)item;
            void var8_8 = destination;
            KotlinClassHeader kotlinClassHeader = it.getClassHeader();
            var8_8.add(kotlinClassHeader);
        }
        return (List)destination;
    }
}

