/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.navigation;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StringStubIndexExtension;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.binding.PsiCodegenPredictor;
import org.jetbrains.kotlin.context.ContextPackage;
import org.jetbrains.kotlin.context.MutableModuleContext;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorsPackage;
import org.jetbrains.kotlin.fileClasses.NoResolveFileClassesProvider;
import org.jetbrains.kotlin.frontend.di.DiPackage;
import org.jetbrains.kotlin.idea.decompiler.navigation.MemberMatching;
import org.jetbrains.kotlin.idea.stubindex.JetFullClassNameIndex;
import org.jetbrains.kotlin.idea.stubindex.JetSourceFilterScope;
import org.jetbrains.kotlin.idea.stubindex.JetTopLevelFunctionFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.JetTopLevelPropertyFqnNameIndex;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.JavaToKotlinClassMap;
import org.jetbrains.kotlin.platform.PlatformToKotlinClassMap;
import org.jetbrains.kotlin.psi.JetCallableDeclaration;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassBody;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetEnumEntry;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetImportDirective;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetPrimaryConstructor;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetSecondaryConstructor;
import org.jetbrains.kotlin.psi.JetTypeParameterListOwner;
import org.jetbrains.kotlin.psi.JetVisitor;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.TargetPlatform;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.jvm.TopDownAnalyzerFacadeForJVM;
import org.jetbrains.kotlin.resolve.lazy.KotlinCodeAnalyzer;
import org.jetbrains.kotlin.resolve.lazy.ResolveSession;
import org.jetbrains.kotlin.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;

public class JetSourceNavigationHelper {
    private static boolean forceResolve = false;

    private JetSourceNavigationHelper() {
    }

    @NotNull
    private static GlobalSearchScope createLibraryOrSourcesScope(@NotNull JetNamedDeclaration declaration, @NotNull NavigationKind navigationKind) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "createLibraryOrSourcesScope"));
        }
        if (navigationKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigationKind", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "createLibraryOrSourcesScope"));
        }
        JetFile containingFile = declaration.getContainingJetFile();
        VirtualFile libraryFile = containingFile.getVirtualFile();
        if (libraryFile == null) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "createLibraryOrSourcesScope"));
            }
            return globalSearchScope;
        }
        boolean includeLibrarySources = navigationKind == NavigationKind.CLASS_FILES_TO_SOURCES;
        if (ProjectRootsUtil.isInContent(declaration, false, includeLibrarySources, !includeLibrarySources)) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "createLibraryOrSourcesScope"));
            }
            return globalSearchScope;
        }
        Project project = declaration.getProject();
        GlobalSearchScope globalSearchScope = includeLibrarySources ? JetSourceFilterScope.kotlinLibrarySources(GlobalSearchScope.allScope((Project)project), project) : JetSourceFilterScope.kotlinLibraryClassFiles(GlobalSearchScope.allScope((Project)project), project);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "createLibraryOrSourcesScope"));
        }
        return globalSearchScope;
    }

    private static List<JetFile> getContainingFiles(@NotNull Iterable<JetNamedDeclaration> declarations2) {
        if (declarations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "getContainingFiles"));
        }
        HashSet result2 = Sets.newHashSet();
        for (JetNamedDeclaration declaration : declarations2) {
            PsiFile containingFile = declaration.getContainingFile();
            if (!(containingFile instanceof JetFile)) continue;
            result2.add((JetFile)containingFile);
        }
        return Lists.newArrayList((Iterable)result2);
    }

    private static boolean haveRenamesInImports(@NotNull List<JetFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "haveRenamesInImports"));
        }
        for (JetFile file : files) {
            for (JetImportDirective importDirective : file.getImportDirectives()) {
                if (importDirective.getAliasName() == null) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static JetNamedDeclaration findSpecialProperty(@NotNull Name memberName, @NotNull JetClass containingClass) {
        if (memberName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberName", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "findSpecialProperty"));
        }
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "findSpecialProperty"));
        }
        List<JetParameter> constructorParameters = containingClass.getPrimaryConstructorParameters();
        for (JetParameter constructorParameter : constructorParameters) {
            if (!memberName.equals(constructorParameter.getNameAsName()) || !constructorParameter.hasValOrVar()) continue;
            return constructorParameter;
        }
        if (containingClass.hasModifier(JetTokens.ENUM_KEYWORD)) {
            for (JetEnumEntry enumEntry : ContainerUtil.findAll(containingClass.getDeclarations(), JetEnumEntry.class)) {
                if (!memberName.equals(enumEntry.getNameAsName())) continue;
                return enumEntry;
            }
        }
        return null;
    }

    @Nullable
    private static JetNamedDeclaration convertPropertyOrFunction(@NotNull JetNamedDeclaration declaration, @NotNull NavigationKind navigationKind) {
        Collection<JetNamedDeclaration> candidates;
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "convertPropertyOrFunction"));
        }
        if (navigationKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigationKind", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "convertPropertyOrFunction"));
        }
        if (declaration instanceof JetPrimaryConstructor) {
            JetClassOrObject sourceClassOrObject = JetSourceNavigationHelper.convertNamedClassOrObject(((JetPrimaryConstructor)declaration).getContainingClassOrObject(), navigationKind);
            JetPrimaryConstructor primaryConstructor2 = sourceClassOrObject != null ? sourceClassOrObject.getPrimaryConstructor() : null;
            return primaryConstructor2 != null ? primaryConstructor2 : sourceClassOrObject;
        }
        String memberNameAsString = declaration.getName();
        assert (memberNameAsString != null);
        Name memberName = Name.identifier(memberNameAsString);
        PsiElement decompiledContainer = declaration.getParent();
        if (decompiledContainer instanceof JetFile) {
            candidates = JetSourceNavigationHelper.getInitialTopLevelCandidates(declaration, navigationKind);
        } else if (decompiledContainer instanceof JetClassBody) {
            JetClassOrObject decompiledClassOrObject = (JetClassOrObject)decompiledContainer.getParent();
            JetClassOrObject sourceClassOrObject = JetSourceNavigationHelper.convertNamedClassOrObject(decompiledClassOrObject, navigationKind);
            Collection<Object> collection = candidates = sourceClassOrObject == null ? Collections.emptyList() : JetSourceNavigationHelper.getInitialMemberCandidates(sourceClassOrObject, memberName, declaration.getClass());
            if (candidates.isEmpty() && declaration instanceof JetProperty && sourceClassOrObject instanceof JetClass) {
                return JetSourceNavigationHelper.findSpecialProperty(memberName, (JetClass)sourceClassOrObject);
            }
        } else {
            throw new IllegalStateException("Unexpected container of " + (navigationKind == NavigationKind.CLASS_FILES_TO_SOURCES ? "decompiled" : "source") + " declaration: " + decompiledContainer.getClass().getSimpleName());
        }
        if (candidates.isEmpty()) {
            return null;
        }
        if (!forceResolve) {
            if ((candidates = JetSourceNavigationHelper.filterByReceiverPresenceAndParametersCount(declaration, candidates)).size() <= 1) {
                return candidates.isEmpty() ? null : candidates.iterator().next();
            }
            if (!JetSourceNavigationHelper.haveRenamesInImports(JetSourceNavigationHelper.getContainingFiles(candidates)) && (candidates = JetSourceNavigationHelper.filterByReceiverAndParameterTypes(declaration, candidates)).size() <= 1) {
                return candidates.isEmpty() ? null : candidates.iterator().next();
            }
        }
        KotlinCodeAnalyzer analyzer = JetSourceNavigationHelper.createAnalyzer(candidates, declaration.getProject());
        for (JetNamedDeclaration candidate : candidates) {
            CallableDescriptor candidateDescriptor = (CallableDescriptor)analyzer.resolveToDescriptor(candidate);
            if (!MemberMatching.receiversMatch(declaration, candidateDescriptor) || !MemberMatching.valueParametersTypesMatch(declaration, candidateDescriptor) || !MemberMatching.typeParametersMatch((JetTypeParameterListOwner)declaration, candidateDescriptor.getTypeParameters())) continue;
            return candidate;
        }
        return null;
    }

    @NotNull
    private static KotlinCodeAnalyzer createAnalyzer(@NotNull Collection<JetNamedDeclaration> candidates, @NotNull Project project) {
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "createAnalyzer"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "createAnalyzer"));
        }
        MutableModuleContext newModuleContext = ContextPackage.ContextForNewModule(project, Name.special("<library module>"), DescriptorsPackage.ModuleParameters(TopDownAnalyzerFacadeForJVM.DEFAULT_IMPORTS, PlatformToKotlinClassMap.EMPTY));
        newModuleContext.setDependencies(newModuleContext.getModule(), KotlinBuiltIns.getInstance().getBuiltInsModule());
        FileBasedDeclarationProviderFactory providerFactory = new FileBasedDeclarationProviderFactory(newModuleContext.getStorageManager(), JetSourceNavigationHelper.getContainingFiles(candidates));
        ResolveSession resolveSession = DiPackage.createLazyResolveSession(newModuleContext, providerFactory, new BindingTraceContext(), TargetPlatform.Default.INSTANCE$);
        newModuleContext.initializeModuleContents(resolveSession.getPackageFragmentProvider());
        ResolveSession resolveSession2 = resolveSession;
        if (resolveSession2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "createAnalyzer"));
        }
        return resolveSession2;
    }

    @Nullable
    private static JetClassOrObject convertNamedClassOrObject(@NotNull JetClassOrObject classOrObject, @NotNull NavigationKind navigationKind) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "convertNamedClassOrObject"));
        }
        if (navigationKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigationKind", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "convertNamedClassOrObject"));
        }
        FqName classFqName = classOrObject.getFqName();
        assert (classFqName != null);
        GlobalSearchScope librarySourcesScope = JetSourceNavigationHelper.createLibraryOrSourcesScope(classOrObject, navigationKind);
        if (librarySourcesScope == GlobalSearchScope.EMPTY_SCOPE) {
            return null;
        }
        Collection<JetClassOrObject> classes2 = JetFullClassNameIndex.getInstance().get(classFqName.asString(), classOrObject.getProject(), librarySourcesScope);
        if (classes2.isEmpty()) {
            return null;
        }
        return classes2.iterator().next();
    }

    @NotNull
    private static Collection<JetNamedDeclaration> getInitialTopLevelCandidates(@NotNull JetNamedDeclaration declaration, @NotNull NavigationKind navigationKind) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "getInitialTopLevelCandidates"));
        }
        if (navigationKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigationKind", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "getInitialTopLevelCandidates"));
        }
        FqName memberFqName = declaration.getFqName();
        assert (memberFqName != null);
        GlobalSearchScope librarySourcesScope = JetSourceNavigationHelper.createLibraryOrSourcesScope(declaration, navigationKind);
        if (librarySourcesScope == GlobalSearchScope.EMPTY_SCOPE) {
            List<JetNamedDeclaration> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "getInitialTopLevelCandidates"));
            }
            return list;
        }
        StringStubIndexExtension<? extends JetNamedDeclaration> index2 = JetSourceNavigationHelper.getIndexForTopLevelPropertyOrFunction(declaration);
        Collection collection = index2.get((Object)memberFqName.asString(), declaration.getProject(), librarySourcesScope);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "getInitialTopLevelCandidates"));
        }
        return collection;
    }

    private static StringStubIndexExtension<? extends JetNamedDeclaration> getIndexForTopLevelPropertyOrFunction(@NotNull JetNamedDeclaration decompiledDeclaration) {
        if (decompiledDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decompiledDeclaration", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "getIndexForTopLevelPropertyOrFunction"));
        }
        if (decompiledDeclaration instanceof JetNamedFunction) {
            return JetTopLevelFunctionFqnNameIndex.getInstance();
        }
        if (decompiledDeclaration instanceof JetProperty) {
            return JetTopLevelPropertyFqnNameIndex.getInstance();
        }
        throw new IllegalArgumentException("Neither function nor declaration: " + decompiledDeclaration.getClass().getName());
    }

    @NotNull
    private static List<JetNamedDeclaration> getInitialMemberCandidates(@NotNull JetClassOrObject sourceClassOrObject, final @NotNull Name name2, @NotNull Class<JetNamedDeclaration> declarationClass) {
        if (sourceClassOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceClassOrObject", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "getInitialMemberCandidates"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "getInitialMemberCandidates"));
        }
        if (declarationClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationClass", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "getInitialMemberCandidates"));
        }
        List allByClass = ContainerUtil.findAll(sourceClassOrObject.getDeclarations(), declarationClass);
        List list = ContainerUtil.filter((Collection)allByClass, (Condition)new Condition<JetNamedDeclaration>(){

            public boolean value(JetNamedDeclaration declaration) {
                return name2.equals(declaration.getNameAsSafeName());
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "getInitialMemberCandidates"));
        }
        return list;
    }

    @NotNull
    private static List<JetNamedDeclaration> filterByReceiverPresenceAndParametersCount(final @NotNull JetNamedDeclaration decompiledDeclaration, @NotNull Collection<JetNamedDeclaration> candidates) {
        if (decompiledDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decompiledDeclaration", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "filterByReceiverPresenceAndParametersCount"));
        }
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "filterByReceiverPresenceAndParametersCount"));
        }
        List list = ContainerUtil.filter(candidates, (Condition)new Condition<JetNamedDeclaration>(){

            public boolean value(JetNamedDeclaration candidate) {
                return MemberMatching.sameReceiverPresenceAndParametersCount(candidate, decompiledDeclaration);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "filterByReceiverPresenceAndParametersCount"));
        }
        return list;
    }

    @NotNull
    private static List<JetNamedDeclaration> filterByReceiverAndParameterTypes(final @NotNull JetNamedDeclaration decompiledDeclaration, @NotNull Collection<JetNamedDeclaration> candidates) {
        if (decompiledDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decompiledDeclaration", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "filterByReceiverAndParameterTypes"));
        }
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "filterByReceiverAndParameterTypes"));
        }
        List list = ContainerUtil.filter(candidates, (Condition)new Condition<JetNamedDeclaration>(){

            public boolean value(JetNamedDeclaration candidate) {
                return MemberMatching.receiverAndParametersShortTypesMatch(candidate, decompiledDeclaration);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "filterByReceiverAndParameterTypes"));
        }
        return list;
    }

    public static void setForceResolve(boolean forceResolve) {
        JetSourceNavigationHelper.forceResolve = forceResolve;
    }

    @Nullable
    public static PsiClass getOriginalPsiClassOrCreateLightClass(@NotNull JetClassOrObject classOrObject) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "getOriginalPsiClassOrCreateLightClass"));
        }
        if (LightClassUtil.INSTANCE$.belongsToKotlinBuiltIns(classOrObject.getContainingJetFile())) {
            Name className = classOrObject.getNameAsName();
            assert (className != null) : "Class from BuiltIns should have a name";
            ClassDescriptor classDescriptor = KotlinBuiltIns.getInstance().getBuiltInClassByName(className);
            ClassId javaClassId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(DescriptorUtils.getFqName(classDescriptor));
            if (javaClassId != null) {
                return JavaPsiFacade.getInstance((Project)classOrObject.getProject()).findClass(javaClassId.asSingleFqName().asString(), GlobalSearchScope.allScope((Project)classOrObject.getProject()));
            }
        }
        return LightClassUtil.INSTANCE$.getPsiClass(classOrObject);
    }

    @Nullable
    public static PsiClass getOriginalClass(@NotNull JetClassOrObject classOrObject) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "getOriginalClass"));
        }
        String internalName = PsiCodegenPredictor.getPredefinedJvmInternalName(classOrObject, NoResolveFileClassesProvider.INSTANCE$);
        if (internalName == null) {
            return null;
        }
        String fqName2 = JvmClassName.byInternalName(internalName).getFqNameForClassNameWithoutDollars().asString();
        JetFile file = classOrObject.getContainingJetFile();
        VirtualFile vFile = file.getVirtualFile();
        Project project = file.getProject();
        final ProjectFileIndex idx = ProjectRootManager.getInstance((Project)project).getFileIndex();
        if (vFile == null || !idx.isInLibrarySource(vFile)) {
            return null;
        }
        THashSet orderEntries = new THashSet((Collection)idx.getOrderEntriesForFile(vFile));
        return JavaPsiFacade.getInstance((Project)project).findClass(fqName2, new GlobalSearchScope(project, (Set)orderEntries){
            final /* synthetic */ Set val$orderEntries;
            {
                this.val$orderEntries = set;
                super(x0);
            }

            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                if (file1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper$4", "compare"));
                }
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper$4", "compare"));
                }
                return 0;
            }

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper$4", "contains"));
                }
                List entries = idx.getOrderEntriesForFile(file);
                for (OrderEntry entry : entries) {
                    if (!this.val$orderEntries.contains(entry)) continue;
                    return true;
                }
                return false;
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper$4", "isSearchInModuleContent"));
                }
                return false;
            }

            public boolean isSearchInLibraries() {
                return true;
            }
        });
    }

    @NotNull
    public static JetDeclaration getNavigationElement(@NotNull JetDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "getNavigationElement"));
        }
        JetDeclaration jetDeclaration = JetSourceNavigationHelper.navigateToDeclaration(declaration, NavigationKind.CLASS_FILES_TO_SOURCES);
        if (jetDeclaration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "getNavigationElement"));
        }
        return jetDeclaration;
    }

    @NotNull
    public static JetDeclaration getOriginalElement(@NotNull JetDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "getOriginalElement"));
        }
        JetDeclaration jetDeclaration = JetSourceNavigationHelper.navigateToDeclaration(declaration, NavigationKind.SOURCES_TO_CLASS_FILES);
        if (jetDeclaration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "getOriginalElement"));
        }
        return jetDeclaration;
    }

    @NotNull
    public static JetDeclaration navigateToDeclaration(@NotNull JetDeclaration from, @NotNull NavigationKind navigationKind) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "navigateToDeclaration"));
        }
        if (navigationKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigationKind", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "navigateToDeclaration"));
        }
        if (DumbService.isDumb((Project)from.getProject())) {
            JetDeclaration jetDeclaration = from;
            if (jetDeclaration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "navigateToDeclaration"));
            }
            return jetDeclaration;
        }
        switch (navigationKind) {
            case CLASS_FILES_TO_SOURCES: {
                if (from.getContainingJetFile().isCompiled()) break;
                JetDeclaration jetDeclaration = from;
                if (jetDeclaration == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "navigateToDeclaration"));
                }
                return jetDeclaration;
            }
            case SOURCES_TO_CLASS_FILES: {
                if (from.getContainingJetFile().isCompiled()) {
                    JetDeclaration jetDeclaration = from;
                    if (jetDeclaration == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "navigateToDeclaration"));
                    }
                    return jetDeclaration;
                }
                if (!ProjectRootsUtil.isInContent(from, false, true, false)) {
                    JetDeclaration jetDeclaration = from;
                    if (jetDeclaration == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "navigateToDeclaration"));
                    }
                    return jetDeclaration;
                }
                if (!JetPsiUtil.isLocal(from)) break;
                JetDeclaration jetDeclaration = from;
                if (jetDeclaration == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "navigateToDeclaration"));
                }
                return jetDeclaration;
            }
        }
        JetDeclaration result2 = from.accept(new SourceAndDecompiledConversionVisitor(navigationKind), null);
        JetDeclaration jetDeclaration = result2 != null ? result2 : from;
        if (jetDeclaration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "navigateToDeclaration"));
        }
        return jetDeclaration;
    }

    private static class SourceAndDecompiledConversionVisitor
    extends JetVisitor<JetDeclaration, Void> {
        private final NavigationKind navigationKind;

        public SourceAndDecompiledConversionVisitor(@NotNull NavigationKind navigationKind) {
            if (navigationKind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigationKind", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper$SourceAndDecompiledConversionVisitor", "<init>"));
            }
            this.navigationKind = navigationKind;
        }

        @Override
        public JetDeclaration visitNamedFunction(@NotNull JetNamedFunction function2, Void data2) {
            if (function2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper$SourceAndDecompiledConversionVisitor", "visitNamedFunction"));
            }
            return JetSourceNavigationHelper.convertPropertyOrFunction(function2, this.navigationKind);
        }

        @Override
        public JetDeclaration visitProperty(@NotNull JetProperty property, Void data2) {
            if (property == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper$SourceAndDecompiledConversionVisitor", "visitProperty"));
            }
            return JetSourceNavigationHelper.convertPropertyOrFunction(property, this.navigationKind);
        }

        @Override
        public JetDeclaration visitObjectDeclaration(@NotNull JetObjectDeclaration declaration, Void data2) {
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper$SourceAndDecompiledConversionVisitor", "visitObjectDeclaration"));
            }
            return JetSourceNavigationHelper.convertNamedClassOrObject(declaration, this.navigationKind);
        }

        @Override
        public JetDeclaration visitClass(@NotNull JetClass klass, Void data2) {
            if (klass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper$SourceAndDecompiledConversionVisitor", "visitClass"));
            }
            return JetSourceNavigationHelper.convertNamedClassOrObject(klass, this.navigationKind);
        }

        @Override
        public JetDeclaration visitParameter(@NotNull JetParameter parameter, Void data2) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper$SourceAndDecompiledConversionVisitor", "visitParameter"));
            }
            JetCallableDeclaration callableDeclaration = (JetCallableDeclaration)parameter.getParent().getParent();
            List<JetParameter> parameters2 = callableDeclaration.getValueParameters();
            int index2 = parameters2.indexOf(parameter);
            JetCallableDeclaration sourceCallable = (JetCallableDeclaration)callableDeclaration.accept(this, null);
            if (sourceCallable == null) {
                return null;
            }
            List<JetParameter> sourceParameters = sourceCallable.getValueParameters();
            if (sourceParameters.size() != parameters2.size()) {
                return null;
            }
            return sourceParameters.get(index2);
        }

        @Override
        public JetDeclaration visitPrimaryConstructor(@NotNull JetPrimaryConstructor constructor, Void data2) {
            if (constructor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper$SourceAndDecompiledConversionVisitor", "visitPrimaryConstructor"));
            }
            return JetSourceNavigationHelper.convertPropertyOrFunction(constructor, this.navigationKind);
        }

        @Override
        public JetDeclaration visitSecondaryConstructor(@NotNull JetSecondaryConstructor constructor, Void data2) {
            if (constructor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper$SourceAndDecompiledConversionVisitor", "visitSecondaryConstructor"));
            }
            return JetSourceNavigationHelper.convertPropertyOrFunction(constructor, this.navigationKind);
        }
    }

    public static enum NavigationKind {
        CLASS_FILES_TO_SOURCES,
        SOURCES_TO_CLASS_FILES;

    }
}

