/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.stubBuilder;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.io.StringRef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.KotlinPackage;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.CallableClsStubBuilderKt;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClassClsStubBuilderKt;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClassIdWithTarget;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuilderComponents;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuilderContext;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuildingKt$WhenMappings;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.FlagsToModifiers;
import org.jetbrains.kotlin.idea.stubindex.KotlinFileStubForIde;
import org.jetbrains.kotlin.lexer.JetModifierKeywordToken;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameBase;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetPackageDirective;
import org.jetbrains.kotlin.psi.stubs.KotlinUserTypeStub;
import org.jetbrains.kotlin.psi.stubs.elements.JetStubElementTypes;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinAnnotationEntryStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinAnnotationUseSiteTargetStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFileStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinModifierListStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinNameReferenceExpressionStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinPlaceHolderStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinStubBaseImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinUserTypeStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.ModifierMaskUtils;
import org.jetbrains.kotlin.serialization.Flags;
import org.jetbrains.kotlin.serialization.PackageData;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.AnnotatedCallableKind;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.serialization.deserialization.ProtoContainer;
import org.jetbrains.kotlin.serialization.jvm.JvmProtoBufUtil;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"5\u0016)A1)\u00197mC\ndWM\u0003\u0005Qe>$xNQ;g\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'\"D:fe&\fG.\u001b>bi&|gNC\u000bb]:|G/\u0019;fI\u000e\u000bG\u000e\\1cY\u0016\\\u0015N\u001c3\u000b+\u0005sgn\u001c;bi\u0016$7)\u00197mC\ndWmS5oI*yA-Z:fe&\fG.\u001b>bi&|gN\u0003\rhKR\feN\\8uCR,GmQ1mY\u0006\u0014G.Z&j]\u0012T\u0011\u0003\u0015:pi>\u0014UO\u001a\u0013DC2d\u0017M\u00197f\u0015E\u0019En]*uk\n\u0014U/\u001b7eS:<7\n\u001e\u0006\u0016GJ,\u0017\r^3B]:|G/\u0019;j_:\u001cF/\u001e2t\u00155\tgN\\8uCRLwN\\%eg*!A*[:u\u0015\u001d\u0019E.Y:t\u0013\u0012TAA\\1nK*1\u0001/\u0019:f]RT!cS8uY&t7\u000b^;c\u0005\u0006\u001cX-S7qY*\u0019\u0001o]5\u000b\u000bM$XOY:\u000b\t%l\u0007\u000f\u001c\u0006\u001e]\u0016,Gm\u0016:baBLgnZ!o]>$\u0018\r^5p]\u0016sGO]5fg*9!i\\8mK\u0006t'\u0002B+oSRTAA[1wC*!Q\u000f^5m\u0015Q\u0019'/Z1uK\u001aKG.\u001a$bG\u0006$Wm\u0015;vE*a\u0001/Y2lC\u001e,\u0007K]8u_*9\u0001+Y2lC\u001e,'\u0002\u00044bG\u0006$WMR9OC6,'B\u0002$r\u001d\u0006lWMC\u0001d\u0015U\u0019En]*uk\n\u0014U/\u001b7eKJ\u001cuN\u001c;fqRTA!\u001b3fC*QA-Z2p[BLG.\u001a:\u000b\u0017M$XO\u0019\"vS2$WM\u001d\u0006\u0013\u0017>$H.\u001b8GS2,7\u000b^;c\u00136\u0004HN\u0003\tQe>$xNQ;gIA\u000b7m[1hK*q1M]3bi\u00164\u0015\u000e\\3TiV\u0014'\"\u00049bG.\fw-\u001a$r\u001d\u0006lWM\u0003\u0013de\u0016\fG/Z%oG>l\u0007/\u0019;jE2,\u0017IY5WKJ\u001c\u0018n\u001c8GS2,7\u000b^;c\u0015Y\u0019'/Z1uK6{G-\u001b4jKJd\u0015n\u001d;TiV\u0014'bC*uk\n,E.Z7f]RT1aY8n\u0015!Ig\u000e^3mY&T'B\u0003)tS\u0016cW-\\3oi*IQn\u001c3jM&,'o\u001d\u0006\u000b\u0007>dG.Z2uS>t'b\u0006&fi6{G-\u001b4jKJ\\U-_<pe\u0012$vn[3o\u0015\u0015aW\r_3s\u0015iYu\u000e\u001e7j]6{G-\u001b4jKJd\u0015n\u001d;TiV\u0014\u0017*\u001c9m\u0015\u0011\u001a'/Z1uK6{G-\u001b4jKJd\u0015n\u001d;TiV\u0014gi\u001c:EK\u000ed\u0017M]1uS>t'\"\u00024mC\u001e\u001c(bA%oi*\u0001b\r\\1hgR{GK]1og2\fG/\u001a\u0006\u0011\r2\fwm\u001d+p\u001b>$\u0017NZ5feNT1#\u00193eSRLwN\\1m\u001b>$\u0017NZ5feNT\u0001d\u0019:fCR,W*\u001e7uS\u001aLG.Z\"mCN\u001c8\u000b^;c\u00159iW\u000f\u001c;jM&dWm\u00117bgNTAcS8uY&t'J^7CS:\f'/_\"mCN\u001c(\u0002\u00027pC\u0012T\u0011\u0002]1si\u001aKG.Z:\u000b\u0015\r|W\u000e]8oK:$8O\u0003\rDYN\u001cF/\u001e2Ck&dG-\u001a:D_6\u0004xN\\3oiNTqc\u0019:fCR,\u0007+Y2lC\u001e,g)Y2bI\u0016\u001cF/\u001e2\u000b1\r\u0014X-\u0019;f'R,(MR8s!\u0006\u001c7.Y4f\u001d\u0006lWM\u0003\u000bqC\u000e\\\u0017mZ3ESJ,7\r^5wKN#XO\u0019\u0006\u001a\u0017>$H.\u001b8QY\u0006\u001cW\rS8mI\u0016\u00148\u000b^;c\u00136\u0004HNC\nKKR\u0004\u0016mY6bO\u0016$\u0015N]3di&4XMC\u000bde\u0016\fG/Z*uk\n4uN\u001d+za\u0016t\u0015-\\3\u000b\u0017QL\b/Z\"mCN\u001c\u0018\n\u001a\u0006\u0013\u0017>$H.\u001b8Vg\u0016\u0014H+\u001f9f'R,(MC\u000fde\u0016\fG/\u001a+be\u001e,G/\u001a3B]:|G/\u0019;j_:\u001cF/\u001e2t\u0015E\u0019E.Y:t\u0013\u0012<\u0016\u000e\u001e5UCJ<W\r\u001e\u0006\u0018GJ,\u0017\r^3U_BdUM^3m\u00072\f7o]*uk\nTqa\u00197bgNLEM\u0003\u0006dY\u0006\u001c8\u000f\u0015:pi>TQa\u00117bgNTqaY8oi\u0016DHO\u0003\bQe>$xNQ;gI\rc\u0017m]:\u000b\u001bM,G/\u001e9GS2,7\u000b^;c\u0015!1\u0017\u000e\\3TiV\u0014'b\u0001:fM*I1\u000b\u001e:j]\u001e\u0014VM\u001a\u0006\u0003S>T\u0001BT;mY\u0006\u0014G.\u001a\u0006\fC:tw\u000e^1uS>t7O\u0003\u0003OC6,\u0007~\u0001\u0006\u0003!\tQA\u0001\u0003\u0001\u0011\u0007)!\u0001\"\u0001\t\u0005\u0015\u0011A!\u0001E\u0003\u000b\r!\u0019\u0001#\u0001\r\u0001\u0015\u0019AA\u0001\u0005\u0001\u0019\u0001)!\u0001b\u0001\t\t\u0015\u0019Aa\u0001E\u0004\u0019\u0001)!\u0001B\u0002\t\b\u0015\u0011A1\u0001\u0005\u0006\u000b\u0005A!!B\u0002\u0005\u000b!9A\u0002A\u0003\u0003\t\u0005A\u0001\"B\u0002\u0005\r!=A\u0002A\u0003\u0003\t\u0005A\u0019\"\u0002\u0002\u0005\u000f!QQA\u0001C\b\u0011+)1\u0001\u0002\u0005\t\u00131\u0001Qa\u0001\u0003\u0006\u0011/a\u0001!B\u0002\u0005\u000b!aA\u0002A\u0003\u0002\u00113)!\u0001\u0002\u0006\t\u001b\u0015\u0011AQ\u0003\u0005\b\u000b\t!\u0001\u0002C\u0005\u0006\u0007\u0011\u0011\u0001R\u0004\u0007\u0001\u000b\r!a\u0001c\b\r\u0001\u0015\u0011A!\u0001\u0005\u0012\u000b\t!Q\u0002c\t\u0006\u0005\u0011m\u0001BE\u0003\u0004\t9A\t\u0003\u0004\u0001\u0006\u0007\u0011A\u0001R\u0005\u0007\u0001\u000b\t!\u0001\u0002#\n\u0006\u0005\u0011\r\u0001bE\u0003\u0003\t\u0019Ay\"\u0002\u0002\u0005\u001d!\u0005R!\u0001\u0005\u0017\u000b\t!\u0019\u0003#\f\u0006\u0005\u0011\u0011\u00022C\u0003\u0003\tKA!\"B\u0002\u0005'!-B\u0002A\u0003\u0004\tKAq\u0003\u0004\u0001\u0006\u0007\u0011)\u0001\u0002\u0007\u0007\u0001\u000b\t!\u0011\u0001C\r\u0006\u0007\u0011)\u0002\u0012\u0007\u0007\u0001\u000b\r!\u0001\u0002c\r\r\u0001\u0015\u0011A\u0001\u0003E\u001a\u000b\t!1\u0003c\u000b\u0006\u0005\u0011U\u0001\u0002G\u0003\u0004\t\u0015A1\u0004\u0004\u0001\u0006\u0007\u0011q\u0001\u0002\b\u0007\u0001\u000b\t!\u0011\u0001#\u0010\u0006\u0005\u0011I\u0002BA\u0003\u0004\tgAa\u0004\u0004\u0001\u0006\u0007\u0011q\u0001\u0002\t\u0007\u0001\u000b\t!\u0019\u0004\u0003\u0010\u0006\u0005\u0011q\u0001\u0002I\u0003\u0004\t!A!\u0005\u0004\u0001\u0006\u0007\u00119\u0001R\t\u0007\u0001\u000b\t!\u0001\u0002\u0003\u0012\u0006\u0007\u0011=\u0001\u0002\n\u0007\u0001\u000b\t!y\u0001\u0003\u0013\u0006\u0005\u00111\u0001rB\u0003\u0004\t9AQ\u0005\u0004\u0001\u0006\u0007\u0011\u0011\u0001b\n\u0007\u0001\u000b\t!\u0019\u0001\u0003\u0015\u0006\u0005\u0011\u0011\u0002\"D\u0003\u0003\t\u0003B)&B\u0002\u0005C!QC\u0002A\u0003\u0003\t\u0003A9&B\u0002\u0005E!YC\u0002A\u0003\u0003\t\u0005B!&B\u0002\u0005\r!aC\u0002A\u0003\u0003\t\u0019AA&\"\u000b\u0005G\u0012)2!B\u0001\t\u0006a\u0015\u0001dA\u0011\u0004\u000b\u0005A9\u0001g\u0002%GU\u001ba!D\u0003\u0005\n%\t\u0001\u0002B\u0007\u0002\u0011\u0013A61BC3\t\rAb!(\u0007\u0005\u0001!5Q\u0002C\u0003\u0002\u0011\u0017IA!C\u0002\u0006\u0003!5\u0001T\u0002M\u0006!\u000e\u0001Q4\u0003\u0003\u0001\u0011#iQ!B\u0001\t\u0012%\tA1\u0001M\t!\u000e\u0005Qt\u0002\u0003\u0002\u0011-i1!B\u0001\t\u0013aI\u0001kA\u0001\"\u0007\u0015\t\u00012\u0003M\n#\u000eIAAB\u0005\u0002\t\u0001i\u0011\u0001C\u0006\u000e\u0003!]Q\"\u0001C\u00011\u000e-Qq\u000b\u0003\u000417iz\u0001\u0002\u0001\t\u001d5\u0019Q!\u0001\u0005\r11\u00016\u0001AO\b\t\u0001Aq\"D\u0002\u0006\u0003!e\u0001\u0014\u0004)\u0004\u0002u=A\u0001\u0001\u0005\u0011\u001b\r)\u0011\u0001#\b\u0019\u001eA\u001b\u0011!I\u0002\u0006\u0003!y\u0001dD)\u0004\u0013\u0011m\u0011\"\u0001E\u0010\u001b\u0005A\u0001#D\u0001\t\"5\t\u0001\"\u0005-\u0004\f\u00155Ba\u0001M\u0014;\u001f!\u0001\u0001\u0003\u000b\u000e\u0007\u0015\t\u0001\u0012\u0004M\r!\u000e\u0001\u0011eA\u0003\u0002\u0011=Ar\"U\u0002\u0006\tOI\u0011\u0001c\b\u000e\u0003!\u0005\u0002la\u0003\u0006\u0019\u0011\u0019\u0001\u0014F\u0011\u0004\u000b\u0005Aq\u0002G\bR\u0007\r!I#C\u0001\t a\u001bY!B\u0017\u0005\u0007a)R4\u0004\u0003\u0001\u0011#i\u0011\"B\u0001\t(%)A\u0011A\u0005\u0004\u000b\u0005AA\u0003\u0007\u000b\u0019(A\u001b\u0001!(\u0007\u0005\u0001!=R\u0002C\u0003\u0002\u0011SIA!C\u0002\u0006\u0003!-\u00024\u0006M\u0015!\u000e\u0005\u0011\u0005B\u0003\u0002\u0011Ya\t\u0001\u0007\fR\u0007\u001d!Q#C\u0001\t.5\t\u0001bF\u0007\u0002\u0011_A61B\u0003G\u0002\u0011\u0019\u0001DGO\u000e\t\u0001A\t\"D\u0005\u0006\u0003!\u001d\u0012\"\u0002C\u0001\u0013\r)\u0011\u0001\u0003\u000b\u0019)a\u001d\u0002k\u0001\u0001\u001e\u0010\u0011\u0001\u0001RG\u0007\u0004\u000b\u0005A\u0001\u0004\u0007\rQ\u0007\u0003iJ\u0002B\u0001\t85AQ!\u0001E\u0006\u0013\u0011I1!B\u0001\t2aE\u00024\u0002)\u0004\u0003ueA!\u0001E\u001d\u001b!)\u0011\u0001c\u0003\n\t%\u0019Q!\u0001E\u00161WAZ\u0001UB\u0002C\r)\u0011\u0001\u0003\f\u0019-E\u001b1\u0002\u0002\u000e\n\u0003!5R\"\u0001\u0005\u0018\u001b\u0005!)!D\u0001\t\u00175\t\u0001b\u0003-\u0004\f\u0015YDa\u0001\r\u001e;\u001f!\u0001\u0001c\u000f\u000e\u0007\u0015\t\u0001B\u0007\r\u001b!\u000e\u0001Q\u0014\u0004\u0003\u0001\u0011}i\u0001\"B\u0001\t\f%!\u0011bA\u0003\u0002\u0011iA\"\u0004g\u0003Q\u0007\u0003iz\u0001\u0002\u0001\t\u001f5\u0019Q!\u0001E\r13\u00016!AO\b\t\u0001Ay$D\u0002\u0006\u0003!U\u0002T\u0007)\u0004\u0004\u0005\u001aQ!\u0001\u0005\u00101=\t6a\u0003\u0003\u001e\u0013\u0005Ay\"D\u0001\t75\t\u0001bC\u0007\u0002\u0011Ci\u0011\u0001c\u000eY\u0007\u0017)9\u0006B\u0002\u0019Bu=A\u0001\u0001\u0005\u000f\u001b\r)\u0011\u0001\u0003\u0007\u0019\u0019A\u001b\u0001!h\u0004\u0005\u0001!!RbA\u0003\u0002\u00113AJ\u0002UB\u0001;\u001f!\u0001\u0001\u0003\t\u000e\u0007\u0015\t\u0001R\u0004M\u000f!\u000e\t\u0011eA\u0003\u0002\u0011=Ar\"U\u0002\n\t\u0003J\u0011\u0001c\b\u000e\u0003!\u0001R\"\u0001E\u0011\u001b\u0005A\u0011\u0003WB\u0006\u000b\u0019\"1\u0001G\u0011\u001e\u001a\u0011\u0001\u00012I\u0007\t\u000b\u0005AA$\u0003\u0003\n\u0007\u0015\t\u0001\u0012\bM\u001d1q\u00016\u0001AO\b\t\u0001AA#D\u0002\u0006\u0003!e\u0001\u0014\u0004)\u0004\u0002\u0005\u001aQ!\u0001E\n1'\t6a\u0002\u0003\"\u0013\u0005!\u0001!D\u0001\t;5\t\u0001\u0012\u0005-\u0004\f\u00159Ca\u0001\r$;\u001f!\u0001\u0001c\u0012\u000e\u0007\u0015\t\u0001R\u0002M\u0007!\u000e\u0001Q4\u0004\u0003\u0001\u0011#i\u0011\"B\u0001\t(%)A\u0011A\u0005\u0004\u000b\u0005AA\u0003\u0007\u000b\u0019(A\u001b\t!I\u0002\u0006\u0003!m\u00024H)\u0004\u000f\u0011\u0019\u0013\"\u0001\u0005\u001f\u001b\u0005Ai$D\u0001\t/a\u001bY!\"\u001a\u0005\u0007a%S\u0014\u0004\u0003\u0001\u0011\u001bi\u0001\"B\u0001\t\f%!\u0011bA\u0003\u0002\u0011}Ar\u0004g\u0003Q\u0007\u0001i\u001a\u0002\u0002\u0001\t\u00125)Q!\u0001E\t\u0013\u0005!\u0019\u0001'\u0005Q\u0007\u0003iz\u0001B\u0001\t\u00175\u0019Q!\u0001\u0005\n1%\u00016!A\u0011\u0004\u000b\u0005A\u0019\u0002g\u0005R\u0007%!I%C\u0001\u0005\u00015\t\u0001bC\u0007\u0002\u0011/i\u0011\u0001\"\u0001Y\u0007\u0017)9\u0006B\u0002\u0019Lu=A\u0001\u0001\u0005'\u001b\r)\u0011\u0001#\u0004\u0019\u000eA\u001b\u0001!h\u0004\u0005\u0001!5SbA\u0003\u0002\u0011\u007fAz\u0004UB\u0001;\u001f!\u0001\u0001c\u0014\u000e\u0007\u0015\t\u0001R\u0004M\u000f!\u000e\t\u0011eA\u0003\u0002\u0011=Ar\"U\u0002\n\t\u0017J\u0011\u0001c\b\u000e\u0003!uR\"\u0001\u0005!\u001b\u0005A\u0011\u0003WB\u0006\u000b\u0005\"\u0011\u0001'\u0015\u001e\u0010\u0011\u0001\u0001\"K\u0007\u0004\u000b\u0005Aq\u0002G\bQ\u0007\u0001iz\u0001\u0002\u0001\t)5\u0019Q!\u0001E\r13\u00016\u0011A\u0011\u0004\u000b\u0005A\u0019\u0002g\u0005R\u0007\u001d!\t&C\u0001\u0005\u00015\t\u0001rD\u0007\u0002\u0011CA61BC\u0015\t\r)2!B\u0001\t\u001aae\u00014KQ\u0006\u000b\u0005A\u0019\u0005g\u0011R\u0007\u0005!)%U\u0002\u0006\t'J\u0011\u0001C\u0012\u000e\u0003!\u0005\u0002la\u0003\u0006*\u0011\u0019QcA\u0003\u0002\u0011\u000fB:\u0005g\u0015\"\f\u0015\t\u00012\tM\"#\u000e\tAQI)\u0004\u000b\u0011M\u0013\"\u0001\u0005$\u001b\u0005AA\u0005WB\u0006"})
public final class ClsStubBuildingKt {
    @NotNull
    public static final KotlinFileStubImpl createTopLevelClassStub(@NotNull ClassId classId, @NotNull ProtoBuf.Class classProto, @NotNull ClsStubBuilderContext context) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        Intrinsics.checkParameterIsNotNull((Object)classProto, (String)"classProto");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        FqName fqName2 = classId.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"classId.getPackageFqName()");
        KotlinFileStubImpl fileStub = ClsStubBuildingKt.createFileStub(fqName2);
        ClassClsStubBuilderKt.createClassStub((StubElement<? extends PsiElement>)((StubElement)fileStub), classProto, classId, context);
        return fileStub;
    }

    @NotNull
    public static final KotlinFileStubImpl createPackageFacadeStub(@NotNull ProtoBuf.Package packageProto, @NotNull FqName packageFqName, @NotNull ClsStubBuilderContext c) {
        Intrinsics.checkParameterIsNotNull((Object)packageProto, (String)"packageProto");
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        KotlinFileStubImpl fileStub = KotlinFileStubForIde.Companion.forFile(packageFqName, packageFqName.isRoot());
        ClsStubBuildingKt.setupFileStub(fileStub, packageFqName);
        ProtoContainer container2 = new ProtoContainer(null, packageFqName);
        for (ProtoBuf.Callable callableProto : packageProto.getMemberList()) {
            StubElement stubElement = (StubElement)fileStub;
            ProtoBuf.Callable callable = callableProto;
            Intrinsics.checkExpressionValueIsNotNull((Object)callable, (String)"callableProto");
            CallableClsStubBuilderKt.createCallableStub((StubElement<? extends PsiElement>)stubElement, callable, c, container2);
        }
        return fileStub;
    }

    @NotNull
    public static final KotlinFileStubImpl createFileFacadeStub(@NotNull ProtoBuf.Package packageProto, @NotNull FqName facadeFqName, @NotNull ClsStubBuilderContext c) {
        Intrinsics.checkParameterIsNotNull((Object)packageProto, (String)"packageProto");
        Intrinsics.checkParameterIsNotNull((Object)facadeFqName, (String)"facadeFqName");
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        FqName packageFqName = facadeFqName.parent();
        KotlinFileStubImpl fileStub = KotlinFileStubForIde.Companion.forFileFacadeStub(facadeFqName, packageFqName.isRoot());
        FqName fqName2 = packageFqName;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"packageFqName");
        ClsStubBuildingKt.setupFileStub(fileStub, fqName2);
        ProtoContainer container2 = new ProtoContainer(null, facadeFqName.parent());
        for (ProtoBuf.Callable callableProto : packageProto.getMemberList()) {
            StubElement stubElement = (StubElement)fileStub;
            ProtoBuf.Callable callable = callableProto;
            Intrinsics.checkExpressionValueIsNotNull((Object)callable, (String)"callableProto");
            CallableClsStubBuilderKt.createCallableStub((StubElement<? extends PsiElement>)stubElement, callable, c, container2);
        }
        return fileStub;
    }

    @NotNull
    public static final KotlinFileStubImpl createMultifileClassStub(@NotNull KotlinJvmBinaryClass multifileClass, @NotNull List<? extends KotlinJvmBinaryClass> partFiles, @NotNull FqName facadeFqName, @NotNull ClsStubBuilderComponents components) {
        Intrinsics.checkParameterIsNotNull((Object)multifileClass, (String)"multifileClass");
        Intrinsics.checkParameterIsNotNull(partFiles, (String)"partFiles");
        Intrinsics.checkParameterIsNotNull((Object)facadeFqName, (String)"facadeFqName");
        Intrinsics.checkParameterIsNotNull((Object)components, (String)"components");
        FqName packageFqName = facadeFqName.parent();
        String[] stringArray = multifileClass.getClassHeader().getFilePartClassNames();
        List partNames = stringArray != null ? KotlinPackage.asList((Object[])stringArray) : null;
        KotlinFileStubImpl fileStub = KotlinFileStubForIde.Companion.forMultifileClassStub(facadeFqName, partNames, packageFqName.isRoot());
        FqName fqName2 = packageFqName;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"packageFqName");
        ClsStubBuildingKt.setupFileStub(fileStub, fqName2);
        ProtoContainer multifileClassContainer = new ProtoContainer(null, packageFqName);
        for (KotlinJvmBinaryClass kotlinJvmBinaryClass : partFiles) {
            KotlinClassHeader partHeader = kotlinJvmBinaryClass.getClassHeader();
            String[] stringArray2 = partHeader.getAnnotationData();
            if (stringArray2 == null) {
                Intrinsics.throwNpe();
            }
            PackageData partData = JvmProtoBufUtil.readPackageDataFrom(stringArray2);
            NameResolver nameResolver = partData.getNameResolver();
            Intrinsics.checkExpressionValueIsNotNull((Object)nameResolver, (String)"partData.nameResolver");
            FqName fqName3 = packageFqName;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"packageFqName");
            ClsStubBuilderContext partContext = components.createContext(nameResolver, fqName3);
            for (ProtoBuf.Callable partMember : partData.getPackageProto().getMemberList()) {
                StubElement stubElement = (StubElement)fileStub;
                ProtoBuf.Callable callable = partMember;
                Intrinsics.checkExpressionValueIsNotNull((Object)callable, (String)"partMember");
                CallableClsStubBuilderKt.createCallableStub((StubElement<? extends PsiElement>)stubElement, callable, partContext, multifileClassContainer);
            }
        }
        return fileStub;
    }

    @NotNull
    public static final KotlinFileStubImpl createIncompatibleAbiVersionFileStub() {
        FqName fqName2 = FqName.ROOT;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"FqName.ROOT");
        return ClsStubBuildingKt.createFileStub(fqName2);
    }

    @NotNull
    public static final KotlinFileStubImpl createFileStub(@NotNull FqName packageFqName) {
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        KotlinFileStubImpl fileStub = KotlinFileStubForIde.Companion.forFile(packageFqName, packageFqName.isRoot());
        ClsStubBuildingKt.setupFileStub(fileStub, packageFqName);
        return fileStub;
    }

    public static final void setupFileStub(@NotNull KotlinFileStubImpl fileStub, @NotNull FqName packageFqName) {
        Intrinsics.checkParameterIsNotNull((Object)fileStub, (String)"fileStub");
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        KotlinPlaceHolderStubImpl<JetPackageDirective> packageDirectiveStub = new KotlinPlaceHolderStubImpl<JetPackageDirective>((StubElement)fileStub, JetStubElementTypes.PACKAGE_DIRECTIVE);
        ClsStubBuildingKt.createStubForPackageName(packageDirectiveStub, packageFqName);
        new KotlinPlaceHolderStubImpl((StubElement)fileStub, JetStubElementTypes.IMPORT_LIST);
    }

    public static final void createStubForPackageName(@NotNull KotlinPlaceHolderStubImpl<JetPackageDirective> packageDirectiveStub, @NotNull FqName packageFqName) {
        Intrinsics.checkParameterIsNotNull(packageDirectiveStub, (String)"packageDirectiveStub");
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        ArrayList segments = KotlinPackage.toArrayList((Collection)packageFqName.pathSegments());
        ListIterator iterator2 = segments.listIterator(segments.size());
        Function1<StubElement<? extends PsiElement>, Unit> recCreateStubForPackageName$ = new Function1<StubElement<? extends PsiElement>, Unit>(iterator2){
            final /* synthetic */ ListIterator $iterator;

            public final void invoke(@NotNull StubElement<? extends PsiElement> current) {
                Intrinsics.checkParameterIsNotNull(current, (String)"current");
                switch (this.$iterator.previousIndex()) {
                    case -1: {
                        return;
                    }
                    case 0: {
                        new KotlinNameReferenceExpressionStubImpl(current, ClsStubBuildingKt.ref((Name)this.$iterator.previous()));
                        return;
                    }
                }
                Name lastSegment = (Name)this.$iterator.previous();
                KotlinPlaceHolderStubImpl<T> receiver = new KotlinPlaceHolderStubImpl<T>((StubElement)current, JetStubElementTypes.DOT_QUALIFIED_EXPRESSION);
                this.invoke((StubElement<? extends PsiElement>)receiver);
                new KotlinNameReferenceExpressionStubImpl(receiver, ClsStubBuildingKt.ref(lastSegment));
            }
            {
                this.$iterator = listIterator;
                super(1);
            }
        };
        recCreateStubForPackageName$.invoke((StubElement<? extends PsiElement>)packageDirectiveStub);
    }

    @NotNull
    public static final KotlinUserTypeStub createStubForTypeName(@NotNull ClassId typeClassId, @NotNull StubElement<? extends PsiElement> parent) {
        Intrinsics.checkParameterIsNotNull((Object)typeClassId, (String)"typeClassId");
        Intrinsics.checkParameterIsNotNull(parent, (String)"parent");
        FqNameBase fqName2 = typeClassId.isLocal() ? (FqNameBase)KotlinBuiltIns.FQ_NAMES.any : (FqNameBase)typeClassId.asSingleFqName();
        ArrayList segments = KotlinPackage.toArrayList((Collection)fqName2.pathSegments());
        KotlinPackage.assert((boolean)KotlinPackage.isNotEmpty((Collection)segments));
        ListIterator iterator2 = segments.listIterator(segments.size());
        Function1<StubElement<? extends PsiElement>, KotlinUserTypeStub> recCreateStubForType$ = new Function1<StubElement<? extends PsiElement>, KotlinUserTypeStub>(iterator2){
            final /* synthetic */ ListIterator $iterator;

            @NotNull
            public final KotlinUserTypeStub invoke(@NotNull StubElement<? extends PsiElement> current) {
                Intrinsics.checkParameterIsNotNull(current, (String)"current");
                Name lastSegment = (Name)this.$iterator.previous();
                KotlinUserTypeStubImpl userTypeStub = new KotlinUserTypeStubImpl(current, false);
                if (this.$iterator.hasPrevious()) {
                    this.invoke((StubElement<? extends PsiElement>)((StubElement)userTypeStub));
                }
                new KotlinNameReferenceExpressionStubImpl(userTypeStub, ClsStubBuildingKt.ref(lastSegment));
                return userTypeStub;
            }
            {
                this.$iterator = listIterator;
                super(1);
            }
        };
        return recCreateStubForType$.invoke(parent);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KotlinModifierListStubImpl createModifierListStubForDeclaration(@NotNull StubElement<? extends PsiElement> parent, int flags, @NotNull List<? extends FlagsToModifiers> flagsToTranslate, @NotNull List<? extends JetModifierKeywordToken> additionalModifiers) {
        void destination;
        void $receiver;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull(parent, (String)"parent");
        Intrinsics.checkParameterIsNotNull(flagsToTranslate, (String)"flagsToTranslate");
        Intrinsics.checkParameterIsNotNull(additionalModifiers, (String)"additionalModifiers");
        KotlinPackage.assert((boolean)KotlinPackage.isNotEmpty((Collection)flagsToTranslate));
        Iterable iterable = flagsToTranslate;
        void var6_5 = $receiver2;
        Collection collection = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
        for (Object item : $receiver) {
            void it;
            FlagsToModifiers flagsToModifiers = (FlagsToModifiers)((Object)item);
            void var11_10 = destination;
            JetModifierKeywordToken jetModifierKeywordToken = it.getModifiers(flags);
            var11_10.add(jetModifierKeywordToken);
        }
        List modifiers = KotlinPackage.plus((Collection)KotlinPackage.filterNotNull((Iterable)((List)destination)), (Iterable)additionalModifiers);
        KotlinModifierListStubImpl kotlinModifierListStubImpl = ClsStubBuildingKt.createModifierListStub(parent, modifiers);
        if (kotlinModifierListStubImpl == null) {
            Intrinsics.throwNpe();
        }
        return kotlinModifierListStubImpl;
    }

    @NotNull
    public static /* synthetic */ KotlinModifierListStubImpl createModifierListStubForDeclaration$default(StubElement stubElement, int n, List list, List list2, int n2) {
        if ((n2 & 4) != 0) {
            list = KotlinPackage.listOf();
        }
        if ((n2 & 8) != 0) {
            list2 = KotlinPackage.listOf();
        }
        return ClsStubBuildingKt.createModifierListStubForDeclaration((StubElement<? extends PsiElement>)stubElement, n, list, list2);
    }

    @Nullable
    public static final KotlinModifierListStubImpl createModifierListStub(@NotNull StubElement<? extends PsiElement> parent, @NotNull Collection<? extends JetModifierKeywordToken> modifiers) {
        Intrinsics.checkParameterIsNotNull(parent, (String)"parent");
        Intrinsics.checkParameterIsNotNull(modifiers, (String)"modifiers");
        if (modifiers.isEmpty()) {
            return null;
        }
        return new KotlinModifierListStubImpl(parent, ModifierMaskUtils.computeMask((Function1<? super JetModifierKeywordToken, ? extends Boolean>)((Function1)new Function1<JetModifierKeywordToken, Boolean>(modifiers){
            final /* synthetic */ Collection $modifiers;

            public final boolean invoke(@NotNull JetModifierKeywordToken it) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                return this.$modifiers.contains((Object)((Object)it));
            }
            {
                this.$modifiers = collection;
                super(1);
            }
        })), JetStubElementTypes.MODIFIER_LIST);
    }

    /*
     * WARNING - void declaration
     */
    public static final void createAnnotationStubs(@NotNull List<? extends ClassId> annotationIds, @NotNull KotlinStubBaseImpl<?> parent, boolean needWrappingAnnotationEntries) {
        void destination;
        void $receiver;
        Intrinsics.checkParameterIsNotNull(annotationIds, (String)"annotationIds");
        Intrinsics.checkParameterIsNotNull(parent, (String)"parent");
        Iterable $receiver2 = annotationIds;
        Iterable iterable = $receiver2;
        Collection collection = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
        for (Object item : $receiver) {
            void it;
            ClassId classId = (ClassId)item;
            void var9_9 = destination;
            ClassIdWithTarget classIdWithTarget = new ClassIdWithTarget((ClassId)it, null);
            var9_9.add(classIdWithTarget);
        }
        ClsStubBuildingKt.createTargetedAnnotationStubs((List)destination, parent, needWrappingAnnotationEntries);
    }

    public static /* synthetic */ void createAnnotationStubs$default(List list, KotlinStubBaseImpl kotlinStubBaseImpl, boolean bl, int n) {
        if ((n & 4) != 0) {
            bl = false;
        }
        ClsStubBuildingKt.createAnnotationStubs(list, kotlinStubBaseImpl, bl);
    }

    /*
     * WARNING - void declaration
     */
    public static final void createTargetedAnnotationStubs(@NotNull List<? extends ClassIdWithTarget> annotationIds, @NotNull KotlinStubBaseImpl<?> parent, boolean needWrappingAnnotationEntries) {
        void $receiver;
        Intrinsics.checkParameterIsNotNull(annotationIds, (String)"annotationIds");
        Intrinsics.checkParameterIsNotNull(parent, (String)"parent");
        if (annotationIds.isEmpty()) {
            return;
        }
        KotlinStubBaseImpl entriesParent = needWrappingAnnotationEntries ? (KotlinStubBaseImpl)new KotlinPlaceHolderStubImpl((StubElement)parent, JetStubElementTypes.ANNOTATION) : parent;
        Iterable iterable = annotationIds;
        for (Object element2 : $receiver) {
            void target;
            void annotationClassId;
            ClassIdWithTarget annotation2;
            ClassIdWithTarget classIdWithTarget = annotation2 = (ClassIdWithTarget)element2;
            ClassId classId = classIdWithTarget.component1();
            AnnotationUseSiteTarget annotationUseSiteTarget = classIdWithTarget.component2();
            classIdWithTarget = null;
            StubElement stubElement = (StubElement)entriesParent;
            StringRef stringRef = ClsStubBuildingKt.ref(annotationClassId.getShortClassName());
            Intrinsics.checkExpressionValueIsNotNull((Object)stringRef, (String)"annotationClassId.getShortClassName().ref()");
            KotlinAnnotationEntryStubImpl annotationEntryStubImpl = new KotlinAnnotationEntryStubImpl((StubElement<? extends PsiElement>)stubElement, stringRef, false);
            if (target != null) {
                StubElement stubElement2 = annotationEntryStubImpl;
                StringRef stringRef2 = StringRef.fromString((String)target.name());
                if (stringRef2 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)stringRef2, (String)"StringRef.fromString(target.name())!!");
                new KotlinAnnotationUseSiteTargetStubImpl((StubElement<? extends PsiElement>)stubElement2, stringRef2);
            }
            KotlinPlaceHolderStubImpl constructorCallee = new KotlinPlaceHolderStubImpl(annotationEntryStubImpl, JetStubElementTypes.CONSTRUCTOR_CALLEE);
            KotlinPlaceHolderStubImpl typeReference = new KotlinPlaceHolderStubImpl(constructorCallee, JetStubElementTypes.TYPE_REFERENCE);
            ClsStubBuildingKt.createStubForTypeName((ClassId)annotationClassId, typeReference);
        }
    }

    public static /* synthetic */ void createTargetedAnnotationStubs$default(List list, KotlinStubBaseImpl kotlinStubBaseImpl, boolean bl, int n) {
        if ((n & 4) != 0) {
            bl = false;
        }
        ClsStubBuildingKt.createTargetedAnnotationStubs(list, kotlinStubBaseImpl, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final AnnotatedCallableKind getAnnotatedCallableKind(ProtoBuf.Callable $receiver) {
        ProtoBuf.Callable.CallableKind callableKind;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ProtoBuf.Callable.CallableKind callableKind2 = callableKind = Flags.CALLABLE_KIND.get($receiver.getFlags());
        if (callableKind2 == null) throw (Throwable)new IllegalStateException("Unsupported callable kind: " + (Object)((Object)callableKind));
        switch (ClsStubBuildingKt$WhenMappings.$EnumSwitchMapping$0[callableKind2.ordinal()]) {
            case 1: 
            case 2: {
                AnnotatedCallableKind annotatedCallableKind = AnnotatedCallableKind.PROPERTY;
                return annotatedCallableKind;
            }
            case 3: 
            case 4: {
                AnnotatedCallableKind annotatedCallableKind = AnnotatedCallableKind.FUNCTION;
                return annotatedCallableKind;
            }
            default: {
                throw (Throwable)new IllegalStateException("Unsupported callable kind: " + (Object)((Object)callableKind));
            }
        }
    }

    @NotNull
    public static final StringRef ref(Name $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        StringRef stringRef = StringRef.fromString((String)$receiver.asString());
        if (stringRef == null) {
            Intrinsics.throwNpe();
        }
        return stringRef;
    }

    @NotNull
    public static final StringRef ref(FqName $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        StringRef stringRef = StringRef.fromString((String)$receiver.asString());
        if (stringRef == null) {
            Intrinsics.throwNpe();
        }
        return stringRef;
    }
}

