/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.stubBuilder;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.compiled.ClsStubBuilder;
import com.intellij.psi.impl.compiled.ClassFileStubBuilder;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.util.indexing.FileContent;
import java.util.List;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.decompiler.DecompiledUtilsKt;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.AnnotationLoaderForStubBuilder;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuilderComponents;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuilderContext;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuildingKt;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.DirectoryBasedClassFinder;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.DirectoryBasedDataFinder;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.LoggingErrorReporter;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.kotlin.KotlinBinaryClassCache;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeaderKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFileStubImpl;
import org.jetbrains.kotlin.serialization.ClassData;
import org.jetbrains.kotlin.serialization.PackageData;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.serialization.jvm.JvmProtoBufUtil;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"|\u0006)!2j\u001c;mS:\u001cEn]*uk\n\u0014U/\u001b7eKJT1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\u0005S\u0012,\u0017M\u0003\u0006eK\u000e|W\u000e]5mKJT1b\u001d;vE\n+\u0018\u000e\u001c3fe*q1\t\\:TiV\u0014')^5mI\u0016\u0014(bA2p[*A\u0011N\u001c;fY2L'NC\u0002qg&T\u0001bY8na&dW\r\u001a\u0006\u0007y%t\u0017\u000e\u001e \u000b\u001b\t,\u0018\u000e\u001c3GS2,7\u000b^;c\u0015\u001d\u0019wN\u001c;f]RT1BR5mK\u000e{g\u000e^3oi*!Q\u000f^5m\u0015!Ig\u000eZ3yS:<'b\u0003)tS\u001aKG.Z*uk\nTQa\u001d;vENT1d\u0019:fCR,7\u000b^;c\u0005VLG\u000eZ3s\u0007>l\u0007o\u001c8f]R\u001c(\u0002\u00024jY\u0016T1BV5siV\fGNR5mK*9q\u000e]3oCBL'b\u0001<gg*i\u0001/Y2lC\u001e,g)\u001d(b[\u0016TaAR9OC6,'\u0002\u00028b[\u0016T\u0001d\u00117t'R,(MQ;jY\u0012,'oQ8na>tWM\u001c;t\u0015=!wNQ;jY\u00124\u0015\u000e\\3TiV\u0014'b\u0002&fi\u001aKG.\u001a\u0006\u000fO\u0016$8\u000b^;c-\u0016\u00148/[8o\u0015\rIe\u000e\u001e\u0006\n\u0007>l\u0007/\u00198j_:d\u001dA\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\t!\u0011\u0001\u0003\u0002\u0006\u0005\u0011\r\u0001RA\u0003\u0003\t\tA1!B\u0002\u0005\u0006!\u0001A\u0002A\u0003\u0002\u0011\u0011)!\u0001b\u0002\t\n\u0015\u0011A\u0001\u0002\u0005\u0006\u000b\t!I\u0001c\u0003\u0006\u0007\u0011)\u0001r\u0001\u0007\u0001\u000b\t!A\u0001\u0003\u0005\u0006\u0005\u00111\u0001\u0012C\u0003\u0004\t\u001bAy\u0001\u0004\u0001\u0006\u0005\u0011%\u00012C\u0003\u0004\t\u001fA\u0011\u0002\u0004\u0001\u0006\u0005\u0011=\u0001\"C\u0003\u0003\t\u001bAy!\u0002\u0002\u0005\t!]QA\u0001C\n\u00111)1\u0001\u0002\u0006\t\u00171\u0001QA\u0001\u0003\u0002\u00117)1\u0001B\u0006\t\u001b1\u0001Qa\u0001C\u0003\u00119a\u0001!\u0002\u0002\u0005\u0006!qQA\u0001\u0003\u000b\u0011-)!\u0001B\u0006\t\u001b\u0015\u0011A!\u0001\u0005\u0006\u000b\r!a\u0002C\b\r\u0001\u0015\t\u00012A\u0003\u0004\t=A\u0001\u0003\u0004\u0001\u0005\u00171\u0019\u0001\u0013E\r\u0004\u000b\u0005AY\u0001g\u0003\u001e\u0002Ci\u0003\u0004B\u0006\u0019\u000eu=A\u0001\u0001\u0005\b\u001b\r)\u0011\u0001C\u0004\u0019\u000fA\u001b\u0001!\t\u0004\u0006\u0003!A\u0011\"\u0001C\u0002\u0019\u0003A\u0002\"U\u0002\u0006\t\u001bI\u0011\u0001#\u0005\u000e\u0003!IQv\b\u0003\u00021)iz\u0001\u0002\u0001\t\u00165\u0019Q!\u0001E\u000b1+\u00016\u0001AO\b\t\u0001AI\"D\u0002\u0006\u0003!]\u0001t\u0003)\u0004\u0002\u0005\u001aQ!\u0001\u0005\r11\t6a\u0002\u0003\u000b\u0013\u0005AI\"D\u0001\t\u001b5\t\u00012D\u0017\u001c\t\rAj\"h\u0004\u0005\u0001!UQbA\u0003\u0002\u0011+A*\u0002U\u0002\u0001C%)\u0011\u0001\u0003\u0005\n\t%\u0019Q!\u0001E\u000f1;a\t\u0001\u0007\u0005R\u0007\u0015!i\"C\u0001\t\u00125\t\u0001\"DW\u000b\t-Az\"I\u0002\u0006\u0003!}\u0001tD)\u0004\u0007\u0011}\u0011\"\u0001C\u0003k1)1\u0002Br\u00011\u0019\t3!B\u0001\t\u0007a\u0019\u0011kA\u0002\u0005\r%\tA\u0001\u0001"})
public class KotlinClsStubBuilder
extends ClsStubBuilder {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    public static final Logger LOG;
    public static final Companion Companion;

    static {
        $kotlinClass = Reflection.createKotlinClass(KotlinClsStubBuilder.class);
        Companion companion = Companion = new Companion(null);
        LOG = Logger.getInstance(KotlinClsStubBuilder.class);
    }

    public int getStubVersion() {
        return ClassFileStubBuilder.STUB_VERSION + 1;
    }

    @Nullable
    public PsiFileStub<?> buildFileStub(@NotNull FileContent content2) {
        VirtualFile file;
        Intrinsics.checkParameterIsNotNull((Object)content2, (String)"content");
        VirtualFile virtualFile = file = content2.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"file");
        if (DecompiledUtilsKt.isKotlinInternalCompiledFile(virtualFile)) {
            return null;
        }
        VirtualFile virtualFile2 = file;
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file");
        return this.doBuildFileStub(virtualFile2);
    }

    @Nullable
    public final PsiFileStub<JetFile> doBuildFileStub(@NotNull VirtualFile file) {
        KotlinFileStubImpl kotlinFileStubImpl;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        KotlinJvmBinaryClass kotlinJvmBinaryClass = KotlinBinaryClassCache.getKotlinBinaryClass(file);
        if (kotlinJvmBinaryClass == null) {
            Intrinsics.throwNpe();
        }
        KotlinJvmBinaryClass kotlinBinaryClass = kotlinJvmBinaryClass;
        KotlinClassHeader header = kotlinBinaryClass.getClassHeader();
        ClassId classId = kotlinBinaryClass.getClassId();
        FqName packageFqName = classId.getPackageFqName();
        if (!header.getIsCompatibleAbiVersion()) {
            return ClsStubBuildingKt.createIncompatibleAbiVersionFileStub();
        }
        FqName fqName2 = packageFqName;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"packageFqName");
        ClsStubBuilderComponents components = this.createStubBuilderComponents(file, fqName2);
        if (KotlinClassHeaderKt.isCompatibleMultifileClassKind(header)) {
            KotlinJvmBinaryClass kotlinJvmBinaryClass2 = kotlinBinaryClass;
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinJvmBinaryClass2, (String)"kotlinBinaryClass");
            List<KotlinJvmBinaryClass> partFiles = DecompiledUtilsKt.findMultifileClassParts(file, kotlinJvmBinaryClass2);
            KotlinJvmBinaryClass kotlinJvmBinaryClass3 = kotlinBinaryClass;
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinJvmBinaryClass3, (String)"kotlinBinaryClass");
            FqName fqName3 = classId.asSingleFqName();
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"classId.asSingleFqName()");
            return ClsStubBuildingKt.createMultifileClassStub(kotlinJvmBinaryClass3, partFiles, fqName3, components);
        }
        String[] annotationData = header.getAnnotationData();
        if (annotationData == null) {
            Companion.getLOG().error("Corrupted kotlin header for file " + file.getName());
            return null;
        }
        if (KotlinClassHeaderKt.isCompatiblePackageFacadeKind(header)) {
            PackageData packageData = JvmProtoBufUtil.readPackageDataFrom(annotationData);
            NameResolver nameResolver = packageData.getNameResolver();
            Intrinsics.checkExpressionValueIsNotNull((Object)nameResolver, (String)"packageData.getNameResolver()");
            FqName fqName4 = packageFqName;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName4, (String)"packageFqName");
            ClsStubBuilderContext context = components.createContext(nameResolver, fqName4);
            ProtoBuf.Package package_ = packageData.getPackageProto();
            Intrinsics.checkExpressionValueIsNotNull((Object)package_, (String)"packageData.getPackageProto()");
            FqName fqName5 = packageFqName;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName5, (String)"packageFqName");
            kotlinFileStubImpl = ClsStubBuildingKt.createPackageFacadeStub(package_, fqName5, context);
        } else if (KotlinClassHeaderKt.isCompatibleClassKind(header)) {
            if (Intrinsics.areEqual((Object)((Object)header.getClassKind()), (Object)((Object)JvmAnnotationNames.KotlinClass.Kind.CLASS)) ^ true) {
                return null;
            }
            ClassData classData = JvmProtoBufUtil.readClassDataFrom(annotationData);
            NameResolver nameResolver = classData.getNameResolver();
            Intrinsics.checkExpressionValueIsNotNull((Object)nameResolver, (String)"classData.getNameResolver()");
            FqName fqName6 = packageFqName;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName6, (String)"packageFqName");
            ClsStubBuilderContext context = components.createContext(nameResolver, fqName6);
            ClassId classId2 = classId;
            Intrinsics.checkExpressionValueIsNotNull((Object)classId2, (String)"classId");
            ProtoBuf.Class clazz = classData.getClassProto();
            Intrinsics.checkExpressionValueIsNotNull((Object)clazz, (String)"classData.getClassProto()");
            kotlinFileStubImpl = ClsStubBuildingKt.createTopLevelClassStub(classId2, clazz, context);
        } else if (KotlinClassHeaderKt.isCompatibleFileFacadeKind(header)) {
            PackageData packageData = JvmProtoBufUtil.readPackageDataFrom(annotationData);
            NameResolver nameResolver = packageData.getNameResolver();
            Intrinsics.checkExpressionValueIsNotNull((Object)nameResolver, (String)"packageData.getNameResolver()");
            FqName fqName7 = packageFqName;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName7, (String)"packageFqName");
            ClsStubBuilderContext context = components.createContext(nameResolver, fqName7);
            ProtoBuf.Package package_ = packageData.getPackageProto();
            Intrinsics.checkExpressionValueIsNotNull((Object)package_, (String)"packageData.getPackageProto()");
            FqName fqName8 = classId.asSingleFqName();
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName8, (String)"classId.asSingleFqName()");
            kotlinFileStubImpl = ClsStubBuildingKt.createFileFacadeStub(package_, fqName8, context);
        } else {
            throw (Throwable)new IllegalStateException("Should have processed " + file.getPath() + (" with header " + header));
        }
        return kotlinFileStubImpl;
    }

    private final ClsStubBuilderComponents createStubBuilderComponents(VirtualFile file, FqName packageFqName) {
        VirtualFile virtualFile = file.getParent();
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        DirectoryBasedClassFinder classFinder = new DirectoryBasedClassFinder(virtualFile, packageFqName);
        Logger logger = Companion.getLOG();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LOG");
        DirectoryBasedDataFinder classDataFinder = new DirectoryBasedDataFinder(classFinder, logger);
        KotlinClassFinder kotlinClassFinder = classFinder;
        Logger logger2 = Companion.getLOG();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"LOG");
        AnnotationLoaderForStubBuilder annotationLoader = new AnnotationLoaderForStubBuilder(kotlinClassFinder, new LoggingErrorReporter(logger2));
        return new ClsStubBuilderComponents(classDataFinder, annotationLoader);
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"-\u0004)I1i\\7qC:LwN\u001c\u0006\u0015\u0017>$H.\u001b8DYN\u001cF/\u001e2Ck&dG-\u001a:\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:TA!\u001b3fC*QA-Z2p[BLG.\u001a:\u000b\u0017M$XO\u0019\"vS2$WM\u001d\u0006\u0004\u0003:L(b\u0001'P\u000f*1Aj\\4hKJT1aY8n\u0015!Ig\u000e^3mY&T'bB8qK:\f\u0007/\u001b\u0006\u000bI&\fwM\\8ti&\u001c'b\u0002(pi:+H\u000e\u001c\u0006\fC:tw\u000e^1uS>t7O\u0003\u0004hKRduj\u00129\u000b\u0005A\u0011!\u0002\u0002\u0005\u0001!\rQA\u0001C\u0001\u0011\t)!\u0001B\u0001\t\u0006\u0015\u0011A1\u0001\u0005\u0004\u000b\t!!\u0001c\u0002\u0006\u0007\u0011\u0015\u0001\u0012\u0001\u0007\u0001\u000b\r!1\u0001\u0003\u0001\r\u0001\u0015\t\u0001BA\u0003\u0004\t\u0011AA\u0001\u0004\u0001\u0006\u0003!-QA\u0001\u0003\u0006\u0011\u0019)!\u0001b\u0003\t\u000e\u0015\u0011AA\u0002\u0005\b\u000b\r!i\u0001C\u0003\r\u0001\u0015\u0011A\u0011\u0001\u0005\t\u000b\r!y\u0001c\u0004\r\u0001\u0015\u0011AQ\u0002\u0005\u0006\t\r\u000fArA\r\u0004\u000b\u0005AI\u0001'\u0003.(\u0011\u0019G\u0001'\u0003\"\f\u0015\t\u0001b\u0002\r\b#\u000e\tA\u0001C+\u0004\u0013\u0015!A\u0011B\u0005\u0002\u0011#a\t!D\u0002\u0005\u0012%\t\u0001\u0012C\u001b\u0001"})
    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

