/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.textBuilder;

import com.intellij.openapi.vfs.VirtualFile;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.DeserializerForDecompiler;
import org.jetbrains.kotlin.load.kotlin.KotlinBinaryClassCache;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.name.FqName;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"%\u0004)IB)Z:fe&\fG.\u001b>fe\u001a{'\u000fR3d_6\u0004\u0018\u000e\\3s\u0015%\u0019G.Y:t\r&dWMC\u0006WSJ$X/\u00197GS2,'bA2p[*A\u0011N\u001c;fY2L'NC\u0004pa\u0016t\u0017\r]5\u000b\u0007Y47OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\u0011IG-Z1\u000b\u0015\u0011,7m\\7qS2,'OC\u0006uKb$()^5mI\u0016\u0014(b\u0007#fg\u0016\u0014\u0018.\u00197ju\u0016\u0014hi\u001c:EK\u000e|W\u000e]5mKJ\\E\u000f\u0016\u0006\u0003!\rQA\u0001\u0003\u0001\u0011\t)!\u0001\"\u0001\t\u0006\u0015\u0011A!\u0001\u0005\u0004\u000b\r!\u0019\u0001C\u0001\r\u0001\u0015\t\u0001rA\u0003\u0003\t\u000bAA!\u0002\u0002\u0005\u0007!%QA\u0001C\u0004\u0011\u0015)!\u0001\u0002\u0003\t\f\u0015\u0011A\u0011\u0002\u0005\u0007\u000b\r!Q\u0001\u0003\u0001\r\u0001\u0015\u0011A!\u0002\u0005\u0001\u000b\t!\u0019\u0001C\u0001\u0006.\u0011\u0019\u0001\u0004AO\b\t\u0001A\t!D\u0002\u0006\u0003!\u0011\u0001D\u0001)\u0004\u0001\u0005\u001aQ!\u0001E\u00061\u0017\t6!\u0002\u0003\u0001\u0013\u0005Aa!D\u0001\t\u000ea\u001bi\u0001"})
public final class DeserializerForDecompilerKt {
    @NotNull
    public static final DeserializerForDecompiler DeserializerForDecompiler(@NotNull VirtualFile classFile) {
        Intrinsics.checkParameterIsNotNull((Object)classFile, (String)"classFile");
        KotlinJvmBinaryClass kotlinClass = KotlinBinaryClassCache.getKotlinBinaryClass(classFile);
        boolean value2 = kotlinClass != null;
        if (KotlinPackage.getASSERTIONS_ENABLED() && !value2) {
            String message = "Decompiled data factory shouldn't be called on an unsupported file: " + classFile;
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        KotlinJvmBinaryClass kotlinJvmBinaryClass = kotlinClass;
        if (kotlinJvmBinaryClass == null) {
            Intrinsics.throwNpe();
        }
        FqName packageFqName = kotlinJvmBinaryClass.getClassId().getPackageFqName();
        VirtualFile virtualFile = classFile.getParent();
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        FqName fqName2 = packageFqName;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"packageFqName");
        return new DeserializerForDecompiler(virtualFile, fqName2);
    }
}

