/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.lang.ASTNode;
import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.editor.KotlinSmartEnterHandlerKt;
import org.jetbrains.kotlin.idea.editor.fixers.FixersUtilKt;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinDoWhileFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinForConditionFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinFunctionDeclarationBodyFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinFunctionParametersFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinIfConditionFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinMissingForOrWhileBodyFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinMissingIfBranchFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinMissingWhenBodyFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinWhenSubjectCaretFixer;
import org.jetbrains.kotlin.idea.editor.fixers.KotlinWhileConditionFixer;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetDeclarationWithBody;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetForExpression;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetIfExpression;
import org.jetbrains.kotlin.psi.JetLoopExpression;
import org.jetbrains.kotlin.psi.JetParameter;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"G\u0006)92j\u001c;mS:\u001cV.\u0019:u\u000b:$XM\u001d%b]\u0012dWM\u001d\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*!\u0011\u000eZ3b\u0015\u0019)G-\u001b;pe*i2+\\1si\u0016sG/\u001a:Qe>\u001cWm]:pe^KG\u000f\u001b$jq\u0016\u00148OC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\u0005Y\u0006twM\u0003\u0004=S:LGO\u0010\u0006\u0014O\u0016$8\u000b^1uK6,g\u000e^!u\u0007\u0006\u0014X\r\u001e\u0006\u0007\u000b\u0012LGo\u001c:\u000b\u000f=\u0004XM\\1qS*9\u0001o]5GS2,'b\u0002)tS\u001aKG.\u001a\u0006\u0004aNL'B\u0003)tS\u0016cW-\\3oi*QRn\u001c<f\u0007\u0006\u0014X\r^%og&$WM\u0011:bG\u0016\u001c\u0018JZ!os*!a-\u001b7f\u0015\u0011)f.\u001b;\u000b/I,w-[:uKJ,fN]3t_24X\rZ#se>\u0014(BB8gMN,GOC\u0002J]RTa\"[:KKR\u001cF/\u0019;f[\u0016tGOC\u0004C_>dW-\u00198\u000b3-{G\u000f\\5o!2\f\u0017N\\#oi\u0016\u0014\bK]8dKN\u001cxN\u001dK\u0002\u0015\t\u0001\u0012A\u0003\u0003\t\u0001A\u0011!\u0002\u0002\u0005\u0002!\rQA\u0001\u0003\u0002\u0011\t)!\u0001b\u0001\t\u0006\u0015\u0019AA\u0001\u0005\u0001\u0019\u0001)\u0011\u0001c\u0002\u0006\u0005\u0011\u0019\u0001\u0002B\u0003\u0003\t\u000fAI!B\u0002\u0005\t!\u0019A\u0002A\u0003\u0003\t\u000fAi!\u0002\u0002\u0005\u000b!\u0015Qa\u0001C\u0006\u0011\u0019a\u0001!\u0002\u0002\u0005\b!AQa\u0001C\u0007\u0011\u001fa\u0001!B\u0002\u0005\u000e!EA\u0002A\u0003\u0003\t\u001bA\t\"\u0002\u0002\u0005\f!1QA\u0001C\u0007\u0011\u001f)\u0011\u0001c\u0001\u0006\u0007\u0011M\u0001B\u0003\u0007\u0001\u000b\r!\u0019\u0002c\u0006\r\u0001\u0015\u0019A1\u0003E\r\u0019\u0001!1\u0001$\u0002\u001a\u0007\u0015\t\u0001\u0012\u0002M\u0005;\u0003iQV\t\u0003\u000b1\u0017i\n\u0002\u0002\u0001\t\u00065!Q!\u0001\u0005\u0007\u0019\u0003Ab\u0001U\u0002\u0001;#!\u0001\u0001C\u0004\u000e\t\u0015\t\u0001b\u0002G\u00011\u001d\u00016\u0011A\u0011\u0005\u000b\u0005Ay\u0001$\u0001\u0019\u0010E\u001bq\u0001b\u0003\n\u0003!AQ\"\u0001E\t\u001b\u0005A\u0011\"l\u0010\u0005\u0015aIQt\u0002\u0003\u0001\u0011\u000bi1!B\u0001\t\ra1\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u00012C\u0007\u0004\u000b\u0005Aq\u0001G\u0004Q\u0007\u0003\t3!B\u0001\t\u0015aQ\u0011kA\u0004\u0005\u0013%\tA\u0001A\u0007\u0002\u0011#i\u0011\u0001C\u0005.+\u0011\u0019\u0001TCO\b\t\u0001A1\"D\u0002\u0006\u0003!U\u0001T\u0003)\u0004\u0001\u0005\u001aQ!\u0001\u0005\u000b1)\t6!\u0002C\u000b\u0013\u0005!\u0001!D\u0001\u0005\u00065\u0006B!A\u000b\u0004\u000b\u0005Ay\u0001g\u0004\u0019\u0019\u0005\u001aQ!\u0001\u0005\f1-\t6!\u0002\u0003\r\u0013\u0005!\t!D\u0001\t\u0011UbQa\u0003\u0003d\u0002a)\u0011eA\u0003\u0002\u0011\u000bA*!U\u0002\u0004\t\u0015I\u0011\u0001\u0002\u0001"})
public final class KotlinSmartEnterHandler
extends SmartEnterProcessorWithFixers {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(KotlinSmartEnterHandler.class);
    }

    @Nullable
    protected PsiElement getStatementAtCaret(@Nullable Editor editor, @Nullable PsiFile psiFile) {
        PsiElement atCaret = super.getStatementAtCaret(editor, psiFile);
        if (atCaret instanceof PsiWhiteSpace) {
            return null;
        }
        while (atCaret != null) {
            PsiElement declaration;
            if (this.isJetStatement(atCaret)) {
                return atCaret;
            }
            if (atCaret.getParent() instanceof JetFunctionLiteral) {
                return atCaret;
            }
            if (atCaret instanceof JetDeclaration && (!((declaration = atCaret) instanceof JetParameter) || KotlinSmartEnterHandlerKt.isInLambdaExpression((JetParameter)declaration)) && !(((JetDeclaration)declaration).getParent() instanceof JetForExpression)) {
                return atCaret;
            }
            atCaret = atCaret.getParent();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected void moveCaretInsideBracesIfAny(@NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        int caretOffset = editor.getCaretModel().getOffset();
        CharSequence chars = editor.getDocument().getCharsSequence();
        if (CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"{}")) {
            caretOffset += 2;
        } else if (CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"{\n}")) {
            caretOffset += 3;
        }
        caretOffset = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(caretOffset - 1), (String)" \t") + 1;
        if (CharArrayUtil.regionMatches((CharSequence)chars, (int)(caretOffset - "{}".length()), (CharSequence)"{}") || CharArrayUtil.regionMatches((CharSequence)chars, (int)(caretOffset - "{\n}".length()), (CharSequence)"{\n}")) {
            void $receiver;
            this.commit(editor);
            CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)file.getProject());
            boolean old = settings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE;
            settings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE = false;
            PsiElement psiElement2 = file.findElementAt(caretOffset - 1);
            if (psiElement2 == null) {
                Intrinsics.throwNpe();
            }
            PsiElement psiElement3 = psiElement2;
            JetBlockExpression elt = (JetBlockExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver, JetBlockExpression.class, (boolean)true);
            if (elt != null) {
                this.reformat((PsiElement)elt);
            }
            settings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE = old;
            editor.getCaretModel().moveToOffset(caretOffset - 1);
        }
    }

    public final void registerUnresolvedError(int offset2) {
        if (this.myFirstErrorOffset > offset2) {
            this.myFirstErrorOffset = offset2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isJetStatement(PsiElement $receiver) {
        PsiElement psiElement2;
        if ($receiver.getParent() instanceof JetBlockExpression) {
            ASTNode aSTNode = $receiver.getNode();
            if (KotlinSmartEnterHandlerKt.getBRACES().contains((IElementType)(aSTNode != null ? aSTNode.getElementType() : null)) ^ true) {
                return true;
            }
        }
        if (!KotlinSmartEnterHandlerKt.getBRANCH_CONTAINERS().contains((psiElement2 = $receiver.getParent()) != null && (psiElement2 = psiElement2.getNode()) != null ? psiElement2.getElementType() : null)) return false;
        if ($receiver instanceof JetBlockExpression) return false;
        return true;
    }

    public KotlinSmartEnterHandler() {
        this.addFixers(new SmartEnterProcessorWithFixers.Fixer[]{new KotlinIfConditionFixer(), new KotlinMissingIfBranchFixer(), new KotlinWhileConditionFixer(), new KotlinForConditionFixer(), new KotlinMissingForOrWhileBodyFixer(), new KotlinWhenSubjectCaretFixer(), new KotlinMissingWhenBodyFixer(), new KotlinDoWhileFixer(), new KotlinFunctionParametersFixer(), new KotlinFunctionDeclarationBodyFixer()});
        this.addEnterProcessors(new SmartEnterProcessorWithFixers.FixEnterProcessor[]{new KotlinPlainEnterProcessor()});
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={">\u0006)I2j\u001c;mS:\u0004F.Y5o\u000b:$XM\u001d)s_\u000e,7o]8s\u0015]Yu\u000e\u001e7j]Nk\u0017M\u001d;F]R,'\u000fS1oI2,'OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\u0011IG-Z1\u000b\r\u0015$\u0017\u000e^8s\u0015E1\u0015\u000e_#oi\u0016\u0014\bK]8dKN\u001cxN\u001d\u0006\u001e'6\f'\u000f^#oi\u0016\u0014\bK]8dKN\u001cxN],ji\"4\u0015\u000e_3sg*\u00191m\\7\u000b\u0011%tG/\u001a7mS*TA\u0001\\1oO*1A(\u001b8jizRq\u0001Z8F]R,'OC\u0004bi\u000e\u000b'/\u001a;\u000b\u0015A\u001b\u0018.\u00127f[\u0016tGOC\u0002qg&TAAZ5mK*9\u0001k]5GS2,'BB#eSR|'OC\u0004pa\u0016t\u0017\r]5\u000b\u00115|G-\u001b4jK\u0012TqAQ8pY\u0016\fgN\u0003\rhKR\u001cuN\u001c;s_2\u001cF/\u0019;f[\u0016tGO\u00117pG.TQaY1sKRT1!\u00138u\u0015\u001d)G.Z7f]RTQBS3u\u000bb\u0004(/Z:tS>t\u00077\u0001\u0006\u0003!\tQA\u0001\u0003\u0001\u0011\u0007)!\u0001\"\u0001\t\u0005\u0015\u0011A!\u0001E\u0003\u000b\t!\u0019\u0001C\u0002\u0006\u0007\u0011\u0011\u0001\u0012\u0001\u0007\u0001\u000b\r!)\u0001\u0003\u0001\r\u0001\u0015\t\u0001\u0012B\u0003\u0003\t\u000fAQ!\u0002\u0002\u0005\t!-Qa\u0001C\u0005\u0011\u0011a\u0001!B\u0002\u0005\u000b!\u001dA\u0002A\u0003\u0003\t\u0011A\u0001\"B\u0002\u0005\r!=A\u0002A\u0003\u0004\t\u0019A\u0011\u0002\u0004\u0001\u0006\u0005\u0011!\u0001BC\u0003\u0003\t\u001fA1!B\u0002\u0005\u0011!MA\u0002A\u0003\u0002\u0011\t)1\u0001B\u0005\t\u00171\u0001QA\u0001\u0003\u0007\u0011\u001f)!\u0001\u0002\u0004\t\u0013\u0015\u0011A\u0001\u0003E\n\u000b\r!\u0011\u0002#\u0007\r\u0001\u0015\u0011A!\u0001\u0005\t\u000b\r!A\u0002c\u0007\r\u0001\u0015\u0011A\u0001\u0004E\u000e\t\ra1!G\u0002\u0006\u0003!-\u00014BW6\t-Aj!h\u0004\u0005\u0001!9QbA\u0003\u0002\u0011\u001bAj\u0001U\u0002\u0001;#!\u0001\u0001#\u0005\u000e\t\u0015\t\u0001b\u0002G\u00011\u001d\u00016\u0011AO\b\t\u0001A1!D\u0002\u0006\u0003!E\u0001\u0014\u0003)\u0004\u0003u=A\u0001\u0001E\u000b\u001b\r)\u0011\u0001c\u0005\u0019\u0014A\u001b\u0019!I\u0002\u0006\u0003!M\u00014C)\u0004\u0017\u00115\u0011\"\u0001C\u0001\u001b\u0005A!\"D\u0001\t\u00165\t\u0001bC\u0007\u0002\t\u0003i\u000b\u0005B\u0001\u0019\u0018u=A\u0001\u0001\u0005\r\u001b\r)\u0011\u0001c\u0006\u0019\u0018A\u001b\u0001!h\u0004\u0005\u0001!iQbA\u0003\u0002\u0011\u001bAj\u0001UB\u0001C\u0011)\u0011\u0001#\u0007\r\u0002ae\u0011kA\u0004\u0005\u0018%\t\u0001\"D\u0007\u0002\t\u000bi\u0011\u0001\u0003\u00066\u0019\u0015YAa9\u0001\u0019\r\u0005\u001aQ!\u0001\u0005\u00041\r\t6a\u0001\u0003\u0007\u0013\u0005!\u0001\u0001"})
    public static final class KotlinPlainEnterProcessor
    extends SmartEnterProcessorWithFixers.FixEnterProcessor {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(KotlinPlainEnterProcessor.class);
        }

        private final JetExpression getControlStatementBlock(int caret, PsiElement element2) {
            PsiElement psiElement2 = element2;
            if (psiElement2 instanceof JetDeclarationWithBody) {
                return ((JetDeclarationWithBody)element2).getBodyExpression();
            }
            if (psiElement2 instanceof JetIfExpression) {
                if (FixersUtilKt.isWithCaret((PsiElement)((JetIfExpression)element2).getThen(), caret)) {
                    return ((JetIfExpression)element2).getThen();
                }
                if (FixersUtilKt.isWithCaret((PsiElement)((JetIfExpression)element2).getElse(), caret)) {
                    return ((JetIfExpression)element2).getElse();
                }
            } else if (psiElement2 instanceof JetLoopExpression) {
                return ((JetLoopExpression)element2).getBody();
            }
            return null;
        }

        public boolean doEnter(@NotNull PsiElement atCaret, @Nullable PsiFile file, @NotNull Editor editor, boolean modified) {
            JetBlockExpression block;
            Intrinsics.checkParameterIsNotNull((Object)atCaret, (String)"atCaret");
            Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
            JetExpression jetExpression = this.getControlStatementBlock(editor.getCaretModel().getOffset(), atCaret);
            if (!(jetExpression instanceof JetBlockExpression)) {
                jetExpression = null;
            }
            if ((block = (JetBlockExpression)jetExpression) != null) {
                int n;
                PsiElement firstElement;
                PsiElement psiElement2 = block.getFirstChild();
                Object object = firstElement = psiElement2 != null ? psiElement2.getNextSibling() : null;
                if (firstElement != null) {
                    TextRange textRange = firstElement.getTextRange();
                    if (textRange == null) {
                        Intrinsics.throwNpe();
                    }
                    n = textRange.getStartOffset() - 1;
                } else {
                    TextRange textRange = block.getTextRange();
                    if (textRange == null) {
                        Intrinsics.throwNpe();
                    }
                    n = textRange.getEndOffset();
                }
                int offset2 = n;
                editor.getCaretModel().moveToOffset(offset2);
            }
            this.plainEnter(editor);
            return true;
        }
    }
}

