/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor.fixers;

import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.editor.KotlinSmartEnterHandler;
import org.jetbrains.kotlin.idea.editor.fixers.FixersUtilKt;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetDoWhileExpression;
import org.jetbrains.kotlin.psi.JetExpression;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"e\u0004)\u00112j\u001c;mS:$un\u00165jY\u00164\u0015\u000e_3s\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'\u0002B5eK\u0006Ta!\u001a3ji>\u0014(B\u00024jq\u0016\u00148OC\u0003GSb,'OC\u000fT[\u0006\u0014H/\u00128uKJ\u0004&o\\2fgN|'oV5uQ\u001aK\u00070\u001a:t\u0015\r\u0019w.\u001c\u0006\tS:$X\r\u001c7jU*!A.\u00198h\u0015]Yu\u000e\u001e7j]Nk\u0017M\u001d;F]R,'\u000fS1oI2,'O\u0003\u0004=S:LGO\u0010\u0006\u0006CB\u0004H.\u001f\u0006\u0007\u000b\u0012LGo\u001c:\u000b\u000f=\u0004XM\\1qS*I\u0001O]8dKN\u001cxN\u001d\u0006\u000baNLW\t\\3nK:$(B\u0003)tS\u0016cW-\\3oi*\u0019\u0001o]5\u000b\tUs\u0017\u000e\u001eJ\u0002\u0015\t\u0001\u0012A\u0003\u0003\t\u0001A\u0011!\u0002\u0002\u0005\u0002!\rQA\u0001\u0003\u0002\u0011\t)!\u0001b\u0001\t\u0006\u0015\u0011AA\u0001\u0005\u0004\u000b\r!)\u0001\u0003\u0001\r\u0001\u0015\t\u0001\u0012B\u0003\u0003\t\u000fAQ!\u0002\u0002\u0005\t!-Qa\u0001C\u0005\u0011\u0011a\u0001!B\u0002\u0005\u000b!\u001dA\u0002A\u0003\u0004\t\tAa\u0001\u0004\u0001\u0006\u0005\u0011!\u0001\u0002C\u0003\u0003\t\u001bA)!B\u0002\u0005\u000f!=A\u0002A\u0003\u0003\t\u0011A!\"B\u0002\u0005\u0011!MA\u0002A\u0003\u0002\u0011\u0007)1\u0001B\u0005\t\u00161\u0001QA\u0001\u0003\b\u0011\u001f)!\u0001\u0002\u0002\t\r\u0015\u0011A\u0001\u0003E\n\t\ra1!\u0007\u0005\u0006\u0003!-\u0011\u0002B\u0005\u0004\u000b\u0005Aa\u0001\u0007\u0004\u0019\f5RCa\u0003\r\b;\u001f!\u0001\u0001#\u0002\u000e\u0007\u0015\t\u0001r\u0002M\b!\u000e\u0001Qt\u0002\u0003\u0001\u0011#i1!B\u0001\t\ra1\u0001k!\u0001\u001e\u0010\u0011\u0001\u0001\"C\u0007\u0004\u000b\u0005A\t\u0002'\u0005Q\u0007\u0005\t3!B\u0001\t\u0014aM\u0011kA\u0005\u0005\u000f%\tA\u0001A\u0007\u0002\u0011)i\u0011\u0001#\u0006\u000e\u0003!YQ\u0007D\u0003\f\t\r\b\u0001TB\u0011\u0004\u000b\u0005A1\u0001G\u0002R\u0007\r!i!C\u0001\u0005\u0001\u0001"})
public final class KotlinDoWhileFixer
extends SmartEnterProcessorWithFixers.Fixer<KotlinSmartEnterHandler> {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(KotlinDoWhileFixer.class);
    }

    public void apply(@NotNull Editor editor, @NotNull KotlinSmartEnterHandler processor2, @NotNull PsiElement psiElement2) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)((Object)processor2), (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)psiElement2, (String)"psiElement");
        if (!(psiElement2 instanceof JetDoWhileExpression)) {
            return;
        }
        Document doc = editor.getDocument();
        int start = FixersUtilKt.getStart(FixersUtilKt.getRange(psiElement2));
        JetExpression body2 = ((JetDoWhileExpression)psiElement2).getBody();
        PsiElement whileKeyword = ((JetDoWhileExpression)psiElement2).getWhileKeyword();
        if (body2 == null) {
            if (whileKeyword == null) {
                doc.replaceString(start, start + "do".length(), (CharSequence)"do {} while()");
            } else {
                doc.insertString(start + "do".length(), (CharSequence)"{}");
            }
            return;
        }
        if (whileKeyword != null && !(body2 instanceof JetBlockExpression)) {
            PsiElement psiElement3 = (PsiElement)body2;
            Document document = doc;
            Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"doc");
            int n = FixersUtilKt.startLine(psiElement3, document);
            Document document2 = doc;
            Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"doc");
            if (n > FixersUtilKt.startLine(psiElement2, document2)) {
                doc.insertString(FixersUtilKt.getStart(FixersUtilKt.getRange(whileKeyword)), (CharSequence)"}");
                doc.insertString(start + "do".length(), (CharSequence)"{");
                return;
            }
        }
        if (((JetDoWhileExpression)psiElement2).getCondition() == null) {
            PsiElement lParen = ((JetDoWhileExpression)psiElement2).getLeftParenthesis();
            PsiElement rParen = ((JetDoWhileExpression)psiElement2).getRightParenthesis();
            if (whileKeyword == null) {
                doc.insertString(FixersUtilKt.getEnd(FixersUtilKt.getRange(psiElement2)), (CharSequence)"while()");
            } else if (lParen == null && rParen == null) {
                doc.replaceString(FixersUtilKt.getStart(FixersUtilKt.getRange(whileKeyword)), FixersUtilKt.getEnd(FixersUtilKt.getRange(whileKeyword)), (CharSequence)"while()");
            } else if (lParen != null) {
                processor2.registerUnresolvedError(FixersUtilKt.getEnd(FixersUtilKt.getRange(lParen)));
            }
        }
    }
}

