/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.hierarchy.calls;

import com.google.common.collect.Maps;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.call.CallerMethodsTreeStructure;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.impl.light.LightMemberReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.hierarchy.HierarchyUtils;
import org.jetbrains.kotlin.idea.hierarchy.calls.CalleeReferenceVisitorBase;
import org.jetbrains.kotlin.idea.hierarchy.calls.KotlinCallTreeStructure;
import org.jetbrains.kotlin.idea.references.JetReference;
import org.jetbrains.kotlin.idea.references.ReferencesPackage;
import org.jetbrains.kotlin.idea.search.usagesSearch.UsagesSearchPackage;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetImportDirective;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetPrimaryConstructor;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPropertyAccessor;
import org.jetbrains.kotlin.psi.JetSecondaryConstructor;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

public class KotlinCallerMethodsTreeStructure
extends KotlinCallTreeStructure {
    private final CallerMethodsTreeStructure javaTreeStructure;
    private final PsiClass basePsiClass;

    public KotlinCallerMethodsTreeStructure(@NotNull Project project, @NotNull PsiElement element2, String scopeType) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/hierarchy/calls/KotlinCallerMethodsTreeStructure", "<init>"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/hierarchy/calls/KotlinCallerMethodsTreeStructure", "<init>"));
        }
        super(project, element2, scopeType);
        PsiMethod basePsiMethod = KotlinCallerMethodsTreeStructure.getRepresentativePsiMethod(element2);
        assert (basePsiMethod != null) : "Can't generate light method: " + element2.getText();
        this.basePsiClass = basePsiMethod.getContainingClass();
        this.javaTreeStructure = new CallerMethodsTreeStructure(project, basePsiMethod, scopeType);
    }

    @NotNull
    protected Object[] buildChildren(@NotNull HierarchyNodeDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/idea/hierarchy/calls/KotlinCallerMethodsTreeStructure", "buildChildren"));
        }
        final PsiElement element2 = KotlinCallerMethodsTreeStructure.getTargetElement(descriptor2);
        JetElement codeBlockForLocalDeclaration = KotlinCallerMethodsTreeStructure.getEnclosingElementForLocalDeclaration(element2);
        if (codeBlockForLocalDeclaration != null) {
            BindingContext bindingContext2 = ResolutionUtils.analyze((JetElement)element2, BodyResolveMode.FULL);
            com.intellij.util.containers.HashMap referencesToElements = new com.intellij.util.containers.HashMap();
            codeBlockForLocalDeclaration.accept(new CalleeReferenceVisitorBase(bindingContext2, true, (Map)referencesToElements){
                final /* synthetic */ Map val$referencesToElements;
                {
                    this.val$referencesToElements = map2;
                    super(x0, x1);
                }

                @Override
                protected void processDeclaration(JetSimpleNameExpression reference, PsiElement declaration) {
                    if (!declaration.equals(element2)) {
                        return;
                    }
                    PsiElement container2 = PsiTreeUtil.getParentOfType((PsiElement)reference, (Class[])new Class[]{JetNamedFunction.class, JetPropertyAccessor.class, JetClassOrObject.class});
                    if (container2 instanceof JetPropertyAccessor) {
                        container2 = PsiTreeUtil.getParentOfType((PsiElement)container2, JetProperty.class);
                    }
                    if (container2 != null) {
                        this.val$referencesToElements.put(ReferencesPackage.getMainReference(reference), container2);
                    }
                }
            });
            Object[] objectArray = this.collectNodeDescriptors(descriptor2, (Map<PsiReference, PsiElement>)referencesToElements, null);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/hierarchy/calls/KotlinCallerMethodsTreeStructure", "buildChildren"));
            }
            return objectArray;
        }
        SearchScope searchScope2 = this.getSearchScope(this.scopeType, (PsiElement)this.basePsiClass);
        HashMap methodToDescriptorMap = Maps.newHashMap();
        Object[] javaCallers = null;
        if (element2 instanceof PsiMethod) {
            javaCallers = this.javaTreeStructure.getChildElements((Object)KotlinCallerMethodsTreeStructure.getJavaNodeDescriptor(descriptor2));
            this.processPsiMethodCallers(Collections.singleton((PsiMethod)element2), descriptor2, methodToDescriptorMap, searchScope2, true);
        }
        if (element2 instanceof JetNamedFunction || element2 instanceof JetSecondaryConstructor) {
            List<PsiMethod> lightMethods = LightClassUtil.INSTANCE$.getLightClassMethods((JetFunction)element2);
            this.processPsiMethodCallers(lightMethods, descriptor2, methodToDescriptorMap, searchScope2, false);
        }
        if (element2 instanceof JetProperty) {
            LightClassUtil.PropertyAccessorsPsiMethods propertyMethods2 = LightClassUtil.INSTANCE$.getLightClassPropertyMethods((JetProperty)element2);
            this.processPsiMethodCallers(propertyMethods2, descriptor2, methodToDescriptorMap, searchScope2, false);
        }
        if (element2 instanceof JetClassOrObject) {
            JetPrimaryConstructor constructor = ((JetClassOrObject)element2).getPrimaryConstructor();
            if (constructor != null) {
                PsiMethod lightMethod = LightClassUtil.INSTANCE$.getLightClassMethod(constructor);
                this.processPsiMethodCallers(Collections.singleton(lightMethod), descriptor2, methodToDescriptorMap, searchScope2, false);
            } else {
                this.processJetClassOrObjectCallers((JetClassOrObject)element2, descriptor2, methodToDescriptorMap, searchScope2);
            }
        }
        Object[] callers = methodToDescriptorMap.values().toArray(new Object[methodToDescriptorMap.size()]);
        Object[] objectArray = javaCallers != null ? ArrayUtil.mergeArrays((Object[])javaCallers, (Object[])callers) : callers;
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/hierarchy/calls/KotlinCallerMethodsTreeStructure", "buildChildren"));
        }
        return objectArray;
    }

    private void processPsiMethodCallers(Iterable<PsiMethod> lightMethods, HierarchyNodeDescriptor descriptor2, Map<PsiElement, HierarchyNodeDescriptor> methodToDescriptorMap, SearchScope searchScope2, boolean kotlinOnly) {
        HashSet<PsiMethod> methodsToFind = new HashSet<PsiMethod>();
        for (PsiMethod lightMethod : lightMethods) {
            if (lightMethod == null) continue;
            Object[] superMethods = lightMethod.findDeepestSuperMethods();
            methodsToFind.add(lightMethod);
            ContainerUtil.addAll(methodsToFind, (Object[])superMethods);
        }
        if (methodsToFind.isEmpty()) {
            return;
        }
        THashSet references = ContainerUtil.newTroveSet((TObjectHashingStrategy)new TObjectHashingStrategy<PsiReference>(){

            public int computeHashCode(PsiReference object) {
                return object.getElement().hashCode();
            }

            public boolean equals(PsiReference o1, PsiReference o2) {
                return o1.getElement().equals(o2.getElement());
            }
        });
        for (PsiMethod superMethod : methodsToFind) {
            ContainerUtil.addAll((Collection)references, (Iterable)MethodReferencesSearch.search((PsiMethod)superMethod, (SearchScope)searchScope2, (boolean)true));
        }
        ContainerUtil.process((Iterable)references, this.defaultQueryProcessor(descriptor2, methodToDescriptorMap, kotlinOnly));
    }

    private void processJetClassOrObjectCallers(final JetClassOrObject classOrObject, HierarchyNodeDescriptor descriptor2, Map<PsiElement, HierarchyNodeDescriptor> methodToDescriptorMap, SearchScope searchScope2) {
        FilteringProcessor processor2 = new FilteringProcessor((Condition)new Condition<PsiReference>(){

            public boolean value(PsiReference reference) {
                return UsagesSearchPackage.isConstructorUsage(reference, classOrObject);
            }
        }, this.defaultQueryProcessor(descriptor2, methodToDescriptorMap, false));
        ReferencesSearch.search((PsiElement)classOrObject, (SearchScope)searchScope2, (boolean)false).forEach((Processor)processor2);
    }

    private Processor<PsiReference> defaultQueryProcessor(final HierarchyNodeDescriptor descriptor2, final Map<PsiElement, HierarchyNodeDescriptor> methodToDescriptorMap, boolean kotlinOnly) {
        return new CalleeReferenceProcessor(kotlinOnly){

            @Override
            protected void onAccept(@NotNull PsiReference ref, @NotNull PsiElement element2) {
                if (ref == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/kotlin/idea/hierarchy/calls/KotlinCallerMethodsTreeStructure$4", "onAccept"));
                }
                if (element2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/hierarchy/calls/KotlinCallerMethodsTreeStructure$4", "onAccept"));
                }
                KotlinCallerMethodsTreeStructure.this.addNodeDescriptorForElement(ref, element2, methodToDescriptorMap, descriptor2);
            }
        };
    }

    public static abstract class CalleeReferenceProcessor
    extends ReadActionProcessor<PsiReference> {
        private final boolean kotlinOnly;

        public CalleeReferenceProcessor(boolean only) {
            this.kotlinOnly = only;
        }

        public boolean processInReadAction(PsiReference ref) {
            JetProperty property;
            PsiElement refElement;
            if (!(ref instanceof PsiReferenceExpression) && !(ref instanceof JetReference)) {
                if (!(ref instanceof PsiElement)) {
                    return true;
                }
                PsiElement parent = ((PsiElement)ref).getParent();
                if (parent instanceof PsiNewExpression) {
                    if (((PsiNewExpression)parent).getClassReference() != ref) {
                        return true;
                    }
                } else if (parent instanceof PsiAnonymousClass) {
                    if (((PsiAnonymousClass)parent).getBaseClassReference() != ref) {
                        return true;
                    }
                } else if (ref instanceof LightMemberReference) {
                    PsiElement refTarget = ref.resolve();
                    if (!(refTarget instanceof PsiMethod) || !((PsiMethod)refTarget).isConstructor()) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)(refElement = ref.getElement()), JetImportDirective.class, (boolean)true) != null) {
                return true;
            }
            PsiElement element2 = HierarchyUtils.getCallHierarchyElement(refElement);
            if (this.kotlinOnly && !(element2 instanceof JetNamedDeclaration)) {
                return true;
            }
            if (element2 instanceof JetProperty && PsiTreeUtil.isAncestor((PsiElement)(property = (JetProperty)element2).getInitializer(), (PsiElement)refElement, (boolean)false)) {
                element2 = HierarchyUtils.getCallHierarchyElement(element2.getParent());
            }
            if (element2 != null) {
                this.onAccept(ref, element2);
            }
            return true;
        }

        protected abstract void onAccept(@NotNull PsiReference var1, @NotNull PsiElement var2);
    }
}

