/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.highlighter.AfterAnalysisHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.JetHighlightingColors;
import org.jetbrains.kotlin.idea.highlighter.JetPsiChecker;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.JetDelegatorToSuperCall;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetReferenceExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetTypeElement;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetUserType;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.TasksPackage;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;

public class FunctionsHighlightingVisitor
extends AfterAnalysisHighlightingVisitor {
    public FunctionsHighlightingVisitor(AnnotationHolder holder, BindingContext bindingContext2) {
        super(holder, bindingContext2);
    }

    @Override
    public void visitNamedFunction(@NotNull JetNamedFunction function2) {
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/idea/highlighter/FunctionsHighlightingVisitor", "visitNamedFunction"));
        }
        PsiElement nameIdentifier = function2.getNameIdentifier();
        if (nameIdentifier != null) {
            JetPsiChecker.highlightName(this.holder, nameIdentifier, JetHighlightingColors.FUNCTION_DECLARATION);
        }
        super.visitNamedFunction(function2);
    }

    @Override
    public void visitDelegationToSuperCallSpecifier(@NotNull JetDelegatorToSuperCall call) {
        JetSimpleNameExpression nameExpression;
        JetTypeElement typeElement;
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/idea/highlighter/FunctionsHighlightingVisitor", "visitDelegationToSuperCallSpecifier"));
        }
        JetConstructorCalleeExpression calleeExpression = call.getCalleeExpression();
        JetTypeReference typeRef = calleeExpression.getTypeReference();
        if (typeRef != null && (typeElement = typeRef.getTypeElement()) instanceof JetUserType && (nameExpression = ((JetUserType)typeElement).getReferenceExpression()) != null) {
            JetPsiChecker.highlightName(this.holder, (PsiElement)nameExpression, JetHighlightingColors.CONSTRUCTOR_CALL);
        }
        super.visitDelegationToSuperCallSpecifier(call);
    }

    @Override
    public void visitCallExpression(@NotNull JetCallExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/highlighter/FunctionsHighlightingVisitor", "visitCallExpression"));
        }
        JetExpression callee = expression2.getCalleeExpression();
        ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage.getResolvedCall(expression2, this.bindingContext);
        if (callee instanceof JetReferenceExpression && resolvedCall != null) {
            CallableDescriptor calleeDescriptor = resolvedCall.getResultingDescriptor();
            if (TasksPackage.isDynamic(calleeDescriptor)) {
                JetPsiChecker.highlightName(this.holder, (PsiElement)callee, JetHighlightingColors.DYNAMIC_FUNCTION_CALL);
            } else if (resolvedCall instanceof VariableAsFunctionResolvedCall) {
                JetPsiChecker.highlightName(this.holder, (PsiElement)callee, FunctionsHighlightingVisitor.containedInFunctionClassOrSubclass(calleeDescriptor) ? JetHighlightingColors.VARIABLE_AS_FUNCTION_CALL : JetHighlightingColors.VARIABLE_AS_FUNCTION_LIKE_CALL);
            } else if (calleeDescriptor instanceof ConstructorDescriptor) {
                JetPsiChecker.highlightName(this.holder, (PsiElement)callee, JetHighlightingColors.CONSTRUCTOR_CALL);
            } else if (calleeDescriptor instanceof FunctionDescriptor) {
                FunctionDescriptor fun2 = (FunctionDescriptor)calleeDescriptor;
                JetPsiChecker.highlightName(this.holder, (PsiElement)callee, JetHighlightingColors.FUNCTION_CALL);
                if (DescriptorUtils.isTopLevelDeclaration(fun2)) {
                    JetPsiChecker.highlightName(this.holder, (PsiElement)callee, JetHighlightingColors.PACKAGE_FUNCTION_CALL);
                }
                if (fun2.getExtensionReceiverParameter() != null) {
                    JetPsiChecker.highlightName(this.holder, (PsiElement)callee, JetHighlightingColors.EXTENSION_FUNCTION_CALL);
                }
            }
        }
        super.visitCallExpression(expression2);
    }

    private static boolean containedInFunctionClassOrSubclass(DeclarationDescriptor calleeDescriptor) {
        DeclarationDescriptor parent = calleeDescriptor.getContainingDeclaration();
        if (!(parent instanceof ClassDescriptor)) {
            return false;
        }
        JetType defaultType2 = ((ClassDescriptor)parent).getDefaultType();
        if (KotlinBuiltIns.isFunctionOrExtensionFunctionType(defaultType2)) {
            return true;
        }
        for (JetType supertype : TypeUtils.getAllSupertypes(defaultType2)) {
            if (!KotlinBuiltIns.isFunctionOrExtensionFunctionType(supertype)) continue;
            return true;
        }
        return false;
    }
}

