/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.highlighter.HighlighterPackage;
import org.jetbrains.kotlin.idea.highlighter.JetPsiChecker;
import org.jetbrains.kotlin.idea.inspections.UnusedSymbolInspection;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetParameter;

public class JetPsiCheckerAndHighlightingUpdater
extends JetPsiChecker {
    @Override
    public void annotate(@NotNull PsiElement element2, @NotNull AnnotationHolder holder) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/highlighter/JetPsiCheckerAndHighlightingUpdater", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/kotlin/idea/highlighter/JetPsiCheckerAndHighlightingUpdater", "annotate"));
        }
        try {
            super.annotate(element2, holder);
            if (element2 instanceof JetFile) {
                HighlighterPackage.updateHighlightingResult((JetFile)element2, false);
            }
        }
        catch (ProcessCanceledException e) {
            HighlighterPackage.updateHighlightingResult((JetFile)element2.getContainingFile(), false);
            throw e;
        }
    }

    @Override
    protected boolean shouldSuppressUnusedParameter(@NotNull JetParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/idea/highlighter/JetPsiCheckerAndHighlightingUpdater", "shouldSuppressUnusedParameter"));
        }
        PsiElement grandParent = parameter.getParent().getParent();
        if (grandParent instanceof JetNamedFunction) {
            JetNamedFunction function2 = (JetNamedFunction)grandParent;
            return UnusedSymbolInspection.Companion.isEntryPoint(function2);
        }
        return false;
    }
}

