/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.highlighter.JetHighlightingColors;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetFunctionLiteralExpression;
import org.jetbrains.kotlin.psi.JetVisitorVoid;

class SoftKeywordsHighlightingVisitor
extends JetVisitorVoid {
    private final AnnotationHolder holder;

    SoftKeywordsHighlightingVisitor(AnnotationHolder holder) {
        this.holder = holder;
    }

    public void visitElement(PsiElement element2) {
        if (element2 instanceof LeafPsiElement) {
            IElementType elementType = ((LeafPsiElement)element2).getElementType();
            if (JetTokens.SOFT_KEYWORDS.contains(elementType)) {
                TextAttributesKey attributes = JetHighlightingColors.KEYWORD;
                if (JetTokens.MODIFIER_KEYWORDS.contains(elementType)) {
                    attributes = JetHighlightingColors.BUILTIN_ANNOTATION;
                }
                this.holder.createInfoAnnotation(element2, null).setTextAttributes(attributes);
            }
            if (((Object)((Object)JetTokens.SAFE_ACCESS)).equals(elementType)) {
                this.holder.createInfoAnnotation(element2, null).setTextAttributes(JetHighlightingColors.SAFE_ACCESS);
            }
        }
    }

    @Override
    public void visitFunctionLiteralExpression(@NotNull JetFunctionLiteralExpression expression2) {
        PsiElement arrow;
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/highlighter/SoftKeywordsHighlightingVisitor", "visitFunctionLiteralExpression"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        JetFunctionLiteral functionLiteral = expression2.getFunctionLiteral();
        this.holder.createInfoAnnotation(functionLiteral.getLBrace(), null).setTextAttributes(JetHighlightingColors.FUNCTION_LITERAL_BRACES_AND_ARROW);
        PsiElement closingBrace = functionLiteral.getRBrace();
        if (closingBrace != null) {
            this.holder.createInfoAnnotation(closingBrace, null).setTextAttributes(JetHighlightingColors.FUNCTION_LITERAL_BRACES_AND_ARROW);
        }
        if ((arrow = functionLiteral.getArrow()) != null) {
            this.holder.createInfoAnnotation(arrow, null).setTextAttributes(JetHighlightingColors.FUNCTION_LITERAL_BRACES_AND_ARROW);
        }
    }
}

