/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter.markers;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.CommonClassNames;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetSecondaryConstructor;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"2\u0004)A2m\u001c7mK\u000e$8i\u001c8uC&t\u0017N\\4DY\u0006\u001c8/Z:\u000b\u000f5,G\u000f[8eg*Q1i\u001c7mK\u000e$\u0018n\u001c8\u000b\r-|G\u000f\\5o\u0015%\u00016/['fi\"|GMC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\u0004aNL'bA*fi*A\u0001k]5DY\u0006\u001c8O\u0003\u0003kCZ\f'\u0002B;uS2TaBS1wCB\u001b\u0018.\u0016;jYN\\EOC\u0006hKR\u00046/[\"mCN\u001c(bB3mK6,g\u000e\u001e\u0006\u000b!NLW\t\\3nK:$(\u0002D4fiB\u001b\u0018.T3uQ>$GM\u0003\u0002\u0011\u0007)1\u0001\u0002\u0001\t\u00031\u0001Q!\u0001E\u0003\u000b\t!\u0011\u0001C\u0002\u0006\u0005\u0011\r\u0001rA\u0003\u0004\t\tA!\u0001\u0004\u0001\u0006\u0007\u0011\u0001\u0001\u0002\u0002\u0007\u0001\u000b\r!!\u0001#\u0003\r\u0001\u0015\t\u0001\"B\u0003\u0003\t\u0011AY!\u0002\u0002\u0005\n!!QA\u0001C\u0005\u0011\u0005)1\u0001\u0002\u0002\t\u00101\u0001QA\u0001\u0003\u0003\u0011\u0013)!\u0001\u0002\u0002\t\u0010\u0015\u0011AA\u0001\u0005\u0003\u000b\u0003\"1\u0001\u0007\u0001\u001e\u001a\u0011\u0001\u0001\u0012A\u0007\t\u000b\u0005A\t!\u0003\u0003\n\u0007\u0015\t\u0001R\u0001M\u00031\u0003\u00016\u0001A\u0011\t\u000b\u0005A1!\u0003\u0003\n\u0007\u0015\t\u0001r\u0001M\u00041\r\t6!\u0002\u0003\u0001\u0013\u0005AQ!D\u0001\t\fa\u001ba!\"\r\u0005\u0003a5Q\u0014\u0003\u0003\u0001\u0011\u001diA!B\u0001\t\r1\u0005\u0001D\u0002)\u0004\u0001\u0005\"Q!\u0001E\u0004\u0019\u0003A:!U\u0002\u0006\t\u001bI\u0011\u0001#\u0004\u000e\u0003!9\u0001l\u0001\u0004\u00062\u0011\t\u0001\u0004CO\t\t\u0001Aq!\u0004\u0003\u0006\u0003!1A\u0012\u0001\r\u0007!\u000e\u0001\u0011\u0005B\u0003\u0002\u0011\u000ba\t\u0001'\u0002R\u0007\u0015!\u0001\"C\u0001\t\u00105\t\u0001b\u0002-\u0004\r\u0001"})
public final class JavaPsiUtilsKt {
    @NotNull
    public static final Set<PsiClass> collectContainingClasses(@NotNull Collection<? extends PsiMethod> methods2) {
        Intrinsics.checkParameterIsNotNull(methods2, (String)"methods");
        HashSet<PsiClass> classes2 = new HashSet<PsiClass>();
        for (PsiMethod psiMethod : methods2) {
            ProgressManager.checkCanceled();
            PsiClass parentClass2 = psiMethod.getContainingClass();
            if (parentClass2 == null || !(Intrinsics.areEqual((Object)CommonClassNames.JAVA_LANG_OBJECT, (Object)parentClass2.getQualifiedName()) ^ true)) continue;
            classes2.add(parentClass2);
        }
        return classes2;
    }

    @Nullable
    public static final PsiClass getPsiClass(@Nullable PsiElement element2) {
        PsiClass psiClass;
        if (element2 == null) {
            psiClass = null;
        } else if (element2 instanceof PsiClass) {
            psiClass = (PsiClass)element2;
        } else if (element2 instanceof JetClass) {
            psiClass = LightClassUtil.INSTANCE$.getPsiClass((JetClassOrObject)element2);
        } else if (element2.getParent() instanceof JetClass) {
            PsiElement psiElement2 = element2.getParent();
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.JetClass");
            }
            psiClass = LightClassUtil.INSTANCE$.getPsiClass((JetClass)psiElement2);
        } else {
            psiClass = null;
        }
        return psiClass;
    }

    @Nullable
    public static final PsiMethod getPsiMethod(@Nullable PsiElement element2) {
        PsiMethod psiMethod;
        PsiElement parent;
        PsiElement psiElement2 = element2;
        Object object = parent = psiElement2 != null ? psiElement2.getParent() : null;
        if (element2 == null) {
            psiMethod = null;
        } else if (element2 instanceof PsiMethod) {
            psiMethod = (PsiMethod)element2;
        } else if (parent instanceof JetNamedFunction || parent instanceof JetSecondaryConstructor) {
            PsiElement psiElement3 = parent;
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.JetFunction");
            }
            psiMethod = LightClassUtil.INSTANCE$.getLightClassMethod((JetFunction)psiElement3);
        } else {
            psiMethod = null;
        }
        return psiMethod;
    }
}

