/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.intentions.JetSelfTargetingIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetContainerNode;
import org.jetbrains.kotlin.psi.JetDoWhileExpression;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.JetPsiFactoryKt;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"\u001a\u0006))\"+Z7pm\u0016\u0014%/Y2fg&sG/\u001a8uS>t'bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\u0007W>$H.\u001b8\u000b\t%$W-\u0019\u0006\u000bS:$XM\u001c;j_:\u001c(\"\u0007&fiN+GN\u001a+be\u001e,G/\u001b8h\u0013:$XM\u001c;j_:T!CS3u\u00052|7m[#yaJ,7o]5p]*\u0019\u0001o]5\u000b\rqJg.\u001b;?\u0015\u001d\t\u0007\u000f\u001d7z)>Tq!\u001a7f[\u0016tGO\u0003\u0004fI&$xN\u001d\u0006\u0007\u000b\u0012LGo\u001c:\u000b\u0007\r|WN\u0003\u0005j]R,G\u000e\\5k\u0015\u001dy\u0007/\u001a8ba&TA!\u00168ji*q\u0001.\u00198eY\u0016\u001cu.\\7f]R\u001c(\"C2p]N$(/^2u\u00155QU\r^#yaJ,7o]5p]*)!\r\\8dW*q\u0011n]!qa2L7-\u00192mKR{'bC2be\u0016$xJ\u001a4tKRT1!\u00138u\u0015\u001d\u0011un\u001c7fC:t\u0019A\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\t!\u0011\u0001\u0003\u0002\u0006\u0005\u0011\r\u0001RA\u0003\u0004\t\tA\u0001\u0001\u0004\u0001\u0006\u0007\u0011\u0011\u0001b\u0001\u0007\u0001\u000b\t!\u0011\u0001\u0003\u0003\u0006\u0007\u0011\u001d\u0001r\u0001\u0007\u0001\u000b\u0005Aq!\u0002\u0002\u0005\n!=QA\u0001\u0003\u0006\u0011!)!\u0001b\u0003\t\r\u0015\u0019AA\u0002E\u0007\u0019\u0001)\u0011\u0001c\u0001\u0006\u0007\u00119\u0001\u0012\u0003\u0007\u0001\u000b\t!9\u0001c\u0002\u0006\u0005\u00111\u0001RB\u0003\u0004\t\u000fA!\u0002\u0004\u0001\u0006\u0005\u0011\u001d\u0001BC\u0003\u0004\t\u001dAA\u0002\u0004\u0001\u0006\u0007\u00119\u0001\u0012\u0004\u0007\u0001\t\ra)!\u0007\u0005\u0006\u0003!\u0019\u0011\u0002B\u0005\u0004\u000b\u0005AA\u0001\u0007\u0003\u0019\u00075~Ba\u0003\r\u0006;\u001f!\u0001\u0001c\u0003\u000e\u0007\u0015\t\u0001\u0002\u0002\r\u0005!\u000e\u0001Qt\u0002\u0003\u0001\u0011\u0019i1!B\u0001\t\u000ea5\u0001k!\u0001\"\u0007\u0015\t\u0001r\u0002M\b#\u000e9A!B\u0005\u0002\t\u0001i\u0011\u0001\u0003\u0005\u000e\u0003!EQv\b\u0003\u00021%iz\u0001\u0002\u0001\t\u00145\u0019Q!\u0001\u0005\n1%\u00016\u0001AO\b\t\u0001A)\"D\u0002\u0006\u0003!!\u0001\u0004\u0002)\u0004\u0002\u0005\u001aQ!\u0001E\b1\u001f\t6a\u0002\u0003\n\u0013\u0005!\u0001!D\u0001\t\u00145\t\u0001\u0002CW \t-A2\"h\u0004\u0005\u0001!-QbA\u0003\u0002\u0011\u0011AB\u0001U\u0002\u0001;\u001f!\u0001\u0001c\u0006\u000e\u0007\u0015\t\u0001B\u0003\r\u000b!\u000e\u0005\u0011eA\u0003\u0002\u0011+A*\"U\u0002\b\t-I\u0011\u0001\"\u0001\u000e\u0003!AQ\"\u0001C\u0003k1)1\u0002Br\u00011\u0013\t3!B\u0001\t\u0006a\u0015\u0011kA\u0002\u0005\n%\tA\u0001\u0001"})
public final class RemoveBracesIntention
extends JetSelfTargetingIntention<JetBlockExpression> {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(RemoveBracesIntention.class);
    }

    @Override
    public boolean isApplicableTo(@NotNull JetBlockExpression element2, int caretOffset) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (element2.getStatements().size() != 1) {
            return false;
        }
        PsiElement psiElement2 = element2.getParent();
        if (!(psiElement2 instanceof JetContainerNode)) {
            psiElement2 = null;
        }
        JetContainerNode jetContainerNode = (JetContainerNode)psiElement2;
        if (jetContainerNode == null) {
            return false;
        }
        JetContainerNode containerNode = jetContainerNode;
        PsiElement psiElement3 = element2.getLBrace();
        if (psiElement3 == null) {
            return false;
        }
        PsiElement lBrace = psiElement3;
        PsiElement psiElement4 = element2.getRBrace();
        if (psiElement4 == null) {
            return false;
        }
        PsiElement rBrace = psiElement4;
        if (!lBrace.getTextRange().containsOffset(caretOffset) && !rBrace.getTextRange().containsOffset(caretOffset)) {
            return false;
        }
        String string = UtilsKt.description(containerNode);
        if (string == null) {
            return false;
        }
        String description = string;
        this.setText("Remove braces from '" + description + "' statement");
        return true;
    }

    @Override
    public void applyTo(@NotNull JetBlockExpression element2, @NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        JetExpression statement = (JetExpression)KotlinPackage.single(element2.getStatements());
        PsiElement psiElement2 = element2.getParent();
        if (psiElement2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.JetContainerNode");
        }
        JetContainerNode containerNode = (JetContainerNode)psiElement2;
        PsiElement psiElement3 = containerNode.getParent();
        if (psiElement3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.JetExpression");
        }
        JetExpression construct = (JetExpression)psiElement3;
        this.handleComments(construct, element2);
        PsiElement psiElement4 = statement.copy();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"statement.copy()");
        PsiElement newElement = element2.replace(psiElement4);
        if (construct instanceof JetDoWhileExpression) {
            PsiElement psiElement5 = newElement.getParent();
            if (psiElement5 == null) {
                Intrinsics.throwNpe();
            }
            psiElement5.addAfter(JetPsiFactoryKt.JetPsiFactory((PsiElement)element2).createNewLine(), newElement);
        }
    }

    private final void handleComments(JetExpression construct, JetBlockExpression block) {
        PsiElement sibling;
        PsiElement psiElement2 = block.getFirstChild();
        Object object = sibling = psiElement2 != null ? psiElement2.getNextSibling() : null;
        while (sibling != null) {
            if (sibling instanceof PsiComment) {
                JetPsiFactory psiFactory = JetPsiFactoryKt.JetPsiFactory((PsiElement)construct);
                if (construct.getPrevSibling() instanceof PsiWhiteSpace) {
                    PsiElement psiElement3 = construct.getPrevSibling();
                    if (psiElement3 == null) {
                        Intrinsics.throwNpe();
                    }
                    psiElement3.replace(psiFactory.createNewLine());
                }
                PsiElement psiElement4 = construct.getParent();
                if (psiElement4 == null) {
                    Intrinsics.throwNpe();
                }
                PsiElement commentElement = psiElement4.addBefore(sibling, construct.getPrevSibling());
                PsiElement psiElement5 = construct.getParent();
                if (psiElement5 == null) {
                    Intrinsics.throwNpe();
                }
                psiElement5.addBefore(psiFactory.createNewLine(), commentElement);
            }
            sibling = sibling.getNextSibling();
        }
    }

    public RemoveBracesIntention() {
        super(JetBlockExpression.class, "Remove braces", null, 4, null);
    }
}

