/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.internal.makeBackup;

import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.RevisionsCollector;
import com.intellij.history.core.revisions.Difference;
import com.intellij.history.core.revisions.Revision;
import com.intellij.history.core.tree.RootEntry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryImpl;
import com.intellij.history.integration.patches.PatchCreator;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.io.ZipUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipOutputStream;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.internal.makeBackup.CreateIncrementalCompilationBackup;
import org.jetbrains.kotlin.idea.internal.makeBackup.MakeBackupCompileTaskKt;
import org.jetbrains.kotlin.idea.internal.makeBackup.MakeBackupKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"V\u0006)\u00113I]3bi\u0016Len\u0019:f[\u0016tG/\u00197D_6\u0004\u0018\u000e\\1uS>t')Y2lkBT1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\u0005S\u0012,\u0017M\u0003\u0005j]R,'O\\1m\u0015)i\u0017m[3CC\u000e\\W\u000f\u001d\u0006\t\u0003:\f5\r^5p]*\u00191m\\7\u000b\u0011%tG/\u001a7mS*Tqa\u001c9f]\u0006\u0004\u0018N\u0003\u0007bGRLwN\\*zgR,WN\u0003\u0004=S:LGO\u0010\u0006\u0010C\u000e$\u0018n\u001c8QKJ4wN]7fI*\tQMC\u0007B]\u0006\u001bG/[8o\u000bZ,g\u000e\u001e\u0006\u0005+:LGO\u0003\u0005d_BLHj\\4t\u0015%\u0011\u0017mY6va\u0012K'O\u0003\u0003GS2,'\u0002\u00026bm\u0006T!![8\u000b\u0013%tG-[2bi>\u0014(\"\u0005)s_\u001e\u0014Xm]:J]\u0012L7-\u0019;pe*A\u0001O]8he\u0016\u001c8OC\u0007de\u0016\fG/\u001a)bi\u000eDWm\u001d\u0006\baJ|'.Z2u\u0015\u001d\u0001&o\u001c6fGRTa!\u001e9eCR,'\"\u0004>jaB\u0013xN[3di\u0012K'O\u0003\u0006qe>TWm\u0019;ESJT\u0011bQ8na\u0006t\u0017n\u001c8#\u0004)\u0011\u0001#\u0001\u0006\u0005\u0011\u0001\u0001\"A\u0003\u0003\t\u0003A\u0019!\u0002\u0002\u0005\u0003!\u0011QA\u0001C\u0002\u0011\u000b)!\u0001\u0002\u0002\t\u0007\u0015\u0019AQ\u0001\u0005\u0001\u0019\u0001)\u0011\u0001\u0003\u0003\u0006\u0005\u0011\u001d\u0001\u0012B\u0003\u0003\t\u0011AQ!\u0002\u0002\u0005\n!-Qa\u0001\u0003\u0006\u0011\u000fa\u0001!B\u0002\u0005\u000b!=A\u0002A\u0003\u0002\u0011\u0007)1\u0001\"\u0004\t\u00111\u0001QA\u0001\u0003\u0006\u0011\u001f)\u0011\u0001\u0003\u0006\u0006\u0005\u0011A\u0001RC\u0003\u0004\t#A\u0019\u0002\u0004\u0001\u0006\u0005\u0011%\u0001\u0002D\u0003\u0004\t'A9\u0002\u0004\u0001\u0006\u0005\u0011E\u00012C\u0003\u0003\t'A9\"\u0002\u0002\u0005\n!iQa\u0001C\f\u00117a\u0001!\u0002\u0002\u0005\u0018!mAa\u0001\u0007\u0004!?I2!B\u0001\t\fa-Q\u0014a\b.+\u0011Y\u0001TBO\b\t\u0001Aq!D\u0002\u0006\u0003!1\u0001D\u0002)\u0004\u0001\u0005\u001aQ!\u0001\u0005\b1\u001d\t6!\u0002C\u0007\u0013\u0005!\u0001!D\u0001\t\u00105~B!\u0001M\t;\u001f!\u0001\u0001C\u0005\u000e\u0007\u0015\t\u0001\"\u0003\r\n!\u000e\u0001Qt\u0002\u0003\u0001\u0011-i1!B\u0001\t\u0015aQ\u0001k!\u0001\"\u0007\u0015\t\u0001b\u0002\r\b#\u000e9A\u0011C\u0005\u0002\t\u0001i\u0011\u0001#\u0006\u000e\u0003!YQF\u000b\u0003\u000213iz\u0001\u0002\u0001\t\u00135\u0019Q!\u0001\u0005\n1%\u00016\u0001AO\b\t\u0001AQ\"D\u0002\u0006\u0003!a\u0001\u0004\u0004)\u0004\u0002u=A\u0001\u0001\u0005\f\u001b\r)\u0011\u0001\u0003\u0006\u0019\u0015A\u001b\u0011!I\u0002\u0006\u0003!9\u0001dB)\u0004\u0013\u0011e\u0011\"\u0001\u0003\u0001\u001b\u0005A)\"D\u0001\t\u001a5\t\u0001bC\u0017\u0016\t-Ab\"h\u0004\u0005\u0001!9QbA\u0003\u0002\u0011\u0019Ab\u0001U\u0002\u0001C\r)\u0011\u0001C\u0004\u0019\u000fE\u001bQ\u0001\u0002\b\n\u0003\u0011\u0001Q\"\u0001E\b[S\"\u0011\u0001'\b\u001e\u0010\u0011\u0001\u0001\"C\u0007\u0004\u000b\u0005A\u0011\u0002G\u0005Q\u0007\u0001iz\u0001\u0002\u0001\t\u001b5\u0019Q!\u0001\u0005\r11\u00016\u0011AO\b\t\u0001Aq\"D\u0002\u0006\u0003!I\u0001$\u0003)\u0004\u0003u=A\u0001\u0001\u0005\f\u001b\r)\u0011\u0001\u0003\u0006\u0019\u0015A\u001b\u0019!I\u0002\u0006\u0003!9\u0001dB)\u0004\u0017\u0011u\u0011\"\u0001\u0003\u0001\u001b\u0005A)\"D\u0001\t\u001a5\t\u0001RC\u0007\u0002\u0011-)D\"B\u0006\u0005G\u0004Ab!I\u0002\u0006\u0003!\u0019\u0001dA)\u0004\u0007\u00111\u0011\"\u0001\u0003\u0001"})
public final class CreateIncrementalCompilationBackup
extends AnAction {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    public static final String BACKUP_DIR_NAME = ".backup";
    public static final int PATCHES_TO_CREATE = 5;
    public static final double PATCHES_FRACTION = 0.25;
    public static final double LOGS_FRACTION = 0.05;
    public static final double ZIP_FRACTION = 0.7;
    public static final Companion Companion;

    static {
        $kotlinClass = Reflection.createKotlinClass(CreateIncrementalCompilationBackup.class);
        Companion companion = Companion = new Companion(null);
        BACKUP_DIR_NAME = BACKUP_DIR_NAME;
        PATCHES_TO_CREATE = 5;
        PATCHES_FRACTION = 0.25;
        LOGS_FRACTION = 0.05;
        ZIP_FRACTION = 1.0 - Companion.getPATCHES_FRACTION() - Companion.getLOGS_FRACTION();
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Project project = e.getProject();
        if (project == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"e.getProject()!!");
        presentation.setVisible(MakeBackupCompileTaskKt.incrementalCompilationEnabled(project));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            Intrinsics.throwNpe();
        }
        Project project2 = project;
        VirtualFile virtualFile = project2.getBaseDir();
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        File projectBaseDir = new File(virtualFile.getPath());
        File backupDir = new File(FileUtil.createTempDirectory((String)"makeBackup", (String)null), Companion.getBACKUP_DIR_NAME());
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this, backupDir, project2, projectBaseDir, project2, "Creating backup for debugging Kotlin incremental compilation", true){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ CreateIncrementalCompilationBackup this$0;
            final /* synthetic */ File $backupDir;
            final /* synthetic */ Project $project;
            final /* synthetic */ File $projectBaseDir;

            static {
                $kotlinClass = Reflection.createKotlinClass(actionPerformed.1.class);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                Project project = this.$project;
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                CreateIncrementalCompilationBackup.access$createPatches$0(this.this$0, this.$backupDir, project, indicator);
                CreateIncrementalCompilationBackup.access$copyLogs$1(this.this$0, this.$backupDir, indicator);
                Project project2 = this.$project;
                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
                CreateIncrementalCompilationBackup.access$zipProjectDir$2(this.this$0, this.$backupDir, project2, this.$projectBaseDir, indicator);
            }
            {
                this.this$0 = $outer;
                this.$backupDir = $captured_local_variable$1;
                this.$project = $captured_local_variable$2;
                this.$projectBaseDir = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }
        });
    }

    private final void createPatches(File backupDir, Project project, ProgressIndicator indicator) {
        ApplicationUtilsKt.runReadAction((Function0)new Function0<Unit>(project, backupDir, indicator){
            final /* synthetic */ Project $project;
            final /* synthetic */ File $backupDir;
            final /* synthetic */ ProgressIndicator $indicator;

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                LocalHistoryImpl localHistoryImpl = LocalHistoryImpl.getInstanceImpl();
                if (localHistoryImpl == null) {
                    Intrinsics.throwNpe();
                }
                LocalHistoryImpl localHistoryImpl2 = localHistoryImpl;
                IdeaGateway ideaGateway = localHistoryImpl2.getGateway();
                if (ideaGateway == null) {
                    Intrinsics.throwNpe();
                }
                IdeaGateway gateway = ideaGateway;
                LocalHistoryFacade localHistoryFacade = localHistoryImpl2.getFacade();
                RootEntry rootEntry = gateway.createTransientRootEntry();
                VirtualFile virtualFile = this.$project.getBaseDir();
                if (virtualFile == null) {
                    Intrinsics.throwNpe();
                }
                RevisionsCollector revisionsCollector = new RevisionsCollector(localHistoryFacade, rootEntry, virtualFile.getPath(), this.$project.getLocationHash(), (String)null);
                int patchesCreated = 0;
                File patchesDir = new File(this.$backupDir, "patches");
                patchesDir.mkdirs();
                List list = revisionsCollector.getResult();
                if (list == null) {
                    Intrinsics.throwNpe();
                }
                List revisions = list;
                for (Revision rev : revisions) {
                    void destination;
                    void $receiver;
                    void $receiver2;
                    List differences;
                    String label = rev.getLabel();
                    if (label == null || !KotlinPackage.startsWith$default((String)label, (String)MakeBackupKt.getHISTORY_LABEL_PREFIX(), (boolean)false, (int)2)) continue;
                    File patchFile = new File(patchesDir, KotlinPackage.removePrefix((String)label, (String)MakeBackupKt.getHISTORY_LABEL_PREFIX()) + ".patch");
                    this.$indicator.setText("Creating patch " + patchFile);
                    this.$indicator.setFraction(CreateIncrementalCompilationBackup.Companion.getPATCHES_FRACTION() * (double)patchesCreated / (double)CreateIncrementalCompilationBackup.Companion.getPATCHES_TO_CREATE());
                    if (((Revision)revisions.get(0)).getDifferencesWith(rev) == null) {
                        Intrinsics.throwNpe();
                    }
                    Iterable iterable = differences;
                    void var15_15 = $receiver2;
                    Collection collection = new ArrayList<E>(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
                    for (T item : $receiver) {
                        void d;
                        Difference difference = (Difference)item;
                        void var20_20 = destination;
                        Change change = new Change(d.getLeftContentRevision(gateway), d.getRightContentRevision(gateway));
                        var20_20.add(change);
                    }
                    List changes = (List)destination;
                    PatchCreator.create((Project)this.$project, (List)changes, (String)patchFile.getPath(), (boolean)false, (CommitContext)null);
                    if (++patchesCreated < CreateIncrementalCompilationBackup.Companion.getPATCHES_TO_CREATE()) continue;
                    break;
                }
            }
            {
                this.$project = project;
                this.$backupDir = file;
                this.$indicator = progressIndicator;
                super(0);
            }
        });
    }

    private final void copyLogs(File backupDir, ProgressIndicator indicator) {
        indicator.setText("Copying logs");
        indicator.setFraction(Companion.getPATCHES_FRACTION());
        File logsDir = new File(backupDir, "logs");
        FileUtil.copyDir((File)new File(PathManager.getLogPath()), (File)logsDir);
        indicator.setFraction(Companion.getPATCHES_FRACTION() + Companion.getLOGS_FRACTION());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void zipProjectDir(File backupDir, Project project, File projectDir, ProgressIndicator indicator) {
        Object processedBytes;
        void $receiver;
        Object totalBytes;
        ArrayList files = new ArrayList();
        Ref.LongRef longRef = new Ref.LongRef();
        longRef.element = 0L;
        Object[] objectArray = new File[2];
        objectArray[0] = projectDir;
        File file = backupDir.getParentFile();
        if (file == null) {
            Intrinsics.throwNpe();
        }
        objectArray[1] = file;
        for (File dir : KotlinPackage.listOf((Object[])objectArray)) {
            FileUtil.processFilesRecursively((File)dir, (Processor)((Processor)new Processor<File>(indicator, files, dir, totalBytes){
                final /* synthetic */ ProgressIndicator $indicator;
                final /* synthetic */ ArrayList $files;
                final /* synthetic */ File $dir;
                final /* synthetic */ Ref.LongRef $totalBytes;

                public final boolean process(File it) {
                    File file = it;
                    if (file == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!(!file.isFile() || KotlinPackage.endsWith$default((String)it.getName(), (String)".hprof", (boolean)false, (int)2) || KotlinPackage.startsWith$default((String)it.getName(), (String)"make_backup_", (boolean)false, (int)2) && KotlinPackage.endsWith$default((String)it.getName(), (String)".zip", (boolean)false, (int)2))) {
                        this.$indicator.setText("Scanning project dir: " + it);
                        String string = FileUtil.getRelativePath((File)this.$dir, (File)it);
                        if (string == null) {
                            Intrinsics.throwNpe();
                        }
                        this.$files.add(new Pair((Object)it, (Object)string));
                        this.$totalBytes.element += it.length();
                    }
                    return true;
                }
                {
                    this.$indicator = progressIndicator;
                    this.$files = arrayList;
                    this.$dir = file;
                    this.$totalBytes = longRef;
                }
            }), (Processor)zipProjectDir.2.INSTANCE$);
        }
        File backupFile = new File(projectDir, "make_backup_" + new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date()) + ".zip");
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(backupFile));
        Ref.LongRef longRef2 = new Ref.LongRef();
        longRef2.element = 0L;
        Closeable closeable = zos;
        boolean closed = false;
        try {
            ZipOutputStream it = (ZipOutputStream)$receiver;
            for (Pair pair2 : files) {
                File file2 = (File)pair2.component1();
                String relativePath = (String)pair2.component2();
                indicator.setText("Adding file to backup: " + relativePath);
                indicator.setFraction(Companion.getPATCHES_FRACTION() + Companion.getLOGS_FRACTION() + (double)processedBytes.element / (double)totalBytes.element * Companion.getZIP_FRACTION());
                ZipUtil.addFileToZip((ZipOutputStream)zos, (File)file2, (String)relativePath, (Set)null, (FileFilter)null);
                processedBytes.element += file2.length();
            }
            it = Unit.INSTANCE$;
        }
        catch (Exception e) {
            closed = true;
            try {
                $receiver.close();
            }
            catch (Exception closeException) {
                // empty catch block
            }
            throw (Throwable)e;
        }
        finally {
            if (!closed) {
                $receiver.close();
            }
        }
        FileUtil.delete((File)backupDir);
        WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)new Runnable(project, backupFile){
            final /* synthetic */ Project $project;
            final /* synthetic */ File $backupFile;

            public final void run() {
                ShowFilePathAction.showDialog((Project)this.$project, (String)("Successfully created backup " + this.$backupFile.getAbsolutePath()), (String)"Created backup", (File)this.$backupFile, (DialogWrapper.DoNotAskOption)null);
            }
            {
                this.$project = project;
                this.$backupFile = file;
            }
        }, (ModalityState)null, (Project)project);
        processedBytes = null;
        totalBytes = null;
    }

    public CreateIncrementalCompilationBackup() {
        super("Create backup for debugging Kotlin incremental compilation");
    }

    public static final /* synthetic */ void access$createPatches$0(CreateIncrementalCompilationBackup $this, @NotNull File backupDir, @NotNull Project project, @NotNull ProgressIndicator indicator) {
        $this.createPatches(backupDir, project, indicator);
    }

    public static final /* synthetic */ void access$copyLogs$1(CreateIncrementalCompilationBackup $this, @NotNull File backupDir, @NotNull ProgressIndicator indicator) {
        $this.copyLogs(backupDir, indicator);
    }

    public static final /* synthetic */ void access$zipProjectDir$2(CreateIncrementalCompilationBackup $this, @NotNull File backupDir, @NotNull Project project, @NotNull File projectDir, @NotNull ProgressIndicator indicator) {
        $this.zipProjectDir(backupDir, project, projectDir, indicator);
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"?\u0006)I1i\\7qC:LwN\u001c\u0006#\u0007J,\u0017\r^3J]\u000e\u0014X-\\3oi\u0006d7i\\7qS2\fG/[8o\u0005\u0006\u001c7.\u001e9\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:TA!\u001b3fC*A\u0011N\u001c;fe:\fGN\u0003\u0006nC.,')Y2lkBT1!\u00118z\u0015=\u0011\u0015iQ&V!~#\u0015JU0O\u00036+%BB*ue&twM\u0003\u0003kCZ\f'\u0002\u00027b]\u001eT!cZ3u\u0005\u0006\u001b5*\u0016)`\t&\u0013vLT!N\u000b*iAjT$T?\u001a\u0013\u0016i\u0011+J\u001f:Sa\u0001R8vE2,'\u0002E4fi2{uiU0G%\u0006\u001bE+S(O\u0015A\u0001\u0016\tV\"I\u000bN{fIU!D)&{eJC\nhKR\u0004\u0016\tV\"I\u000bN{fIU!D)&{eJC\tQ\u0003R\u001b\u0005*R*`)>{6IU#B)\u0016S1!\u00138u\u0015Q9W\r\u001e)B)\u000eCUiU0U\u001f~\u001b%+R!U\u000b*a!,\u0013)`\rJ\u000b5\tV%P\u001d*yq-\u001a;[\u0013B{fIU!D)&{eJ\u001a\u0006\u0003!\tQA\u0001\u0003\u0001\u0011\u0007)!\u0001\"\u0001\t\u0005\u0015\u0011A!\u0001E\u0003\u000b\t!\u0019\u0001C\u0002\u0006\u0005\u0011\u0011\u0001rA\u0003\u0004\t\u000bA\t\u0001\u0004\u0001\u0006\u0007\u0011\u0019\u0001\u0002\u0001\u0007\u0001\u000b\u0005A!!B\u0002\u0005\t!!A\u0002A\u0003\u0004\t\u0011AQ\u0001\u0004\u0001\u0006\u0003!-QA\u0001C\u0006\u0011\u0019)!\u0001\u0002\u0004\t\u000b\u0015\u0019A\u0001\u0002E\b\u0019\u0001)1\u0001\u0002\u0003\t\u00151\u0001Aaq\u0001\r\be\u0019Q!\u0001E\u00051\u0013i\u0013\u0003B2\u00151\u0013\t3!B\u0001\t\u000ba)QkA\u0005\u0006\t\u0011%\u0011\"\u0001E\u0007\u0019\u0003i1\u0001\"\u0004\n\u0003!5Q&\u0005\u0003d)a9\u0011eA\u0003\u0002\u0011\u001dAr!V\u0002\n\u000b\u0011!q!C\u0001\u0005\t1\u0005Qb\u0001\u0003\t\u0013\u0005!A!L\t\u0005GRA\n\"I\u0002\u0006\u0003!9\u0001dB+\u0004\u0013\u0015!A\u0011C\u0005\u0002\t\u0011a\t!D\u0002\u0005\u0013%\tA\u0001B\u0017\u0012\t\r$\u00024C\u0011\u0004\u000b\u0005Ay\u0001g\u0004V\u0007%)A\u0001b\u0005\n\u0003\u0011\u0015A\u0012A\u0007\u0004\t+I\u0011\u0001\"\u0002.#\u0011\u0019G\u0003G\u0006\"\u0007\u0015\t\u0001b\u0002\r\b+\u000eIQ\u0001\u0002\u0003\f\u0013\u0005!A\u0001$\u0001\u000e\u0007\u0011]\u0011\"\u0001\u0003\u0005k\u0001\u0001"})
    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        @NotNull
        public final String getBACKUP_DIR_NAME() {
            return BACKUP_DIR_NAME;
        }

        public final int getPATCHES_TO_CREATE() {
            return PATCHES_TO_CREATE;
        }

        public final double getPATCHES_FRACTION() {
            return PATCHES_FRACTION;
        }

        public final double getLOGS_FRACTION() {
            return LOGS_FRACTION;
        }

        public final double getZIP_FRACTION() {
            return ZIP_FRACTION;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

