/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.liveTemplates.macro;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.overrideImplement.ImplementMembersHandler;
import org.jetbrains.kotlin.psi.JetReferenceExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

class AnonymousTemplateEditingListener
extends TemplateEditingAdapter {
    private JetReferenceExpression classRef;
    private ClassDescriptor classDescriptor;
    private final Editor editor;
    private final PsiFile psiFile;
    private static final Map<Editor, AnonymousTemplateEditingListener> ourAddedListeners = new HashMap<Editor, AnonymousTemplateEditingListener>();

    public AnonymousTemplateEditingListener(PsiFile psiFile, Editor editor) {
        this.psiFile = psiFile;
        this.editor = editor;
    }

    public void currentVariableChanged(TemplateState templateState, Template template, int oldIndex, int newIndex) {
        JetReferenceExpression ref;
        DeclarationDescriptor descriptor2;
        assert (templateState.getTemplate() != null);
        TextRange variableRange = templateState.getVariableRange("SUPERTYPE");
        if (variableRange == null) {
            return;
        }
        PsiElement name2 = this.psiFile.findElementAt(variableRange.getStartOffset());
        if (name2 != null && name2.getParent() instanceof JetReferenceExpression && (descriptor2 = ResolutionUtils.analyze(ref = (JetReferenceExpression)name2.getParent(), BodyResolveMode.FULL).get(BindingContext.REFERENCE_TARGET, ref)) instanceof ClassDescriptor) {
            this.classRef = ref;
            this.classDescriptor = (ClassDescriptor)descriptor2;
        }
    }

    public void templateFinished(Template template, boolean brokenOff) {
        ourAddedListeners.remove(this.editor);
        if (this.classDescriptor != null) {
            if (this.classDescriptor.getKind() == ClassKind.CLASS) {
                int placeToInsert = this.classRef.getTextRange().getEndOffset();
                PsiDocumentManager.getInstance((Project)this.psiFile.getProject()).getDocument(this.psiFile).insertString(placeToInsert, (CharSequence)"()");
                boolean hasConstructorsParameters = false;
                for (ConstructorDescriptor cd : this.classDescriptor.getConstructors()) {
                    hasConstructorsParameters |= cd.getValueParameters().size() != 0;
                }
                if (hasConstructorsParameters) {
                    this.editor.getCaretModel().moveToOffset(placeToInsert + 1);
                }
            }
            new ImplementMembersHandler().invoke(this.psiFile.getProject(), this.editor, this.psiFile, true);
        }
    }

    static void registerListener(Editor editor, Project project) {
        if (ourAddedListeners.containsKey(editor)) {
            return;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        assert (psiFile != null);
        TemplateState templateState = TemplateManagerImpl.getTemplateState((Editor)editor);
        if (templateState != null) {
            AnonymousTemplateEditingListener listener2 = new AnonymousTemplateEditingListener(psiFile, editor);
            ourAddedListeners.put(editor, listener2);
            templateState.addTemplateStateListener((TemplateEditingListener)listener2);
        }
    }
}

