/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.projectView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.AbstractPsiBasedNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import org.jetbrains.kotlin.idea.JetIconProvider;
import org.jetbrains.kotlin.idea.projectView.JetFileTreeNode;
import org.jetbrains.kotlin.idea.projectView.JetProjectViewUtil;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetModifierListOwner;
import org.jetbrains.kotlin.psi.JetPsiUtil;

public class JetClassOrObjectTreeNode
extends AbstractPsiBasedNode<JetClassOrObject> {
    protected JetClassOrObjectTreeNode(Project project, JetClassOrObject jetClassOrObject, ViewSettings viewSettings) {
        super(project, (Object)jetClassOrObject, viewSettings);
    }

    protected PsiElement extractPsiFromValue() {
        return (PsiElement)this.getValue();
    }

    protected Collection<AbstractTreeNode> getChildrenImpl() {
        return JetProjectViewUtil.getClassOrObjectChildren((JetClassOrObject)this.getValue(), this.getProject(), this.getSettings());
    }

    private void update(AbstractTreeNode node) {
        Project project = this.getProject();
        if (project != null) {
            ProjectView.getInstance((Project)project).getCurrentProjectViewPane().getTreeBuilder().addSubtreeToUpdateByElement((Object)node);
        }
    }

    protected void updateImpl(PresentationData data2) {
        JetClassOrObject classOrObject = (JetClassOrObject)this.getValue();
        if (classOrObject != null) {
            data2.setPresentableText(classOrObject.getName());
            AbstractTreeNode parent = this.getParent();
            if (JetIconProvider.getMainClass(classOrObject.getContainingJetFile()) != null) {
                if (parent instanceof JetFileTreeNode) {
                    this.update(parent.getParent());
                }
            } else if (!(parent instanceof JetClassOrObjectTreeNode) && !(parent instanceof JetFileTreeNode)) {
                this.update(parent);
            }
        }
    }

    protected boolean isDeprecated() {
        return JetPsiUtil.isDeprecated((JetModifierListOwner)this.getValue());
    }

    public boolean canRepresent(Object element2) {
        if (!this.isValid()) {
            return false;
        }
        return super.canRepresent(element2) || JetProjectViewUtil.canRepresentPsiElement((PsiElement)this.getValue(), element2, this.getSettings());
    }

    public int getWeight() {
        return 20;
    }
}

