/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.projectView;

import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.kotlin.idea.projectView.JetClassOrObjectTreeNode;
import org.jetbrains.kotlin.idea.projectView.JetDeclarationTreeNode;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclaration;

public final class JetProjectViewUtil {
    private JetProjectViewUtil() {
    }

    public static Collection<AbstractTreeNode> getClassOrObjectChildren(JetClassOrObject classOrObject, Project project, ViewSettings settings) {
        if (classOrObject != null && settings.isShowMembers()) {
            ArrayList<AbstractTreeNode> result2 = new ArrayList<AbstractTreeNode>();
            List<JetDeclaration> declarations2 = classOrObject.getDeclarations();
            for (JetDeclaration declaration : declarations2) {
                if (declaration instanceof JetClassOrObject) {
                    result2.add((AbstractTreeNode)new JetClassOrObjectTreeNode(project, (JetClassOrObject)declaration, settings));
                    continue;
                }
                result2.add((AbstractTreeNode)new JetDeclarationTreeNode(project, declaration, settings));
            }
            return result2;
        }
        return Collections.emptyList();
    }

    public static boolean canRepresentPsiElement(PsiElement value2, Object element2, ViewSettings settings) {
        PsiFile elementFile;
        if (value2 == null || !value2.isValid()) {
            return false;
        }
        PsiFile file = value2.getContainingFile();
        if (file != null && (file == element2 || file.getVirtualFile() == element2)) {
            return true;
        }
        if (value2 == element2) {
            return true;
        }
        if (!settings.isShowMembers() && element2 instanceof PsiElement && ((PsiElement)element2).getContainingFile() != null && (elementFile = ((PsiElement)element2).getContainingFile()) != null && file != null) {
            return elementFile.equals(file);
        }
        return false;
    }
}

