/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.quickfix.JetIntentionAction;
import org.jetbrains.kotlin.idea.quickfix.JetSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.PsiPackage;

public class AddFunctionBodyFix
extends JetIntentionAction<JetFunction> {
    public AddFunctionBodyFix(@NotNull JetFunction element2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/quickfix/AddFunctionBodyFix", "<init>"));
        }
        super(element2);
    }

    @NotNull
    public String getText() {
        String string = JetBundle.message("add.function.body", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/AddFunctionBodyFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JetBundle.message("add.function.body", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/AddFunctionBodyFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/AddFunctionBodyFix", "isAvailable"));
        }
        return super.isAvailable(project, editor, file) && !((JetFunction)this.element).hasBody();
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, JetFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/AddFunctionBodyFix", "invoke"));
        }
        JetFunction newElement = (JetFunction)((JetFunction)this.element).copy();
        JetPsiFactory psiFactory = PsiPackage.JetPsiFactory((PsiElement)file);
        if (!(newElement.getLastChild() instanceof PsiWhiteSpace)) {
            newElement.add(psiFactory.createWhiteSpace());
        }
        if (!newElement.hasBody()) {
            newElement.add((PsiElement)psiFactory.createEmptyBody());
        }
        ((JetFunction)this.element).replace(newElement);
    }

    public static JetSingleIntentionActionFactory createFactory() {
        return new JetSingleIntentionActionFactory(){

            @Override
            @Nullable
            public JetIntentionAction createAction(Diagnostic diagnostic) {
                PsiElement element2 = diagnostic.getPsiElement();
                JetFunction function2 = (JetFunction)PsiTreeUtil.getParentOfType((PsiElement)element2, JetFunction.class, (boolean)false);
                if (function2 == null) {
                    return null;
                }
                return new AddFunctionBodyFix(function2);
            }
        };
    }
}

