/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.actions.JetAddFunctionToClassifierAction;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.quickfix.JetHintAction;
import org.jetbrains.kotlin.idea.quickfix.JetIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.JetSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;

public class AddFunctionToSupertypeFix
extends JetHintAction<JetNamedFunction> {
    private final List<FunctionDescriptor> functionsToAdd;

    public AddFunctionToSupertypeFix(JetNamedFunction element2) {
        super(element2);
        this.functionsToAdd = AddFunctionToSupertypeFix.generateFunctionsToAdd(element2);
    }

    private static List<FunctionDescriptor> generateFunctionsToAdd(JetNamedFunction functionElement) {
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)ResolutionUtils.resolveToDescriptor(functionElement);
        DeclarationDescriptor containingDeclaration = functionDescriptor.getContainingDeclaration();
        if (!(containingDeclaration instanceof ClassDescriptor)) {
            return Collections.emptyList();
        }
        ArrayList functions2 = Lists.newArrayList();
        ClassDescriptor classDescriptor = (ClassDescriptor)containingDeclaration;
        for (ClassDescriptor supertypeDescriptor : AddFunctionToSupertypeFix.getSupertypes(classDescriptor)) {
            if (KotlinBuiltIns.isAnyOrNullableAny(supertypeDescriptor.getDefaultType())) continue;
            functions2.add(AddFunctionToSupertypeFix.generateFunctionSignatureForType(functionDescriptor, supertypeDescriptor));
        }
        return functions2;
    }

    private static List<ClassDescriptor> getSupertypes(ClassDescriptor classDescriptor) {
        ArrayList supertypes2 = Lists.newArrayList(TypeUtils.getAllSupertypes(classDescriptor.getDefaultType()));
        Collections.sort(supertypes2, new Comparator<JetType>(){

            @Override
            public int compare(JetType o1, JetType o2) {
                if (((Object)o1).equals(o2)) {
                    return 0;
                }
                if (JetTypeChecker.DEFAULT.isSubtypeOf(o1, o2)) {
                    return -1;
                }
                if (JetTypeChecker.DEFAULT.isSubtypeOf(o2, o1)) {
                    return 1;
                }
                return o1.toString().compareTo(o2.toString());
            }
        });
        ArrayList supertypesDescriptors = Lists.newArrayList();
        for (JetType supertype : supertypes2) {
            supertypesDescriptors.add(DescriptorUtils.getClassDescriptorForType(supertype));
        }
        return supertypesDescriptors;
    }

    private static FunctionDescriptor generateFunctionSignatureForType(FunctionDescriptor functionDescriptor, ClassDescriptor typeDescriptor) {
        Modality modality = typeDescriptor.getModality();
        if (typeDescriptor.getKind() == ClassKind.INTERFACE) {
            modality = Modality.OPEN;
        }
        return functionDescriptor.copy(typeDescriptor, modality, functionDescriptor.getVisibility(), CallableMemberDescriptor.Kind.DECLARATION, false);
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/AddFunctionToSupertypeFix", "isAvailable"));
        }
        return super.isAvailable(project, editor, file) && !this.functionsToAdd.isEmpty();
    }

    public boolean showHint(Editor editor) {
        return false;
    }

    @NotNull
    public String getText() {
        if (this.functionsToAdd.size() == 1) {
            FunctionDescriptor newFunction = this.functionsToAdd.get(0);
            ClassDescriptor supertype = (ClassDescriptor)newFunction.getContainingDeclaration();
            String string = JetBundle.message("add.function.to.type.action.single", IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES.render(newFunction), supertype.getName().toString());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/AddFunctionToSupertypeFix", "getText"));
            }
            return string;
        }
        String string = JetBundle.message("add.function.to.supertype.action.multiple", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/AddFunctionToSupertypeFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JetBundle.message("add.function.to.supertype.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/AddFunctionToSupertypeFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    protected void invoke(final @NotNull Project project, final Editor editor, final JetFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/AddFunctionToSupertypeFix", "invoke"));
        }
        CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(){

            @Override
            public void run() {
                AddFunctionToSupertypeFix.this.createAction(project, editor, file).execute();
            }
        });
    }

    @NotNull
    private JetAddFunctionToClassifierAction createAction(Project project, Editor editor, JetFile file) {
        JetAddFunctionToClassifierAction jetAddFunctionToClassifierAction = new JetAddFunctionToClassifierAction(project, editor, this.functionsToAdd);
        if (jetAddFunctionToClassifierAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/AddFunctionToSupertypeFix", "createAction"));
        }
        return jetAddFunctionToClassifierAction;
    }

    public static JetIntentionActionsFactory createFactory() {
        return new JetSingleIntentionActionFactory(){

            @Override
            @Nullable
            public IntentionAction createAction(Diagnostic diagnostic) {
                JetNamedFunction function2 = QuickFixUtil.getParentElementOfType(diagnostic, JetNamedFunction.class);
                return function2 == null ? null : new AddFunctionToSupertypeFix(function2);
            }
        };
    }
}

