/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.quickfix.JetIntentionAction;
import org.jetbrains.kotlin.idea.quickfix.JetSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetQualifiedExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetThisExpression;
import org.jetbrains.kotlin.psi.PsiPackage;

public class ChangeToBackingFieldFix
extends JetIntentionAction<JetSimpleNameExpression> {
    public ChangeToBackingFieldFix(@NotNull JetSimpleNameExpression element2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/quickfix/ChangeToBackingFieldFix", "<init>"));
        }
        super(element2);
    }

    @NotNull
    public String getText() {
        String string = JetBundle.message("change.to.backing.field", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeToBackingFieldFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JetBundle.message("change.to.backing.field", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeToBackingFieldFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, JetFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/ChangeToBackingFieldFix", "invoke"));
        }
        JetSimpleNameExpression backingField = (JetSimpleNameExpression)PsiPackage.JetPsiFactory((PsiElement)file).createExpression("$" + ((JetSimpleNameExpression)this.element).getText());
        ((JetSimpleNameExpression)this.element).replace((PsiElement)backingField);
    }

    public static JetSingleIntentionActionFactory createFactory() {
        return new JetSingleIntentionActionFactory(){

            @Override
            public JetIntentionAction<JetSimpleNameExpression> createAction(Diagnostic diagnostic) {
                JetExpression selector;
                PsiElement element2;
                JetSimpleNameExpression expression2 = QuickFixUtil.getParentElementOfType(diagnostic, JetSimpleNameExpression.class);
                if (expression2 == null && (element2 = diagnostic.getPsiElement()) instanceof JetQualifiedExpression && ((JetQualifiedExpression)element2).getReceiverExpression() instanceof JetThisExpression && (selector = ((JetQualifiedExpression)element2).getSelectorExpression()) instanceof JetSimpleNameExpression) {
                    expression2 = (JetSimpleNameExpression)selector;
                }
                if (expression2 == null) {
                    return null;
                }
                return new ChangeToBackingFieldFix(expression2);
            }
        };
    }
}

