/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.quickfix.ChangeFunctionReturnTypeFix;
import org.jetbrains.kotlin.idea.quickfix.JetIntentionAction;
import org.jetbrains.kotlin.idea.quickfix.JetIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.JetSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.ShortenReferences;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetMultiDeclarationEntry;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPropertyAccessor;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetVariableDeclaration;
import org.jetbrains.kotlin.psi.PsiPackage;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;

public class ChangeVariableTypeFix
extends JetIntentionAction<JetVariableDeclaration> {
    private static final Logger LOG = Logger.getInstance(ChangeVariableTypeFix.class);
    private final JetType type;

    public ChangeVariableTypeFix(@NotNull JetVariableDeclaration element2, @NotNull JetType type2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix", "<init>"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix", "<init>"));
        }
        super(element2);
        this.type = type2;
    }

    @NotNull
    public String getText() {
        String propertyName = ((JetVariableDeclaration)this.element).getName();
        FqName fqName2 = ((JetVariableDeclaration)this.element).getFqName();
        if (fqName2 != null) {
            propertyName = fqName2.asString();
        }
        String string = JetBundle.message("change.element.type", propertyName, IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES.renderType(this.type));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JetBundle.message("change.type.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix", "isAvailable"));
        }
        return super.isAvailable(project, editor, file) && !ErrorUtils.containsErrorType(this.type);
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, JetFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix", "invoke"));
        }
        JetPsiFactory psiFactory = PsiPackage.JetPsiFactory((PsiElement)file);
        PsiElement nameIdentifier = ((JetVariableDeclaration)this.element).getNameIdentifier();
        assert (nameIdentifier != null) : "ChangeVariableTypeFix applied to variable without name";
        JetTypeReference replacingTypeReference = psiFactory.createType(IdeDescriptorRenderers.SOURCE_CODE.renderType(this.type));
        ArrayList<JetTypeReference> toShorten = new ArrayList<JetTypeReference>();
        toShorten.add(((JetVariableDeclaration)this.element).setTypeReference(replacingTypeReference));
        if (this.element instanceof JetProperty) {
            JetTypeReference setterParameterTypeRef;
            JetPropertyAccessor setter;
            JetTypeReference getterReturnTypeRef;
            JetPropertyAccessor getter = ((JetProperty)this.element).getGetter();
            JetTypeReference jetTypeReference = getterReturnTypeRef = getter == null ? null : getter.getReturnTypeReference();
            if (getterReturnTypeRef != null) {
                toShorten.add((JetTypeReference)getterReturnTypeRef.replace((PsiElement)replacingTypeReference));
            }
            JetParameter setterParameter = (setter = ((JetProperty)this.element).getSetter()) == null ? null : setter.getParameter();
            JetTypeReference jetTypeReference2 = setterParameterTypeRef = setterParameter == null ? null : setterParameter.getTypeReference();
            if (setterParameterTypeRef != null) {
                toShorten.add((JetTypeReference)setterParameterTypeRef.replace((PsiElement)replacingTypeReference));
            }
        }
        ShortenReferences.DEFAULT.process(toShorten);
    }

    @NotNull
    public static JetSingleIntentionActionFactory createFactoryForComponentFunctionReturnTypeMismatch() {
        JetSingleIntentionActionFactory jetSingleIntentionActionFactory = new JetSingleIntentionActionFactory(){

            @Override
            @Nullable
            public IntentionAction createAction(@NotNull Diagnostic diagnostic) {
                if (diagnostic == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix$1", "createAction"));
                }
                JetMultiDeclarationEntry entry = ChangeFunctionReturnTypeFix.getMultiDeclarationEntryThatTypeMismatchComponentFunction(diagnostic);
                BindingContext context = ResolutionUtils.analyze(entry);
                ResolvedCall<FunctionDescriptor> resolvedCall = context.get(BindingContext.COMPONENT_RESOLVED_CALL, entry);
                if (resolvedCall == null) {
                    return null;
                }
                JetFunction componentFunction = (JetFunction)DescriptorToSourceUtils.descriptorToDeclaration(resolvedCall.getCandidateDescriptor());
                if (componentFunction == null) {
                    return null;
                }
                JetType expectedType = resolvedCall.getCandidateDescriptor().getReturnType();
                return expectedType == null ? null : new ChangeVariableTypeFix(entry, expectedType);
            }
        };
        if (jetSingleIntentionActionFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix", "createFactoryForComponentFunctionReturnTypeMismatch"));
        }
        return jetSingleIntentionActionFactory;
    }

    @NotNull
    public static JetIntentionActionsFactory createFactoryForPropertyOrReturnTypeMismatchOnOverride() {
        JetIntentionActionsFactory jetIntentionActionsFactory = new JetIntentionActionsFactory(){

            @Override
            @NotNull
            protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
                if (diagnostic == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix$2", "doCreateActions"));
                }
                LinkedList<IntentionAction> actions = new LinkedList<IntentionAction>();
                if (diagnostic.getPsiElement() instanceof JetProperty) {
                    PsiElement overriddenProperty;
                    JetProperty property = (JetProperty)diagnostic.getPsiElement();
                    DeclarationDescriptor descriptor2 = ResolutionUtils.resolveToDescriptor(property);
                    if (!(descriptor2 instanceof PropertyDescriptor)) {
                        LinkedList<IntentionAction> linkedList = actions;
                        if (linkedList == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix$2", "doCreateActions"));
                        }
                        return linkedList;
                    }
                    PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor2;
                    JetType lowerBoundOfOverriddenPropertiesTypes = QuickFixUtil.findLowerBoundOfOverriddenCallablesReturnTypes(propertyDescriptor);
                    JetType propertyType = propertyDescriptor.getReturnType();
                    assert (propertyType != null) : "Property type cannot be null if it mismatch something";
                    LinkedList<PropertyDescriptor> overriddenMismatchingProperties = new LinkedList<PropertyDescriptor>();
                    boolean canChangeOverriddenPropertyType = true;
                    for (PropertyDescriptor propertyDescriptor2 : propertyDescriptor.getOverriddenDescriptors()) {
                        JetType overriddenPropertyType = propertyDescriptor2.getReturnType();
                        if (overriddenPropertyType == null) continue;
                        if (!JetTypeChecker.DEFAULT.isSubtypeOf(propertyType, overriddenPropertyType)) {
                            overriddenMismatchingProperties.add(propertyDescriptor2);
                        } else if (propertyDescriptor2.isVar() && !JetTypeChecker.DEFAULT.equalTypes(overriddenPropertyType, propertyType)) {
                            canChangeOverriddenPropertyType = false;
                        }
                        if (!propertyDescriptor2.isVar() || lowerBoundOfOverriddenPropertiesTypes == null || JetTypeChecker.DEFAULT.equalTypes(lowerBoundOfOverriddenPropertiesTypes, overriddenPropertyType)) continue;
                        lowerBoundOfOverriddenPropertiesTypes = null;
                    }
                    if (lowerBoundOfOverriddenPropertiesTypes != null) {
                        actions.add(new ChangeVariableTypeFix(property, lowerBoundOfOverriddenPropertiesTypes));
                    }
                    if (overriddenMismatchingProperties.size() == 1 && canChangeOverriddenPropertyType && (overriddenProperty = DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)overriddenMismatchingProperties.get(0))) instanceof JetProperty) {
                        actions.add(new ChangeVariableTypeFix((JetProperty)overriddenProperty, propertyType));
                    }
                }
                LinkedList<IntentionAction> linkedList = actions;
                if (linkedList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix$2", "doCreateActions"));
                }
                return linkedList;
            }
        };
        if (jetIntentionActionsFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix", "createFactoryForPropertyOrReturnTypeMismatchOnOverride"));
        }
        return jetIntentionActionsFactory;
    }
}

