/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinPackage;
import kotlin.Sequence;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.quickfix.DeprecatedSyntaxFix;
import org.jetbrains.kotlin.idea.quickfix.LambdaToFunctionExpression;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.ShortenReferences;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetFunctionLiteralArgument;
import org.jetbrains.kotlin.psi.JetFunctionLiteralExpression;
import org.jetbrains.kotlin.psi.JetLabeledExpression;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetParameterList;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.JetPsiFactoryKt;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetReturnExpression;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.JetPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.JetType;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"\u0018\n)QB*Y7cI\u0006$vNR;oGRLwN\\#yaJ,7o]5p]*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgN\u0003\u0003jI\u0016\f'\u0002C9vS\u000e\\g-\u001b=\u000b'\u0011+\u0007O]3dCR,GmU=oi\u0006Dh)\u001b=\u000b\rqJg.\u001b;?\u0015e1WO\\2uS>tG*\u001b;fe\u0006dW\t\u001f9sKN\u001c\u0018n\u001c8\u000b9)+GOR;oGRLwN\u001c'ji\u0016\u0014\u0018\r\\#yaJ,7o]5p]*\u0019\u0001o]5\u000b7\u0019,hn\u0019;j_:d\u0015\u000e^3sC2\f%oZ;nK:$h*Y7f\u0015\u0011q\u0015-\\3\u000b\t9\fW.\u001a\u0006\u001fO\u0016$h)\u001e8di&|g\u000eT5uKJ\fG.\u0011:hk6,g\u000e\u001e(b[\u0016TAdZ3u\rVt7\r^5p]2KG/\u001a:bY\u0016C\bO]3tg&|gN\u0003\u0007sK\u000e,\u0017N^3s)f\u0004XM\u0003\u0004TiJLgn\u001a\u0006\u0005U\u00064\u0018M\u0003\u0003mC:<'bD4fiJ+7-Z5wKJ$\u0016\u0010]3\u000b\u0015I,G/\u001e:o)f\u0004XMC\u0007hKR\u0014V\r^;s]RK\b/\u001a\u0006\u0019GJ,\u0017\r^3Gk:\u001cG/[8o\u000bb\u0004(/Z:tS>t'\u0002\u0005&fi:\u000bW.\u001a3Gk:\u001cG/[8o\u0015i9W\r\u001e$v]\u000e$\u0018n\u001c8MSR,'/\u00197Be\u001e,X.\u001a8u\u0015iQU\r\u001e$v]\u000e$\u0018n\u001c8MSR,'/\u00197Be\u001e,X.\u001a8u\u0015I9W\r\u001e'b[\n$\u0017\rT1cK2t\u0015-\\3\u000b\rI,hNR5y\u0015\u0011)f.\u001b;\u000b\u001b)+G/\u0012=qe\u0016\u001c8/[8o\u0015E\u0011X\r\u001d7bG\u0016<\u0016\u000e\u001e5SKR,(O\u001c\u0006\u000baNLg)Y2u_JL(\"\u0004&fiB\u001b\u0018NR1di>\u0014\u0018\u0010m\u0001\u000b\u0005A\t!\u0002\u0002\u0005\u0001!\tQA\u0001C\u0001\u0011\u0007)!\u0001B\u0001\t\u0005\u0015\u0011A1\u0001E\u0003\u000b\r!!\u0001\u0003\u0001\r\u0001\u0015\u0019AA\u0001\u0005\u0004\u0019\u0001)!\u0001B\u0001\t\u000b\u0015\u0019Aq\u0001E\u0005\u0019\u0001)!\u0001b\u0002\t\n\u0015\u0011A!\u0001E\u0007\u000b\r!Q\u0001\u0003\u0004\r\u0001\u0015\u0011A!\u0002\u0005\u0007\u000b\u0005A\u0019!B\u0002\u0005\u000e!EA\u0002A\u0003\u0002\u0011%)!\u0001b\u0004\t\u0014\u0015\u0011A\u0001\u0003E\t\u000b\r!9\u0001\u0003\u0007\r\u0001\u0015\u0011Aq\u0001\u0005\r\u000b\r!9\u0001C\u0007\r\u0001\u0015\u0011Aq\u0001\u0005\u000e\u000b\r!i\u0001#\b\r\u0001\u0015\u0019Aq\u0001\u0005\u0010\u0019\u0001)1\u0001b\u0002\t\"1\u0001QA\u0001C\u0004\u0011=)!\u0001b\u0002\t\"\u0011\tARA\r\u0004\u000b\u0005A1\u0001G\u0002.#\u0011\u0019G\u0001g\u0003\"\t\u0015\t\u00012\u0002G\u00011\u0017)6\u0001C\u0003\u0004\t\u0017I\u0011\u0001\u0003\u0004\u000e\u0007\u00119\u0011\"\u0001\u0005\u0007[A!1\r\u0002\r\u0005C\r)\u0011\u0001\u0003\u0003\u0019\tU\u001b\u0001\"B\u0002\u0005\t%\t\u0001\u0012B\u0007\u0004\t\u001fI\u0011\u0001#\u0003.#\u0011\u0019G\u0001\u0007\u0005\"\t\u0015\t\u0001b\u0002G\u00011\u001d)6\u0001C\u0003\u0004\t!I\u0011\u0001#\u0005\u000e\u0007\u0011Q\u0011\"\u0001E\t[E!1\r\u0002M\u000bC\u0011)\u0011\u0001C\u0004\r\u0002a9Qk\u0001\u0005\u0006\u0007\u0011U\u0011\"\u0001E\t\u001b\r!1\"C\u0001\t\u00125VA!\u0001M\fC\r)\u0011\u0001C\u0005\u0019\u0013E\u001b1\u0001b\u0006\n\u0003!MQv\u0003\u0003\u000213\tC!B\u0001\t\u00151\u0005\u0001DC)\u0004\u0007\u0011e\u0011\"\u0001E\u000b[/!\u0011\u0001g\u0007\"\t\u0015\t\u0001b\u0002G\u00011\u001d\t6a\u0001C\u000e\u0013\u0005A\t\",\u0006\u0005\u0017aq\u0011eA\u0003\u0002\u0011-A2\"U\u0002\u0004\t9I\u0011\u0001\u0002\u0001.7\u0011\tQcA\u0003\u0002\u0011/A:\u0002g\b\u001e\u0010\u0011\u0001\u0001\u0002E\u0007\u0004\u000b\u0005AA\u0002\u0007\u0007Q\u0007\u0003\t3!B\u0001\t\u0017aY\u0011kA\u0004\u0005 %\tA\u0001A\u0007\u0002\u00113i\u0011\u0001C\u00076.\u0015-Ba9\u0001\u0019\bu=A\u0001\u0001\u0005\u0005\u001b\r)\u0011\u0001\u0003\u0003\u0019\tA\u001b\u0001!I\u0002\u0006\u0003!\u0015\u0001TA)\u0004\u000b\u0011\u001d\u0011\"\u0001\u0003\u0001\u001b\u0005AI\u0001"})
public final class LambdaToFunctionExpression
implements DeprecatedSyntaxFix {
    public static final /* synthetic */ KClass $kotlinClass;
    @Nullable
    private final Name functionLiteralArgumentName;
    @Nullable
    private final String receiverType;
    @Nullable
    private final String returnType;
    @NotNull
    private final JetFunctionLiteralExpression functionLiteralExpression;

    static {
        $kotlinClass = Reflection.createKotlinClass(LambdaToFunctionExpression.class);
    }

    @Nullable
    public final Name getFunctionLiteralArgumentName() {
        return this.functionLiteralArgumentName;
    }

    @Nullable
    public final String getReceiverType() {
        return this.receiverType;
    }

    @Nullable
    public final String getReturnType() {
        return this.returnType;
    }

    @Override
    public void runFix() {
        PsiElement replacedFunctionExpression;
        if (!JetPsiUtil.isDeprecatedLambdaSyntax(this.functionLiteralExpression)) {
            return;
        }
        JetNamedFunction newFunctionExpression = this.createFunctionExpression();
        JetFunctionLiteralArgument literalArgument = this.getFunctionLiteralArgument();
        PsiElement psiElement2 = replacedFunctionExpression = literalArgument == null ? this.functionLiteralExpression.replace(newFunctionExpression) : (PsiElement)((JetValueArgument)KotlinPackage.last(PsiModificationUtilsKt.moveInsideParenthesesAndReplaceWith(literalArgument, (JetExpression)newFunctionExpression, this.functionLiteralArgumentName).getValueArguments())).getArgumentExpression();
        if (psiElement2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.JetExpression");
        }
        JetExpression jetExpression = JetPsiUtil.deparenthesize((JetExpression)psiElement2);
        if (jetExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.JetNamedFunction");
        }
        JetNamedFunction functionExpression = (JetNamedFunction)jetExpression;
        ShortenReferences.process$default(ShortenReferences.Companion.getDEFAULT(), KotlinPackage.filterNotNull((Iterable)KotlinPackage.listOf((Object[])new JetTypeReference[]{functionExpression.getReceiverTypeReference(), functionExpression.getTypeReference()})), null, 2);
    }

    /*
     * WARNING - void declaration
     */
    private final JetFunctionLiteralArgument getFunctionLiteralArgument() {
        void $receiver;
        PsiElement psiElement2 = (PsiElement)this.functionLiteralExpression;
        boolean strict = false;
        JetFunctionLiteralArgument argument = (JetFunctionLiteralArgument)PsiTreeUtil.getParentOfType((PsiElement)$receiver, JetFunctionLiteralArgument.class, (boolean)strict);
        if (argument != null && Intrinsics.areEqual((Object)argument.getFunctionLiteral(), (Object)this.functionLiteralExpression)) {
            return argument;
        }
        return null;
    }

    private final void replaceWithReturn(JetExpression $receiver, JetPsiFactory psiFactory) {
        if ($receiver instanceof JetReturnExpression) {
            return;
        }
        $receiver.replace((PsiElement)CreateByPatternKt.createExpressionByPattern(psiFactory, "return $0", $receiver));
    }

    /*
     * WARNING - void declaration
     */
    private final String getLambdaLabelName() {
        void $receiver;
        PsiElement psiElement2 = (PsiElement)this.functionLiteralExpression;
        boolean strict = false;
        JetLabeledExpression labeledExpression = (JetLabeledExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver, JetLabeledExpression.class, (boolean)strict);
        if (labeledExpression != null && Intrinsics.areEqual((Object)JetPsiUtil.deparenthesize(labeledExpression.getBaseExpression()), (Object)this.functionLiteralExpression)) {
            return labeledExpression.getLabelName();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final JetNamedFunction createFunctionExpression() {
        PsiElement psiElement2;
        String string;
        StringBuilder stringBuilder;
        JetFunctionLiteral functionLiteral;
        JetPsiFactory psiFactory;
        block19: {
            block18: {
                String string2;
                String it;
                String $receiver;
                StringBuilder stringBuilder2;
                String string3;
                StringBuilder stringBuilder3;
                String parameterList2;
                String functionName;
                block17: {
                    block16: {
                        psiFactory = JetPsiFactoryKt.JetPsiFactory((PsiElement)this.functionLiteralExpression);
                        functionLiteral = this.functionLiteralExpression.getFunctionLiteral();
                        functionName = this.getLambdaLabelName();
                        JetParameterList jetParameterList = functionLiteral.getValueParameterList();
                        parameterList2 = jetParameterList != null ? jetParameterList.getText() : null;
                        stringBuilder3 = new StringBuilder().append("fun ");
                        string3 = this.receiverType;
                        if (string3 == null) break block16;
                        String string4 = string3;
                        stringBuilder2 = stringBuilder3;
                        it = $receiver;
                        string2 = it + ".";
                        stringBuilder3 = stringBuilder2;
                        string3 = string2;
                        if (string3 != null) break block17;
                    }
                    string3 = "";
                }
                StringBuilder stringBuilder4 = stringBuilder3.append(string3);
                String string5 = functionName;
                if (string5 == null) {
                    string5 = "";
                }
                StringBuilder stringBuilder5 = stringBuilder4.append(string5);
                String string6 = parameterList2;
                if (string6 == null) {
                    string6 = "()";
                }
                stringBuilder = stringBuilder5.append(string6);
                string = this.returnType;
                if (string == null) break block18;
                $receiver = string;
                stringBuilder2 = stringBuilder;
                it = $receiver;
                string2 = ": " + it;
                stringBuilder = stringBuilder2;
                string = string2;
                if (string != null) break block19;
            }
            string = "";
        }
        String functionDeclaration = stringBuilder.append(string).toString();
        JetNamedFunction functionWithEmptyBody = psiFactory.createFunction(functionDeclaration + " {}");
        JetBlockExpression jetBlockExpression = functionLiteral.getBodyExpression();
        if (jetBlockExpression == null) {
            return functionWithEmptyBody;
        }
        JetBlockExpression blockExpression = jetBlockExpression;
        List<JetExpression> statements = blockExpression.getStatements();
        if (statements.isEmpty()) {
            return functionWithEmptyBody;
        }
        if (statements.size() == 1) {
            return psiFactory.createFunction(functionDeclaration + " = " + ((JetExpression)KotlinPackage.first(statements)).getText());
        }
        if (this.returnType != null) {
            Unit unit;
            void destination;
            void $receiver;
            void $receiver2;
            Iterable iterable = statements;
            void var10_12 = $receiver2;
            Collection collection = new ArrayList();
            for (Object element2 : $receiver) {
                if (!(element2 instanceof JetExpression)) continue;
                destination.add(element2);
            }
            JetExpression jetExpression = (JetExpression)KotlinPackage.lastOrNull((List)((List)destination));
            if (jetExpression != null) {
                this.replaceWithReturn(jetExpression, psiFactory);
                unit = Unit.INSTANCE$;
            } else {
                unit = null;
            }
        }
        if ((psiElement2 = functionLiteral.getArrow()) == null) {
            psiElement2 = functionLiteral.getLBrace();
        }
        PsiElement fromElement = psiElement2;
        PsiElement toElement = functionLiteral.getRBrace();
        String bodyText2 = KotlinPackage.joinToString$default((Sequence)KotlinPackage.map((Sequence)KotlinPackage.takeWhile((Sequence)PsiUtilsKt.siblings$default(fromElement, false, false, 1), (Function1)((Function1)new Function1<PsiElement, Boolean>(toElement){
            final /* synthetic */ PsiElement $toElement;

            public final boolean invoke(@NotNull PsiElement it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it, (Object)this.$toElement) ^ true;
            }
            {
                this.$toElement = psiElement2;
                super(1);
            }
        })), (Function1)createFunctionExpression.bodyText.2.INSTANCE$), (String)"", null, null, (int)0, null, null, (int)62);
        return psiFactory.createFunction(functionDeclaration + "{ " + bodyText2 + "}");
    }

    @NotNull
    public final JetFunctionLiteralExpression getFunctionLiteralExpression() {
        return this.functionLiteralExpression;
    }

    /*
     * WARNING - void declaration
     */
    public LambdaToFunctionExpression(@NotNull JetFunctionLiteralExpression functionLiteralExpression) {
        String string;
        String string2;
        String string3;
        JetType it;
        LambdaToFunctionExpression lambdaToFunctionExpression;
        void value22;
        Intrinsics.checkParameterIsNotNull((Object)functionLiteralExpression, (String)"functionLiteralExpression");
        this.functionLiteralExpression = functionLiteralExpression;
        BindingContext bindingContext2 = ResolutionUtils.analyze$default(this.functionLiteralExpression, null, 1);
        JetType functionLiteralType = bindingContext2.getType(this.functionLiteralExpression);
        boolean bl = functionLiteralType != null && KotlinBuiltIns.isExactFunctionOrExtensionFunctionType(functionLiteralType);
        if (KotlinPackage.getASSERTIONS_ENABLED() && value22 == false) {
            String message = "Broken function type for expression: " + this.getFunctionLiteralExpression().getText() + ", at: " + DiagnosticUtils.atLocation(this.getFunctionLiteralExpression());
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        if (functionLiteralType == null) {
            Intrinsics.throwNpe();
        }
        LambdaToFunctionExpression lambdaToFunctionExpression2 = this;
        JetType jetType = KotlinBuiltIns.getReceiverType(functionLiteralType);
        if (jetType != null) {
            void $receiver;
            JetType value22 = jetType;
            lambdaToFunctionExpression = lambdaToFunctionExpression2;
            it = (JetType)$receiver;
            DescriptorRenderer descriptorRenderer = IdeDescriptorRenderers.INSTANCE$.getSOURCE_CODE();
            JetType jetType2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)jetType2, (String)"it");
            string3 = descriptorRenderer.renderType(jetType2);
            lambdaToFunctionExpression2 = lambdaToFunctionExpression;
            string2 = string3;
        } else {
            string2 = null;
        }
        lambdaToFunctionExpression2.receiverType = string2;
        JetType $receiver = KotlinBuiltIns.getReturnTypeFromFunctionType(functionLiteralType);
        lambdaToFunctionExpression = this;
        it = $receiver;
        if (KotlinBuiltIns.isUnit(it)) {
            string = null;
        } else {
            DescriptorRenderer descriptorRenderer = IdeDescriptorRenderers.INSTANCE$.getSOURCE_CODE();
            JetType jetType3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)jetType3, (String)"it");
            string = descriptorRenderer.renderType(jetType3);
        }
        lambdaToFunctionExpression.returnType = string3 = string;
        JetFunctionLiteralArgument jetFunctionLiteralArgument = this.getFunctionLiteralArgument();
        this.functionLiteralArgumentName = jetFunctionLiteralArgument != null ? JetPsiUtilKt.getFunctionLiteralArgumentName(jetFunctionLiteralArgument, bindingContext2) : null;
    }
}

