/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.ChangeFunctionSignatureFix;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.ChangeSignaturePackage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetChangeSignatureConfiguration;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetMethodDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetMutableMethodDescriptor;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.resolve.BindingContext;

public class RemoveFunctionParametersFix
extends ChangeFunctionSignatureFix {
    private final ValueParameterDescriptor parameterToRemove;

    public RemoveFunctionParametersFix(@NotNull PsiElement context, @NotNull FunctionDescriptor functionDescriptor, @NotNull ValueParameterDescriptor parameterToRemove) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/idea/quickfix/RemoveFunctionParametersFix", "<init>"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/idea/quickfix/RemoveFunctionParametersFix", "<init>"));
        }
        if (parameterToRemove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterToRemove", "org/jetbrains/kotlin/idea/quickfix/RemoveFunctionParametersFix", "<init>"));
        }
        super(context, functionDescriptor);
        this.parameterToRemove = parameterToRemove;
    }

    @NotNull
    public String getText() {
        String string = JetBundle.message("remove.parameter", this.parameterToRemove.getName().asString());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/RemoveFunctionParametersFix", "getText"));
        }
        return string;
    }

    @Override
    protected void invoke(@NotNull Project project, Editor editor, JetFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/RemoveFunctionParametersFix", "invoke"));
        }
        BindingContext bindingContext2 = ResolutionUtils.analyzeFully(file);
        ChangeSignaturePackage.runChangeSignature(project, this.functionDescriptor, new JetChangeSignatureConfiguration(){

            @Override
            @NotNull
            public JetMethodDescriptor configure(@NotNull JetMethodDescriptor originalDescriptor, @NotNull BindingContext bindingContext2) {
                if (originalDescriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalDescriptor", "org/jetbrains/kotlin/idea/quickfix/RemoveFunctionParametersFix$1", "configure"));
                }
                if (bindingContext2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/idea/quickfix/RemoveFunctionParametersFix$1", "configure"));
                }
                JetMethodDescriptor jetMethodDescriptor = ChangeSignaturePackage.modify(originalDescriptor, (Function1<? super JetMutableMethodDescriptor, ? extends Unit>)new Function1<JetMutableMethodDescriptor, Unit>(){

                    public Unit invoke(JetMutableMethodDescriptor descriptor2) {
                        int index2 = RemoveFunctionParametersFix.this.functionDescriptor.getValueParameters().indexOf(RemoveFunctionParametersFix.this.parameterToRemove);
                        descriptor2.removeParameter(descriptor2.getReceiver() != null ? index2 + 1 : index2);
                        return null;
                    }
                });
                if (jetMethodDescriptor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/RemoveFunctionParametersFix$1", "configure"));
                }
                return jetMethodDescriptor;
            }

            @Override
            public boolean performSilently(@NotNull Collection<? extends PsiElement> elements) {
                if (elements == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/kotlin/idea/quickfix/RemoveFunctionParametersFix$1", "performSilently"));
                }
                return false;
            }

            @Override
            public boolean forcePerformForSelectedFunctionOnly() {
                return false;
            }
        }, bindingContext2, this.context, this.getText());
    }
}

