/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.intentions.SpecifyTypeExplicitlyIntention;
import org.jetbrains.kotlin.idea.quickfix.JetIntentionAction;
import org.jetbrains.kotlin.idea.quickfix.JetSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.JetCallableDeclaration;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPropertyAccessor;
import org.jetbrains.kotlin.types.JetType;

public class RemovePartsFromPropertyFix
extends JetIntentionAction<JetProperty> {
    private final boolean removeInitializer;
    private final boolean removeGetter;
    private final boolean removeSetter;

    private RemovePartsFromPropertyFix(@NotNull JetProperty element2, boolean removeInitializer, boolean removeGetter, boolean removeSetter) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/quickfix/RemovePartsFromPropertyFix", "<init>"));
        }
        super(element2);
        this.removeInitializer = removeInitializer;
        this.removeGetter = removeGetter;
        this.removeSetter = removeSetter;
    }

    private RemovePartsFromPropertyFix(@NotNull JetProperty element2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/quickfix/RemovePartsFromPropertyFix", "<init>"));
        }
        this(element2, element2.hasInitializer(), element2.getGetter() != null && element2.getGetter().getBodyExpression() != null, element2.getSetter() != null && element2.getSetter().getBodyExpression() != null);
    }

    private static String partsToRemove(boolean getter, boolean setter, boolean initializer) {
        StringBuilder sb = new StringBuilder();
        if (getter) {
            sb.append("getter");
            if (setter && initializer) {
                sb.append(", ");
            } else if (setter || initializer) {
                sb.append(" and ");
            }
        }
        if (setter) {
            sb.append("setter");
            if (initializer) {
                sb.append(" and ");
            }
        }
        if (initializer) {
            sb.append("initializer");
        }
        return sb.toString();
    }

    @NotNull
    public String getText() {
        String string = JetBundle.message("remove.parts.from.property", RemovePartsFromPropertyFix.partsToRemove(this.removeGetter, this.removeSetter, this.removeInitializer));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/RemovePartsFromPropertyFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JetBundle.message("remove.parts.from.property.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/RemovePartsFromPropertyFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/RemovePartsFromPropertyFix", "isAvailable"));
        }
        JetType type2 = QuickFixUtil.getDeclarationReturnType((JetNamedDeclaration)this.element);
        return super.isAvailable(project, editor, file) && type2 != null && !type2.isError();
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, JetFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/RemovePartsFromPropertyFix", "invoke"));
        }
        JetType type2 = QuickFixUtil.getDeclarationReturnType((JetNamedDeclaration)this.element);
        JetProperty newElement = (JetProperty)((JetProperty)this.element).copy();
        JetPropertyAccessor getter = newElement.getGetter();
        if (this.removeGetter && getter != null) {
            newElement.deleteChildInternal(getter.getNode());
        }
        JetPropertyAccessor setter = newElement.getSetter();
        if (this.removeSetter && setter != null) {
            newElement.deleteChildInternal(setter.getNode());
        }
        JetExpression initializer = newElement.getInitializer();
        JetType typeToAdd = null;
        if (this.removeInitializer && initializer != null) {
            PsiElement nameIdentifier = newElement.getNameIdentifier();
            assert (nameIdentifier != null);
            PsiElement nextSibling = nameIdentifier.getNextSibling();
            assert (nextSibling != null);
            newElement.deleteChildRange(nextSibling, (PsiElement)initializer);
            if (newElement.getTypeReference() == null && type2 != null) {
                typeToAdd = type2;
            }
        }
        this.element = (JetProperty)((JetProperty)this.element).replace(newElement);
        if (typeToAdd != null) {
            SpecifyTypeExplicitlyIntention.Companion.addTypeAnnotation(editor, (JetCallableDeclaration)this.element, typeToAdd);
        }
    }

    public static JetSingleIntentionActionFactory createFactory() {
        return new JetSingleIntentionActionFactory(){

            @Override
            public JetIntentionAction<JetProperty> createAction(Diagnostic diagnostic) {
                PsiElement element2 = diagnostic.getPsiElement();
                assert (element2 instanceof JetElement);
                JetProperty property = (JetProperty)PsiTreeUtil.getParentOfType((PsiElement)element2, JetProperty.class);
                if (property == null) {
                    return null;
                }
                return new RemovePartsFromPropertyFix(property);
            }
        };
    }
}

